;****************************************************************************
;                                 PIC16C84.H
;               Microchip PIC16C84 Microcontroller Header File
;****************************************************************************


;   Organisation : P H Research (Tel/Fax: 01954 200411)
;   Originator   : Paul T.B. Hackett (email: paul@ph-research.prestel.co.uk)
;                                    (mobile: 0410 169361)

;   Date         : 18-12-97
;   Version      : 1.1


;   Description

;   This header file defines all the registers and bits within the PIC16C84  

;****************************************************************************


; define constants
 
w           equ         0
f           equ         1

bit0        equ         0
bit1        equ         1
bit2        equ         2
bit3        equ         3
bit4        equ         4
bit5        equ         5
bit6        equ         6
bit7        equ         7


; Define reset and interrupt vectors

RST_Vec     equ         0000H
INT_Vec     equ         0004H


;****************************************************************************


; Define Special Function Registers

; Page 0

ind         equ         00H             ; Indirect data register (not a physical register)
rtcc        equ         01H             ; Real time clock counter
pcl         equ         02H             ; Program counter (low byte)
status      equ         03H             ; Status register
fsr         equ         04H             ; File select register (address pointer)
porta       equ         05H             ; Port A input/output register
portb       equ         06H             ; Port B input/output register
eedata      equ         08H             ; EEPROM data register
eeaddr      equ         09H             ; EEPROM address register
pclath      equ         0AH             ; Program counter latch (high byte)
intcon      equ         0BH             ; Interrupt control register

; Page 1

optreg      equ         01H             ; Real time clock/counter register
trisa       equ         05H             ; Port A data direction register
trisb       equ         06H             ; Port B data direction register
eecon1      equ         08H             ; EEPROM control register 1
eecon2      equ         09H             ; EEPROM control register 2 (not a physical register)


;****************************************************************************


; Define commonly used flags and bits


; Status register

#define     _c          status,bit0     ; Carry flag
#define     _dc         status,bit1     ; Digit carry flag
#define     _z          status,bit2     ; Zero flag
#define     _pd         status,bit3     ; Power down flag
#define     _to         status,bit4     ; Time out flag
#define     _rp0        status,bit5     ; Register page selection bit 0 (direct addressing)
#define     _rp1        status,bit6     ; Register page selection bit 1 (direct addressing)
#define     _irp        status,bit7     ; Register page selection bit (indirect addressing)


; Interrupt control register

#define     _rbif       intcon,bit0     ; RB port change interrupt flag
#define     _intf       intcon,bit1     ; INT interrupt flag
#define     _rtif       intcon,bit2     ; RTCC overflow interrupt flag
#define     _rbie       intcon,bit3     ; RBIF interrupt enable bit
#define     _inte       intcon,bit4     ; INT interrupt enable bit
#define     _rtie       intcon,bit5     ; RTIF interrupt enable bit
#define     _eeie       intcon,bit6     ; EEPROM write interrupt enable bit
#define     _gie        intcon,bit7     ; Global interrupt enable bit


; Option register

#define     _ps0        option,bit0     ;
#define     _ps1        option,bit1     ;
#define     _ps2        option,bit2     ;
#define     _psa        option,bit3     ;
#define     _rte        option,bit4     ;
#define     _rts        option,bit5     ;
#define     _intedg     option,bit6     ;
#define     _rbpu       option,bit7     ;


; Input/Output ports

#define     _ra0        porta,bit0      ; Port A bit 0 (RA0)
#define     _ra1        porta,bit1      ; Port A bit 1 (RA1)
#define     _ra2        porta,bit2      ; Port A bit 2 (RA2)
#define     _ra3        porta,bit3      ; Port A bit 3 (RA3)
#define     _ra4        porta,bit4      ; Port A bit 4 (RA4)

#define     _rb0        portb,bit0      ; Port B bit 0 (RB0)
#define     _rb1        portb,bit1      ; Port B bit 1 (RB1)
#define     _rb2        portb,bit2      ; Port B bit 2 (RB2)
#define     _rb3        portb,bit3      ; Port B bit 3 (RB3)
#define     _rb4        portb,bit4      ; Port B bit 4 (RB0)
#define     _rb5        portb,bit5      ; Port B bit 5 (RB1)
#define     _rb6        portb,bit6      ; Port B bit 6 (RB2)
#define     _rb7        portb,bit7      ; Port B bit 7 (RB3)


;****************************************************************************
