; **************************************************************************
;                                 INTSERV.ASM
;               PIC16C84 Software Listing for Naughts and Crosses
; **************************************************************************


;   Organisation : P H Research (Tel/Fax: 01954 200411)
;   Originator   : Paul T.B. Hackett (email: paul@ph-research.prestel.co.uk)
;                                    (mobile: 0410 169361)

;   Version : 1.0


;   Description


; **************************************************************************


Int_Serv                                ; Interrupt service routine

            MOVWF       W_TEMP          ; Store wreg
            SWAPF       status,w        ;
            MOVWF       S_TEMP          ; Store status
            BCF         _rp0            ; Select page 0

            MOVLW       RTCC_INIT       ;
            MOVWF       rtcc            ; Initialise RTCC with init value
            BCF         _rtif           ; Clear RTCC overflow interrupt flag

            CALL        SW_Timer        ; Decrement software timers
            CALL        Disp_Scan       ; Display scan control
            CALL        Pwr_Off_Tst     ; Test if inactive and power off

            SWAPF       S_TEMP,w        ;
            MOVWF       status          ; Restore status and page select
            SWAPF       W_TEMP,f        ;
            SWAPF       W_TEMP,w        ; Restore wreg
           
            RETURN                      ; Return from interrupt service routine


; **************************************************************************
; **************************************************************************


SW_Timer                                ; Software timer subroutine

            MOVF        TIMER1,f        ; Service timer 1
            BTFSC       _z              ; Test if timer 1 is zero
            GOTO        Dec_Timer2      ; If zero service timer 2
            DECF        TIMER1,f        ; If not zero then decrement timer 1

Dec_Timer2  MOVF        TIMER2,f        ; Service timer 2
            BTFSC       _z              ; Test if timer 2 is zero
            GOTO        Dec_Timer3      ; If zero service timer 3
            DECF        TIMER2,f        ; If not zero then decrement timer 2

;           ******************************************************

Dec_Timer3  DECFSZ      TIMER3,f        ; Decrement timer 3 and test if zero
            GOTO        Timer_End       ; If not zero then goto Timer_End
            MOVLW       10              ;
            MOVWF       TIMER3          ; Load timer 3 with 10 mS

;           ******************************************************

Dec_Timer4  MOVF        TIMER4,f        ; Service timer 4
            BTFSC       _z              ; Test if timer 4 is zero
            GOTO        Dec_Timer5      ; If zero goto Dec_Timer5
            DECF        TIMER4,f        ; If not zero decrement timer 4

Dec_Timer5  MOVF        TIMER5,f        ; Service timer 5
            BTFSC       _z              ; Test if timer 5 is zero
            GOTO        Dec_Timer6      ; If zero goto Dec_Timer6
            DECF        TIMER5,f        ; If not zero decrement timer 5

;           ******************************************************

Dec_Timer6  DECFSZ      TIMER6,f        ; Decrement timer 6 and test if zero
            GOTO        Timer_End       ; If not zero then goto Timer_End
            MOVLW       10              ;
            MOVWF       TIMER6          ; Load timer 6 with 100 mS

;           ******************************************************

Dec_Timer7  MOVF        TIMER7,f        ; Service timer 7
            BTFSC       _z              ; Test if timer 7 is zero
            GOTO        Timer_End       ; If zero goto Timer_End
            DECF        TIMER7,f        ; If not zero decrement timer 7

Timer_End   RETURN                      ; Return from software timer subroutine


; **************************************************************************


Disp_Scan                               ; Display scan subroutine

            BSF         _rp0            ; Select page 1
            MOVLW       00000000B       ;
            MOVWF       trisb           ; Define port B data direction
            BCF         _rp0            ; Select page 0

;           ******************************************************

            BTFSC       _ra2            ; Test if column 3 is illuminated
            GOTO        Disp_Blank      ; If yes goto Disp_Blank else continue

            BTFSC       _ra0            ; Test if column 1 is illuminated
            GOTO        Disp_Col2       ; If yes goto Disp_Col2 else continue

            BTFSC       _ra1            ; Test if column 2 is illuminated
            GOTO        Disp_Col3       ; If yes goto Disp_Col3 else goto Disp_Col1

;           ******************************************************

Disp_Col1   CLRF        porta           ; Disable all column drivers
            MOVF        COL1,w          ;
            MOVWF       portb           ; Load port B with column 1 data (COL1)
            BSF         _ra0            ; Enable column 1 driver
            GOTO        DScan_End       ;

Disp_Col2   CLRF        porta           ; Disable all column drivers
            MOVF        COL2,w          ;
            MOVWF       portb           ; Load port B with column 2 data (COL2)
            BSF         _ra1            ; Enable column 2 driver
            GOTO        DScan_End       ;

Disp_Col3   CLRF        porta           ; Disable all column drivers
            MOVF        COL3,w          ;
            MOVWF       portb           ; Load port B with column 3 data (COL3)
            BSF         _ra2            ; Enable column 3 driver
            GOTO        DScan_End       ;

Disp_Blank  CLRF        porta           ; Disable all column drivers
            CALL        Key_Scan        ; Call Front panel key scan routine

DScan_End   RETURN                      ; Return from display scan subroutine


; **************************************************************************


Key_Scan                                ; Front panel key scan routine

            CALL        Get_Key         ; Read key value (result in wreg)
            MOVWF       KEY_VAL         ; Store result in KEY_VAL

            BCF         KEY_FLGS,bit0   ; Clear valid key flag
            MOVF        KVAL_OLD,w      ;
            BTFSC       _z              ; Test if key value is zero
            GOTO        No_Key          ; If yes goto No_Key else continue
            SUBWF       KEY_VAL,w       ;
            BTFSC       _z              ; Test if KEY_VAL = KVAL_OLD
            BSF         KEY_FLGS,bit0   ; If yes set valid key flag else continue

No_Key      MOVF        KEY_VAL,w       ;
            MOVWF       KVAL_OLD        ; Load KVAL_OLD with KEY_VAL


KScan_End   RETURN                      ; End of 'Key_Scan' routine


; **************************************************************************


Get_Key                                 ; Read key value (result in wreg)

            BSF         _rp0            ; Select page 1
            MOVLW       00000111B       ;
            MOVWF       trisb           ; Define port B data direction
            BCF         _rp0            ; Select page 0

            BSF         _rb4            ; Disable keypad column 2 drive
            BSF         _rb5            ; Disable keypad column 3 drive

            BCF         _rb3            ; Enable keypad column 1 drive
            BTFSS       _rb0            ; Test if key 1 is pressed
            RETLW       1               ; If yes return from subroutine with wreg = 1
            BTFSS       _rb1            ; Test if key 4 is pressed
            RETLW       4               ; If yes return from subroutine with wreg = 4
            BTFSS       _rb2            ; Test if key 7 is pressed
            RETLW       7               ; If yes return from subroutine with wreg = 7
            BSF         _rb3            ; Disable keypad column 1 drive

            BCF         _rb4            ; Enable keypad column 2 drive
            BTFSS       _rb0            ; Test if key 2 is pressed
            RETLW       2               ; If yes return from subroutine with wreg = 2
            BTFSS       _rb1            ; Test if key 5 is pressed
            RETLW       5               ; If yes return from subroutine with wreg = 5
            BTFSS       _rb2            ; Test if key 8 is pressed
            RETLW       8               ; If yes return from subroutine with wreg = 8
            BSF         _rb4            ; Disable keypad column 2 drive

            BCF         _rb5            ; Enable keypad column 3 drive
            BTFSS       _rb0            ; Test if key 3 is pressed
            RETLW       3               ; If yes return from subroutine with wreg = 3
            BTFSS       _rb1            ; Test if key 6 is pressed
            RETLW       6               ; If yes return from subroutine with wreg = 6
            BTFSS       _rb2            ; Test if key 9 is pressed
            RETLW       9               ; If yes return from subroutine with wreg = 9
            BSF         _rb5            ; Disable keypad column 3 drive

            RETLW       0               ; If no key is pressed return from subroutine with wreg = 0


; **************************************************************************


Pwr_Off_Tst                             ; Test if inactive and power off

            MOVF        TIMER7,f        ;
            BTFSS       _z              ; Test if timer 7 is zero
            GOTO        Pwr_Off_End     ; If not then goto Pwr_Off_End else continue

            CLRF        porta           ; Disable all column drivers

            BSF         _rp0            ; Select page 1
            MOVLW       00000000B       ;
            MOVWF       trisb           ; Define port B data direction (all outputs)
            BCF         _rp0            ; Select page 0

            MOVLW       11111111B       ;
            MOVWF       portb           ; Set all port B outputs high

            BCF         _gie            ; Disable interrupts

            SLEEP                       ; Shutdown PIC


Pwr_Off_End RETURN                      ; Return from power off test subroutine


; **************************************************************************
; **************************************************************************
