;WEATHER1670.ASM 04JUL03 - COPYRIGHT JOHN BECKER - EPE PIC MET OFFICE

;PIC16F877-20, 10MHz, WDT OFF, POR ON, XTAL HS

;Config register bits
; CP1 CP0 DBG NIL WRT CPD LVP BOR CP1 CP0 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   1   0   0   1   0
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC '87 data sheet.

#DEFINE BANK0   BCF $03,5
#DEFINE BANK1   BSF $03,5
#DEFINE RP1LO BCF $03,6  ; clear STATUS bit 6 (RP1)
#DEFINE RP1HI BSF $03,6  ; set   STATUS bit 6 (RP1)
#DEFINE BLOCK0 BCF $03,7 ; clear STATUS bit 7 (IRP)
#DEFINE BLOCK1 BSF $03,7 ; set   STATUS bit 7 (IRP)
#DEFINE   SERIALDELAY CALL CYCLES15  ; set serial chip write delay value
              ; CYCLES5 for 4MHz or below, CYCLES25 for 20MHz
#DEFINE   SETECHAN MOVLW 0          ; set serial chip channel (value from 0 to 7)
  ; is placed into ECHAN via main prog, where its definition should be made

	List P = PIC16F877, R=DEC; 
        __CONFIG   h'3F32'
        include P16F877.inc

        CBLOCK
LOOP
LOOPA
RSLINE
STORE
STORE1
MODE
SLOWIT        ; counter for pause
COUNT0        ; lsb
COUNT1
COUNT2        ; msb
DIGIT1        ; lsd
DIGIT2
DIGIT3
DIGIT4
DIGIT5
DIGIT6
DIGIT7
DIGIT8        ; msd
BITCNT
DIGCNT
FAHRENMSB
FAHRENLSB
MULCLSB     ; multiplicant LSB
MULCMSB     ; multiplicant MSB
MULPLSB     ; multiplier LSB
MULPMSB     ; multiplier MSB
PRODLSB     ; product LSB
PRODMSB     ; product MSB
DIVIDLSB    ; Dividend and quotient
DIVIDMSB
REMDRLSB    ; Remainder
REMDRMSB
DIVISLSB     ; Divisor
DIVISMSB
SAVEW
SAVES
ISRFLAG
PLUSFLAG
MEMHI     ; msb val to be sent to eeprom chip
MEMLO     ; lsb val to be sent to eeprom chip
SHOWCHAN
MINLSB
MINMSB
MAXLSB
MAXMSB
WIND0LSB
WIND0MSB
WIND1LSB
WIND1MSB
WIND2LSB
WIND2MSB
WIND3LSB
WIND3MSB
SUBJECTNO
ROOTL
ROOTH
REMDRL
REMDRH
NUML
NUMM
NUMH
WINDNLSB
WINDNMSB
WINDWLSB
WINDWMSB
COMPASSVAL
COMPASSSTORE
CHANGECOUNT
BCOUNT
COUNT
DATAI
DATAO
EEPROM
VALCHANGE         ; val changed flag during change routine
SAMCNT            ; sub-unit for SAMCNTLSB use
CHANTIMER
RAIN
ECHAN
ABORT
HOLDLCD
            ENDC

; addresses in all 4 banks

            CBLOCK $70
FREQMSB
FREQLSB
POLLCNT
RADDRH
RADDRL
WADDRH
WADDRL
SAMCNTMSB
SAMCNTLSB
SLAVE
MEMCNT      ; number of eeprom memory chips used
MEMFUL      ; memory full flag
TXBUF
SIGN
            ENDC

               ; locations up to $7F are available

; EQUATES FOR PETER HEMSLEY'S MATHS ROUTINES - used in bank1

REGA0   EQU $A0                        ;lsb
REGA1   EQU $A1
REGA2   EQU $A2
REGA3   EQU $A3                        ;msb
REGB0   EQU $A4                        ;lsb
REGB1   EQU $A5
REGB2   EQU $A6
REGB3   EQU $A7                        ;msb
REGC0   EQU $A8                        ;lsb
REGC1   EQU $A9
REGC2   EQU $AA
REGC3   EQU $AB                        ;msb
MTEMP   EQU $AC
MCOUNT  EQU $AD

WINDNDMSB EQU $B0
WINDNDLSB EQU $B1
WINDSDMSB EQU $B2
WINDSDLSB EQU $B3
WINDWDMSB EQU $B4
WINDWDLSB EQU $B5
WINDEDMSB EQU $B6
WINDEDLSB EQU $B7

MEM1:       .EQU $20  ; first data memory location for Bank 2 (at $120)
                      ; extends to MEM64 at $5F (Bank 2 $15F)

             ;************************************************************
             ;           Bit Definitions
             ;************************************************************

DI:     .EQU $07        ; eeprom input bit
DO:     .EQU $06        ; eeprom output bit
SDATA:  .EQU $04        ; serial EE data line (PORTC)
SCLK:   .EQU $03        ; serial EE clock line (PORTC)

;******************

        .ORG 0
        goto GIEOFF

        .ORG 4          ; Interrupt vector address
        bcf T1CON,0     ; stop timer 1
        goto ISR

        .ORG 7          ; Start of program memory

GIEOFF: BCF INTCON,GIE  ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

ROUTEIT: movf MODE,W
        addwf PCL,F
        goto HUMID        ; 0
        goto SOIL         ; 1
        goto LIGHT        ; 2
        goto WATER        ; 3
        goto WIND0        ; 4
        goto WIND1        ; 5
        goto WIND2        ; 6
        goto WIND3        ; 7
        goto TEMPERATURE  ; 8
        goto BAROMETER    ; 9
        goto RAINING      ; 10
        clrf MODE         ; 11
        call SENDSERIAL

        incf CHANTIMER,F
        btfss CHANTIMER,2
        goto ROUTEIT
        call INCSHOWCHAN
        clrf CHANTIMER
        goto ROUTEIT

SUBJECTVAL: ADDWF PCL,F ; used during setting correction values
        retlw 0         ; humid
        retlw 5         ; soil
        retlw 10        ; light
        retlw 15        ; water
        retlw 20        ; temperature
        retlw 25        ; barom
        retlw 30        ; Water pulse
        retlw 40        ; Water mask
        retlw 50        ; Wind pulse
        retlw 60        ; Wind mask
        retlw 70        ; North adjust
        retlw 80        ; West adjust
        retlw 90        ; Sample period
        retlw 110       ; Temp +-
        retlw 117       ; Barom +-

MESSAG2: addwf PCL,F
        retlw 'C'
        retlw 'L'
        retlw 'E'
        retlw 'A'
        retlw 'R'
        retlw 'I'
        retlw 'N'
        retlw 'G'
        retlw ' '
        retlw 'E'
        retlw 'E'
        retlw 'P'
        retlw 'R'
        retlw 'O'
        retlw 'M'
        retlw ' '

MESSAG5: addwf PCL,F
        retlw '0'
        retlw '0'
        retlw 'K'
        retlw ' '
        retlw 'C'
        retlw 'H'
        retlw 'A'
        retlw 'N'
        retlw ' '
        retlw '0'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '

;*******************

START:  bcf STATUS,RP0
        bcf STATUS,RP1
        clrf PORTA
        clrf PORTB
        clrf PORTC
        clrf PORTD
        clrf PORTE
        clrf PCLATH
        movlw ' '
        movwf RAIN

        BLOCK0
        BANK1
        movlw %00011111     ; RB0-RB4 as input, RB5-RB7 as output
        movwf TRISB
        movlw %10100111
        movwf TRISC         ; PORTC 3,4,6 as output, 1,2,3,5,7 as input
        clrf TRISD          ; PORTD as output
        clrf TRISE          ; PORTE as output
        movlw %10000100     ; set RHS justify, RA0, RA1, RA3 as analog inputs
        movwf ADCON1        ; with RA, RE digital, ref to +VE and 0V
        movlw %11011011     ; RA0, RA1, RA3, RA4 as input, RA2, RA5 as output
        movwf TRISA
        movlw %00000110     ; timer 1:64 (1/50th sec), pull-ups on
        movwf OPTION_REG
        BANK0
        movlw %10000001     ; set AD on, Fosc/32
        movwf ADCON0

        clrf INTCON
        call PAUSIT     ;1/5 sec delay

        bsf PCLATH,3
        call LCDSET
        clrf PCLATH

        call PAUSIT     ;1/5 sec delay

        clrf MODE
        call PAUSIT
        clrf INTCON

ST1:    btfsc PORTB,0      ; is PORTB,0 pressed?
        goto ST2
        bsf PCLATH,3
        call CHANGE        ; yes, so EEPROM factors need changing
        clrf PCLATH

ST2:    clrf WADDRH
        clrf WADDRL
        clrf PCLATH
        clrf MEMFUL
        clrf CHANTIMER

        movlw 37
        call PRMGET
        movwf SAMCNTMSB    ; set initial sampling period for eeprom chips
        movlw 60
        movwf SAMCNT
        movwf SAMCNTLSB

        call CLRMEM
        call CLRLINE1
        call CLRLINE2
        clrf MODE
        movlw %00010000
        movwf COMPASSSTORE
        clrf SHOWCHAN

        clrf LOOP
        call LCD1
        bsf RSLINE,4
SHOWMSG: movf LOOP,W
        bsf PCLATH,3
        call MESSAG
        clrf PCLATH
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWMSG

; ****** GET CHIP COUNT

         clrf ECHAN

GETCHIP  clrf WADDRH      ; set write address MSB
         clrf WADDRL      ; set write address LSB
         clrf RADDRH      ; set read address MSB
         clrf RADDRL      ; set read address LSB

         bsf PCLATH,3      ; get present contents of chip location 0
         call READ         ; read from EEPROM chip
         clrf PCLATH

         movf MEMLO,W      ; get LSB value
         movwf FAHRENLSB

         comf MEMLO,F     ; invert value
         clrf WADDRL      ; set write address LSB
         bsf PCLATH,3      ; write it back into chip
         call SAVESAMPLE
         clrf PCLATH
         clrf RADDRL      ; set read address LSB

         bsf PCLATH,3      ; re-read chip
         call READ         ; read from EEPROM chip
         clrf PCLATH
         xorwf FAHRENLSB,W     ; is 2nd read value same as 1st read?
         btfsc STATUS,Z
         goto SHOWCHIPS   ; yes

WRITEBACK comf MEMLO,F
         clrf WADDRL      ; set write address LSB

         bsf PCLATH,3
         call SAVESAMPLE
         clrf PCLATH
         clrf RADDRL      ; set write address LSB

         bsf PCLATH,3
         call READ         ; read from EEPROM chip
         clrf PCLATH

        incf ECHAN,F
        btfss ECHAN,3
        goto GETCHIP

SHOWCHIPS:
         call LCD21
         bsf RSLINE,4

         movf ECHAN,W
         iorlw 48
         call LCDOUT

         movlw ' '
         call LCDOUT
         movlw 'E'
         call LCDOUT
         movlw 'E'
         call LCDOUT
         movlw 'P'
         call LCDOUT
         movlw 'R'
         call LCDOUT
         movlw 'O'
         call LCDOUT
         movlw 'M'
         call LCDOUT
         movlw ' '
         call LCDOUT
         movlw 'C'
         call LCDOUT
         movlw 'H'
         call LCDOUT
         movlw 'I'
         call LCDOUT
         movlw 'P'
         call LCDOUT
         movlw 'S'
         call LCDOUT

        movf ECHAN,W
        movwf MEMCNT
        clrf ECHAN
        clrf WADDRH
        clrf WADDRL

        btfsc PORTB,3      ; is PORTB,3 pressed?
        goto ST5
        bsf PCLATH,3
        call CLEARIT
        clrf PCLATH

        clrf WADDRH      ; set write address MSB
        clrf WADDRL      ; set write address LSB
        clrf ECHAN

        movf ECHAN,W 
        movwf STORE1
        movlw 42                ; store current ECHAN & WADDR values
        bsf PCLATH,3
        call SETPRM
        clrf PCLATH

        movf WADDRH,W 
        movwf STORE1
        movlw 43
        bsf PCLATH,3
        call SETPRM
        clrf PCLATH

        movf WADDRL,W 
        movwf STORE1
        movlw 44
        bsf PCLATH,3
        call SETPRM
        clrf PCLATH

ST5:    movlw 42           ; get last write address
        call PRMGET
        movwf ECHAN

        movlw 43
        call PRMGET
        movwf WADDRH

        movlw 44
        call PRMGET
        movwf WADDRL

        bcf PORTB,2
        call LONGPAUSE

        bsf PCLATH,3
        call JOESETBAUD      ; set baud rate
        clrf PCLATH
        clrf HOLDLCD

        BANK1
        clrf WINDNDLSB
        clrf WINDNDMSB
        clrf WINDSDLSB
        clrf WINDSDMSB
        clrf WINDWDLSB
        clrf WINDWDMSB
        clrf WINDEDLSB
        clrf WINDEDMSB
        BANK0

;****************** START OF MAIN

INTRPT: btfss INTCON,2     ; has a timer time-out been detected?
        goto INTRPT        ; no

        btfsc PORTB,2      ; is RB2 pressed (low)?
        goto INTR3
        movf ECHAN,W            ; store current ECHAN & WADDR values
        movwf STORE1
        movlw 42     
        bsf PCLATH,3
        call SETPRM
        clrf PCLATH

        movf WADDRH,W 
        movwf STORE1
        movlw 43
        bsf PCLATH,3
        call SETPRM
        clrf PCLATH

        movf WADDRL,W 
        movwf STORE1
        movlw 44
        bsf PCLATH,3
        call SETPRM
        clrf PCLATH

        call JOESETBAUD

INTR0:  btfss PORTB,2      ; is RB2 still pressed (low)?
        goto INTR0
        goto 0

INTR3:  clrf COUNT0        ; Wait for any character to be received

INTR4:  nop
        btfss   PIR1,RCIF       ; Check for any RX'd data
        goto    INTR6           ; Nothing RX'd
        movf    RCREG,W         ; Store the RX'd data in 'W'

        sublw   'G'             ; Is this a 'G' ?
        btfsc   STATUS,Z
        goto    INTR5           ; Yes, a 'G'
INTR6:  decfsz COUNT0,F         ; no, is there a timeout?
        goto INTR4              ; no, so wait again
        goto INTR2              ; yes

INTR5:  movf ECHAN,W            ; store current ECHAN & WADDR values
        movwf STORE1
        movlw 42     
        bsf PCLATH,3
        call SETPRM
        clrf PCLATH

        movf WADDRH,W 
        movwf STORE1
        movlw 43
        bsf PCLATH,3
        call SETPRM
        clrf PCLATH

        movf WADDRL,W 
        movwf STORE1
        movlw 44
        bsf PCLATH,3
        call SETPRM
        clrf PCLATH

        bsf PCLATH,3       ; call download
        call JOEDOWNLOAD

INTR2:  clrf PCLATH
        call SAMPLIT
        btfsc PORTB,1
        goto INTR2B
        incf HOLDLCD,F     ; inc flag for holding lcd display
        call CLRLINE1

INTR2A: btfss PORTB,1      ; wait till switch released
        goto INTR2A
        call PAUSIT

INTR2B: bcf INTCON,1
        goto INTRPT

;*****************

SHOWSUBJECT: movwf COUNT0     ; loop length brought in on W
        call LCD1
        bsf RSLINE,4

SUB2:   movf SUBJECTNO,W

        bsf PCLATH,3
        call SUBJECT
        clrf PCLATH

        call LCDOUT
        incf SUBJECTNO,F
        decfsz COUNT0,F
        goto SUB2

        call LCD12
        bsf RSLINE,4

        movf FREQLSB,W
        movwf COUNT0
        movf FREQMSB,W
        movwf COUNT1
        clrf COUNT2

        bsf PCLATH,3
        call BIN2HEX
        clrf PCLATH

        movf DIGIT4,W
        call LCDOUT
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        return

;************ READ HUMIDITY SENSOR ************

HUMID:  movlw 0           ; PORTE 000 - position Y0 - ok 22MAR03
        movwf PORTE
        movlw 192         ; %11000000 stops usonic tx from operating in this mode
        movwf PORTB
        call OSCILLATE

        movf SHOWCHAN,W
        xorwf MODE,W
        btfsc STATUS,Z
        call SHOWHUMID
        return

;************ SOIL SENSING

SOIL:   movlw 1           ; PORTE 001 - position Y1 - ok 22MAR03
        movwf PORTE
        movlw 192         ; %11000000 stops usonic tx from operating in this mode
        movwf PORTB
        call OSCILLATE

        movf SHOWCHAN,W
        xorwf MODE,W
        btfsc STATUS,Z
        call SHOWSOIL
        return

;************ LIGHT SENSING

LIGHT:  movlw 2           ; PORTE 010 - position Y2 - ok 22MAR03
        movwf PORTE
        movlw 192         ; %11000000 stops usonic tx from operating in this mode
        movwf PORTB
        call OSCILLATE

        movf SHOWCHAN,W
        xorwf MODE,W
        btfsc STATUS,Z
        call SHOWLIGHT
        return

;************* READ WATER SENSOR ********

WATER:  movlw 0
        movwf PORTE
        movlw 64
        movwf PORTB
        call SONICTX3

        bcf STATUS,C        ; divide by 16
        rrf FREQMSB,F
        rrf FREQLSB,F
        bcf STATUS,C
        rrf FREQMSB,F
        rrf FREQLSB,F
        bcf STATUS,C
        rrf FREQMSB,F
        rrf FREQLSB,F
        bcf STATUS,C
        rrf FREQMSB,F
        rrf FREQLSB,F
        bcf STATUS,C
        rrf FREQMSB,F
        rrf FREQLSB,F
        bcf STATUS,C
        rrf FREQMSB,F
        rrf FREQLSB,F

        movf SHOWCHAN,W
        xorwf MODE,W
        btfsc STATUS,Z
        call SHOWWATER
        return

;****************** GET TEMPERATURE

TEMPERATURE:
        movlw %10000001 ; set AD on, Fosc/32
        iorlw %00011000      ; set for RA3
        movwf ADCON0
        call PAUSIT

        bsf ADCON0,GO       ;start data conversion
        call GETADC

        movf SHOWCHAN,W
        xorwf MODE,W
        btfsc STATUS,Z
        call SHOWTEMP
        return

;********* GET BAROMETER VALUE

BAROMETER:
        movlw %10000001    ; set AD on, Fosc/32, set for RA0
        movwf ADCON0
        call PAUSIT
        bsf ADCON0,GO         ; start data conversion
        call GETADC

        movf SHOWCHAN,W
        xorwf MODE,W
        btfsc STATUS,Z
        call SHOWBAROM
        return

;********* GET RAIN VALUE

RAINING: movlw 3           ; PORTE 011 - position Y3
        movwf PORTE
        movlw 192         ; %11000000 stops usonic tx from operating in this mode
        movwf PORTB
        movlw ' '
        movwf RAIN
        btfss PORTA,4
        return
        movlw '*'
        movwf RAIN
        return

;************ WIND TX/RX

WIND0:  movlw %00000001
        movwf PORTE
        movlw %00000000        ; North
        movwf PORTB
        clrf FREQLSB
        clrf FREQMSB
        call SONICTX

        movf FREQLSB,W
        movwf WIND0LSB
        BANK1
        movwf WINDNDLSB
        BANK0
        movf FREQMSB,W
        movwf WIND0MSB
        BANK1
        movwf WINDNDMSB
        BANK0
        movf SHOWCHAN,W
        xorwf MODE,W
        btfsc STATUS,Z
        call SHOWWIND
        return

WIND1:  movlw %00000001
        movwf PORTE
        movlw %01000000          ; South
        movwf PORTB
        call SONICTX

        movf FREQLSB,W
        movwf WIND1LSB
        BANK1
        movwf WINDSDLSB
        BANK0
        movf FREQMSB,W
        movwf WIND1MSB
        BANK1
        movwf WINDSDMSB
        BANK0
        movf SHOWCHAN,W
        xorwf MODE,W
        btfsc STATUS,Z
        call SHOWWIND
        return

WIND2:  movlw %00000001
        movwf PORTE
        movlw %10000000        ; West
        movwf PORTB
        call SONICTX

        movf FREQLSB,W
        movwf WIND2LSB
        BANK1
        movwf WINDWDLSB
        BANK0
        movf FREQMSB,W
        movwf WIND2MSB
        BANK1
        movwf WINDWDMSB
        BANK0
        movf SHOWCHAN,W
        xorwf MODE,W
        btfsc STATUS,Z
        call SHOWWIND
        return

WIND3:  movlw %00000001
        movwf PORTE
        movlw %11000000           ; East
        movwf PORTB
        call SONICTX

        movf FREQLSB,W
        movwf WIND3LSB
        BANK1
        movwf WINDEDLSB
        BANK0
        movf FREQMSB,W
        movwf WIND3MSB
        BANK1
        movwf WINDEDMSB
        BANK0
        movf SHOWCHAN,W
        xorwf MODE,W
        btfsc STATUS,Z
        call SHOWWIND
        return

;*************

OSCILLATE: movlw %00001100   ; stop timer 1
        movwf T1CON
        clrf TMR1L           ; reset timer 1
        clrf TMR1H
        bcf PIR1,0           ; timer rollover flag
        bsf T1CON,0          ; start timer 1

        bsf PORTE,2          ; set RE2 high
OSCA1:  btfsc PIR1,0         ; has timer 1 overflowed?
        goto ENDOSCA         ; yes
        btfss PORTA,4        ; no, is RA4 high yet?
        goto OSCA1           ; no 
        bcf PORTE,2          ; set RE2 low

OSCA2:  btfsc PIR1,0         ; has timer 1 overflowed?
        goto ENDOSCA         ; yes
        btfsc PORTA,4        ; no, is RA4 low yet?
        goto OSCA2           ; no

        bcf T1CON,0          ; stop timer 1
        clrf TMR1L           ; reset timer 1
        clrf TMR1H           ; and start required count over full up-down cycle
        bcf PIR1,0           ; timer rollover flag (but assumed not needed hereafter)
        bsf T1CON,0          ; start timer 1
      
        bsf PORTE,2          ; set RE2 high
OSCB1:  btfss PORTA,4        ; no, is RA4 high yet?
        goto OSCB1           ; no 

        bcf PORTE,2          ; set RE2 low
OSCB2:  btfsc PORTA,4        ; no, is RA4 low yet?
        goto OSCB2           ; no

ENDOSCA: bcf T1CON,0         ; stop timer 1
        btfss PIR1,0         ; has timer 1 overflowed?
        goto OSCB4           ; no
        movlw 255
        movwf TMR1L
        movwf TMR1H

OSCB4:  movf TMR1L,W         ; copy count into FREQ
        movwf FREQLSB
        movf TMR1H,W
        movwf FREQMSB
        bcf PORTE,2
        return


;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F87x devices ****
;         according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf STATUS,RP0  ;set for Page 3
        bcf EECON1,EEPGD ;point to data memory
        bsf EECON1,RD   ;enable read flag
        bcf STATUS,RP0  ;set for Page 2 
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        bcf STATUS,RP1  ;set for Page 0
        return

;******** LCD ROUTINES **********

LCD1:   movlw %10000000
        goto LCDLIN
LCD12:  movlw %10001100
        goto LCDLIN

LCD21:  movlw %11000000
        goto LCDLIN

LCD2B:  movlw %11001011
        goto LCDLIN
LCD2E:  movlw %11001110

LCDLIN: BCF RSLINE,4

LCDOUT: movwf STORE
        movlw 50
        movwf LOOPA
DELAYIT: decfsz LOOPA,F
        goto DELAYIT
        call SENDIT

SENDIT: swapf STORE,F
        movf STORE,W
        andlw 15
        iorwf RSLINE,W
        movwf PORTD
        BSF PORTA,2
        nop 
        nop
        BCF PORTA,2
        RETURN

;.............

PAUSIT: movlw 10
        movwf SLOWIT
        bcf INTCON,2
PAUSE:  btfss INTCON,2
        goto PAUSE
        bcf INTCON,2
        decfsz SLOWIT,F
        goto PAUSE
        return

PAUSIT2: clrf TMR0
        movlw 10
        movwf SLOWIT
        bcf INTCON,2
PAUSE2: btfss INTCON,2
        goto PAUSE2
        bcf INTCON,2
        decfsz SLOWIT,F
        goto PAUSE2
        return

;............

CLRLINE1: call LCD1     ;set address for line 1 cell 1
        bsf RSLINE,4    ;set RS for data send
        clrf LOOP       ;
CLRL1:  movlw ' '       ;clear cell
        call LCDOUT     ;
        incf LOOP,F     ;inc loop
        btfss LOOP,4    ;has last LCD letter been sent?
        goto CLRL1      ;no
        return

;************

bin2dec: clrf    digit1
	clrf	digit2
	clrf	digit3
	clrf	digit4
	clrf	digit5
	clrf	digit6
	clrf	digit7
	clrf	digit8

	movlw	24		;24 bits to do
	movwf	bitcnt

bitlp   rlf     count0,F        ;Shift msb into carry
	rlf	count1,F
	rlf	count2,F

	movlw	digit1
	movwf	fsr		;Pointer to digits
	movlw	8		;8 digits to do
	movwf	digcnt
adjlp	rlf	indf,F		;Shift digit 1 bit left
	movlw	10
	subwf	indf,w		;Check and adjust for decimal overflow
	skpnc
	movwf	indf

	incf	fsr,F		;Next digit
	decfsz	digcnt,F
	goto	adjlp
        decfsz  bitcnt,F        ;Next bit
	goto	bitlp
        movlw 48
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
	return

;********** GET ADC VALUE

GETADC: btfsc ADCON0,GO
        goto GETADC
        movf ADRESH,W     ;get ADC MSB val
        movwf FREQMSB
        movf MODE,W        ; is mode = TEMP?
        xorlw 8
        btfss STATUS,Z
        goto ADC2         ; no

        movf RAIN,W       ; is it raining?
        xorlw '*'
        btfsc STATUS,Z
        bsf FREQMSB,5     ; yes, so set bit 5

ADC2:   BANK1
        movf ADRESL,W     ;get ADC LSB val
        BANK0
        movwf FREQLSB
        return

;****************

;A neat Multiply routine, from Peter Hemsley 15July01.

;Multiply 16 bit multiplicand (mulcL,H) by 16 bit multiplier (mulpL,H)
;32 bit result (product) in mulpL,H (low word) and prodL,H (high word)

MULTIPLY: movlw  16        ; B'00010000' H'10'
          movwf  BITCNT  
          clrf   PRODLSB  
          clrf   PRODMSB  
JMP0014:  bcf    STATUS,0
          btfss  MULPLSB,0
          goto   JMP0028
          movf   MULCLSB,W
          addwf  PRODLSB,F
          movf   MULCMSB,W
          btfsc  STATUS,0
          goto   JMP0024
          addwf  PRODMSB,F
          goto   JMP0028
JMP0024:  addwf  PRODMSB,F
          incf   PRODMSB,F
          btfsc  STATUS,2
          bsf    STATUS,0
JMP0028:  rrf    PRODMSB,F
          rrf    PRODLSB,F
          rrf    MULPMSB,F
          rrf    MULPLSB,F
          decfsz BITCNT,F
          goto   JMP0014
          return 

DIVISION: movf   DIVISLSB,W
          iorwf  DIVISMSB,W
          btfsc  STATUS,2
          goto   JMP0041
          movlw  16
          movwf  BITCNT 
          clrf   REMDRMSB  
          clrf   REMDRLSB  
JMP0018:  bcf    STATUS,0
          rlf    DIVIDLSB,F
          rlf    DIVIDMSB,F
          rlf    REMDRLSB,F
          rlf    REMDRMSB,F
          movf   DIVISMSB,W
          subwf  REMDRMSB,W
          btfss  STATUS,2
          goto   JMP0029
          movf   DIVISLSB,W
          subwf  REMDRLSB,W
JMP0029:  btfss  STATUS,0
          goto   JMP0038
          movf   DIVISLSB,W
          subwf  REMDRLSB,F
          btfss  STATUS,0
          decf   REMDRMSB,F
          movf   DIVISMSB,W
          subwf  REMDRMSB,F
          bsf    DIVIDLSB,0
JMP0038:  decfsz BITCNT,F
          goto   JMP0018
          bcf    STATUS,2
JMP0041:  return 

;*************

CLRLINE2: call LCD21
        bsf RSLINE,4
        movlw 16
        movwf LOOP
CL2:    movlw ' '
        call LCDOUT
        decfsz LOOP,F
        goto CL2
        return

;***********

SONICTX: call PAUSIT2
        movlw 29
        call PRMGET           ; WINDPULSE number of pulses to be sent
        movwf LOOP

        movlw %00001100       ; stop timer 1
        movwf T1CON
        clrf TMR1L            ; reset timer 1
        clrf TMR1H
        bcf PIR1,0            ; clear timer 1 overflow
        bsf T1CON,0           ; start timer 1

BEAMITW: bsf PORTE,2          ;send 40kHz signal
         movlw 9              ;command qty sets freq/mark-space
         movwf LOOPA
B2:      decfsz LOOPA,F
         goto B2
         nop

         bcf PORTE,2
         movlw 9              ;command qty sets freq/mark-space
         movwf LOOPA
B3:      decfsz LOOPA,F
         goto B3
         nop

         decfsz LOOP,F
         goto BEAMITW
;         goto BEAMITW

        bcf PORTE,2
        movlw 31
        call PRMGET           ;WINDMASK  masking delay
        movwf LOOPA
        clrf LOOP
B4:     decfsz LOOP,F
        goto B4
        decfsz LOOPA,F
        goto B4
        clrf ISRFLAG
        bsf PORTA,5    ; set delay period monitor flag (for scope monitoring)

        movf PORTB,W
        bcf     INTCON, RBIF    ; and ensure flag bit is clear
        bsf     INTCON, RBIE    ; enable RBIF interrupt
        bsf     INTCON, GIE     ; enable global interrupts

LISTEN2: btfsc PIR1,0         ; has timer 1 overflowed?
        goto L2               ; yes
        btfss ISRFLAG,0
        goto LISTEN2          ; no

L2:     bcf     INTCON, GIE     ; disable global interrupts
        bcf     INTCON, RBIF    ; and ensure flag bit is clear
        bcf     INTCON, RBIE    ; disable RBIF interrupt

        bcf T1CON,0           ; yes, stop timer
        btfss PIR1,0          ; has timer 1 overflowed?
        goto L3               ; no
        clrf TMR1L            ; yes
        clrf TMR1H
        movlw $ff
        movwf TMR1L

L3:     bcf PORTA,5    ; clear delay period monitor flag (for scope monitoring)
        movf TMR1L,W          ; get sample count
        movwf FREQLSB
        movf TMR1H,W
        movwf FREQMSB
        return

;************

SONICTX3: call PAUSIT2
        movlw 25
        call PRMGET           ; WINDPULSE number of pulses to be sent
        movwf LOOP

        movlw %00001100       ; stop timer 1
        movwf T1CON
        clrf TMR1L            ; reset timer 1
        clrf TMR1H
        bcf PIR1,0            ; clear timer 1 overflow
        bsf T1CON,0           ; start timer 1

BEAMITW3: bsf PORTB,5           ;send 40kHz signal
         movlw 9              ;command qty sets freq/mark-space
         movwf LOOPA
B23:     decfsz LOOPA,F
         goto B23
         nop

         bcf PORTB,5           ;send 40kHz signal
         movlw 9              ;command qty sets freq/mark-space
         movwf LOOPA
B33:      decfsz LOOPA,F
         goto B33
         nop

         decfsz LOOP,F
         goto BEAMITW3
;         goto BEAMITW3

        bcf PORTE,2
        movlw 27
        call PRMGET           ;WATERMASK  masking delay
        movwf LOOPA
        clrf LOOP
B43:     decfsz LOOP,F
        goto B43
        decfsz LOOPA,F
        goto B43
        clrf ISRFLAG

        bsf PORTA,5    ; set delay period monitor flag (for scope monitoring)
        movf PORTB,W
        bcf     INTCON, RBIF    ; and ensure flag bit is clear
        bsf     INTCON, RBIE    ; enable RBIF interrupt
        bsf     INTCON, GIE     ; enable global interrupts

LISTEN23: btfsc PIR1,0         ; has timer 1 overflowed?
        goto L23               ; yes
        btfss ISRFLAG,0
        goto LISTEN23          ; no

L23:    bcf     INTCON, GIE     ; disable global interrupts
        bcf     INTCON, RBIF    ; and ensure flag bit is clear
        bcf     INTCON, RBIE    ; disable RBIF interrupt

        bcf T1CON,0           ; yes, stop timer
        btfss PIR1,0          ; has timer 1 overflowed?
        goto L33               ; no
        clrf TMR1L            ; yes
        clrf TMR1H
        movlw $ff
        movwf TMR1L

L33:    bcf PORTA,5    ; clear delay period monitor flag (for scope monitoring)
        movf TMR1L,W          ; get sample count
        movwf FREQLSB
        movf TMR1H,W
        movwf FREQMSB
        return

;**************

; From Program 4 of Malc Wiles' Demo of RBIF interrupt
; ----------------------------------------------------------
; Interrupt service routine
; ----------------------------------------------------------

ISR:    movwf SAVEW           ; save W 
        swapf STATUS,W
        movwf SAVES           ; save STATUS
        BANK0                 ; ensure bank 0 set for PORT access

; check that it's an RBIF interrupt 

        btfss INTCON, RBIF    ; test RBIF
        goto  POP             ; not an RBIF interrupt

        bsf ISRFLAG,0 
        bcf INTCON, RBIF      ; clear the interrupt

; restore context and exit

POP:    swapf SAVES,W         ; restore STATUS
        movwf STATUS
        swapf SAVEW,F         ; restore W
        swapf SAVEW,W
        retfie                ; exit ISR

;************

; counter = 1691 for 204mm
; counter = 1971 for 250mm
; so        280  for 46mm
; thus      280/46 = 6.087 counts for 1mm
; and       46/280 = 0.1643mm for 1 count 

; Speed of sound = 332metres/second
; 332m/s = 332mm/ms   

;332m/s * 3600 = 1,195,200m/h = 1195.2 kph *5/8 = 747.00 mph. count = -0
;333m/s * 3600 = 1,198,800m/h = 1198.8 kph *5/8 = 749.25 mph. count = -6.087
;334m/s * 3600 = 1,202,400m/h = 1202.4 kph *5/8 = 751.50 mph. count = -12.174
;335m/s * 3600 = 1,206,000m/h = 1206.0 kph *5/8 = 753.25 mph. count = -18.261

;but, the counter only increment by 5 counts, not 1, which = 0.8215mm
;so resolution can only be 749.25-747.0 = 2.5mph *5/6.087 = 1.845mph =2.952kph
;when test for PIR overflow is included
;When PIR check excluded, increments in 3 counts
;so resolution can only be 749.25-747.0 = 2.5mph *3/6.087 = 1.232mph =1.971kph
;ideal would be increment in 1 = 2.5mph / 6.087 = 0.41mph = 0.557kph
        
;**************

SETBAUD:  BANK1
          movlw 64            ; BRG for 9600baud from 10MHz, brgh=1
          movwf SPBRG

          movlw %00000101     ; set sync=0, brgh=1 + ninth bit set
          movwf TXSTA         ; it is essential to set 9th bit when data
                              ; is output to QBasic

          movlw %10000111     ;set output reg (RC6 is the pin)
          movwf TRISC
          bcf PIE1,4          ;clear interrupt bit (bit TXIE)
          BANK0

          movlw %10000000     ;set SPEN Bit of RCSTA reg
          movwf RCSTA

          BANK1
          bsf TXSTA,5         ;enable transmission (bit TXEN)
          BANK0
          return

SERIAL1:  btfss PIR1,4  ;wait for TXIF bit 4 to go high (showing TXREG empty)
          goto SERIAL1
          nop
          movwf TXREG         ;put val in TXREG ready for transmission
          return

;*************** OUTPUT TO PC SERIAL PORT FOR INDIVIDUAL SAMPLES

SENDSERIAL: movlw MEM1
        movwf FSR
        clrf LOOP
        movlw 0
        movwf COUNT0
        call SERIAL
        movlw 255
        movwf COUNT0
        call SERIAL
        movlw 0
        movwf COUNT0
        call SERIAL

SENDSER2: BLOCK1
        movf INDF,W
        BLOCK0
        movwf COUNT0
        call SERIAL
        incf FSR,F
        incf LOOP,F
        movf LOOP,W
        xorlw 20
        btfss STATUS,Z
        goto SENDSER2

        movf SHOWCHAN,W   ; is showchan = 10?
        xorlw 10
        btfsc STATUS,Z
        call QUADWIND

        movf SHOWCHAN,W   ; is showchan = 11?
        xorlw 11
        btfsc STATUS,Z
        call SHOWSAMPLECOUNT  ; yes

CHKTIM: decfsz SAMCNTLSB,F   ;dec sample counter lsb, is it = 0?
        return               ;no
        movf SAMCNT,W
        movwf SAMCNTLSB
        movf SAMCNTMSB,F     ; is msb = 0 ?
        btfsc STATUS,Z
        goto CHKTIM2         ; yes
        decf SAMCNTMSB,F   ; no, so dec msb
        return

CHKTIM2: movf MEMCNT,F       ; are any memory chips present?
        btfsc STATUS,Z
        return              ; no, none

        movlw 37           ; yes, at least one mem chip exists
        call PRMGET
        movwf SAMCNTMSB    ; reset sampling rate for eeprom chips
        movf SAMCNT,W
        movwf SAMCNTLSB

        movlw MEM1         ; store samples to eeprom chips
        movwf FSR
        clrf LOOP

SAVEIT: BLOCK1
        movf INDF,W
        BLOCK0
        movwf MEMHI     ;msb data value to be sent to EEPROM chip
        incf FSR,F

        BLOCK1
        movf INDF,W
        BLOCK0
        movwf MEMLO     ;lsb data value to be sent to EEPROM chip

        bsf PCLATH,3
        call SAVESAMPLE
        bcf PCLATH,3

        movf MEMFUL,F
        btfsc STATUS,Z
        goto SAV2
        clrf MEMFUL
        return

SAV2:   incf FSR,F
        incf LOOP,F
        movf LOOP,W
        xorlw 10
        btfss STATUS,Z
        goto SAVEIT

        return

SERIAL: btfss PIR1,4  ;wait for TXIF bit 4 to go high (showing TXREG empty)
        goto SERIAL
        movf COUNT0,W
        andlw 127
        movwf TXREG   ;put val (held in W) in TXREG ready for transmission
        return

;***************

SAMPLIT: incf MODE,F
        call ROUTEIT

        bcf STATUS,C
        rlf MODE,W
        iorlw MEM1
        movwf FSR
        BLOCK1
        bcf STATUS,C
        rlf FREQLSB,W        ; rotate LSB bit 7 into MSB
        rlf FREQMSB,W
        andlw %01111111      ; clear bit 7 of MSB
        movwf INDF           ; put MSB into MEM + 0

        incf FSR,F
        movf FREQLSB,W
        andlw %01111111      ; clear bit 7 of LSB
        movwf INDF           ; put LSB into MEM + 1
        BLOCK0
        return

;***********SHOW HUMIDITY VALUE **********

SHOWHUMID: call CLRLINE1
        movlw 0
        movwf SUBJECTNO
        movlw 5               ; show mode name
        call SHOWSUBJECT

        movlw 0
        call GETPERCENT

        movf DIVIDLSB,W    ; copy answer for decimalisation
        movwf COUNT0
        movf DIVIDMSB,W
        movwf COUNT1
        clrf COUNT2
        call bin2dec

        call CLRLINE2
        call LCD21
        bsf RSLINE,4

        movf DIGIT3,W         ; is there a leading zero?
        andlw 15
        btfsc STATUS,Z
        goto HUMID2           ; yes
        movf DIGIT3,W         ; no
        call LCDOUT
HUMID2: movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movlw '%'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movf RAIN,W
        call LCDOUT
        return

;**********SHOW SOIL MOISTNESS **********

SHOWSOIL: movlw 5
        movwf SUBJECTNO
        movlw 5
        call SHOWSUBJECT

        movlw 4
        call GETPERCENT

        movf DIVIDLSB,W
        sublw 100          ; subtract from 100
        movwf DIVIDLSB
        btfss STATUS,C
        decf DIVIDMSB,F

        movf DIVIDLSB,W    ; copy answer for decimalisation
        movwf COUNT0
        movf DIVIDMSB,W
        movwf COUNT1
        clrf COUNT2

        call bin2dec
        call CLRLINE2
        call LCD21
        bsf RSLINE,4

        movf DIGIT3,W         ; is there a leading zero?
        andlw 15
        btfsc STATUS,Z
        goto SOIL3            ; yes
        movf DIGIT3,W         ; no
        call LCDOUT
SOIL3:  movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movlw '%'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movf RAIN,W
        call LCDOUT

        return

;************ SHOW LIGHTLEVEL ***********

SHOWLIGHT: movlw 10
        movwf SUBJECTNO
        movlw 5
        call SHOWSUBJECT

        movlw 8
        call GETPERCENT

        movf DIVIDLSB,W
        sublw 100          ; subtract from 100
        movwf DIVIDLSB
        btfss STATUS,C
        decf DIVIDMSB,F

        movf DIVIDLSB,W    ; copy answer for decimalisation
        movwf COUNT0
        movf DIVIDMSB,W
        movwf COUNT1
        clrf COUNT2
        call bin2dec
        call CLRLINE2
        call LCD21
        bsf RSLINE,4

        movf DIGIT3,W         ; is there a leading zero?
        andlw 15
        btfsc STATUS,Z
        goto LIGHT2           ; yes

        movf DIGIT3,W         ; no
        call LCDOUT
LIGHT2: movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movlw '%'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movf RAIN,W
        call LCDOUT
        return

;************** SHOW WATER LEVEL **************

SHOWWATER: movlw 15
        movwf SUBJECTNO
        movlw 5 
        call SHOWSUBJECT

        movlw 12
        call GETPERCENT

        movf DIVIDLSB,W
        sublw 100          ; subtract from 100
        movwf DIVIDLSB
        btfss STATUS,C
        decf DIVIDMSB,F

        movf DIVIDLSB,W    ; copy answer for decimalisation
        movwf COUNT0
        movf DIVIDMSB,W
        movwf COUNT1
        clrf COUNT2

        call CLRLINE2
        call bin2dec
        call LCD21
        bsf RSLINE,4

        movf DIGIT3,W         ; is there a leading zero?
        andlw 15
        btfsc STATUS,Z
        goto WATER2           ; yes

        movf DIGIT3,W
        call LCDOUT
WATER2: movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movlw '%'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movf RAIN,W
        call LCDOUT
        return

;********* SHOW TEMPERATURE *************

SHOWTEMP: call CLRLINE1
        movlw 20
        movwf SUBJECTNO
        movlw 5 
        call SHOWSUBJECT

        movf FREQMSB,W      ; put val into REGA
        andlw %00011111     ; exclude rain flag
        BANK1
        movwf REGA1
        BANK0
        movf FREQLSB,W
        BANK1
        movwf REGA0
        clrf REGA2
        clrf REGA3
        BANK0
        clrf COUNT2

        movlw 16
        call PRMGET       ; MSB to be multiplied
        BANK1
        movwf REGB1
        BANK0
        movlw 17
        call PRMGET       ; LSB to be multiplied
        BANK1
        movwf REGB0
        clrf REGB2
        clrf REGB3
        BANK0

        bsf PCLATH,3
        BANK1
        call MULTIPLY32   ; REGA * REGB -> REGA
        BANK0
        clrf PCLATH

        BANK1
        movf REGA0,W
        BANK0
        movwf COUNT0
        BANK1
        movf REGA1,W
        BANK0
        movwf COUNT1
        clrf COUNT2

        movlw 18
        call PRMGET       ; MSB of divisor
        BANK1
        movwf REGB1
        BANK0
        movlw 19
        call PRMGET       ; LSB of divisor
        BANK1
        movwf REGB0
        clrf REGB2
        clrf REGB3
        BANK0

        bsf PCLATH,3
        BANK1
        call DIVIDE32     ; REGA / REGB -> REGA
        BANK0
        clrf PCLATH

        movlw 39          ; add correction
        call PRMGET       ; LSB of +- value
        BANK1             
        addwf REGA0,F
        btfsc STATUS,C
        incf REGA1,F        
        BANK0

        movlw 38
        call PRMGET       ; MSB of +- value
        BANK1             
        addwf REGA1,F
        movf REGA0,W
;        BANK0

;        BANK1
        movf REGA1,W
;        BANK0
;        BANK1
        movf REGA0,W
        BANK0
        movwf COUNT0
        BANK1
        movf REGA1,W
        BANK0
        movwf COUNT1

        clrf SIGN
        btfss COUNT1,7
        goto SHOWT2
        comf COUNT0,F           ; yes, so invert result
        comf COUNT1,F
        incf COUNT0,F
        movlw '-'
        movwf SIGN

SHOWT2: movf COUNT0,W
        movwf FAHRENLSB    ; store for conversion
        movf COUNT1,W
        movwf FAHRENMSB    ; store for conversion

        call bin2dec
        call CLRLINE2
        call LCD21
        bsf RSLINE,4

        movf SIGN,W
        btfss STATUS,Z
        call LCDOUT

        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movlw '.'
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movlw $DF          ; degrees symbol '^'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw ' '
        call LCDOUT

        movf FAHRENLSB,W
        movwf MULCLSB
        movf FAHRENMSB,W
        movwf MULCMSB
        movlw 9
        movwf MULPLSB
        clrf MULPMSB
        call MULTIPLY           ; multiply by 9

        movf MULPLSB,W
        movwf DIVIDLSB
        movf MULPMSB,W
        movwf DIVIDMSB
        movlw 5
        movwf DIVISLSB
        clrf DIVISMSB
        call DIVISION            ; divide by 5

        movf DIVIDLSB,W
        movwf COUNT0
        movf DIVIDMSB,W
        movwf COUNT1
        clrf COUNT2

        movf SIGN,W              ; is sign negative?
        btfsc STATUS,Z
        goto TEM332              ; no

        movlw $40
        movwf DIGIT1
        movlw $01
        movwf DIGIT2

        movf COUNT0,W            ; yes, so subtract val from 320
        subwf DIGIT1,F
        btfss STATUS,C
        decf DIGIT2,F
        movf COUNT1,W
        subwf DIGIT2,F

        movf DIGIT2,W
        movwf COUNT1
        movf DIGIT1,W
        movwf COUNT0

        goto SHOWT3

TEM332: movlw $40               ; add 320  (add 32.0^) = $140
        addwf COUNT0,F
        btfsc STATUS,C
        incf COUNT1,F
        incf COUNT1,F

SHOWT3: call bin2dec
        movf DIGIT4,W
        andlw 15
        btfsc STATUS,Z
        goto TEM432
        movf DIGIT4,W
        call LCDOUT

TEM432: movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movlw '.'
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movlw $DF          ; degrees symbol '^'
        call LCDOUT
        movlw 'F'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movf RAIN,W
        call LCDOUT
        return

;********* SHOW BAROMETER READING

SHOWBAROM: movlw 25
        movwf SUBJECTNO
        movlw 5
        call SHOWSUBJECT

        movf FREQMSB,W      ; put val into REGA
        andlw %00011111     ; exclude rain flag
        BANK1
        movwf REGA1
        BANK0
        movf FREQLSB,W
        BANK1
        movwf REGA0
        clrf REGA2
        clrf REGA3
        BANK0
        clrf COUNT2

        movlw 20
        call PRMGET       ; MSB to be multiplied
        BANK1
        movwf REGB1
        BANK0
        movlw 21
        call PRMGET       ; LSB to be multiplied
        BANK1
        movwf REGB0
        clrf REGB2
        clrf REGB3
        BANK0

        bsf PCLATH,3
        BANK1
        call MULTIPLY32   ; REGA * REGB -> REGA
        BANK0
        clrf PCLATH

        BANK1
        movf REGA0,W
        BANK0
        movwf COUNT0
        BANK1
        movf REGA1,W
        BANK0
        movwf COUNT1
        clrf COUNT2

        movlw 22
        call PRMGET       ; MSB of divisor
        BANK1
        movwf REGB1
        BANK0
        movlw 23
        call PRMGET       ; LSB of divisor
        BANK1
        movwf REGB0
        clrf REGB2
        clrf REGB3
        BANK0

        bsf PCLATH,3
        BANK1
        call DIVIDE32     ; REGA / REGB -> REGA
        BANK0
        clrf PCLATH

        BANK1
        movf REGA0,W
        BANK0
        movwf COUNT0
        BANK1
        movf REGA1,W
        BANK0
        movwf COUNT1

        movlw 41          ; add correction
        call PRMGET       ; LSB of +- value
        addwf COUNT0,F
        btfsc STATUS,C
        incf COUNT1,F
        movlw 40
        call PRMGET       ; MSB of +- value
        addwf COUNT1,F

        call bin2dec
        call CLRLINE2
        call LCD21
        bsf RSLINE,4

        movf DIGIT4,W         ; is there a leading zero?
        andlw 15
        btfsc STATUS,Z
        goto BAROM2A          ; yes
        movf DIGIT4,W 
        call LCDOUT

BAROM2A: 
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movlw 'm'
        call LCDOUT
        movlw 'B'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movf RAIN,W
        call LCDOUT
        return

;*********** SHOW WIND VALUES

SHOWWIND: call GETHYPOT
        call LCD1
        bsf RSLINE,4
        movlw 'W'
        call LCDOUT
        movlw 'I'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        movlw 'D'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'N'
        call LCDOUT

        movf WIND0LSB,W
        movwf COUNT0
        clrf COUNT1
        clrf COUNT2

        bsf PCLATH,3
        call BIN2HEX
        clrf PCLATH

        movlw '-'
        btfsc WIND1LSB,0      ; show negative sign if needed
        call LCDOUT

        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT

        movlw ' '
        call LCDOUT
        movlw 'W'
        call LCDOUT

        movf WIND2LSB,W
        movwf COUNT0
        clrf COUNT1
        clrf COUNT2

        bsf PCLATH,3
        call BIN2HEX
        clrf PCLATH

        movlw '-'
        btfsc WIND3LSB,0      ; show negative sign if needed
        call LCDOUT

        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movlw ' '
        call LCDOUT
        movf RAIN,W
        call LCDOUT
        goto ENDWIND

        movlw '1'                 ; author's test for direction bit results
        btfss COMPASSSTORE,3
        movlw '0'
        call LCDOUT
        movlw '1'
        btfss COMPASSSTORE,2
        movlw '0'
        call LCDOUT
        movlw '1'
        btfss COMPASSSTORE,1
        movlw '0'
        call LCDOUT
        movlw '1'
        btfss COMPASSSTORE,0
        movlw '0'
        call LCDOUT

ENDWIND: bcf INTCON, RBIF   ; and ensure flag bit is clear
        bcf INTCON, GIE     ; disable global interrupts
        return

;******** GET PERCENTAGE ***********

GETPERCENT: 
        movwf STORE1
        call PRMGET     ; get max value
        movwf MAXMSB
        movwf MULCMSB
        movf STORE1,W
        addlw 1
        call PRMGET
        movwf MAXLSB
        movwf MULCLSB

        movf STORE1,W   ; get min value
        addlw 2
        call PRMGET
        movwf MINMSB
        movf STORE1,W
        addlw 3
        call PRMGET
        movwf MINLSB

        movf FREQLSB,W      ; subtract count from MAX (held in MULC)
        subwf MULCLSB,F
        btfsc STATUS,C     ; is there a borrow?
        goto GP1           ; no
        movlw 1            ; yes, so subtract 1 from msb
        subwf MULCMSB,F
        btfss STATUS,C     ; is there a borrow?
        goto GP1A          ; yes

GP1:    movf FREQMSB,W     ; subtract count from MAX (held in MULC)
        subwf MULCMSB,F
        btfsc STATUS,C     ; is there a borrow?
        goto GP1B          ; no 

GP1A:   clrf DIVIDMSB      ; yes so set result to 100
        movlw 100
        movwf DIVIDLSB
        return

GP1B:   movf FREQLSB,W     ; copy count into MULP
        movwf MULCLSB
        movf FREQMSB,W
        movwf MULCMSB

        movf MINLSB,W      ; subtract min from max
        subwf MAXLSB,F
        btfss STATUS,C
        decf MAXMSB,F
        movf MINMSB,W      ; subtract min from max
        subwf MAXMSB,F

        movf MINLSB,W      ; subtract min LSB from count (held in MULC)
        subwf MULCLSB,F
        btfsc STATUS,C     ; is there a borrow?
        goto GP2           ; no
        movlw 1            ; yes, so subtract 1 from msb
        subwf MULCMSB,F
        btfss STATUS,C     ; is there a borrow?
        goto GP3           ; yes

GP2:    movf MINMSB,W      ; subtract min MSB from count (held in MULC)
        subwf MULCMSB,F
        btfss STATUS,C     ; is there a borrow?
        goto GP3           ; yes

        movf MODE,W        ; is mode = 7 (barom)
        xorlw 7
        movlw 110
        btfss STATUS,Z
        movlw 100
        movwf MULPLSB
        clrf MULPMSB
        call MULTIPLY           ; multiply by 100 or 110

CHECKPROD: movf PRODLSB,W       ; is answer > 65535?
        btfsc STATUS,Z
        goto CPD2               ; no
        bcf STATUS,C            ; yes, so divide answer by 2
        rrf PRODLSB,F
        rrf MULPMSB,F
        rrf MULPLSB,F
        bcf STATUS,C            ; yes, and divide range by 2
        rrf MAXMSB,F
        rrf MAXLSB,F
        goto CHECKPROD          ; and try again

CPD2:   movf MULPLSB,W          ; copy answer into divide
        movwf DIVIDLSB
        movf MULPMSB,W
        movwf DIVIDMSB

        movf MAXMSB,W       ; get the max-min val (range)
        movwf DIVISMSB
        movf MAXLSB,W       ; get the max-min val (range)
        movwf DIVISLSB
        call DIVISION       ; divide sensor val by range
        return

GP3:    clrf DIVIDLSB      ; yes so set result to 0
        clrf DIVIDMSB
        return

; ******** SQUARE ROOT ROUTINE FROM PETER HEMSLEY *********

; Disassembly from C:\PIC\SQRT.HEX on 04-02-2002 at 21:14:19


SQRT:     clrf   ROOTL  
          clrf   ROOTH  
          clrf   REMDRL  
          clrf   REMDRH  

          movlw  12
          movwf  COUNT0
SQRLP:    rlf    NUML,F
          rlf    NUMM,F
          rlf    NUMH,F
          rlf    REMDRL,F
          rlf    REMDRH,F
          rlf    NUML,F
          rlf    NUMM,F
          rlf    NUMH,F
          rlf    REMDRL,F
          rlf    REMDRH,F
          bcf    ROOTL,0
          bsf    STATUS,0
          rlf    ROOTL,F
          rlf    ROOTH,F
          movf   ROOTH,W
          subwf  REMDRH,W
          btfss  STATUS,2
          goto   TSTGT
          movf   ROOTL,W
          subwf  REMDRL,W
TSTGT:    btfss  STATUS,0
          goto   REMLT
          movf   ROOTL,W
          subwf  REMDRL,F
          btfss  STATUS,0
          decf   REMDRH,F
          movf   ROOTH,W
          subwf  REMDRH,F
          bsf    ROOTL,1
REMLT:    decfsz COUNT0,F
          goto   SQRLP
          bcf    STATUS,0
          rrf    ROOTH,F
          rrf    ROOTL,F
         return

;*********** GET WIND SPEED FROM VALUES OF WIND0 AND WIND1
; using standard formula: hypoteneuse = sqr.root((adjacent^2) + (opposite^2))
; thus speed = sqr.root((north^2) + (west^2))

GETHYPOT: clrf COMPASSVAL
        movlw 33
        call PRMGET
        movwf STORE
        btfss STORE,3         ; is val >= 8? (i.e has val to be added to north?)
        goto HYP2B            ; no
        bcf STORE,3

        movf STORE,W          ; yes, add correction val to north
        andlw %00000111
        addwf WIND0LSB,F
        btfsc STATUS,C
        incf WIND0MSB,F
        goto HYP2C

HYP2B:  movf STORE,W          ; no, add correction to south
        addwf WIND1LSB,F
        btfsc STATUS,C
        incf WIND1MSB,F

HYP2C:  movf WIND1LSB,W       ; subtract South (Wind1) from North (Wind0)
        subwf WIND0LSB,F      ; leaving answer in Wind0
        btfss STATUS,C        ; is there a borrow?
        incf WIND1MSB,F       ; yes, so inc val of next byte to be subtracted
        movf WIND1MSB,W       ; subtract South from North MSB
        subwf WIND0MSB,F
        clrf WIND1LSB         ; used as a flag for non-inversion
        btfsc STATUS,C        ; is there a borrow?
        goto HYP2             ; no
        comf WIND0MSB,F       ; yes, so invert answer
        comf WIND0LSB,F       
        incf WIND0LSB,F       
        btfss STATUS,Z        ; is LSB = 0?
        incf WIND1LSB,F       ; no, used as a flag for inversion
        bsf COMPASSVAL,2

HYP2:   movf WIND0LSB,W       ; square the value of north (only LSB needed)
        movwf MULCLSB         ; with answer going into WindN
        movwf MULPLSB
        clrf MULCMSB
        clrf MULPMSB
        call MULTIPLY

        movf MULPLSB,W
        movwf WINDNLSB
        movf MULPMSB,W
        movwf WINDNMSB

        movlw 35
        call PRMGET
        movwf STORE
        btfss STORE,3         ; is val >= 8? (i.e has val to be added to west?)
        goto HYP3B            ; no
        bcf STORE,3

        movf STORE,W          ; yes, add correction val to west
        andlw %00000111
        addwf WIND2LSB,F
        btfsc STATUS,C
        incf WIND2MSB,F
        goto HYP3C

HYP3B:  movf STORE,W          ; no, add correction to east
        addwf WIND3LSB,F
        btfsc STATUS,C
        incf WIND3MSB,F

HYP3C:  movf WIND3LSB,W       ; subtract East (Wind3) from West (Wind2)
        subwf WIND2LSB,F      ; leaving answer in Wind2
        btfss STATUS,C        ; is there a borrow?
        incf WIND3MSB,F       ; yes, so inc val of next byte to be subtracted
        movf WIND3MSB,W       ; subtract East from West MSB
        subwf WIND2MSB,F
        clrf WIND3LSB         ; used as a flag for non-inversion
        btfsc STATUS,C        ; is there a borrow?
        goto HYP3             ; no
        comf WIND2MSB,F       ; yes, so invert answer
        comf WIND2LSB,F
        incf WIND2LSB,F       
        btfss STATUS,Z        ; is LSB = 0?
        incf WIND3LSB,F       ; used as a flag for inversion
        bsf COMPASSVAL,3

HYP3:   movf WIND2LSB,W       ; square the value of west
        movwf MULCLSB         ; with answer going into WindW
        movwf MULPLSB
        clrf MULCMSB
        clrf MULPMSB
        call MULTIPLY

        movf MULPLSB,W
        movwf WINDWLSB
        movf MULPMSB,W
        movwf WINDWMSB

        clrf MULCMSB        ; add the 2 squared values
        movf WINDNLSB,W     ; with answer going into MULC
        addwf WINDWLSB,W 
        movwf MULCLSB
        btfsc STATUS,C
        incf MULCMSB,F
        movf WINDNMSB,W
        addwf WINDWMSB,W 
        addwf MULCMSB,F

        movlw 9             ; multiply by 9. The reason is that
        movwf MULPLSB       ; each ultrasonic digit difference between
        movlw 0             ; base figure and speed figure represents
        movwf MULPMSB       ; approx 3 kph. Squaring 3 (= 9) gives closer
        call MULTIPLY       ; tolerance to decimals

        movf MULPLSB,W      ; take answer (in MULP) and get its square root
        movwf NUML          ; with answer going into ROOT 
        movf MULPMSB,W
        movwf NUMM
        clrf NUMH

        call SQRT           ; get square root

        movf ROOTL,W
        movwf COUNT0
        movf ROOTH,W
        movwf COUNT1
        clrf COUNT2

        call bin2dec
        call CLRLINE2

        call LCD21
        bsf RSLINE,4
        movf DIGIT3,W
        andlw 15
        btfsc STATUS,Z
        goto KP2            ; bypass leading zero
        movf DIGIT3,W
        call LCDOUT
KP2:    movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movlw 'k'
        call LCDOUT
        movlw 'p'
        call LCDOUT
        movlw 'h'
        call LCDOUT
        movlw ' '
        call LCDOUT

        movf ROOTL,W
        movwf MULCLSB
        movf ROOTH,W
        movwf MULCMSB

        movlw 5                 ; get MPH
        movwf MULPLSB
        clrf MULPMSB
        call MULTIPLY           ; multiply by 5

        movf MULPLSB,W
        movwf DIVIDLSB
        movf MULPMSB,W
        movwf DIVIDMSB

        movlw 8                 ; divide by 8
        movwf DIVISLSB
        clrf DIVISMSB
        call DIVISION

        movf DIVIDLSB,W
        movwf COUNT0
        movf DIVIDMSB,W
        movwf COUNT1
        clrf COUNT2
        call bin2dec

        movf DIGIT3,W
        andlw 15
        btfsc STATUS,Z
        goto MP2            ; bypass leading zero
        movf DIGIT3,W
        call LCDOUT

MP2:    movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movlw 'm'
        call LCDOUT
        movlw 'p'
        call LCDOUT
        movlw 'h'
        call LCDOUT

DIRECTION: movf WIND0LSB,W     ; are both winds = 0?
         iorwf WIND2LSB,W
         btfsc STATUS,Z
         goto DIR13            ; yes, so leave compass bearing as previous

         movf WIND0LSB,W       ; are both winds equal to each other?
         xorwf WIND2LSB,W
         btfss STATUS,Z
         goto DIR0             ; no
         bsf COMPASSVAL,1      ; yes, (bit 1 = 1, bit 0 remains = 0)
         goto DIR12            ; so it's a 45 degree base angle

DIR0:    movf WIND2LSB,W       ; is west = 0?
         btfss STATUS,Z
         goto DIR1             ; no
         bsf COMPASSVAL,0      ; yes, so north is dominant (bit 0 = 1)
         goto DIR12

DIR1:    movf WIND0LSB,W       ; is north = 0?
         btfsc STATUS,Z
         goto DIR12            ; yes, so west is dominant (bit 0 remains = 0)

DIR2:   movf WIND0LSB,W        ; set Wind0 (north) as number to be divided
        movwf DIVIDLSB
        clrf DIVIDMSB
        bsf COMPASSVAL,0       ; set north as dominant (bit 0 = 1)

        movf WIND2LSB,W        ; set Wind2 (west) as the dividing number
        movwf DIVISLSB
        clrf DIVISMSB

        movf WIND2LSB,W        ; is number to be divided > than divisor?
        subwf DIVIDLSB,W
        btfsc STATUS,C
        goto DIR3              ; yes

        movf WIND2LSB,W        ; no, set Wind2 as number to be divided
        movwf DIVIDLSB
        movf WIND0LSB,W        ; and set Wind0 as dividing number
        movwf DIVISLSB
        bcf COMPASSVAL,0       ; set west as dominant (bit 0 = 0)

DIR3:   call DIVISION          ; divide
        movlw %11111110        ; is answer less than 2? This fig has been arrived at
        andwf DIVIDLSB,W       ;   by examining the results of the formula: angle = ATN(N / W) / (PI/180) in Basic
        btfss STATUS,Z         ;   where ATN = arctangent
        goto DIR12             ; no, answer is >= 2 leave COMPASSVAL,0 still as previously set

DIR4:   bsf COMPASSVAL,1       ; yes, answer <2, so angle is between about 30 and 45 degrees, i.e. midway
        bcf COMPASSVAL,0       ; set COMPASSVAL,0 = 0 & COMPASSVAL,1 = 1

DIR12:  movf COMPASSVAL,W
        movwf COMPASSSTORE

DIR13:  call LCD2E
        bsf RSLINE,4
        movf COMPASSSTORE,W
        bsf PCLATH,3
        call COMPASS1
        clrf PCLATH
        call LCDOUT
        movf COMPASSSTORE,W
        bsf PCLATH,3
        call COMPASS2
        clrf PCLATH
        call LCDOUT
        movf RAIN,W
        call LCDOUT

ENDDIR: return

;**************

INCSHOWCHAN:

        btfsc HOLDLCD,0         ; is LCD screen to be held?
        return                  ; yes
        incf SHOWCHAN,F
        movf SHOWCHAN,W
        xorlw 5                 ; if showchan = 5 then showchan = 8
        movlw 8                 ; to avoid repeating wind details 4 times
        btfsc STATUS,Z
        movwf SHOWCHAN

        movf SHOWCHAN,W
        xorlw 12
        btfsc STATUS,Z
        clrf SHOWCHAN

INCSC2: return

; **************

SHOWSAMPLECOUNT:
        clrf LOOP
        call LCD1
        bsf RSLINE,4
SHOWCNT: movf LOOP,W
        bsf PCLATH,3
        call SAMPLECOUNT
        clrf PCLATH

        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWCNT

        call CLRLINE2
        call LCD21
        bsf RSLINE,4
        movf MEMCNT,F   ; is MEMCNT = 0 (no mem chips selected)?
        movlw '0'
        btfss STATUS,Z
        incf ECHAN,W     ; no, there are chips selected
        iorlw 48
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT

        movf WADDRL,W
        BANK1
        movwf REGA0
        BANK0
        movf WADDRH,W
        BANK1
        movwf REGA1
        clrf REGA2
        clrf REGA3

        movlw 20
        movwf REGB0
        clrf REGB1
        clrf REGB2
        clrf REGB3
        BANK0

        bsf PCLATH,3
        BANK1
        call DIVIDE32     ; REGA / REGB -> REGA
        BANK0
        clrf PCLATH

        BANK1
        movf REGA2,W
        BANK0
        movwf COUNT2
        BANK1
        movf REGA1,W
        BANK0
        movwf COUNT1
        BANK1
        movf REGA0,W
        BANK0
        movwf COUNT0
        call BIN2DEC
        movf DIGIT5,W
        call LCDOUT
        movf DIGIT4,W
        call LCDOUT
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movf RAIN,W
        call LCDOUT
        return

;............

CLRMEM: clrf LOOP
        movlw MEM1
        movwf FSR
CLRSER: BLOCK1
        clrf INDF
        BLOCK0
        incf FSR,F
        incf LOOP,F
        movf LOOP,W
        xorlw 36
        btfss STATUS,Z
        goto CLRSER
        return

LONGPAUSE: call PAUSIT  ;1/5 sec delay
        call PAUSIT     ;1/5 sec delay
        call PAUSIT     ;1/5 sec delay
        call PAUSIT     ;1/5 sec delay
        call PAUSIT     ;1/5 sec delay
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        return

; *********************

QUADWIND: bsf PCLATH,3
        call SHOWQUADWIND
        clrf PCLATH
        return

;**************************

          org $0800

TABLCD: addwf PCL,F     ;LCD initialisation table
        retlw %00110011 ;initialise lcd - first byte
        retlw %00110011 ;2nd byte (repeat of first)
        retlw %00110010 ;set for 4-bit operation
        retlw %00101100 ;set for 2 lines
        retlw %00000110 ;set entry mode to increment each address
        retlw %00001100 ;set display on, cursor off, blink off
        retlw %00000001 ;clear display
        retlw %00000010 ;return home, cursor & RAM to zero
                        ;end inititalisation table

COMPASS1: ADDWF PCL,F    ; Compass points
        retlw 'W'       ; 0  0    0000
        retlw 'N'       ; 1  1    0001
        retlw 'N'       ; 2  2    0010
        retlw '*'       ; 3  3    0011

        retlw 'W'       ; 4  4    0100
        retlw 'S'       ; 5  5    0101
        retlw 'S'       ; 6  6    0110
        retlw '*'       ; 7  7    0111

        retlw 'E'       ; 8  8    1000
        retlw 'N'       ; 9  9    1001
        retlw 'N'       ;10  10   1010
        retlw '*'       ;11  11   1011

        retlw 'E'       ;12  12   1100
        retlw 'S'       ;13  13   1101
        retlw 'S'       ;14  14   1110
        retlw '*'       ;15  15   1111
        retlw '?'       ;16      10000

COMPASS2: ADDWF PCL,F    ; Compass points
        retlw ' '       ; 0
        retlw ' '       ; 1
        retlw 'W'       ; 2
        retlw '*'       ; 3

        retlw ' '       ; 4
        retlw ' '       ; 5
        retlw 'W'       ; 6
        retlw '*'       ; 7

        retlw ' '       ; 8
        retlw ' '       ; 9
        retlw 'E'       ;10
        retlw '*'       ;11

        retlw ' '       ;12
        retlw ' '       ;13
        retlw 'E'       ;14
        retlw '*'       ;15
        retlw ' '       ;16


CHANEL: ADDWF PCL,F     ;add program counter
        retlw 'C'
        retlw 'H'
        retlw 'A'
        retlw 'N'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '

MESSAG: addwf PCL,F
        retlw 'P'
        retlw 'I'
        retlw 'C'
        retlw ' '
        retlw 'M'
        retlw 'E'
        retlw 'T'
        retlw ' '
        retlw 'O'
        retlw 'F'
        retlw 'F'
        retlw 'I'
        retlw 'C'
        retlw 'E'
        retlw ' '
        retlw ' '

MESSAG3: addwf PCL,F
        retlw 'S'
        retlw 'E'
        retlw 'N'
        retlw 'D'
        retlw 'I'
        retlw 'N'
        retlw 'G'
        retlw ' '
        retlw 'T'
        retlw 'O'
        retlw ' '
        retlw 'P'
        retlw 'C'
        retlw ' '
        retlw ' '
        retlw ' '

MESSAG4: addwf PCL,F
        retlw 'S'
        retlw 'E'
        retlw 'N'
        retlw 'D'
        retlw 'I'
        retlw 'N'
        retlw 'G'
        retlw ' '
        retlw 'F'
        retlw 'I'
        retlw 'N'
        retlw 'I'
        retlw 'S'
        retlw 'H'
        retlw 'E'
        retlw 'D'

SUBJECT: ADDWF PCL,F    ; used during setting correction values 
        retlw 'H'       ; 0 humid
        retlw 'U'
        retlw 'M'
        retlw 'I'
        retlw 'D'
        retlw 'S'        ; 5 soil
        retlw 'O'
        retlw 'I'
        retlw 'L'
        retlw ' '
        retlw 'L'        ; 10 light
        retlw 'I'
        retlw 'G'
        retlw 'H'
        retlw 'T'
        retlw 'W'        ; 15 water level
        retlw 'A'
        retlw 'T'
        retlw 'E'
        retlw 'R'
        retlw 'T'        ; 20 temperature
        retlw 'E'
        retlw 'M'
        retlw 'P'
        retlw ' '
        retlw 'B'        ; 25 barometer
        retlw 'A'
        retlw 'R'
        retlw 'O'
        retlw 'M'
        retlw 'W'        ; 30 Water pulse
        retlw 'A'
        retlw 'T'
        retlw 'E'
        retlw 'R'
        retlw 'P'
        retlw 'U'
        retlw 'L'
        retlw 'S'
        retlw 'E'
        retlw 'W'        ; 40 Water mask
        retlw 'A'
        retlw 'T'
        retlw 'E'
        retlw 'R'
        retlw ' '
        retlw 'M'
        retlw 'A'
        retlw 'S'
        retlw 'K'
        retlw 'W'        ; 50 Wind pulse
        retlw 'I'
        retlw 'N'
        retlw 'D'
        retlw ' '
        retlw 'P'
        retlw 'U'
        retlw 'L'
        retlw 'S'
        retlw 'E'
        retlw 'W'        ; 60 Wind mask
        retlw 'I'
        retlw 'N'
        retlw 'D'
        retlw ' '
        retlw 'M'
        retlw 'A'
        retlw 'S'
        retlw 'K'
        retlw ' '

        retlw 'N'        ; 70 North adjust
        retlw ' '
        retlw 'A'
        retlw 'D'
        retlw 'J'
        retlw 'U'
        retlw 'S'
        retlw 'T'
        retlw ' '
        retlw ' '

        retlw 'W'        ; 80 West adjust
        retlw ' '
        retlw 'A'
        retlw 'D'
        retlw 'J'
        retlw 'U'
        retlw 'S'
        retlw 'T'
        retlw ' '
        retlw ' '

        retlw 'S'        ; 90 Sample period
        retlw 'A'
        retlw 'M'
        retlw 'P'
        retlw 'L'
        retlw 'E'
        retlw ' '
        retlw 'P'
        retlw 'R'
        retlw 'D'

        retlw 'E'        ; 100 eeprom count - no longer called
        retlw 'E'
        retlw 'P'
        retlw 'R'
        retlw 'O'
        retlw 'M'
        retlw ' '
        retlw 'Q'
        retlw 'T'
        retlw 'Y'

        retlw 'T'        ; 110 Temp +-     
        retlw 'E'
        retlw 'M'
        retlw 'P'
        retlw '+'
        retlw '-'
        retlw ' '

        retlw 'B'        ; 117 Barom +-
        retlw 'A'
        retlw 'R'
        retlw 'O'
        retlw 'M'
        retlw '+'
        retlw '-'

SAMPLECOUNT: ADDWF PCL,F  ; sample count message
        retlw 'C'       ; 0
        retlw 'H'       ; 1
        retlw 'A'       ; 2
        retlw 'N'       ; 3
        retlw '/'       ; 4
        retlw 'S'       ; 5
        retlw 'A'       ; 6
        retlw 'M'       ; 7
        retlw 'P'       ; 8
        retlw 'L'       ; 9
        retlw 'E'       ;10
        retlw ' '       ;11
        retlw ' '       ;12
        retlw ' '       ;13
        retlw ' '       ;14
        retlw ' '       ;15

;*****************

;SERIALMEM01 30MAR02 from LOG430.ASM 29OCT99 - JOHN BECKER - EPE DATA LOGGER MODIFIED EXTRACT

SAVESAMPLE:

WRMSB:  movf MEMHI,W
        call WRBYTE
        incf WADDRL,F
WRLSB:  movf MEMLO,W
        call WRBYTE
        decf WADDRL,F

INCCHN: movlw 2         ;add 2 to Write address ready for next batch
        addwf WADDRL,F
        btfss STATUS,C
        return
        incf WADDRH,F
        movf WADDRH,W    ; is count = max per eeprom chip?
        xorlw %10000000
        btfss STATUS,Z
        return           ; no
        clrf WADDRH      ; yes
        clrf WADDRL
        incf ECHAN,F     ; .....CHAN
        movf ECHAN,W      ; is CHAN = max eeprom chip qty?
        xorwf MEMCNT,W
        btfss STATUS,Z
        return           ; no
        bsf MEMFUL,0     ; yes, set MEMFUL flag
        clrf ECHAN
;        clrf PCLATH      ; so easiest option now taken - to restart
;        goto START
        return

;..............

;***** THIS IS THE START OF MPASM'S WRITE DATA TO SERIAL EEPROM CHIP ***

; First used by John Becker in 8-CHAN DATA LOGGER 1999
; taken from MPASM FILE C:\PIC\2WDPOLL.ASM
; see Microchip CD-ROM disk 2, download\appnote\category\eeproms\00567.ZIP
; the original used timings based on a 4MHz clock
; this routine has been modified to enable different xtal rates
; Defining SERIALDELAY as "call CYCLE5" is for 4MHz or less xtal
; Defining SERIALDELAY as "call CYCLE25" is for 20MHz xtal
         
;***************************************************************
;       Byte Write Routine with data polling
;***************************************************************

WRBYTE    movwf DATAO       ; entry with val to sent in W, stored to DATAO
          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000   ; set slave address and write mode
          MOVWF SLAVE
         
BYTE      call BSTART       ; generate start bit
          movf SLAVE,W      ; move slave address
          movwf TXBUF       ; into transmit buffer
          call TX           ; and send it
         
          movf WADDRH,W     ; send address high byte
          movwf TXBUF       ; into transmit buffer
          call TX           ; and send it
         
          movf WADDRL,W     ; send address low byte
          movwf TXBUF       ; into transmit buffer
          call TX           ; and send it
         
          movf DATAO,W      ; move data byte
          movwf TXBUF       ; to tranmit buffer
          call TX           ; and transmit it
          call BSTOP        ; generate stop bit
         
          movlw 40          ; now start polling for a low ack bit
          movwf POLLCNT     ; set max number of times to poll
POLL      call BSTART       ; generate start bit

          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000   ; set slave address and write mode
        
          movwf TXBUF       ; into transmit buffer
          call TX           ; and send it
          btfss EEPROM,DI   ; was the ack bit low?
          goto EXITPOLL     ; yes, do another byte
          decfsz POLLCNT,F  ; is poll counter down to zero?
          goto POLL         ; no, poll again.
EXITPOLL  return 
         
;**************************************************************
;       Start Bit Subroutine - generates a start bit
;       (Low going data line while clock is high)
;**************************************************************
         
BSTART    bsf PORTC,SDATA   ; make sure data is high
          BANK1 
          movlw B'10100111'
          movwf TRISC       ; set data and clock lines for output
          BANK0 
          bcf PORTC,SCLK    ; make sure clock is low
          nop 
          bsf PORTC,SCLK    ; set clock high
          SERIALDELAY       ; timing adjustment
          bcf PORTC,SDATA   ; data line goes low during
                            ; high clock for start bit
          SERIALDELAY       ; timing adjustment
          bcf PORTC,SCLK    ; start clock train
          nop 
          nop 
          retlw 0
         
;************************************************************
;       Stop Bit Subroutine - generates a stop bit
;       (High going data line while clock is high)
;************************************************************
         
BSTOP     BANK1 
          movlw B'10100111'
          movwf TRISC       ; set data/clock lines as outputs
          BANK0 
          bcf PORTC,SDATA   ; make sure data line is low
          SERIALDELAY       ; timing adjustment  
          bsf PORTC,SCLK    ; set clock high
          SERIALDELAY       ; timing adjustment
          bsf PORTC,SDATA   ; data goes high while clock high for stop bit
          SERIALDELAY       ; timing adjustment
          bcf PORTC,SCLK    ; set clock low again
          SERIALDELAY       ; timing adjustment
          retlw 0
         
;*************************************************************
;       BITOUT routine takes one bit of data in 'do' and
;       transmits it to the serial EE device
;*************************************************************
         
BITOUT    BANK1 
          movlw B'10100111'
          movwf TRISC
          BANK0 
          btfss EEPROM,DO   ; check for state of data bit to xmit
          goto BITLOW       ;
          bsf PORTC,SDATA   ; set data line high
          goto CLKOUT       ; go toggle the clock
         
BITLOW    bcf PORTC,SDATA   ; output a low bit
CLKOUT    bsf PORTC,SCLK    ; set clock line high
          SERIALDELAY       ; timing adjustment
          bcf PORTC,SCLK    ; return clock line low
          retlw 0
         
;**************************************************************
;       BITIN routine reads one bit of data from the
;       serial EE device and stores it in 'di'
;**************************************************************
         
BITIN     bsf EEPROM,DI     ; assume input bit is high
          BANK1 
          movlw B'10110111' ; make sdata an input line
          movwf TRISC
          BANK0 
          bsf PORTC,SDATA   ; set sdata line for input
          bsf PORTC,SCLK    ; set clock line high
          SERIALDELAY       ; timing adjustment
          btfss PORTC,SDATA ; read the data bit
          bcf EEPROM,DI     ; input bit was low
          bcf PORTC,SCLK    ; set clock line low
          retlw 0
         
;****************************************************************
;       Transmit Data Subroutine
;****************************************************************
         
TX        movlw 8
          movwf COUNT       ; set the #bits to 8
TXLP      bcf EEPROM,DO     ; assume bit out is low
          btfsc TXBUF,7     ; is bit out really low?
          bsf EEPROM,DO     ; otherwise data bit =1
          call BITOUT       ; serial data out
          rlf TXBUF,F       ; rotate txbuf left
          decfsz COUNT,F    ; 8 bits done?
          goto TXLP         ; no - go again
          call BITIN        ; read ack bit
          retlw 0

;****************************************************************
;       Transmit Data Subroutine
;****************************************************************
         
TX2       movlw 8
          movwf COUNT       ; set the #bits to 8
TXLP2     bcf EEPROM,DO     ; assume bit out is low
          btfsc TXBUF,7     ; is bit out really low?
          bsf EEPROM,DO     ; no, set it high
          call BITOUT       ; send the bit to serial EE
          rlf TXBUF,F       ; rotate txbuf left
          decfsz COUNT,F    ; 8 bits done?
          goto TXLP2        ; no - go again
          call BITIN2       ; read ack bit
          btfsc EEPROM,DI   ; check ack bit
          nop 
          retlw 0

;***** THIS IS THE END OF MPASM'S WRITE DATA TO SERIAL EEPROM CHIP ***

;***** THIS IS THE START OF MPASM'S READ DATA FROM SERIAL EEPROM CHIP ***

; First used by John Becker in 8-CHAN DATA LOGGER 1999
; taken from MPASM FILE C:\PIC\2WSEQR.ASM
; see Microchip CD-ROM disk 2, download\appnote\category\eeproms\00567.ZIP
         
;************************************************************
;       2-Wire Sequential Read Program
;************************************************************
;       Stop Bit Subroutine - generates a stop bit
;       (High going data line while clock is high)
;************************************************************
         
BSTOP2    BANK1 
          movlw B'10100111'
          movwf TRISC       ; set data/clock lines as outputs
          BANK0 
          bcf PORTC,SDATA   ; make sure data line is low
          SERIALDELAY 
          bsf PORTC,SCLK    ; set clock high
          SERIALDELAY 
          bsf PORTC,SDATA   ; data goes high while clock high for stop bit
          SERIALDELAY 
          bcf PORTC,SCLK    ; set clock low again
          SERIALDELAY 
          retlw 0
         
;**************************************************************
;       BITIN2 routine reads one bit of data from the
;       serial EE device and stores it in 'di'
;**************************************************************
         
BITIN2    bsf EEPROM,DI     ; assume input bit is high
          BANK1 
          movlw B'10110111' ; make sdata an input line
          movwf TRISC
          BANK0 
          bsf PORTC,SCLK    ; set clock line high
          SERIALDELAY 
          btfss PORTC,SDATA ; read the data bit
          bcf EEPROM,DI     ; input bit was low, set 'di' accordingly
          bcf PORTC,SCLK    ; set clock line low
          retlw 0
         
;****************************************************************
;       Receive data Routine
;****************************************************************
         
RX        movlw 8           ; set # bits to 8
          movwf COUNT
          clrf DATAI        ; clear input register
          bcf STATUS,0      ; make sure carry bit is low
RXLP      rlf DATAI,F       ; rotate DATAI 1 bit left
          call BITIN2       ; read a bit
          btfsc EEPROM,DI
          bsf DATAI,0       ; set bit 0 if necessary
          decfsz COUNT,F    ; 8 bits done?
          goto RXLP         ; no, do another
          retlw 0
         
;**************************************************************
;       READ (sequential read routine)
;**************************************************************
         
READ:     MOVLW 2
          MOVWF BCOUNT      ; set number of bytes to read
          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000   ; set slave address and write mode;
          MOVWF SLAVE
         
          call BSTART       ; generate start bit
          movf SLAVE,W      ; get slave address
          movwf TXBUF       ; into transmit buffer
          call TX2          ; and send it
         
          movf RADDRH,W     ; send address high byte
          movwf TXBUF       ; into transmit buffer
          call TX2          ; and send it
         
          movf RADDRL,W     ; get word address
          movwf TXBUF       ; into transmit buffer
          call TX2          ; and send it
          call BSTART       ; generate start bit

          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100001     ; set slave address and write mode
         
          movwf TXBUF       ; into transmit buffer
          call TX2          ; and transmit it

RBYTE     call RX           ; read 1 byte from device
          decfsz BCOUNT,F   ; are both bytes read?
          goto LOWACK       ; no, send low ack and do another
          bsf EEPROM,DO     ; yes, send high ack bit
          call BITOUT       ; to stop transmission
          call BSTOP2       ; and send a stop bit
          movf DATAI,W
	    movwf COUNT0
          movwf MEMLO       ; data low byte
          return 
         
LOWACK    movf DATAI,W
	    movwf COUNT1
          movwf MEMHI       ; data high byte
          bcf EEPROM,DO     ; send low ack bit
          call BITOUT       ; to continue transmission
          goto RBYTE        ; and read another byte
         
;***** THIS IS THE END OF MPASM'S READ DATA FROM SERIAL EEPROM CHIP ***

LCDSET: clrf LOOP       ;clr LCD set-up loop
        clrf RSLINE     ;clear RS line for instruction send
LCDST2: movf LOOP,W     ;get table address
        call TABLCD     ;get set-up instruction
        clrf PCLATH
        call LCDOUT     ;perform it
        bsf PCLATH,3
        incf LOOP,F     ;inc loop
        btfss LOOP,3    ;has last LCD set-up instruction now been done?
        goto LCDST2     ;no
        return

; **************

JOEDOWNLOAD: bcf PCLATH,3
         call CLRLINE2     ; clear LCD line 2
         clrf LOOP
         call LCD1
         bsf RSLINE,4
SHOWMSGJ movf LOOP,W
         bsf PCLATH,3
         call MESSAG3     ; sending to PC message
         bcf PCLATH,3
         call LCDOUT
         bsf PCLATH,3
         incf LOOP,F
         btfss LOOP,4
         goto SHOWMSGJ
         clrf ABORT
         bsf T1CON,0           ; start timer 1
         call JOESENDPC
         return

       ;*************** OUTPUT TO PC SERIAL PORT FOR DOWNLOAD

;  Modified from Joe Farr's file SAMPLE5.ASM
;  Orig Date: 10-Feb-2003, mod date 01MAR03
;---------------------------------------------------------------------
; Description:
; Sends 100 blocks of 258 bytes (256 data + 2 trailer) to the
; serial port.
; On receipt of a 'G' command from the PC, the PIC waits for 'B'
; command and then sends a 258 byte block. The PIC again waits for a 'B'
; command before sending the next block.
; The block being sent is reflected on the PORTB LEDS.
; Each block contains ASCII codes (0 to 255).
;
; The PIC waits for a character before sending back the ASCII block
;
;---------------------------------------------------------------------

JOESETBAUD
        clrf PCLATH
        BANK1                   ; Configure the baud rate generator
        movlw 64            ; BRG for 9600baud from 10MHz, brgh=1
	movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed) & ASYNC transmission
        movwf   TXSTA           ; In bank 1
        bcf 	STATUS,RP0  	; back to RAM page 0
        movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In bank 0
        bsf PCLATH,3
        call 	FlushRXBuffer   ; Flush the RX buffer in bank 0
        return

JOESENDPC
        clrf RADDRH       ; reset start address for reading EEPROM chip
        clrf RADDRL

        movlw   'W'
        call    TxByte
        movlw   'E'
        call    TxByte
        movlw   'A'
        call    TxByte
        movlw   'T'
        call    TxByte
        movlw   'H'
        call    TxByte
        movlw   'E'
        call    TxByte
        movlw   'R'
        call    TxByte
        movf MEMCNT,W            ; number of EEPROM chips
        iorlw 48
        call    TxByte

        movlw 37                 ; sample rate
        clrf PCLATH
        call PRMGET
        bsf PCLATH,3
        call TxByte

        movf ECHAN,W             ; send current ECHAN & WRITE address
        call    TxByte
        movf WADDRH,W
        call    TxByte
        movf WADDRL,W
        call    TxByte

        movf MEMCNT,W
        btfsc STATUS,Z           ; are there any eeprom chips installed?
        return                   ; no

        movf ECHAN,W             ; temp store ECHAN into (anything)
        movwf FAHRENMSB
        clrf ECHAN

        goto WAITB

WaitG 				; Wait for any character to be received
        call 	FlushRXBuffer   ; Make sure that the RX buffer is empty
        call    RecLoop         ; Wait and read from serial - character returned in W
        sublw   'G'             ; Is this a 'G'
        btfss   STATUS,Z
        goto    WaitG           ; Not a 'G'

        clrf PCLATH
        movlw 'R'
        call LCDOUT
        bsf PCLATH,3

; 'G' has been received - Confirm ready state back to PC
SendR:  movlw   'R'             ; Signal 'R'eady
        call    TxByte

; Start sending the blocks
; First, wait for the PC to send us a 'B' command (Send block)

WaitB
	call 	FlushRXBuffer   ; Make sure that the RX buffer is empty
        call    RecLoop         ; Wait and read from serial - character returned in W
        movwf   PORTB
        sublw   'B'             ; Is this a 'B'
        btfsc   STATUS,Z
        goto    SendNext        ; Yes a 'B'
        btfsc ABORT,0           ; is abort tranfser flag set?
        goto    ENDTF           ; yes, so abort transfer
        goto    WaitB           ; Not a 'B'

; 'B' received, send a block

SendNext
         call READ         ; read from EEPROM chip
         movf MEMLO,W      ; get LSB value
         call TXBYTE       ; send it to PC
         movf MEMHI,W      ; get MSB value
         call TXBYTE       ; send it to PC
       
         movlw 2
         addwf RADDRL,F    ; inc read address by 2
         btfss STATUS,C
         goto SendNext

; Data portion of the block has been sent, now send the Block terminator
        movlw   0x0D            ; CR
        call    TxByte
        movlw   0x0A            ; LF
        call    TxByte

        incf RADDRH,F
        btfss RADDRH,7    ; is bit 7 of MSB high? (32768)
        goto    WaitB

        clrf RADDRH       ; reset start address for reading EEPROM chip
        clrf RADDRL

        incf ECHAN,F
        movf ECHAN,W
        xorwf MEMCNT,W
        btfss STATUS,Z
        goto WAITB

ENDTF:  movf FAHRENMSB,W   ; restore count into ECHAN
        movwf ECHAN
        return

; Receive a character from RS232
; (This routine does not return until a character has been received)
; The received character is in the W register

RecLoop:
        clrf TMR1L            ; reset timer 1
        clrf TMR1H
        bcf PIR1,0            ; clear timer 1 overflow

RecLoop2:
        btfss PIR1,0          ; has timer 1 overflowed?
        goto RECLOOP3         ; no
        movlw 0
        bsf ABORT,0           ; yes, set flag
        return

RECLOOP3: nop
        btfss   PIR1,RCIF       ; Check for any RX'd data
        goto    RecLoop2        ; Nothing RX'd
        movf    RCREG,W         ; Store the RX'd data in 'W'
        return

; Send byte in W to the USART

TxByte
        nop
        btfss   PIR1,TXIF       ; TX Buffer empty yet ?
        goto    TxByte          ; No - Keep waiting
        movwf   TXREG           ; Now empty - send this character
        return

; Flush the contents of the RX Buffer

FlushRXBuffer
	movf    RCREG,W        	; Flush the RX buffer in bank 0
        movf    RCREG,W
	movf    RCREG,W
        return

;********** CHANGE SETTINGS - groups to suit function

CHANGE: btfss PORTB,0
        goto CHANGE
        clrf CHANGECOUNT      ; used as a loop counter
        clrf FREQMSB          ; used as eeprom address pointer
        clrf FREQLSB          ; used as '*' routing flag

        clrf PCLATH
        call PAUSIT
        bsf PCLATH,3

CHANGELOOP: clrf PCLATH
        movlw %11001100   ; for double byte numbers
        call LCDLIN
        bsf RSLINE,4
        movlw '*'
        call LCDOUT
        clrf VALCHANGE
        bcf STATUS,C
        rrf CHANGECOUNT,W
        call SUBJECTVAL
        movwf SUBJECTNO
        movlw 5               ; show mode name
        bsf PCLATH,3
        call SHOWSUBJECT2
        call CHANGEIT
        btfsc VALCHANGE,0     ; has value been changed?
        call SAVEPROM         ; yes
        incf CHANGECOUNT,F
        incf FREQMSB,F        ; used as eeprom address pointer
        movf CHANGECOUNT,W    ; is count = 12?
        xorlw 12
        btfss STATUS,Z
        goto CHANGELOOP       ; no

CHANGELOOP2: movlw %11001100  ; for single byte numbers, max val decimal 9
        addlw 3
        clrf PCLATH
        call LCDLIN
        bsf RSLINE,4
        movlw '*'
        call LCDOUT
        clrf VALCHANGE
        bcf STATUS,C
        rrf CHANGECOUNT,W
        call SUBJECTVAL
        movwf SUBJECTNO
        movlw 10
        bsf PCLATH,3
        call SHOWSUBJECT2     ; show mode name
        call CHANGE4
        btfsc VALCHANGE,0     ; has value been changed?
        call SAVEPROM         ; yes
        incf CHANGECOUNT,F
        incf CHANGECOUNT,F
        incf FREQMSB,F        ; used as eeprom address pointer
        movf CHANGECOUNT,W    ; is count = 20?
        xorlw 20
        btfss STATUS,Z
        goto CHANGELOOP2

CHANGELOOP3: clrf PCLATH
        movlw %11001100  ; for single val bytes with +- signing
        addlw 3
        call LCDLIN
        bsf RSLINE,4
        movlw '*'
        call LCDOUT
        clrf VALCHANGE
        bcf STATUS,C
        rrf CHANGECOUNT,W
        call SUBJECTVAL
        movwf SUBJECTNO
        movlw 10
        bsf PCLATH,3
        call SHOWSUBJECT2     ; show mode name
        call CHANGE5
        btfsc VALCHANGE,0     ; has value been changed?
        call SAVEPROM         ; yes
        incf CHANGECOUNT,F
        incf CHANGECOUNT,F
        incf FREQMSB,F        ; used as eeprom address pointer
        movf CHANGECOUNT,W    ; is count = 24?
        xorlw 24
        btfss STATUS,Z
        goto CHANGELOOP3

CHANGELOOP4: clrf PCLATH
        movlw %11001100  ; for single byte numbers, sample delay
        addlw 3
        call LCDLIN
        bsf RSLINE,4
        movlw '*'
        call LCDOUT
        clrf VALCHANGE
        bcf STATUS,C
        rrf CHANGECOUNT,W
        call SUBJECTVAL
        movwf SUBJECTNO
        movlw 10
        bsf PCLATH,3
        call SHOWSUBJECT2     ; show mode name
        call CHANGE6
;        call CHANGE7
        clrf COUNT1
        btfsc VALCHANGE,0     ; has value been changed?
        call SAVEPROM         ; yes
        incf CHANGECOUNT,F
        incf CHANGECOUNT,F
        incf FREQMSB,F        ; used as eeprom address pointer
        movf CHANGECOUNT,W    ; is count = 28?
        xorlw 26   ; 28
        btfss STATUS,Z
        goto CHANGELOOP4

CHANGELOOP5: clrf PCLATH
        movlw %11001111   ; for double byte Temp/Barom numbers
        call LCDLIN
        bsf RSLINE,4
        movlw '*'
        call LCDOUT
        clrf VALCHANGE
        bcf STATUS,C
        rrf CHANGECOUNT,W
        call SUBJECTVAL
        movwf SUBJECTNO
        movlw 7               ; show mode name
        bsf PCLATH,3
        call SHOWSUBJECT2
        call CHANGE7
        btfsc VALCHANGE,0     ; has value been changed?
        call SAVEPROM         ; yes
        incf CHANGECOUNT,F
        incf CHANGECOUNT,F    ; 09may03
        incf FREQMSB,F        ; used as eeprom address pointer
        movf CHANGECOUNT,W    ; is count = 26?
        xorlw 30
        btfss STATUS,Z
        goto CHANGELOOP5      ; no
        return

CHANGEIT: btfsc CHANGECOUNT,0
        goto CHANGE2
        clrf PCLATH
        movlw 'M'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'X'
        call LCDOUT
        movlw ' '
        call LCDOUT
        bsf PCLATH,3
        goto CHANGE3

CHANGE2: clrf PCLATH
        movlw 'M'
        call LCDOUT
        movlw 'I'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        movlw ' '
        call LCDOUT
        bsf PCLATH,3

CHANGE3: clrf PCLATH          ; get msb value - double byte vals
        movf FREQMSB,W
        call PRMGET
        movwf COUNT1
        incf FREQMSB,F 
        movf FREQMSB,W 
        call PRMGET
        movwf COUNT0
        movlw COUNT1
        movwf FSR
        clrf LOOP
        clrf FREQLSB          ; used as '*' routing flag
        bsf PCLATH,3

CMAX2:  clrf COUNT2
        call BIN2HEX
        call SHOWHEX

        movf COUNT0,W          ; temporary store
        movwf REMDRLSB 
        movf COUNT1,W          ; temporary store
        movwf REMDRMSB 
        clrf COUNT2

CMAX2A: movf FSR,W
        movwf SAVES             ; store FSR
        clrf PCLATH
        call BIN2DEC
        bsf PCLATH,3
        call SHOWDEC
        movf REMDRLSB,W        ; recall from store
        movwf COUNT0
        movf REMDRMSB,W        ; recall from store
        movwf COUNT1
        movf SAVES,W
        movwf FSR              ; restore FSR
        call WAITSWITCH
        movf LOOP,W
        xorlw 4
        btfsc STATUS,Z
        return
        clrf PCLATH
        call PAUSIT
        call PAUSIT
        call PAUSIT
        bsf PCLATH,3
        goto CMAX2

CHANGE4: movf FREQMSB,W         ; get msb value - single byte vals
        clrf PCLATH
        call PRMGET
        movwf COUNT1
        incf FREQMSB,F 
        movf FREQMSB,W 
        call PRMGET
        movwf COUNT0
        movlw COUNT0
        movwf FSR
        clrf LOOP
        clrf FREQLSB          ; used as '*' routing flag
        movlw 3
        movwf LOOP
        movwf FREQLSB         ; used as '*' routing flag
        bsf PCLATH,3

CMAX4:  clrf COUNT2
        call BIN2HEX
        clrf PCLATH
        call LCD12
        bsf RSLINE,4
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        bsf PCLATH,3
        call WAITSWITCH
        movf COUNT0,W
        addlw 6             ; add 6 to set DC flag if val > 9
        movlw 1             ; load W with 1 to put into COUNT0 if DC flag is set
        btfsc STATUS,DC
        movwf COUNT0
        movf LOOP,W
        xorlw 4
        btfsc STATUS,Z
        return
        clrf PCLATH
        call PAUSIT
        call PAUSIT
        call PAUSIT
        bsf PCLATH,3
        goto CMAX4

CHANGE5: movf FREQMSB,W         ; get msb value - single bytes vals with +- signing
        clrf PCLATH
        call PRMGET
        movwf COUNT1
        incf FREQMSB,F 
        movf FREQMSB,W 
        call PRMGET
        movwf COUNT0
        movlw COUNT0
        movwf FSR
        clrf LOOP
        clrf FREQLSB          ; used as '*' routing flag
        movlw 3
        movwf LOOP
        movwf FREQLSB          ; used as '*' routing flag
        bsf PCLATH,3

CMAX5:  clrf PCLATH
        call LCD12
        bsf RSLINE,4
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        clrf COUNT2
        bsf PCLATH,3
        btfss COUNT0,3        ; is val +VE (bit 3 set)?
        goto CMAX5A           ; no 
        bcf COUNT0,3          ; yes
        call BIN2HEX
        movlw '+'
        movf COUNT0,F          ; is val = 0?
        btfsc STATUS,Z
        movlw ' '              ; yes
        clrf PCLATH
        call LCDOUT
        bsf PCLATH,3
        bsf COUNT0,3
        goto CMAX7

CMAX5A: call BIN2HEX
        movlw '-'
        movf COUNT0,F          ; is val = 0?
        btfsc STATUS,Z
        movlw ' '              ; yes
        clrf PCLATH
        call LCDOUT
        bsf PCLATH,3
        goto CMAX7

CMAX7:  movf DIGIT1,W
        clrf PCLATH
        call LCDOUT
        bsf PCLATH,3
        call WAITSWITCH
        movf LOOP,W
        xorlw 4
        btfsc STATUS,Z
        return
        clrf PCLATH
        call PAUSIT
        call PAUSIT
        call PAUSIT
        bsf PCLATH,3
        goto CMAX5

CHANGE6: ; movf FREQMSB,W         ; get msb value - single byte vals max 255
        clrf PCLATH          ; get msb value - double byte vals
        movf FREQMSB,W
        call PRMGET
        movwf COUNT1
        incf FREQMSB,F 
        movf FREQMSB,W 
        call PRMGET
        movwf COUNT0
        movlw COUNT1
        movwf FSR
        clrf LOOP
        clrf FREQLSB          ; used as '*' routing flag
        bsf PCLATH,3

CMAX6:  clrf COUNT1
        clrf COUNT2

        movf COUNT0,W          ; temporary store
        movwf REMDRLSB 
        movf COUNT1,W          ; temporary store
        movwf REMDRMSB 
        clrf COUNT2

        incf COUNT0,F
;        btfsc STATUS,Z
;        incf COUNT0,F
        call BIN2HEX
        call SHOWHEX
;        decf COUNT0,F


CMAX6A: movf FSR,W
        movwf SAVES             ; store FSR
        clrf PCLATH
;        incf COUNT0,F
        call BIN2DEC
        bsf PCLATH,3
        call SHOWDEC
;        decf COUNT0,F

        movf REMDRLSB,W        ; recall from store
        movwf COUNT0
        movf REMDRMSB,W        ; recall from store
        movwf COUNT1
        movf SAVES,W
        movwf FSR              ; restore FSR

        btfsc PORTB,1
        goto CMAX6B
        incf COUNT0,W
        andlw 127              ; limit to 127
        movwf COUNT0
        bsf VALCHANGE,0
        goto CMAX6D

CMAX6B: btfsc PORTB,2
        goto CMAX6C
        decf COUNT0,W
        andlw 127              ; limit to 127
        movwf COUNT0
        bsf VALCHANGE,0
        goto CMAX6D

CMAX6C: btfss PORTB,0
        goto CMAX6F
        btfsc PORTB,3
        goto CMAX6

CMAX6E: btfss PORTB,3
        goto CMAX6E
        goto CMAX6G

CMAX6F: btfss PORTB,0
        goto CMAX6F

CMAX6G: clrf PCLATH
        call PAUSIT
        bsf PCLATH,3
        return

CMAX6D: clrf PCLATH
        call PAUSIT
        call PAUSIT
        call PAUSIT
        bsf PCLATH,3
        goto CMAX6

; ***********

CHANGE7: clrf PCLATH          ; get msb value - double byte vals
        movf FREQMSB,W
        call PRMGET
        movwf COUNT1
        incf FREQMSB,F 
        movf FREQMSB,W 
        call PRMGET
        movwf COUNT0
        movlw COUNT1
        movwf FSR
        clrf LOOP
        clrf FREQLSB          ; used as '*' routing flag
        bsf PCLATH,3

CMAX8:  clrf COUNT2
        call BIN2HEX
        call SHOWHEX

        movf COUNT0,W          ; temporary store
        movwf REMDRLSB 
        movf COUNT1,W          ; temporary store
        movwf REMDRMSB 
        clrf COUNT2
        movlw ' '
        movwf SIGN
        btfss COUNT1,7
        goto CMAX8A
        comf COUNT0,F           ; yes, so invert result
        comf COUNT1,F
        incf COUNT0,F
        movlw '-'
        movwf SIGN

CMAX8A: movf FSR,W
        movwf SAVES             ; store FSR
        clrf PCLATH
        call BIN2DEC
        bsf PCLATH,3
        call SHOWDEC

        movf SIGN,W
        clrf PCLATH
        call LCDOUT
        bsf PCLATH,3

        movf REMDRLSB,W        ; recall from store
        movwf COUNT0
        movf REMDRMSB,W        ; recall from store
        movwf COUNT1
        movf SAVES,W
        movwf FSR              ; restore FSR

        btfsc PORTB,1
        goto CMAX8B
        movlw 1
        addwf COUNT0,F
        btfsc STATUS,C
        incf COUNT1,F
        bsf VALCHANGE,0
        goto CMAX8D

CMAX8B: btfsc PORTB,2
        goto CMAX8C
        movlw 1
        subwf COUNT0,F
        btfss STATUS,C
        decf COUNT1,F
        bsf VALCHANGE,0
        goto CMAX8D

CMAX8C: btfss PORTB,0
        goto CMAX8F
        btfsc PORTB,3
        goto CMAX8

CMAX8E: btfss PORTB,3
        goto CMAX8E
        goto CMAX8G

CMAX8F: btfss PORTB,0
        goto CMAX8F

CMAX8G: clrf PCLATH
        call PAUSIT
        bsf PCLATH,3
        return

CMAX8D: clrf PCLATH
        call PAUSIT
        call PAUSIT
        call PAUSIT
        bsf PCLATH,3
        goto CMAX8

; ****************

WAITSWITCH: btfss PORTB,0
        goto INCDIGIT
        btfss PORTB,1
        goto INCVALUE
        btfss PORTB,2
        goto DECVALUE
        btfss PORTB,3
        goto INCSUBJECT
        goto WAITSWITCH

INCDIGIT: incf LOOP,F
        incf FREQLSB,F          ; used as '*' routing flag
        movlw %11001011
        addwf FREQLSB,W        ; used as '*' routing flag
        clrf PCLATH
        call LCDLIN
        bsf RSLINE,4
        movlw ' '
        call LCDOUT
        movlw '*'
        call LCDOUT
        bsf PCLATH,3

WAITSWITCH2: btfss PORTB,0    ; wait switch release
        goto WAITSWITCH2
        clrf PCLATH
        call PAUSIT
        call PAUSIT
        bsf PCLATH,3
        movf LOOP,W
        xorlw 2
        btfss STATUS,Z
        return
        decf FSR,F            ; dec FSR value
        return

INCVALUE: bsf VALCHANGE,0
        btfsc LOOP,0          ; is MSB to be incremented (bit 0 = 0)?
        goto INCLSB           ; no, so inc lsb
        movlw 16              ; yes, inc msb
        addwf INDF,F
        return

INCLSB: movlw 1
        addwf INDF,W
        btfss STATUS,DC
        goto INCL2
        movf INDF,W
        andlw %11110000
INCL2:  movwf INDF
        return

DECVALUE: bsf VALCHANGE,0
        btfsc LOOP,0          ; is MSB to be incremented (bit 0 = 0)?
        goto DECLSB           ; no, so inc lsb
        movlw 16              ; yes, inc msb
        subwf INDF,F
        return

DECLSB: movf INDF,W
        andlw %11110000
        movwf STORE
        decf INDF,W
        andlw %00001111
        iorwf STORE,W

DECL2:  movwf INDF
        return

INCSUBJECT: btfss PORTB,3
        goto INCSUBJECT
        clrf PCLATH
        call CLRLINE2
        movlw 4
        movwf LOOP
        call PAUSIT
        call PAUSIT
        bsf PCLATH,3
        return

SHOWSUBJECT2: movwf COUNT0     ; loop length brought in on W

        clrf PCLATH
        call CLRLINE1
        call LCD1
        bsf RSLINE,4
        bsf PCLATH,3

SUB3:   movf SUBJECTNO,W
        call SUBJECT
        clrf PCLATH
        call LCDOUT
        bsf PCLATH,3
        incf SUBJECTNO,F
        decfsz COUNT0,F
        goto SUB3
        movlw ' '
        clrf PCLATH
        call LCDOUT
        bsf PCLATH,3
        return

SHOWHEX: clrf PCLATH
        call LCD12
        bsf RSLINE,4
        movf DIGIT4,W
        call LCDOUT
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        bsf PCLATH,3
        return

SHOWDEC: clrf PCLATH
        call LCD21
        bsf RSLINE,4
        movf DIGIT5,W
        call LCDOUT
        movf DIGIT4,W
        call LCDOUT
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        bsf PCLATH,3
        return

;****************

SAVEPROM: movf COUNT1,W       ; stores changed factors back to eeprom
        movwf STORE1
        decf FREQMSB,W 
        call SETPRM
        movf COUNT0,W
        movwf STORE1
        movf FREQMSB,W 
        call SETPRM

        clrf PCLATH
        call LCD2B
        bsf RSLINE,4

        movlw 'S'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'V'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'D'
        call LCDOUT
        call LONGPAUSE
        call CLRLINE2
        bsf PCLATH,3

        return

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F87x devices ********
          ;according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in STORE1.
SETPRM: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bcf STATUS,RP1  ;set for Page 0
        movf STORE1,W   ;get data value from STORE1 and hold in W
        bsf STATUS,RP1  ;set for Page 2
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf STATUS,RP0  ;set for page 3
        bcf EECON1,EEPGD ;point to Data memory
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw $55       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw $AA       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        bcf STATUS,RP1  ;set for Page 0
        bcf STATUS,RP0

CHKWRT: btfss PIR2,EEIF ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR2,EEIF   ;clear bit 4 of PIR2
        return

BIN2HEX: swapf COUNT1,W  ;get most significant nibble
        andlw 15
        movwf DIGIT4
        addlw 6
        btfss STATUS,DC
        goto BIN2
        movf DIGIT4,W
        addlw 55        ;set as alpha
        goto BIN3
BIN2:   movf DIGIT4,W
        iorlw 48        ;set as numeral
BIN3:   movwf DIGIT4
        movf COUNT1,W  ;get next significant nibble
        andlw 15
        movwf DIGIT3
        addlw 6
        btfss STATUS,DC
        goto BIN4
        movf DIGIT3,W
        addlw 55        ;set as alpha
        goto BIN5
BIN4:   movf DIGIT3,W
        iorlw 48        ;set as numeral
BIN5:   movwf DIGIT3
        swapf COUNT0,W  ;get next significant nibble
        andlw 15
        movwf DIGIT2
        addlw 6
        btfss STATUS,DC
        goto BIN6
        movf DIGIT2,W
        addlw 55        ;set as alpha
        goto BIN7
BIN6:   movf DIGIT2,W
        iorlw 48        ;set as numeral
BIN7:   movwf DIGIT2
        movf COUNT0,W  ;get least significant nibble
        andlw 15
        movwf DIGIT1
        addlw 6
        btfss STATUS,DC
        goto BIN8
        movf DIGIT1,W
        addlw 55        ;set as alpha
        goto BIN9
BIN8:   movf DIGIT1,W
        iorlw 48        ;set as numeral
BIN9:   movwf DIGIT1
        return

;*******************

;*** SIGNED 32 BIT INTEGER MATHS ROUTINES FOR PIC16 SERIES BY PETER HEMSLEY JAN 2003 ***


;*** SIGNED MULTIPLY ***
;REGA * REGB -> REGA
;Return carry set if overflow

multiply32
	clrf	MTEMP
	call	chksgna		;Make REGA positive
	skpnc
	return			;Overflow
	call	chksgnb		;Make REGB positive
	skpnc
	return			;Overflow

	call	movac		;Move REGA to REGC
	call	clra		;Clear product

	movlw	D'31'		;Loop counter
	movwf	MCOUNT

muloop	call	slac		;Shift left product and multiplicand

	rlf	REGA3,w
	skpnc			;Check for overflow
	return

	btfss	REGC3,7		;If multiplicand bit is a 1 then
	goto	nxtmul
	call	addba		;add multiplier to product

	rlf	REGA3,w
	skpnc			;Check for overflow
	return

nxtmul	decfsz	MCOUNT,f	;Next
	goto	muloop

	btfsc	MTEMP,0		;Check result sign
	call	negatea		;Negative
	return

;*** SIGNED DIVIDE ***
;REGA / REGB -> REGA
;Remainder in REGC
;Return carry set if overflow or division by zero

divide32  movf    REGB0,w         ;Trap division by zero
	iorwf	REGB1,w
	iorwf	REGB2,w
	iorwf	REGB3,w
	sublw	0
	skpnc
	return

	clrf	MTEMP
	call	chksgna		;Make dividend (REGA) positive
	skpnc
	return			;Overflow
	call	chksgnb		;Make divisor (REGB) positive
	skpnc
	return			;Overflow

	clrf	REGC0		;Clear remainder
	clrf	REGC1
	clrf	REGC2
	clrf	REGC3

	movlw	D'32'		;Loop counter
	movwf	MCOUNT

dvloop	call	slac		;Shift dividend (REGA) msb into remainder (REGC)

	movf	REGB3,w		;Test if remainder (REGC) >= divisor (REGB)
	subwf	REGC3,w
	skpz
	goto	dtstgt
	movf	REGB2,w
	subwf	REGC2,w
	skpz
	goto	dtstgt
	movf	REGB1,w
	subwf	REGC1,w
	skpz
	goto	dtstgt
	movf	REGB0,w
	subwf	REGC0,w
dtstgt	skpc			;Carry set if remainder >= divisor
	goto	dremlt

	movf	REGB0,w		;Subtract divisor (REGB) from remainder (REGC)
	subwf	REGC0,f
	movf	REGB1,w
	skpc
	incfsz	REGB1,w
	subwf	REGC1,f
	movf	REGB2,w
	skpc
	incfsz	REGB2,w
	subwf	REGC2,f
	movf	REGB3,w
	skpc
	incfsz	REGB3,w
	subwf	REGC3,f
	clrc
	bsf	REGA0,0		;Set quotient bit

dremlt	decfsz	MCOUNT,f	;Next
	goto	dvloop

	btfsc	MTEMP,0		;Check result sign
	call	negatea		;Negative
	return

;UTILITY ROUTINES

;Add REGB to REGA
;Used by add, multiply

addba	movf	REGB0,w		;Add lo byte
	addwf	REGA0,f

	movf	REGB1,w		;Add mid-lo byte
	skpnc			;No carry_in, so just add
	incfsz	REGB1,w		;Add carry_in to REGB
	addwf	REGA1,f		;Add and propagate carry_out

	movf	REGB2,w		;Add mid-hi byte
	skpnc
	incfsz	REGB2,w
	addwf	REGA2,f

	movf	REGB3,w		;Add hi byte
	skpnc
	incf	REGB3,w
	addwf	REGA3,f
	return

;Move REGA to REGC
;Used by multiply, sqrt

movac	movf	REGA0,w
	movwf	REGC0
	movf	REGA1,w
	movwf	REGC1
	movf	REGA2,w
	movwf	REGC2
	movf	REGA3,w
	movwf	REGC3
	return

;Clear REGA
;Used by multiply, sqrt

clra	clrf	REGA0
	clrf	REGA1
	clrf	REGA2
	clrf	REGA3
	return

;Check sign of REGA and convert negative to positive
;Used by multiply, divide, bin2dec

chksgna	rlf	REGA3,w
	skpc
	return

;Negate REGA
;Used by multiply, divide, bin2dec, dec2bin

negatea	movf	REGA3,w		;Save sign in w
	andlw	0x80

	comf	REGA0,f		;2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
	incfsz	REGA0,f
	goto	nega1
	incfsz	REGA1,f
	goto	nega1
	incfsz	REGA2,f
	goto	nega1
	incf	REGA3,f
nega1
	incf	MTEMP,f		;flip sign flag
	addwf	REGA3,w		;Return carry set if -2147483648
	return


;Check sign of REGB and negative convert to positive
;Used by multiply, divide

chksgnb	rlf	REGB3,w
	skpc
	return

;Negate REGB
;Used by subtract, multiply, divide

negateb	movf	REGB3,w		;Save sign in w
	andlw	0x80

	comf	REGB0,f		;2's complement
	comf	REGB1,f
	comf	REGB2,f
	comf	REGB3,f
	incfsz	REGB0,f
	goto	negb1
	incfsz	REGB1,f
	goto	negb1
	incfsz	REGB2,f
	goto	negb1
	incf	REGB3,f
negb1
	incf	MTEMP,f		;flip sign flag
	addwf	REGB3,w		;Return carry set if -2147483648
	return


;Shift left REGA and REGC
;Used by multiply, divide

slac	rlf	REGA0,f
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f
	rlf	REGC0,f
	rlf	REGC1,f
	rlf	REGC2,f
	rlf	REGC3,f
	return

;*********************

CLEARIT: clrf PCLATH
        call CLRLINE1
        call CLRLINE2

        clrf LOOP
        call LCD1
        bsf RSLINE,4
        bsf PCLATH,3

SHOWCLR: movf LOOP,W
        clrf PCLATH
        call MESSAG2          ; clearing eeprom
        call LCDOUT
        bsf PCLATH,3
        incf LOOP,F
        btfss LOOP,4
        goto SHOWCLR

        clrf LOOP
        clrf PCLATH
        call LCD21
        bsf RSLINE,4
        bsf PCLATH,3

SHOWCL2: movf LOOP,W
        clrf PCLATH
        call MESSAG5          ; clearing eeprom
        call LCDOUT
        bsf PCLATH,3
        incf LOOP,F
        btfss LOOP,4
        goto SHOWCL2

        clrf MEMHI        ; clear entire serial eeprom
        clrf MEMLO

        clrf WADDRH      ; set write address MSB
        clrf WADDRL      ; set write address LSB
        clrf ECHAN

CLEAR2: call SAVESAMPLE
        movf MEMFUL,W
        btfss STATUS,Z
        goto CLEAR3

        movf WADDRL,W
        btfss STATUS,Z
        goto CLEAR2

        movf WADDRH,W
        movwf COUNT1
        movf WADDRL,W
        movwf COUNT0
        clrf COUNT2

        clrf PCLATH
        call BIN2DEC
        call LCD21
        bsf RSLINE,4
        movf DIGIT5,W
        call LCDOUT
        movf DIGIT4,W
        call LCDOUT
        movlw 'K'
        call LCDOUT

        movlw ' '
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'H'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        movlw ' '
        call LCDOUT

        movf ECHAN,W
        iorlw 48
        call LCDOUT
        bsf PCLATH,3
        goto CLEAR2

CLEAR3: call SHOWTITLE
        return

SHOWTITLE: clrf LOOP
        clrf PCLATH
        call LCD1
        bsf RSLINE,4
        bsf PCLATH,3

SHOWMS1: movf LOOP,W
        call MESSAG           ; PIC Met Office
        clrf PCLATH
        call LCDOUT
        bsf PCLATH,3
        incf LOOP,F
        btfss LOOP,4
        goto SHOWMS1
        return

; *********** cycles pause called by Serial EEPROM write routines ****
         
; the CALL takes 2 clock cycles
; the RETURN takes 2 clock cycles
; a pause of 4 clock cycles is created by just CALLing CYCLES4 and returning
; each NOP adds a further 1 cycle pause

CYCLES25  nop 
CYCLES24  nop 
CYCLES23  nop 
CYCLES22  nop 
CYCLES21  nop 
CYCLES20  nop 
CYCLES19  nop 
CYCLES18  nop 
CYCLES17  nop 
CYCLES16  nop 
CYCLES15  nop 
CYCLES14  nop 
CYCLES13  nop 
CYCLES12  nop 
CYCLES11  nop 
CYCLES10  nop 
CYCLES9   nop 
CYCLES8   nop 
CYCLES7   nop 
CYCLES6   nop 
CYCLES5   nop 
CYCLES4   return 

; ***************

SHOWQUADWIND:
        clrf PCLATH
        call LCD1
        bsf RSLINE,4

        BANK1
        movf WINDNDLSB,W
        BANK0
        movwf COUNT0
        BANK1
        movf WINDNDMSB,W
        BANK0
        movwf COUNT1
        clrf COUNT2

        bsf PCLATH,3
        call BIN2HEX
        clrf PCLATH
        movlw 'N'
        call LCDOUT
        movf DIGIT4,W
        call LCDOUT
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT

        BANK1
        movf WINDSDLSB,W
        BANK0
        movwf COUNT0
        BANK1
        movf WINDSDMSB,W
        BANK0
        movwf COUNT1
        clrf COUNT2

        bsf PCLATH,3
        call BIN2HEX
        clrf PCLATH
        movlw 'S'
        call LCDOUT
        movf DIGIT4,W
        call LCDOUT
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT

        clrf PCLATH
        call LCD21
        bsf RSLINE,4

        BANK1
        movf WINDWDLSB,W
        BANK0
        movwf COUNT0
        BANK1
        movf WINDWDMSB,W
        BANK0
        movwf COUNT1
        clrf COUNT2

        bsf PCLATH,3
        call BIN2HEX
        clrf PCLATH
        movlw 'W'
        call LCDOUT
        movf DIGIT4,W
        call LCDOUT
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT

        BANK1
        movf WINDEDLSB,W
        BANK0
        movwf COUNT0
        BANK1
        movf WINDEDMSB,W
        BANK0
        movwf COUNT1
        clrf COUNT2

        bsf PCLATH,3
        call BIN2HEX
        clrf PCLATH
        movlw 'E'
        call LCDOUT
        movf DIGIT4,W
        call LCDOUT
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        return

; **********************

	  ORG $2100

        DE   $07   ; 0  Humid max MSB
        DE   $02   ; 1  Humid max LSB
        DE   $05   ; 2  Humid min MSB
        DE   $DF   ; 3  Humid min LSB

        DE   $2D   ; 4  Soil max MSB
        DE   $30   ; 5  Soil max LSB
        DE   $06   ; 6  Soil min MSB
        DE   $78   ; 7  Soil min LSB

        DE   $14   ; 8  Light max MSB
        DE   $00   ; 9  Light max LSB
        DE   $02   ; 10 Light min MSB
        DE   $D2   ; 11 Light min LSB

        DE   $01   ; 12 Water max MSB
        DE   $60   ; 13 Water max LSB
        DE   $00   ; 14 Water min MSB
        DE   $22   ; 15 Water min LSB

        DE   $00   ; 16 Temp - multiplier MSB  (MAX)
        DE   $01   ; 17 Temp - multiplier LSB  (MAX)
        DE   $00   ; 18 Temp - divisor MSB (MIN)
        DE   $02   ; 19 Temp - divisor LSB (MIN) 

        DE   $00   ; 20 Barom - multiplier max MSB
        DE   $08   ; 21 Barom - multiplier max LSB
        DE   $00   ; 22 Barom - divisor  min MSB
        DE   $07   ; 23 Barom - divisor  min LSB

        DE   0     ; 24  dummy value - keep as 0
        DE   5     ; 25  ; 25 WATERPULSE (number of 40kHz pulses to be sent when sensing water level
        DE   0     ; 26  dummy value - keep as 0
        DE   1     ; 27  ; 26 WATERMASK val for rain delay before listen (as WINDMASK)
        DE   0     ; 28  dummy value - keep as 0
        DE   3     ; 29  ; 28 WINDPULSE (number of 40kHz pulses to be sent when sensing wind)
        DE   0     ; 30  dummy value - keep as 0
        DE   1   ; 31  ; 27 WINDMASK val for wind delay before listen
                   ;     each mask unit = 0.325 milliseconds delay = 325 microsecs

        DE   0     ; 32  dummy value - keep as 0
        DE   0     ; 33  North correction - vals 8 and over are +VE (val - 8) and vals less than 8 are -VE
        DE   0     ; 34  dummy value - keep as 0
        DE   0     ; 35  West correction - vals 8 and over are +VE (val - 8) and vals less than 8 are -VE

        DE   0     ; 36  dummy value - keep as 0
        DE   0     ; 37  sample rate for eeprom chip storage (immaterial if no mem chips used)

        DE   0     ; $FE ; 0     ; 38  TEMP +- MSB correction
        DE   0     ; $C5 ; 0     ; 39  TEMP +- LSB

        DE   $01   ; $03   ; 40  BAROM +- MSB correction (950 decimal)
        DE   $9C   ; $C0   ; 41  BAROM +- LSB 

        DE   $00   ; 42  ECHAN
        DE   $00   ; 43  Recorded sample count MSB
        DE   $00   ; 44  Recorded sample count LSB
        DE   $00   ; 45  not used
        DE   $00   ; 46  not used
        DE   $00   ; 47  not used
        DE   $00   ; 48  not used
        DE   $00   ; 49  not used
        DE   $00   ; 50  not used

         .END



