        LIST    P=12C508, R=HEX	
;
	TITLE 'Scale1' - MAIN PROGRAM FOR RUNNING MAGENTA PIPE DESCALER MK1'
;
;	COPYRIGHT:  CICUIT DESIGN, ARTWORK, AND SOFTWARE - MAGENTA ELECTRONICS 
;
;			MAGENTA ELECTRONICS LTD. 135 HUNTER STREET,
;			BURTON ON TRENT, STAFFORDSHIRE DE14 2ST  UK.
;			TEL. 44 (0)1283 565435   FAX. 546932
;			EMAIL: MAGENTA_ELECTRONICS@COMPUSERVE.COM
;			http://ourworld.compuserve.com/homepages/magenta_electronics
;
;			FULL KITS FOR THIS PROJECT - REF 868 PRICE 22.95 (SEPT 97)
;			POSTAGE UK 3.00,  AIR MAIL 8.50
;			POWER SUPPLY 3.99			
;
;			PUBLISHED IN OCTOBER 1997 EVERYDAY AND PRACTICAL ELECTRONICS
;
;	ASSEMBLER: MPASM v01.50
;	DEVELOPED USING MPLAB FOR WINDOWS/16 3.22.02
;
;
;	SET CHIP CONFIGURATION TO: 
;		MCLR - ENABLE,  CP - OFF,  WATCHDOG - OFF,  INT. RC OSC		
;
;	VERSION 1 RELEASED 26/8/97
;
        #DEFINE INDF    0000                    ;
        #DEFINE TMR0    0001                    ;
        #DEFINE PCL     0002                    ;
        #DEFINE STATUS  0003                    ;
        #DEFINE FSR     0004                    ;
        #DEFINE OSCCAL  0005                    ;     
	#DEFINE GPIO    0006                    ;
;
        #DEFINE TABPNT  0007                    ;FREQUENCY TABLE POINTER
        #DEFINE FCOUNT  0008                    ;FREQUENCY COUNTING REGISTER
;
;       DEFINE GPIO BITS
;       #DEFINE		0006,0                 
        #DEFINE OUTPUT  0006,1                  ;OUTPUT SIGNAL
;       #DEFINE         0006,2                 
;       #DEFINE         0006,4                 
;     	#DEFINE         0006,5             
;
;       DEFINE STATUS REGISTER
        #DEFINE CARRY   0003,0                  ;CARRY FLAG
        #DEFINE DCARRY  0003,1                  ;DECIMAL CARRY FLAG
        #DEFINE ZERO    0003,2                  ;ZERO FLAG
        #DEFINE RPAGE   0003,5                  ;REGISTER PAGE SELECT
;
	ORG	0X00
	MOVWF	OSCCAL		;LOAD CALIBRATION VALUE FOR INTERNAL OSC.
	GOTO	START		;AFTER POWER ON, OR RESET GO TO 'START'
;
	ORG	0008		;BEGIN CODE AT 0008
;
;Clear registers 10 - 20:
;
START	MOVLW	0x10		; INITIALISE FSR
	MOVWF	FSR		; 
NXREG	CLRF	INDF 		; CLEAR INDICATED REGISTER
	INCF	FSR,1 		; STEP ON TO NEXT
	BTFSC	FSR,4		; CHECK TO SEE IF COMPLETE (HEX 20 REACHED)
	GOTO	NXREG		; LOOP UNTIL ALL REGISTERS ARE CLEAR
;
;Set up i/o ports
;
	MOVLW	0x0		; SET UP INITIAL VALUES TO 0 IN W
	MOVWF	GPIO		; WRITE TO GPIO PORT LATCHES 
	MOVLW	B'00111101'	; SET GPIO 1 TO OUTPUT - OTHERS TO INPUT
	TRIS	GPIO		; WRITE TO 'TRIS' REGISTER 
;
;Set up OPTION register contents
;
	MOVLW	B'11000111'	; SET UP OPTION BITS - 1/256 PRESCALER TO TIMER 
	OPTION			; TRANSFER TO OPTION REGISTER
;
;Initialise timer and frequency table pointer
;
MAIN	MOVLW	0X01		;LOAD START VALUE FOR STEP TIMER	
	MOVWF	TMR0		;
	MOVLW	0X23		;INITIALISE FREQUENCY TABLE POINTER
	MOVWF	TABPNT		;
;
;
;****CODE FROM 'FREQ' DOWN TO END OF 'OFLOOP' IS CRITICAL FOR OUTPUT FREQUENCIES
;****DO NOT ALTER NUMBER OF MACHINE CYCLES
;
FREQ	CALL	TABLE		;GET VALUE FOR FREQUENCY COUNTER
	MOVWF	FCOUNT		;LOAD FREQUENCY COUNTER
	BSF	OUTPUT		;TURN ON OUTPUT
;
FTIMH	MOVF	TMR0,0		;TEST FOR TIME UP			
	BTFSC	ZERO		;CONTINUE UNTIL TIMER IS ZERO		
	GOTO	NXTF		;TIMER IS ZERO SO JUMP TO END ROUTINE
	DECFSZ	FCOUNT,1	;DECREMENT FREQUENCY COUNTER 
	GOTO	FTIMH		;LOOP UNTIL ZERO

	CALL	TABLE		;GET VALUE FOR FREQUENCY COUNTER
	MOVWF	FCOUNT		;LOAD FREQUENCY COUNTER	
	NOP			;NOPS ADDED TO MATCH ON AND OFF TIME
	NOP
	BCF	OUTPUT
;
FTIML	MOVF	TMR0,0		;TEST FOR TIME UP			
	BTFSC	ZERO		;CONTINUE UNTIL TIMER IS ZERO		
	GOTO	NXTF		;TIMER IS ZERO SO JUMP TO END ROUTINE
	DECFSZ	FCOUNT,1	;DECREMENT FREQUENCY COUNTER 
	GOTO	FTIML		;LOOP UNTIL ZERO

	GOTO	FREQ		;CONTINUE UNTIL TIMER IS ZERO	

NXTF	MOVLW	0X01		;RELOAD LOAD START VALUE FOR STEP TIMER	
	MOVWF	TMR0		;
	DECF	TABPNT,1	;STEP ONE DOWN IN TABLE
	BTFSS	ZERO
	GOTO	FREQ		;NOT ZERO SO DO NEXT FREQUENCY

	BCF	OUTPUT		;END OF TABLE SO TURN OFF FOR ONE STEP 
FLOOP	MOVF	TMR0,0		;TEST TIMER FOR TIME UP			
	BTFSS	ZERO		;TIMER IS ZERO SO JUMP TO END ROUTINE	
	GOTO	FLOOP		;NOT ZERO SO LOOP UNTIL TIME IS UP
;
	GOTO	MAIN		;SEQUENCE ENDED SO BEGIN AGAIN

;
TABLE	ORG	0080
	MOVF	TABPNT,0	;LOAD TABLE POINTER INTO W
	ADDWF	PCL		;ADD W TO CURRENT LOCATION
	RETLW	0X38		;RETURN WITH LOCATION CONTENTS IN W
	RETLW	0X35
	RETLW	0X32
	RETLW	0X2F
	RETLW	0X2C
	RETLW	0X29
	RETLW	0X27
	RETLW	0X24
	RETLW	0X22
	RETLW	0X20
	RETLW	0X1E
	RETLW	0X1C
	RETLW	0X1B
	RETLW	0X1A
	RETLW	0X19
	RETLW	0X18	
	RETLW	0X17
	RETLW	0X16
	RETLW	0X15
	RETLW	0X14
	RETLW	0X13
	RETLW	0X12
	RETLW	0X11
	RETLW	0X10
	RETLW	0X0F
	RETLW	0X0E
	RETLW	0X0D
	RETLW	0X0C
	RETLW	0X0B
	RETLW	0X0A
	RETLW	0X09
  	RETLW	0X08
	RETLW	0X07
	RETLW	0X06
	RETLW	0X05
	RETLW	0X04
;
	ORG	0100
	DATA	'M'
	DATA	'A'
	DATA	'G'
	DATA	'E'
	DATA	'N'
	DATA	'T'
	DATA	'A'
;
	DATA	'E'
	DATA	'L'
	DATA	'E'
	DATA	'C'
	DATA	'T'
	DATA	'R'
	DATA	'O'
	DATA	'N'
	DATA	'I'
	DATA	'C'
	DATA	'S'
;
;
;	THE FOLLOWING TWO LINES OF CODE WERE USED DURING DEVELOPMENT USING A WINDOWED CHIP
;	THEY ARE NECESSARY BECAUSE THE OSCILLATOR CALIBRATION CONSTANT IS ERASED BY UV
;	AND SO HAS TO BE REMEMBERED AND RELOADED EACH TIME.  THE NORMAL PLASTIC CHIP 
;	HAS ITS CALIBRATION VALUE IN THE SAME LOCATION, BUT CANNOT BE ERASED. 
;	
;***	ORG	01FF		;***** ONLY FOR EPROM CHIP - INSERT CALIBRATION CONSTANT - 
;***	DATA	0C50		;***** 0C50 RETLW #50 IN EEPROM CHIP 1
;
;
;
;	THE CONFIGURATION WORD STORED AT 0FFF SETS UP THE OPERATING MODE
;
;	IN THIS CASE: 	MCLR - ENABLED,  	CODE PROTECTION - OFF, 
;			WATCHDOG - DISABLED, 	INTERNAL RC OSCILLATOR.
;
;	NOTE THAT SOME VERSIONS OF MPASM GIVE AN ERROR MESSAGE BECAUSE OF THE HIGH 
;	ADDRESS LOCATION,  BUT STILL LOAD THE CODE CORRECTLY.
;
	ORG	0FFF		;SET UP CONFIGURATION - GIVES ERROR MESSAGE - BUT IGNORE 
	DATA	0X1A	
;
	END
