;PROGRAM		PIC-controlled Digilogue Clock	
;DESIGN		John Scott Paterson
;PROCESSOR		16C84		
;OSCILLATOR		Crystal  3.2768Mhz
;INT CLOCK		819.2khz  or 1.22uS	
;PRESCALER		assigned to RTCC, set to divide by 64
;VERSION		2.00
;DATE			18.7.96

;****************************************equates*****************************************
	
indadd		equ		0
rtcc		equ		1
pc		equ		2
status		equ		3
fsr		equ		4
porta		equ		5
portb		equ		6
intcon		equ		0bh
tbctr		equ		0eh		;counter for 20mS intervals
hsctr		equ		tbctr+1		;counter for half-seconds
mins		equ		tbctr+2		;counter for minutes	
hrs		equ		tbctr+3		;counter for hours
del1		equ		tbctr+4
del2		equ		tbctr+5
temp		equ		tbctr+6

		org		0
		goto		Start
		org		4		;set up interrupt vector
		goto		ServInt
		org		10		;locate code

Start		call		Init		;set ports,counters & RTCC interrupt
Loop		goto		Loop		;main timing loop

ServInt		decfsz		tbctr		;has half-second elapsed yet?
		goto		RunEnd	;if not exit
		movlw		.25		;otherwise reload tbctr
		movwf		tbctr
		call		KeyScan	;check keys  
		decfsz		hsctr		;has minute elapsed yet
		goto		RunEnd	;if not exit
		movlw		.120		;else reload hcctr and inc time
		movwf		hsctr 
		call		IncMins		;increment time
RunEnd	call		Display		;display time
		movlw		b'10100000'
		movwf		intcon		;re-enable rtcc interrupt
		retfie	

Display		movlw		b'00001100'	
		movwf		porta		;hours & digits off
		swapf		mins,w		;load tens of mins into w
		andlw		.15		;mask msds
		call		Convert		;convert to 7-seg code
		movwf		portb		;output to portb
		bsf		porta,0		;digit 2 on
		call		Delay	
		bcf		porta,0		;digit 2 off
		movf		mins,w		;load units of mins into w
		andlw		.15		;mask msbs
		call		Convert		;convert to 7-seg code
		movwf		portb		;output to portb
		bsf		porta,1		;digit 1 on
		call 		Delay		;delay   
 		bcf		porta,1		;digit 1 off   
		call		ShowFace 	;display hr leds
		call		Delay
		clrf		portb		;blank hr leds
		movf		hrs,w
		call		HourTable	;get hour data
		movwf		portb		;and display it
		btfss		portb,1		;if B1 high
		call		Odd		;enable odd hour
		btfsc		portb,1		;if not
		call		Even    		;enable even hour
		return			

InitHsc 		movlw		.25		
		movwf		tbctr		;generate 1/2 second intervals   
            		movlw		.120		;generate 1 min interval 
		movwf		hsctr	
		return		

ShowFace	movlw		b'11111110'	;all hours on
		movwf		portb
		clrf		porta   
		return		 

Odd		bcf		porta,2		;enables odd hours
		bsf		porta,3
		return		
	
Even		bsf		porta,2		;enables even hours
		bcf		porta,3
		return		

Delay		movlw		4		;display delay
		movwf		del1
D1		movlw		.100
		movwf		del2
Dloop		decfsz		del2
		goto		Dloop
		decfsz		del1
		goto		D1
		return		

IncMins		call		InitHsc		;zero seconds
	 	incf		mins		; increment mins
		movf		mins,w		;and move into W
		andlw		.15		;mask off high nibbble
		xorlw		.10		;and compare to 10
		btfss		status,2		;if <10 don't increment 10s of mins
		goto		EndMins
		movlw		b'00001010'	;else zero units and increment
		xorwf		mins		;10s of minutes
		movlw		.16
		addwf		mins
		movf		mins,w		;move mins into W
		xorlw		060		;and compare with 60
		btfss		status,2
		goto		EndMins	;if <60 don't change hours
		clrf		mins		;else clear mins and
		call		IncHrs		;increment hours
EndMins 	return		
	
IncHrs		incf		hrs		;increment hours
		movf		hrs,w		;and move into W
		xorlw		.12		;compare with 12
		btfss		status,2		;if <12 leave
		goto		EndHrs
		clrf		hrs		;else clear hours
EndHrs		return		

KeyScan	movf		portb,w		;move portb into W
		movwf		temp		;and save 
		clrf		portb		;clear portb
		bsf		portb,7		;set PB7 high
		btfsc		portb,0		;test PB0 and if low
		call		IncMins		;increment minutes
		bcf		portb,7		;set PB7 low and
		bsf		portb,6		;PB6 high
		btfsc		portb,0		;test PB0 and if low
		call		IncHrs		;increment hours
		movf		temp,w		;then restore state
		movwf		portb		;of portb
		return		 	

Init		movlw		0
		tris		porta		;porta to all o/ps
		movlw		1
		tris		portb		;portb b0=i/p, b1-b7=o/ps
		movlw		5
		option		 		;set rtcc prescale etc 
		clrf		porta
		clrf		portb
		clrf		hrs
		clrf		mins
		call		InitHsc		;init half sec cntr  
		movlw		b'10100000'	;enable rtcc interrupt
		movwf		intcon
		return
	
Convert		addwf		pc		;7-seg lookup table
		retlw		b'00010000'
		retlw		b'11010110'
		retlw		b'01001000'
		retlw		b'01000100'
		retlw		b'10000110'
		retlw		b'00100100'
		retlw		b'10100000'
		retlw		b'01010110'
		retlw		b'00000000'
		retlw		b'00000110'

HourTable	addwf		pc 
		retlw		b'10000001'
		retlw		b'10000011'
		retlw		b'01000001'
		retlw		b'01000011'
		retlw		b'00100001'
		retlw		b'00100011'
		retlw		b'00010001'
		retlw		b'00010011'
		retlw		b'00001001'
		retlw		b'00001011'
		retlw		b'00000101'
 		retlw		b'00000111'
	
		END
