;*****************************************************************************        
;
;   Module:     menufb1.inc
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    1.0 5/10/03                                                  
;
;               Functions to implement the main menu options
;               that are located in the second memory bank, and therefore
;               need careful PCLATH bit manipulation
;
;*****************************************************************************        




;View monthly stats
;
;
;record # of records in tmpNumRec
;
;exit if tmpNumRec=0 or tmpNumRec=1   ( insufficient records for stats )
;
;decrement tmpNumRec
;get last entered record. Store fuel in fuel1, miles in miles1, date in mmyy1
;
;set validData = 0
;while tmpNumRec != 0
;    get previous record. Store fuel in fuel2, miles in miles2, date in mmyy2
;    decrement tmpNumRec
;    
;    if mmyy1 == mmyy2 && (tmpNumRec != 0)   // added 19/7/03
;        add fuel2 to fuel1
;        set validData = 1
;        
;    if mmyy1 != mmyy2 or tmpNumRec == 0
;        if validData == 1
;            set validData = 0
;            do tmp = miles1 - miles2. do mpg = tmp / fuel1. display mpg
;            wait for key
;        
;        store fuel2 in fuel1
;        store miles2 in miles1
;        store mmyy2 in mmyy1
;        
;        
;        
;miles1, miles2 are 6 digit BCD
;fuel2 is 2 digit BCD
;fuel1 is 6 digit BCD
;mmyy1, mmyy2 are 4 digit BCD        
;validData is 1 bit in flags2
; TmpNumRec is 2 byte word, binary

;*****************************************************************************        
;
;   Function :  reportMonthB1
;               Runs backwards through the records, calculating the monthly  
;               average fuel consumption, and displaying each months values.    
;               This function resides in bank1, so we twiddle the PCLATH bits
;
;   Input:      N/A - this is a menu option
;
;   Output:     N/A - this is a menu option
;
;*****************************************************************************        
reportMonthB1
    clrf    PCLATH              ; Needed for calls to eepread/eepwrite

    clrf    eepNum    
    clrf    eepAddH
    movlw   0x0F                ; # of fuel loads
    movwf   eepAddL
    call    eepRead
    
    movfw   eepData
    movwf   tmpNumRecH
    movlw   0x10                ; # of fuel loads
    movwf   eepAddL
    call    eepRead
    
    movfw   eepData
    movwf   tmpNumRecL

    movlw   0x11                ; Next record add
    movwf   eepAddL
    call    eepRead
    
    movfw   eepData
    movwf   tmpNextRecH
    movlw   0x12                ; Next record add
    movwf   eepAddL
    call    eepRead
    
    movfw   eepData
    movwf   tmpNextRecL
    
    ; We have tmpNextRec ( next location to write data to )  and tmpNumRec ( number of fuel loads )
    
    movlw   high rm001          ; Need to do this for goto's
    movwf   PCLATH
    
    ; First, check that tmpNumRec is greater than 1
    movfw   tmpNumRecH
    btfss   STATUS, Z
    goto    rm001
    
    movfw   tmpNumRecL
    andlw   0xFE
    btfsc   STATUS, Z           ; If zero, we do not have enough records 
    goto    rm_exit
    
rm001                           ; OK, we have enough records for stats
    ; decrement tmpNumRec by 1
    movlw   0x01
    subwf   tmpNumRecL, F
    btfss   STATUS, C
    decf    tmpNumRecH, F
    
    ; Calculate address of last entered fuel setting.
    ; This is done by subtracting 8 from tmpNextRec, and
    ; if this value is less than 0x0013, make it 0x15EB ( the last record )
    
    movlw   0x08
    subwf   tmpNextRecL, F
    btfss   STATUS, C
    decf    tmpNextRecH, F
    
    ; Have we underflowed?
    movfw   tmpNextRecH
    btfss   STATUS,Z
    goto    rm002
    movlw   0x13
    subwf   tmpNextRecL, W
    btfsc   STATUS, C           ; Carry is set == record # OK
    goto    rm002
    
    ; Fix up address to last address
    movlw   0x15
    movwf   tmpNextRecH
    movlw   0xEB
    movwf   tmpNextRecL
    
rm002                           ; We have the address of the record to fetch in tmpNextRec
    clrf    PCLATH
    movfw   tmpNextRecL
    movwf   eepAddL
    movfw   tmpNextRecH
    movwf   eepAddH

    movlw   .1                    ;Increment the EEPROM Adress by 1 - skip day field
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F

    call    eepRead
    movfw   eepData
    movwf   mmyy1_0
    
    movlw   .1                    ;Increment the EEPROM Adress by 1 
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F

    call    eepRead
    movfw   eepData
    movwf   mmyy1_1

    movlw   .2                    ;Increment the EEPROM Adress by 2 - move to miles field
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F

    call    eepRead
    movfw   eepData
    movwf   miles1_0

    movlw   .1                    ;Increment the EEPROM Adress by 1 
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F

    call    eepRead
    movfw   eepData
    movwf   miles1_1

    movlw   .1                    ;Increment the EEPROM Adress by 1 
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F

    call    eepRead
    movfw   eepData
    movwf   miles1_2

    movlw   .1                    ;Increment the EEPROM Adress by 1 - to the fuel record
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F

    call    eepRead
    movfw   eepData
    movwf   fuel1_2
    clrf    fuel1_1             ; Fuel1 is a 6 digit store, so clear other digits
    clrf    fuel1_0

    bcf     flags2, VALIDDATA_FLAGS2
    
rm003                           ; Loop while tmpNumRec != 0
    movlw   high rm003          ; Need to do this for goto's
    movwf   PCLATH
    movfw   tmpNumRecH    
    btfss   STATUS, Z
    goto    rm005
    movfw   tmpNumRecL
    btfss   STATUS, Z
    goto    rm005
    
    goto    rm_exit             ; No more records, so exit
    
rm005                           ; OK - tmpNumRec is not zero
    ; get previous record ( current record in tmpNextRec )
    
    movlw   0x08
    subwf   tmpNextRecL, F
    btfss   STATUS, C
    decf    tmpNextRecH, F
    
    ; Have we underflowed?
    movfw   tmpNextRecH
    btfss   STATUS,Z
    goto    rm006
    movlw   0x13
    subwf   tmpNextRecL, W
    btfsc   STATUS, C           ; Carry is set == record # OK
    goto    rm006
    
    ; Fix up address to last address
    movlw   0x15
    movwf   tmpNextRecH
    movlw   0xEB
    movwf   tmpNextRecL

rm006
    clrf    PCLATH
    movfw   tmpNextRecL
    movwf   eepAddL
    movfw   tmpNextRecH
    movwf   eepAddH

    movlw   .1                    ;Increment the EEPROM Adress by 1 - skip day field
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F

    call    eepRead
    movfw   eepData
    movwf   mmyy2_0
    
    movlw   .1                    ;Increment the EEPROM Adress by 1 
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F

    call    eepRead
    movfw   eepData
    movwf   mmyy2_1

    movlw   .2                    ;Increment the EEPROM Adress by 2 - move to miles field
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F

    call    eepRead
    movfw   eepData
    movwf   miles2_0

    movlw   .1                    ;Increment the EEPROM Adress by 1 
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F

    call    eepRead
    movfw   eepData
    movwf   miles2_1

    movlw   .1                    ;Increment the EEPROM Adress by 1 
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F

    call    eepRead
    movfw   eepData
    movwf   miles2_2

    movlw   .1                    ;Increment the EEPROM Adress by 1 - to the fuel record
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F

    call    eepRead
    movfw   eepData
    movwf   fuel2

    ; decrement tmpNumRec by 1
    movlw   0x01
    subwf   tmpNumRecL, F
    btfss   STATUS, C
    decf    tmpNumRecH, F

    ; does mmyy1 == mmyy2 ? If it does, add fuel2 to fuel1

    movlw   high rm007          ; Need to do this for goto's
    movwf   PCLATH
    
    movfw   mmyy1_0
    subwf   mmyy2_0, W
    btfss   STATUS, Z    
    goto    rm007               ; Different, so dont add fuel2 into total
    
    movfw   mmyy1_1
    subwf   mmyy2_1, W
    btfss   STATUS, Z
    goto    rm007               ; Different, so dont add fuel2 into total
    
    movfw   tmpNumRecH
    btfss   STATUS, Z
    goto    rm006a
    
    movfw   tmpNumRecL
    btfsc   STATUS, Z
    goto    rm007
    
rm006a    
    ; Date is in same month, so add fuel2 to fuel1 ( 2 digit BCD add to a 6 digit BCD )
    movfw   fuel2
    movwf   byteBCDTmpA
    movfw   fuel1_0
    movwf   wordBCDTmpA0
    movfw   fuel1_1
    movwf   wordBCDTmpA1
    movfw   fuel1_2
    movwf   wordBCDTmpA2

    movlw   HIGH calcBCDAddByte2Word
    movwf   PCLATH    
    call    calcBCDAddByte2Word
    movlw   HIGH rm007
    movwf   PCLATH    
    
    movfw   wordBCDTmpA2
    movwf   fuel1_2
    movfw   wordBCDTmpA1
    movwf   fuel1_1
    movfw   wordBCDTmpA0
    movwf   fuel1_0
        
    bsf     flags2, VALIDDATA_FLAGS2

rm007                           ; if yymm1 != yymm2 OR tmpNumRec == 0, display results
    movfw   mmyy1_0
    subwf   mmyy2_0, W
    btfss   STATUS, Z    
    goto    rm008               ; Different
    
    movfw   mmyy1_1
    subwf   mmyy2_1, W
    btfss   STATUS, Z
    goto    rm008               ; Different
    
    ; is tmpNumRec 0? If it is, goto next check otherwise loop back
    movfw   tmpNumRecH    
    btfss   STATUS, Z
    goto    rm003
    movfw   tmpNumRecL
    btfss   STATUS, Z
    goto    rm003
    
rm008                           ; is ValidDate == 1?
    btfss   flags2, VALIDDATA_FLAGS2
    goto    rm009
    
    bcf     flags2, VALIDDATA_FLAGS2
    
    ; do calc, display msg, wait key
    
    movlw   HIGH calcBCDSubWord
    movwf   PCLATH    
    
     ; do tmp = miles1 - miles2 
    movfw   miles1_0
    movwf   wordBCDTmpA0
    movfw   miles1_1
    movwf   wordBCDTmpA1
    movfw   miles1_2
    movwf   wordBCDTmpA2
    movfw   miles2_0
    movwf   wordBCDTmpB0
    movfw   miles2_1
    movwf   wordBCDTmpB1
    movfw   miles2_2
    movwf   wordBCDTmpB2
    call    calcBCDSubWord
   
     ; do tmp / fuel1
     
    movfw   fuel1_0
    movwf   wordBCDTmpB0
    movfw   fuel1_1
    movwf   wordBCDTmpB1
    movfw   fuel1_2
    movwf   wordBCDTmpB2

    clrf    PCLATH    

    call    dspClear
    call    showConsumption    

    movlw   ' '
    call    dspPutChar
       
    call    readUnits
    call    uiDspDistance
    movlw   '/'
    call    dspPutChar
    call    uiDspVolume
     
    call    dspLine2
    movlw   st1m8 - st1m1       ; Display 'Next / Done'. Next is '*'
    call    uiDspStr1
    
    
     ; wait key. Loop back or exit, depending on key
    call    kbdReadKey

    movfw   rawKey
    sublw   '*'
    movlw   high rm009
    movwf   PCLATH
    btfsc   STATUS, Z
    goto    rm009
    
    goto    rm_exit             ; Exit
    
rm009                           ; save new months variable, loop back
    movfw   fuel2
    movwf   fuel1_2
    clrf    fuel1_1             ; Fuel1 is a 6 digit store, so clear other digits
    clrf    fuel1_0
    movfw   miles2_0
    movwf   miles1_0
    movfw   miles2_1
    movwf   miles1_1
    movfw   miles2_2
    movwf   miles1_2
    movfw   mmyy2_0
    movwf   mmyy1_0    
    movfw   mmyy2_1
    movwf   mmyy1_1
    
    goto    rm003    

rm_exit    
    clrf    PCLATH   
    return
    


;*****************************************************************************        
;
;   Function :  checkRemindersB1
;               Runs through the reminders looking for reminders that are due
;               to be displayed, either because the time or the distance       
;               cretieria have been met. If it finds any, it sets the MS bit
;               in the flag byte.
;               This routine is called automatically at midnight every day
;
;   Input:      Display inactive - so do not fiddle with the display
;
;   Output:     N/A 
;
;*****************************************************************************        
checkRemindersB1

    ; For each reminder
    ;  if the flag byte is either 1, 2 or 4, check the approriate field(s)
    ; 0x01 == miles 0x02 == distance 0x04 == both
    ; for expiry
    clrf    PCLATH   

    ; first, get and store the current date and last recorded mileage
    ; Get RTC 
    bcf     INTCON, GIE         ; Disable global interrupts
    movfw   daysBCD
    movwf   daysBCDTmp
    movfw   monthsBCD
    movwf   monthsBCDTmp
    movfw   yearsBCD
    movwf   yearsBCDTmp
    bsf     INTCON, GIE         ; Enable global interrupts

    ; get last recorded mileage
    clrf    eepNum
    movlw   0x1b
    movwf   eepAddH
    movlw   0x97
    movwf   eepAddL
    call    eepRead
    movfw   eepData
    movwf   BCDTmpF0
    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    call    eepRead
    movfw   eepData
    movwf   BCDTmpF1
    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    call    eepRead
    movfw   eepData
    movwf   BCDTmpF2
    
    
    ; Start with the first record at 15f7
    clrf    eepNum
    movlw   0x15
    movwf   eepAddH
    movlw   0xf7
    movwf   eepAddL

cr000
    clrf    PCLATH
    call    eepRead

    movlw   high cr001
    movwf   PCLATH

    movfw   eepData
    btfss   STATUS, Z           ; Non zero means the slot is occupied
    goto    cr001

cr001a    
    ; Try next slot, if not at end ( 1b7f )
    movfw   eepAddH
    sublw   0x1B
    btfss   STATUS, Z
    goto    cr002               ; not at end, so try next
    
    movfw   eepAddL
    sublw   0x7F
    btfss   STATUS, Z
    goto    cr002               ; not at end, so try next

    clrf    PCLATH    
    return
    
cr002
    movlw   0x18                    ;Increment the EEPROM Adress by 1 record
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    goto    cr000

cr001
    ; We have a slot, lets look at the data
    ; save eeprom address

    movfw   eepAddH
    movwf   tmpNextRecH    
    movfw   eepAddL
    movwf   tmpNextRecL    
    
    ; Save config byte
    movfw   eepData
    movwf   arTmp
    
    ; Get & save date
    ; get & save distance
    clrf    PCLATH
    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    call    eepRead
    movfw   eepData
    movwf   daysBCDTmp2
    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    call    eepRead
    movfw   eepData
    movwf   monthsBCDTmp2
    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    call    eepRead
    movfw   eepData
    movwf   yearsBCDTmp2
    movlw   .2                    ;Increment the EEPROM Adress by 2
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    call    eepRead
    movfw   eepData
    movwf   BCDTmpE0
    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    call    eepRead
    movfw   eepData
    movwf   BCDTmpE1
    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    call    eepRead
    movfw   eepData
    movwf   BCDTmpE2

    movlw   high cr007
    movwf   PCLATH
    
    ; Is the reminder already active?
    btfsc   arTmp, 7
    goto    cr007               ; Yes, so no action
    
    ; We have actual date in daysBCDTmp...
    ; We have last mileage in BCDTmpF
    
    ; We have reminder date in daysBCDTmp2
    ; We have reminder mileage in BCDTmpE
    
    ; is the date field relevant?
        
    btfsc   arTmp, 2            ; both?
    goto    cr003               ; Do time
    btfss   arTmp, 1            ; Time?
    goto    cr004               ; No - try distance

cr003
    ; Compare date
    
    movfw   daysBCDTmp2
    movwf   wordBCDTmpA2
    movfw   monthsBCDTmp2
    movwf   wordBCDTmpA1
    movfw   yearsBCDTmp2
    movwf   wordBCDTmpA0

    movfw   daysBCDTmp
    movwf   wordBCDTmpB2
    movfw   monthsBCDTmp
    movwf   wordBCDTmpB1
    movfw   yearsBCDTmp
    movwf   wordBCDTmpB0

    movlw   high calcBCDSubWord
    movwf   PCLATH
    ; subtracts wordBCDTmpB from wordBCDTmpA
    call    calcBCDSubWord
    
    movlw   high cr006
    movwf   PCLATH

    ; The carry will be clear on the days following the reminder point
    btfss   STATUS, C
    goto    cr006               ; Set the 'exceeded' bit
    
    
cr004
    ; Compare distance?
    btfsc   arTmp, 1            ; If it is time only, no need to do distance
    goto    cr007

cr005
    ; Compare distance
    
    movfw   BCDTmpE2
    movwf   wordBCDTmpA2
    movfw   BCDTmpE1
    movwf   wordBCDTmpA1
    movfw   BCDTmpE0
    movwf   wordBCDTmpA0

    movfw   BCDTmpF2
    movwf   wordBCDTmpB2
    movfw   BCDTmpF1
    movwf   wordBCDTmpB1
    movfw   BCDTmpF0
    movwf   wordBCDTmpB0
    
    movlw   high calcBCDSubWord
    movwf   PCLATH

    ; subtracts wordBCDTmpB from wordBCDTmpA
    call    calcBCDSubWord

    movlw   high cr007
    movwf   PCLATH
    
    ; The carry will be clear on the days following the reminder point
    btfsc   STATUS, C
    goto    cr007               ; Carry set, no overflow
    
cr006    
    ; Set the 'exceeded' bit
    movfw   tmpNextRecH    
    movwf   eepAddH
    movfw   tmpNextRecL
    movwf   eepAddL

    movfw   arTmp
    iorlw   0x80                ; set the MSB, to indicate reminder is active

    movwf   eepData

    clrf    PCLATH
        
    call    eepWrite
    
cr007
    ; restore eeprom address
    movfw   tmpNextRecH    
    movwf   eepAddH
    movfw   tmpNextRecL
    movwf   eepAddL

    movlw   high cr001a
    movwf   PCLATH

    goto    cr001a

cr_exit     
    clrf    PCLATH   
    return
    



;*****************************************************************************        
;
;   Function :  DeleteReminderB1
;               scrolls through the stored reminders, allowing one to be
;               deleted.
;               This function resides in bank1, so we twiddle the PCLATH bits
;
;   Input:      N/A - this is a menu option
;
;   Output:     N/A - this is a menu option
;
;*****************************************************************************        
DeleteReminderB1
    ; Find first reminder. If there are none, just exit
    
    ; For each reminder, display just the text
    ; Each one should say '*=Next, #=Done' ( st1m8 ) at bottom
    ; Use the '0' key to delete

    clrf    PCLATH   
    call    dspClear
    
    ; Start with the first record at 15f7
    clrf    eepNum
    movlw   0x15
    movwf   eepAddH
    movlw   0xf7
    movwf   eepAddL

dr000
    clrf    PCLATH
    call    eepRead

    movlw   high DeleteReminderB1
    movwf   PCLATH

    movfw   eepData
    btfss   STATUS, Z           ; Non zero means the slot is occupied
    goto    dr001

dr001a    
    ; Try next slot, if not at end ( 1b7f )
    movfw   eepAddH
    sublw   0x1B
    btfss   STATUS, Z
    goto    dr002               ; not at end, so try next
    
    movfw   eepAddL
    sublw   0x7F
    btfss   STATUS, Z
    goto    dr002               ; not at end, so try next

    clrf    PCLATH    
    return
    
dr002
    movlw   0x18                ; Increment the EEPROM Adress by 1 record
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    goto    dr000

dr001
    ; We have a slot, lets look at the data
    ; save eeprom address
    ; Display distance, if enabled
    ; Display time, if enabled
    ; display text
    ; restore eeprom address        

    ; save eeprom address
    movfw   eepAddH
    movwf   tmpNextRecH    
    movfw   eepAddL
    movwf   tmpNextRecL    

    ; get the date
    movlw   .7                    ;Increment the EEPROM Adress by 8
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F

    ; now get the text
    movlw   RXBuffer
    movwf   FSR

dr001b
    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    clrf    PCLATH
    call    eepRead
    movfw   eepData
    movwf   INDF
    incf    FSR, F
    movfw   FSR
    sublw   RXBuffer + 0x10
    movlw   high viewRemindersB1
    movwf   PCLATH
    btfss   STATUS, Z
    goto    dr001b
      
    ; Display text
dr005
    clrf    PCLATH
    call    dspClear
    
    call    dspLine2
    movlw   st1m8 - st1m1
    call    uiDspStr1

    call    dspHome

    movlw   RXBuffer
    movwf   FSR

dr006
    clrf    PCLATH
    movfw   INDF
    call    dspPutChar
    incf    FSR, F
    movfw   FSR
    sublw   RXBuffer + 0x10
    movlw   high viewRemindersB1
    movwf   PCLATH
    btfss   STATUS, Z
    goto    dr006

    clrf    PCLATH
    call    kbdReadKey

    movfw   rawKey
    sublw   '*'
    movlw   high viewRemindersB1
    movwf   PCLATH
    btfsc   STATUS, Z
    goto    dr007
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    dr_exit

    movfw   rawKey
    sublw   '0'
    btfss   STATUS, Z
    goto    dr_exit
    
    ; Delete the entry
    movfw   tmpNextRecH    
    movwf   eepAddH
    movfw   tmpNextRecL
    movwf   eepAddL

    clrf    PCLATH   

    clrf    eepData
    call    eepWrite
    
    movlw   high viewRemindersB1
    movwf   PCLATH
    goto    dr_exit

dr007
    ; restore eeprom address
    movfw   tmpNextRecH    
    movwf   eepAddH
    movfw   tmpNextRecL
    movwf   eepAddL

    goto    dr001a

dr_exit     
    clrf    PCLATH   
    return



;*****************************************************************************        
;
;   Function :  viewRemindersB1
;               scrolls through the stored reminders
;               This function resides in bank1, so we twiddle the PCLATH bits
;
;   Input:      LSB of viewType set if we are only displaying overdue reminders
;
;   Output:     N/A - this is a menu option
;
;*****************************************************************************        
viewRemindersB1
    ; Find first reminder. If there are none, just exit
    
    ; For each reminder, display date, mileage, text
    ; Each one should say '*=Next, #=Done' ( st1m8 ) at bottom
    
    clrf    PCLATH   
    call    dspClear
    
    ; Start with the first record at 15f7
    clrf    eepNum
    movlw   0x15
    movwf   eepAddH
    movlw   0xf7
    movwf   eepAddL

vr000
    clrf    PCLATH
    call    eepRead

    movlw   high viewRemindersB1
    movwf   PCLATH

    movfw   eepData
    btfss   STATUS, Z           ; Non zero means the slot is occupied
    goto    vr001

vr001a    
    ; Try next slot, if not at end ( 1b7f )
    movfw   eepAddH
    sublw   0x1B
    btfss   STATUS, Z
    goto    vr002               ; not at end, so try next
    
    movfw   eepAddL
    sublw   0x7F
    btfss   STATUS, Z
    goto    vr002               ; not at end, so try next

    clrf    PCLATH    
    return
    
vr002
    movlw   0x18                    ;Increment the EEPROM Adress by 1 record
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    goto    vr000

vr001
    ; Check the view type parameter.
    ; If we are only to display overdue reminders, check MSB bit
    
    btfss   viewType, 0
    goto    vr001c

    ; Check MSB, quit if not set
    btfss   eepData, 7
    goto    vr001a                  ; Not set - skip to next

vr001c
    ; We have a slot, lets look at the data
    ; save eeprom address
    ; Display distance, if enabled
    ; Display time, if enabled
    ; display text
    ; restore eeprom address        

    ; save eeprom address
    movfw   eepAddH
    movwf   tmpNextRecH    
    movfw   eepAddL
    movwf   tmpNextRecL    

    ; get the arTmp variable, date, miles, text
    clrf    PCLATH
    call    eepRead
    movfw   eepData
    movwf   arTmp
    
    ; get the date
    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    call    eepRead
    movfw   eepData
    movwf   daysBCDTmp
    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    call    eepRead
    movfw   eepData
    movwf   monthsBCDTmp
    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    call    eepRead
    movfw   eepData
    movwf   yearsBCDTmp
    movlw   .2                    ;Increment the EEPROM Adress by 2
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    call    eepRead
    movfw   eepData
    movwf   BCDTmpE0
    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    call    eepRead
    movfw   eepData
    movwf   BCDTmpE1
    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    call    eepRead
    movfw   eepData
    movwf   BCDTmpE2

    ; now get the text
    movlw   RXBuffer
    movwf   FSR

vr001b
    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    clrf    PCLATH
    call    eepRead
    movfw   eepData
    movwf   INDF
    incf    FSR, F
    movfw   FSR
    sublw   RXBuffer + 0x10
    movlw   high viewRemindersB1
    movwf   PCLATH
    btfss   STATUS, Z
    goto    vr001b
    
      
    ; now to display the data
    btfsc   arTmp, 2            ; both?
    goto    vr003               ; Do time
    btfss   arTmp, 1            ; Time?
    goto    vr004               ; No - try distance
    
vr003
    clrf    PCLATH
    call    dspClear
 
    ; display time
    call    dspLine2
    movlw   st1m8 - st1m1
    call    uiDspStr1

    call    dspHome
    
    movlw   daysBCDTmp
    movwf   FSR
    call    uiDspBCDByte
    movlw   '/'
    call    dspPutChar
    call    uiDspBCDByte
    movlw   '/'
    call    dspPutChar
    call    uiDspBCDByte

    call    kbdReadKey

    sublw   '*'
    movlw   high viewRemindersB1
    movwf   PCLATH
    btfsc   STATUS, Z
    goto    vr004
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    vr_exit

vr004
    btfsc   arTmp, 1            ; If it is time only, no need to do distance
    goto    vr005

    clrf    PCLATH
    call    dspClear
    
    call    dspLine2
    movlw   st1m8 - st1m1
    call    uiDspStr1

    call    dspHome

    call    readUnits
    call    uiDspDistance
    movlw   ':'
    call    dspPutChar

    movlw   BCDTmpE0
    movwf   FSR
    call    uiDspBCDWord
    
    call    kbdReadKey

    sublw   '*'
    movlw   high viewRemindersB1
    movwf   PCLATH
    btfsc   STATUS, Z
    goto    vr005
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    vr_exit

    ; Display text
    
vr005
    clrf    PCLATH
    call    dspClear
    
    call    dspLine2
    movlw   st1m8 - st1m1
    call    uiDspStr1

    call    dspHome

    movlw   RXBuffer
    movwf   FSR

vr006
    clrf    PCLATH
    movfw   INDF
    call    dspPutChar
    incf    FSR, F
    movfw   FSR
    sublw   RXBuffer + 0x10
    movlw   high viewRemindersB1
    movwf   PCLATH
    btfss   STATUS, Z
    goto    vr006

    clrf    PCLATH
    call    kbdReadKey

    sublw   '*'
    movlw   high viewRemindersB1
    movwf   PCLATH
    btfsc   STATUS, Z
    goto    vr007
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    vr_exit

vr007
    ; restore eeprom address
    movfw   tmpNextRecH    
    movwf   eepAddH
    movfw   tmpNextRecL
    movwf   eepAddL

    goto    vr001a

vr_exit     
    clrf    PCLATH   
    return
       
   
   
;*****************************************************************************        
;
;   Function :  addReminderB1
;               Allows entry of the date / distance and text for a reminder,
;               if there is space to add one.
;               This function resides in bank1
;
;   Input:      N/A - this is a menu option
;
;   Output:     N/A - this is a menu option
;
;*****************************************************************************        
addReminderB1
    clrf    PCLATH   
    call    dspClear
      
    ; First, find a free slot and store it's address in tmpNextRec
    ; Give a warning message if insufficient space 
    
    ; Get the type of the reminder, store in arTmp
    
    ; If type = distance, ask for miles, store in BCDTmpE
    ; If type = time, ask for date, store in daysBCDTmp
    
    ; Enter text for reminder, store in rxbuffer
    
    ; Commit to eeprom
    
    
    ; Start with the first record at 15f7
    clrf    eepNum
    movlw   0x15
    movwf   eepAddH
    movlw   0xf7
    movwf   eepAddL

ar000
    clrf    PCLATH
    call    eepRead

    movlw   high addReminderB1
    movwf   PCLATH

    movfw   eepData
    btfsc   STATUS, Z           ; Zero means the slot is free
    goto    ar001
    
    ; Try next slot, if not at end ( 1b7f )
    movfw   eepAddH
    sublw   0x1B
    btfss   STATUS, Z
    goto    ar002               ; not at end, so try next
    
    movfw   eepAddL
    sublw   0x7F
    btfss   STATUS, Z
    goto    ar002               ; not at end, so try next

    clrf    PCLATH
    ; We are at the end, so tell use and exit
    movlw   st1m13 - st1m1       ; Memory full
    call    uiDspStr1
    
    ; Give a pause for user to see display
    movlw   D'255'
    call    uiWait10ms               
 
    clrf    PCLATH    
    return
    
ar002
    movlw   0x18                    ;Increment the EEPROM Adress by 1 record
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    goto    ar000
    
ar001
    ; OK, we have a free record in EEPROM_ADDRESS
    ; Save the address
    
    
    movfw   eepAddH
    movwf   tmpNextRecH    
    movfw   eepAddL
    movwf   tmpNextRecL    
    
    ; Ask for the type of the reminder
    movlw   0x01            ; bit0 == distance
    movwf   arTmp
    
ar001a
    clrf    PCLATH    

    call    dspClear

    movlw   st1m14 - st1m1      ; Display 'Type:'
    call    uiDspStr1
    movlw   st1m15 - st1m1       ; Assume distance
    btfsc   arTmp, 1
    movlw   st1m16 - st1m1       ; Date
    btfsc   arTmp, 2
    movlw   st1m17 - st1m1       ; Date/distance
    call    uiDspStr1

    call    dspLine2

    movlw   st1m10 - st1m1
    call    uiDspStr1

    call    kbdReadKey

    sublw   '*'
    movlw   high addReminderB1
    movwf   PCLATH
    btfss   STATUS, Z
    goto    ar003               ; Done key pressed
    
    ; mov to next option bit
    bcf     STATUS, C
    rlf     arTmp, F
    btfss   arTmp, 3
    goto    ar001a
    
    movlw   0x01
    movwf   arTmp
    goto    ar001a
    
ar003   
    ; We now have reminder type in arTmp
    ; Now get the distance and/or time, as determined by arTmp
    
    ; Get time?
    btfsc   arTmp, 2            ; both?
    goto    ar004               ; Do time
    btfss   arTmp, 1            ; Time?
    goto    ar005               ; No - try distance

ar004
    ; Ask for time
    clrf    PCLATH
    clrf    daysBCDTmp
    clrf    monthsBCDTmp
    clrf    yearsBCDTmp

    call    dspClear

    movlw   st1m19 - st1m1
    call    uiDspStr1

    call    dspLine2

    movlw   daysBCDTmp
    movwf   FSR
    call    uiDspBCDByte

    movlw   '/'
    call    dspPutChar
    call    uiDspBCDByte
    movlw   '/'
    call    dspPutChar
    call    uiDspBCDByte

    call    dspLine2
    movlw   0x00F
    call    dspPutCmd       ; disp on, blinking cursor      

    call    kbdReadKey

    sublw   '*'
    movlw   high addReminderB1
    movwf   PCLATH
    btfsc   STATUS, Z
    goto    ar004
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ar_exit
    
    movlw   '0'
    subwf   rawKey, W
    movwf   daysBCDTmp
    swapf   daysBCDTmp, F
    movfw   rawKey
    clrf    PCLATH
    call    dspPutChar

    call    kbdReadKey
        
    sublw   '*'
    movlw   high addReminderB1
    movwf   PCLATH
    btfsc   STATUS, Z
    goto    ar004
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ar005
    
    movlw   '0'
    subwf   rawKey, W
    addwf   daysBCDTmp, F
    movfw   rawKey
    clrf    PCLATH
    call    dspPutChar

    movlw   '/'
    call    dspPutChar

    call    kbdReadKey

    sublw   '*'
    movlw   high addReminderB1
    movwf   PCLATH
    btfsc   STATUS, Z
    goto    ar004
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ar005
    
    movlw   '0'
    subwf   rawKey, W
    movwf   monthsBCDTmp
    swapf   monthsBCDTmp, F
    movfw   rawKey
    clrf    PCLATH
    call    dspPutChar

    call    kbdReadKey
        
    sublw   '*'
    movlw   high addReminderB1
    movwf   PCLATH
    btfsc   STATUS, Z
    goto    ar004
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ar005
    
    movlw   '0'
    subwf   rawKey, W
    addwf   monthsBCDTmp, F
    movfw   rawKey
    clrf    PCLATH
    call    dspPutChar

    movlw   '/'
    call    dspPutChar

    call    kbdReadKey

    sublw   '*'
    movlw   high addReminderB1
    movwf   PCLATH
    btfsc   STATUS, Z
    goto    ar004
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ar005
    
    movlw   '0'
    subwf   rawKey, W
    movwf   yearsBCDTmp
    swapf   yearsBCDTmp, F
    movfw   rawKey
    clrf    PCLATH
    call    dspPutChar

    call    kbdReadKey
        
    sublw   '*'
    movlw   high addReminderB1
    movwf   PCLATH
    btfsc   STATUS, Z
    goto    ar004
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ar005
    
    movlw   '0'
    subwf   rawKey, W
    addwf   yearsBCDTmp, F
    movfw   rawKey
    clrf    PCLATH
    call    dspPutChar
        
ar005
    ; ask for distance?
      movlw   high addReminderB1
      movwf   PCLATH
    btfsc   arTmp, 1            ; If it is time only, no need to do distance
    goto    ar006

    ; Ask for distance

ar005a
    clrf    PCLATH
    clrf    BCDTmpE0
    clrf    BCDTmpE1
    clrf    BCDTmpE2

    call    dspClear
    call    dspLine2

    movlw   st1m9 - st1m1
    call    uiDspStr1   

    call    dspHome        

    call    readUnits
    call    uiDspDistance
    movlw   ':'
    call    dspPutChar

    movlw   BCDTmpE0
    movwf   FSR
    call    uiDspBCDWord

    ; Move cursor to next position
    movfw   distanceDspLen
    addlw   1 + 0x80
    call    dspPutCmd

    movlw   0x00F
    call    dspPutCmd       ; disp on, blinking cursor      
    
    call    kbdReadKey
    
    sublw   '*'
    movlw   high addReminderB1
    movwf   PCLATH
    btfsc   STATUS, Z
    goto    ar005a
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ar_exit     ; Abort if # key pressed here
    
    movlw   '0'
    subwf   rawKey, W
    movwf   BCDTmpE0
    swapf   BCDTmpE0, F
    movfw   rawKey
    clrf    PCLATH
    call    dspPutChar

    call    kbdReadKey
    
    sublw   '*'
    movlw   high addReminderB1
    movwf   PCLATH
    btfsc   STATUS, Z
    goto    ar005a
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ar006           
    
    movlw   '0'
    subwf   rawKey, W
    addwf   BCDTmpE0, F
    movfw   rawKey
    clrf    PCLATH
    call    dspPutChar

    call    kbdReadKey
    
    sublw   '*'
    movlw   high addReminderB1
    movwf   PCLATH
    btfsc   STATUS, Z
    goto    ar005a
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ar006         
    
    movlw   '0'
    subwf   rawKey, W
    movwf   BCDTmpE1
    swapf   BCDTmpE1, F
    movfw   rawKey
    clrf    PCLATH
    call    dspPutChar

    call    kbdReadKey
    
    sublw   '*'
    movlw   high addReminderB1
    movwf   PCLATH
    btfsc   STATUS, Z
    goto    ar005a
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ar006         
    
    movlw   '0'
    subwf   rawKey, W
    addwf   BCDTmpE1, F
    movfw   rawKey
    clrf    PCLATH
    call    dspPutChar

    call    kbdReadKey
    
    sublw   '*'
    movlw   high addReminderB1
    movwf   PCLATH
    btfsc   STATUS, Z
    goto    ar005a
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ar006           
    
    movlw   '0'
    subwf   rawKey, W
    movwf   BCDTmpE2
    swapf   BCDTmpE2, F
    movfw   rawKey
    clrf    PCLATH
    call    dspPutChar
    
    call    kbdReadKey
    
    sublw   '*'
    movlw   high addReminderB1
    movwf   PCLATH
    btfsc   STATUS, Z
    goto    ar005a
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ar006          
    
    movlw   '0'
    subwf   rawKey, W
    addwf   BCDTmpE2, F
    movfw   rawKey
    clrf    PCLATH
    call    dspPutChar

ar006
    ; get text
    
    ; This is the fun bit.
    ; Clear the display.
    ; Fill the rxbuffer with spaces
    ; cursor position stored in curPos
    clrf    curPos
    
    movlw   high addReminderB1
    movwf   PCLATH

    ; Fill buffer with spaces
    movlw   RXBuffer
    movwf   FSR
ar006a
    movlw   ' '
    movwf   INDF
    incf    FSR, F
    movfw   FSR
    sublw   RXBuffer + 0x10
    btfss   STATUS, Z
    goto    ar006a       

    clrf    PCLATH    
    call    dspClear
    call    dspLine2

    movlw   st1m9 - st1m1
    call    uiDspStr1   

ar006c
    clrf    PCLATH
    call    dspHome        
    
    ; Display contents of the buffer

    movlw   RXBuffer
    movwf   FSR

ar006b
    clrf    PCLATH
    movfw   INDF
    call    dspPutChar
    incf    FSR, F
    movfw   FSR
    sublw   RXBuffer + 0x10
    movlw   high addReminderB1
    movwf   PCLATH
    btfss   STATUS, Z
    goto    ar006b       

    clrf    PCLATH

    ; Move cursor to position
    movfw   curPos
    addlw   0x80
    call    dspPutCmd

    movlw   0x00F
    call    dspPutCmd       ; disp on, blinking cursor      

    ; Get key, action it
    call    kbdReadKey
    
    movfw   rawKey
    sublw   '*'
    movlw   high addReminderB1
    movwf   PCLATH
    btfsc   STATUS, Z
    goto    ar006
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ar007
       
    movfw   rawKey
    sublw   '2'
    btfsc   STATUS, Z
    goto    ar006d
    
    movfw   rawKey
    sublw   '8'
    btfsc   STATUS, Z
    goto    ar006e

    movfw   rawKey
    sublw   '4'
    btfsc   STATUS, Z
    goto    ar006f
    
    movfw   rawKey
    sublw   '6'
    btfsc   STATUS, Z
    goto    ar006g
    goto    ar006c
    
ar006d
    ; decrement character under the cursor
    movlw   RXBuffer
    addwf   curPos, W
    movwf   FSR
    movfw   INDF
    sublw   ' '
    btfss   STATUS, Z
    decf    INDF, F
    goto    ar006c             
    
    
ar006e
    ; increment character under the cursor
    movlw   RXBuffer
    addwf   curPos, W
    movwf   FSR
    movfw   INDF
    sublw   0x7F
    btfss   STATUS, Z
    incf    INDF, F
    goto    ar006c             

ar006f
    ; decrement cursor position
    movfw   curPos
    sublw   0x00
    btfss   STATUS, Z
    decf    curPos, F
    goto    ar006c             
    
ar006g
    ; increment cursor position
    movfw   curPos
    sublw   0x0F
    btfss   STATUS, Z
    incf    curPos, F
    goto    ar006c             

    
ar007
    clrf    PCLATH
    
    movfw   tmpNextRecH    
    movwf   eepAddH
    movfw   tmpNextRecL
    movwf   eepAddL
    
    ; Save the stuff
    ; arTmp first, then daysBCDTMP, then miles, then rxBuffer
    movfw   arTmp
    movwf   eepData
    call    eepWrite
    movfw   daysBCDTmp
    movwf   eepData
    call    eepWrite
    movfw   monthsBCDTmp
    movwf   eepData
    call    eepWrite
    movfw   yearsBCDTmp
    movwf   eepData
    call    eepWrite
    clrf    eepData
    call    eepWrite
    movfw   BCDTmpE0
    movwf   eepData
    call    eepWrite
    movfw   BCDTmpE1
    movwf   eepData
    call    eepWrite
    movfw   BCDTmpE2
    movwf   eepData
    call    eepWrite
    
    movlw   RXBuffer
    movwf   FSR
    
ar007a    
    clrf    PCLATH
    movfw   INDF
    movwf   eepData
    call    eepWrite
    incf    FSR, F
    movfw   FSR    
    sublw   RXBuffer + 0x10
    movlw   high addReminderB1
    movwf   PCLATH
    btfss   STATUS, Z
    goto    ar007a
        
ar_exit    
    clrf    PCLATH    
    return
    
    
    

;*****************************************************************************        
;
;   Function :  calClockB1
;               Entry of the clock calibration factor screen
;               This screen allows the user to enter a number of minutes
;               to add to the clock each month
;
;   Input:      N/A - this is a menu option
;
;   Output:     N/A - this is a menu option
;
;*****************************************************************************        
calClockB1
    clrf    PCLATH    
    call    dspClear
    
    call    dspLine2

    movlw   st1m9 - st1m1
    call    uiDspStr1   

    call    dspHome        

    movlw   st1m20 - st1m1
    call    uiDspStr1   

    ; fetch current value, and display it
    clrf    eepNum
    clrf    eepAddH
    movlw   0x03
    movwf   eepAddL
    call    eepRead
    movfw   eepData
    movwf   byteBCDTmpA

    movlw   byteBCDTmpA
    movwf   FSR
    call    uiDspBCDByte

    ; Move cursor to next position
    movlw   0x0B + 0x80
    call    dspPutCmd

    movlw   0x00F
    call    dspPutCmd       ; disp on, blinking cursor      
    
    call    kbdReadKey
    
    sublw   '*'

    movlw   HIGH calClockB1
    movwf   PCLATH    

    btfsc   STATUS, Z
    goto    calClockB1
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    cc_done
    
    movlw   '0'
    subwf   rawKey, W
    movwf   byteBCDTmpA
    swapf   byteBCDTmpA, F
    movfw   rawKey
    
    clrf    PCLATH
    call    dspPutChar

    call    kbdReadKey
    
    sublw   '*'
    movlw   HIGH calClockB1
    movwf   PCLATH    
    btfsc   STATUS, Z
    goto    calClockB1
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    cc_done

    movlw   '0'
    subwf   rawKey, W
    addwf   byteBCDTmpA, F
    movfw   rawKey
    clrf    PCLATH
    call    dspPutChar

cc_done
    ; Write byte to the clock calibration byte in eeprom
    
    clrf    PCLATH

    clrf    eepNum    
    clrf    eepAddH
    movlw   0x03
    movwf   eepAddL
    movfw   byteBCDTmpA
    movwf   minOffset
    movwf   eepData
    call    eepWrite
    return
    