; MORSE111.ASM 29AUG02  Morse code decoder - amended for "3" error

; morse pulse monitored via RA0

	list	p=16F84,r=dec
        __config        h'3FF2'

; Macros

#define BANK0   BCF 0x03,5
#define BANK1   BSF 0x03,5

; Equates for registers

	include	p16f84.inc

LOOP:   .EQU $0C        ;loop counter 1 - general
CLKCNT: .EQU $0D        ;pre-counter for CLOCK
CLKSEC: .EQU $0E        ;CLOCK main counter - secs
STORE1: .EQU $11        ;general store 1
STORE2: .EQU $12        ;general store 2
LOOPA:  .EQU $13        ;loop counter 2 - LCD use only
RSLINE: .EQU $14        ;RS line flag for LCD
LOOPB:  .EQU $15
PREV:   .EQU $16
COUNT:  .EQU $17
FSRSTORE: .EQU $18
STORA:  .EQU $19
DIT:    .EQU $1A
DAH:    .EQU $1B
SWITCH  .EQU $1C
MODE    .EQU $1D

LCD0:  EQU $30
LCD1   EQU $31
LCD2:  EQU $32
LCD3:  EQU $33
LCD4:  EQU $34
LCD5:  EQU $35
LCD6:  EQU $36
LCD7:  EQU $37
LCD8:  EQU $38
LCD9:  EQU $39
LCDA:  EQU $3A
LCDB:  EQU $3B
LCDC:  EQU $3C
LCDD:  EQU $3D
LCDE:  EQU $3E
LCDF:  EQU $3F

LOW0:        .EQU $40
MORSEBYTE:   .EQU $41
MORSECNT:    .EQU $42
LETTERSPACE: .EQU $43
LCDCOUNT:    .EQU $44
WORDSPACE:   .EQU $45
BPMFRACT:    .EQU $46
BPM0:        .EQU $47
BPM1:        .EQU $48
BPM0A:       .EQU $49
BPM1A:       .EQU $4A
HIGHCNT:     .EQU $4B
PITCH:	 .EQU $4C

W:      .EQU 0
F:      .EQU 1

C:      .EQU 0
DC:     .EQU 1
Z:      .EQU 2

	org	4
        goto    START           ; Interrupt vector
	org	5
        goto    START

ROUTE:  andlw %00000111
	addwf PCL,F
        retlw ' '         ; word space call
        goto TABLE1
        goto TABLE2
        goto TABLE3
        goto TABLE4
        goto TABLE5
        goto TABLE6
        retlw '#'

TABLE1: movf MORSEBYTE,W
        andlw %00000001
	addwf PCL,F
        retlw 'E'           ; 1 0  e .            0
        retlw 'T'           ; 1 1  t -            1

TABLE2: movf MORSEBYTE,W
        andlw %00000011
	addwf PCL,F
        retlw 'I'           ; 2 0  i ..          00
        retlw 'A'           ; 2 1  a .-          01
        retlw 'N'           ; 2 2  n -.          10
        retlw 'M'           ; 2 3  m --          11

TABLE3: movf MORSEBYTE,W
        andlw %00000111
	addwf PCL,F
        retlw 'S'           ; 3 0  s ...        000
        retlw 'U'           ; 3 1  u ..-        001
        retlw 'R'           ; 3 2  r .-.        010
        retlw 'W'           ; 3 3  w .--        011
        retlw 'D'           ; 3 4  d -..        100
        retlw 'K'           ; 3 5  k -.-        101
        retlw 'G'           ; 3 6  g --.        110
        retlw 'O'           ; 3 7  o ---        111

TABLE4: movf MORSEBYTE,W
        andlw %00001111
	addwf PCL,F
        retlw 'H'           ; 4 0  h ....      0000
        retlw 'V'           ; 4 1  v ...-      0001
        retlw 'F'           ; 4 2  f ..-.      0010
        retlw 'U'           ; 4 3  U ..--      0011 character U double-dot
        retlw 'L'           ; 4 4  l .-..      0100
        retlw 'A'           ; 4 5  A .-.-      0101 character A double-dot
        retlw 'P'           ; 4 6  p .--.      0110
        retlw 'J'           ; 4 7  j .---      0111
        retlw 'B'           ; 4 8  b -...      1000
        retlw 'X'           ; 4 9  x -..-      1001
        retlw 'C'           ; 4 10 c -.-.      1010
        retlw 'Y'           ; 4 11 y -.--      1011
        retlw 'Z'           ; 4 12 z --..      1100
        retlw 'Q'           ; 4 13 q --.-      1101
        retlw 'O'           ; 4 14 O ---.      1110 character O double-dot
        retlw 'C'           ; 4 15 C ----      1111 character Ch (chi?)

TABLE5: movf MORSEBYTE,W
        andlw %00011111
	addwf PCL,F
        retlw '5'           ; 5 0  5 .....    00000
        retlw '4'           ; 5 1  4 ....-    00001
        retlw '*'           ; 5 2  unknown    00010
;        goto UNDERSTOOD     ; 5 2    ...-.    00010 message "understood"
;        retlw '*'           ; 5 3  unknown    00011
        retlw '3'           ; 5 3  3 ...--    00011
        retlw 'E'           ; 5 4  E ..-..    00100 character E acute
        retlw '*'           ; 5 5  unknown    00101
        retlw '*'           ; 5 6  unknown    00110
        retlw '2'           ; 5 7  2 ..---    00111
        retlw '*'           ; 5 8  unknown    01000
;        goto WAITMSG        ; 5 8    .-...    01000 message "wait"
        retlw '*'           ; 5 9  unknown    01001
        retlw '+'           ; 5 10 + .-.-.    01010
        retlw '*'           ; 5 11 unknown    01011
        retlw '*'           ; 5 12 unknown    01100
        retlw 'A'           ; 5 13 A .--.-    01101 character A acute
        retlw '*'           ; 5 14 unknown    01110
        retlw '1'           ; 5 15 1 .----    01111
        retlw '6'           ; 5 16 6 -....    10000
        retlw '='           ; 5 17 = -...-    10001
        retlw '/'           ; 5 18 / -..-.    10010
        retlw '*'           ; 5 19 unknown    10011
        retlw '*'           ; 5 20 unknown    10100
        retlw '*'           ; 5 21 unknown    10101
;        goto STARTING       ; 5 21  -.-.-     10101 message "starting signal"
        retlw '('           ; 5 22 ( -.--.    10110
        retlw '*'           ; 5 23 unknown    10111
        retlw '7'           ; 5 24 7 --...    11000
        retlw '*'           ; 5 25 unknown    11001
        retlw '*'           ; 5 26 unknown    11010
        retlw 'N'           ; 5 27 N --.--    11011 character N cidilla
        retlw '8'           ; 5 28 8 ---..    11100
        retlw '*'           ; 5 29 unknown    11101
        retlw '9'           ; 5 30 9 ----.    11110
        retlw '0'           ; 5 31 0 -----    11111

TABLE6: movf MORSEBYTE,W
        andlw %00111111
	addwf PCL,F
        retlw '*'           ; 6 0  unknown   000000
        retlw '*'           ; 6 1  unknown   000001
        retlw '*'           ; 6 2  unknown   000010
        retlw '*'           ; 6 3  unknown   000011
        retlw '*'           ; 6 4  unknown   000100
        retlw '*'           ; 6 5  unknown   000101
;        goto ENDWORK        ; 6 5   ...-.0   000101 message "end of work"  
;        retlw '3'           ; 6 6  3 ...--.  000110
        retlw '*'           ; 6 6    ...--.  000110 (prev "3")
        retlw '*'           ; 6 7  unknown   000111
        retlw '*'           ; 6 8  unknown   001000
        retlw '*'           ; 6 9  unknown   001001
        retlw '*'           ; 6 10 unknown   001010
        retlw '*'           ; 6 11 unknown   001011
        retlw '?'           ; 6 12 ? ..--..  001100
        retlw '!'           ; 6 13 ! ..--.-  001101
        retlw '*'           ; 6 14 unknown   001110
        retlw '*'           ; 6 15 unknown   001111
        retlw '*'           ; 6 16 unknown   010000
        retlw '*'           ; 6 17 unknown   010001
        retlw '"'           ; 6 18 " .-..-.  010010
        retlw '*'           ; 6 19 unknown   010011
        retlw '*'           ; 6 20 unknown   010100
        retlw '.'           ; 6 21 . .-.-.-  010101
        retlw '*'           ; 6 22 unknown   010110
        retlw '*'           ; 6 23 unknown   010111
        retlw '*'           ; 6 24 unknown   011000
        retlw '*'           ; 6 25 unknown   011001
        retlw '*'           ; 6 26 unknown   011010
        retlw '*'           ; 6 27 unknown   011011
        retlw '*'           ; 6 28 unknown   011100
        retlw '*'           ; 6 29 unknown   011101
        retlw '''           ; 6 30 ' .----.  011110
        retlw '*'           ; 6 31 unknown   011111
        retlw '*'           ; 6 32 unknown   100000
        retlw '-'           ; 6 33 - -....-  100001
        retlw '*'           ; 6 34 unknown   100010
        retlw '*'           ; 6 35 unknown   100011
        retlw '*'           ; 6 36 unknown   100100
        retlw '*'           ; 6 37 unknown   100101
        retlw '*'           ; 6 38 unknown   100110
        retlw '*'           ; 6 39 unknown   100111
        retlw '*'           ; 6 40 unknown   101000
        retlw '*'           ; 6 41 unknown   101001
        retlw '*'           ; 6 42 unknown   101010
        retlw '*'           ; 6 43 unknown   101011
        retlw '*'           ; 6 44 unknown   101100
        retlw ')'           ; 6 45 ) -.--.-  101101
        retlw '*'           ; 6 46 unknown   101110
        retlw '*'           ; 6 47 unknown   101111
        retlw '*'           ; 6 48 unknown   110000
        retlw '*'           ; 6 49 unknown   110001
        retlw '*'           ; 6 50 unknown   110010
        retlw 44            ; 6 51 , --..--  110011 comma
        retlw '*'           ; 6 52 unknown   110100
        retlw '*'           ; 6 53 unknown   110101
        retlw '*'           ; 6 54 unknown   110110
        retlw '*'           ; 6 55 unknown   110111
        retlw 59            ; 6 56 ; ---...  111000 semicolon
        retlw '*'           ; 6 57 unknown   111001
        retlw '*'           ; 6 58 unknown   111010
        retlw '*'           ; 6 59 unknown   111011
        retlw '*'           ; 6 60 unknown   111100
        retlw '*'           ; 6 61 unknown   111101
        retlw '*'           ; 6 62 unknown   111110
        retlw '*'           ; 6 63 unknown   111111

MSGOK:  addwf PCL,F         ; message "understood"
        retlw 'u'
        retlw 'n'
        retlw 'd'
        retlw 'e'
        retlw 'r'
        retlw 's'
        retlw 't'
        retlw 'o'
        retlw 'o'
        retlw 'd'

MSGTX:  addwf PCL,F         ; message "invite to transmit"
        retlw 'i'
        retlw 'n'
        retlw 'v'
        retlw 'i'
        retlw 't'
        retlw 'e'
        retlw ' '
        retlw 't'
        retlw 'x'

MSGWAIT: addwf PCL,F         ; message "wait"
        retlw 'w'
        retlw 'a'
        retlw 'i'
        retlw 't'

MSGEND: addwf PCL,F         ; message "end of work"
        retlw 'e'
        retlw 'n'
        retlw 'd'
        retlw ' '
        retlw 'w'
        retlw 'o'
        retlw 'r'
        retlw 'k'

MSGST:  addwf PCL,F         ; message "starting signal"
        retlw 's'
        retlw 't'
        retlw 'a'
        retlw 'r'
        retlw 't'
        retlw 'i'
        retlw 'n'
        retlw 'g'

MSGERR: addwf PCL,F         ; message "error"
        retlw 'e'
        retlw 'r'
        retlw 'r'
        retlw 'o'
        retlw 'r'

MESSAG: addwf PCL,F
        retlw 'E'
        retlw 'P'
        retlw 'E'
        retlw ' '
        retlw 'M'
        retlw 'O'
        retlw 'R'
        retlw 'S'
        retlw 'E'
        retlw ' '
        retlw 'R'
        retlw 'E'
        retlw 'A'
        retlw 'D'
        retlw 'E'
        retlw 'R'

TABLCD: addwf PCL,F     ;LCD initialisation table - normal 2 line mode
        retlw %00110011 ;initialise lcd - first byte
        retlw %00110011 ;2nd byte (repeat of first)
        retlw %00110010 ;set for 4-bit operation
        retlw %00101100 ;set for 2 lines
        retlw %00000110 ;set entry mode to increment each address
        retlw %00001100 ;set display on, cursor off, blink off
        retlw %00000001 ;clear display
        retlw %00000010 ;return home, cursor & RAM to zero
                        ;end inititalisation table

START:  clrf PORTA              ; initialise all port outputs to zero
	  clrf PORTB
        BANK1
        movlw %00010011
        movwf TRISA             ; RA0-RA1, RA4 as inputs, RA2-RA3outputs
        movlw %11000000         ; RB7-6 input, RB5-0 outputs
        movwf TRISB
        movlw %00000100         ; set timer ratio 1/32
        movwf OPTION_REG
        BANK0

        call PAUSIT     ;1st 1/5th sec delay
LCDSET: clrf LOOP       ;clr LCD set-up loop
        clrf RSLINE     ;clear RS line for instruction send
LCDST2: movf LOOP,W     ;get table address
        call TABLCD     ;get set-up instruction
        call LCDOUT     ;perform it
        incf LOOP,F     ;inc loop
        btfss LOOP,3    ;has last LCD set-up instruction now been done?
        goto LCDST2     ;no
        call PAUSIT

LCDMSG: clrf LOOP       ;clear loop
        bsf RSLINE,4    ;set RS for data send
LCDMS2: movf LOOP,W     ;get table address
        call MESSAG     ;get message letter
        call LCDOUT     ;show it
        incf LOOP,F     ;inc loop
        btfss LOOP,4    ;has last LCD letter been sent?
        goto LCDMS2     ;no, repeat for next

        clrf CLKSEC     ;clear seconds counter
        clrf COUNT
        clrf LCDCOUNT
        clrf MODE
        clrf BPMFRACT
        clrf BPM0
        clrf BPM1
        clrf BPM0A
        clrf BPM1A
        clrf HIGHCNT
        clrf MORSEBYTE
        clrf MORSECNT

        clrf SWITCH
        movlw %00010000
        movwf PREV
 
        movlw 255
        movwf DIT
        movlw 2
        movwf DAH
        movlw 4
        movwf LETTERSPACE

WAITA:  btfss PORTA,4   ; wait till PORTA,4 goes high
        goto WAITA

        movlw 100        ;initial basic CLKCNT val for secs timing
        movwf CLKCNT
        movlw 60
        movwf CLKSEC

        movlw %11000000
        call LCDLIN      ;set address for line 2 (address 0)
        bsf RSLINE,4     ;set RS for data send

        movlw LCD0       ; set FSR for LCD
        movwf FSR

MAIN:   btfsc PORTA,4    ; is input lo?
        goto PITCHLO
        incf PITCH,F
        btfss PITCH,6
        goto PITCHLO
        bsf PORTA,2
        goto MAIN2
PITCHLO: bcf PORTA,2

MAIN2:  btfss INTCON,2  ;has a timer time-out been detected?
        goto MAIN       ;no
        BCF INTCON,2    ;yes
        call CLKADD     ;update time
        call GETMORSE
        goto MAIN

GETMORSE: movf PORTA,W
        andlw %00010000
        movwf STORA
        btfsc STORA,4      ; is input lo?
        goto LOPATH

HIPATH: bsf PORTA,3
        movf STORA,W
        xorwf PREV,W
        btfsc STATUS,Z     ; is PORTA,4 = prev PORTA,4 ?
        goto HI1           ; yes

        rlf MORSEBYTE,F    ; no, rotate left morsebyte
        bcf MORSEBYTE,0    ; clear LSB
        incf MORSECNT,F    ; inc the number of rotations

INCIT:  incf COUNT,F
        btfsc COUNT,4       ; is count = 16 ?
        call SETDAH         ; yes, update dit/dah lengths

HI1:    incfsz HIGHCNT,F    ; inc counter
        goto HI2
        decf HIGHCNT,F      ; set for 255 if rollover has occurred

HI2:    movf DAH,W          ; is count = DAH ?
        xorwf HIGHCNT,W
        btfsc STATUS,Z
        bsf MORSEBYTE,0     ; yes; set morsebyte LSB to 1
        goto ENDMORSE

LOPATH: bcf PORTA,3
        movf STORA,W
        xorwf PREV,W
        btfsc STATUS,Z      ; is PORTA,4 = prev PORTA0
        goto DITY           ; yes

        clrf LOW0           ; no so clear low count
        bcf PORTA,2
        movf HIGHCNT,W      ; subtract HIGH from DIT
        subwf DIT,W
        btfss STATUS,C      ; is there a borrow?
        goto DITX           ; yes
        movf HIGHCNT,W      ; no, so store HIGH into DIT
        movwf DIT
DITX:   clrf HIGHCNT        ; clear HIGH

DITY:   incfsz LOW0,F       ; inc LOW counter
        goto LO2
        decf LOW0,F         ; set for 255 if rollover has occurred

LO2:    movf LOW0,W         ; is LOW = LETTERSPACE value ?
        xorwf LETTERSPACE,W
        btfss STATUS,Z      ;
        goto LO3            ; no

        call INCBPM         ; update BPM
        call LCDMEM         ; send character to LCD and store it
        btfss LCDCOUNT,4    ; is LCD count = 16 ?
        goto ENDMORSE       ; no
        call COPYLCD        ; copy LCD line 2 to Line 1
        goto ENDMORSE

LO3:    movf LOW0,W         ; is LOW = WORDSPACE value
        xorwf WORDSPACE,W
        btfss STATUS,Z      ;
        goto ENDMORSE       ; no
        clrf MORSECNT       ; yes, cause space to be sent to LCD
        call LCDMEM
        btfsc LCDCOUNT,4    ; is LCD count = 16?
        call COPYLCD        ; yes, copy line 2 to line 1

ENDMORSE: movf STORA,W      ; store last-read PORTA val into PREV
        movwf PREV
        return

SETDAH: bcf STATUS,C        ; set timing values relative to DIT
        rlf DIT,W
        movwf DAH           ; DAH = 2 x DIT
        movwf LETTERSPACE
        rlf DAH,W           ; wordspace = DAH x 3 + DIT  = DIT x 7
        addwf DAH,W
        addwf DIT,W         ; new
        movwf WORDSPACE

        clrf COUNT
        movlw 255           ; set DIT to highest poss val
        movwf DIT
        return

LCDMEM: movf LCDCOUNT,W     ; yes, is LCD count = 0 ?
        btfsc STATUS,Z
        call CLRLCD         ; yes, so clear LCD

        movf MORSECNT,W
        call ROUTE
        movwf INDF
        call LCDOUT
        clrf MORSECNT
        clrf MORSEBYTE
        incf LCDCOUNT,F
        incf FSR,F
        return

COPYLCD: btfsc PORTA,1     ; is WPM switch = 1? 
        goto ENDCLR        ; yes, so bypass copy LCD lines
        movlw %10000000
        call LCDLIN
        bsf RSLINE,4
        
        movlw LCD0
        movwf FSR
        clrf LOOP
COPY2:  movf INDF,W
        call LCDOUT
        incf FSR,F
        incf LOOP,F
        btfss LOOP,4
        goto COPY2

ENDCLR: btfsc PORTA,1      ; is BPM switch = 1?
        call BPMSHOW       ; yes
        movlw %11000000
        call LCDLIN        ;set address for line 1 (address 0)
        bsf RSLINE,4       ;set RS for data send
        clrf LCDCOUNT
        movlw LCD0
        movwf FSR
        return

BPMSHOW: movlw %10000000
        call LCDLIN        ;set address for line 1 (address 0)
        bsf RSLINE,4       ;set RS for data send

        movf BPM1A,W
        iorlw 48
        call LCDOUT
        movf BPM0A,W
        iorlw 48
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'W'
        call LCDOUT
        movlw 'P'
        call LCDOUT
        movlw 'M'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT

        movf BPM1,W
        iorlw 48
        call LCDOUT
        movf BPM0,W
        iorlw 48
        call LCDOUT
        movlw 'w'
        call LCDOUT
        return

INCBPM: movlw 51           ; equiv to dividing letter count by 5
        addwf BPMFRACT,F
        btfss STATUS,C     ; is there a carry?
        return             ; no
        incf BPM0,F        ; inc WPM count, in BCD
        movlw 6            ; check units >9
        addwf BPM0,W       ; if 6 is added is there a digit carry?
        btfss STATUS,DC
        return
        clrf BPM0          ; yes
        incf BPM1,F        ; inc WPM tens count in BCD
        movlw 6            ; check units >9
        addwf BPM1,W       ; if 6 is added is there a digit carry?
        btfss STATUS,DC
        return
        clrf BPM1          ;yes
        return

CLRLCD: movlw %11000000
        call LCDLIN
        bsf RSLINE,4

        clrf LOOP
CLRL2:  movlw ' '
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto CLRL2
        movlw %11000000
        call LCDLIN
        bsf RSLINE,4
        return

UNDERSTOOD:
        clrf LOOPB
OK2:    movf LOOPB,W
        call MSGOK      ;show message
        call LCDOUT
        incf LOOPB,F
        movf LOOPB,W
        xorlw 10
        btfss STATUS,Z
        goto OK2
        retlw ' '

WAITMSG:
        clrf LOOPB
WAIT2:  movf LOOPB,W
        call MSGWAIT    ;show message
        call LCDOUT
        incf LOOPB,F
        movf LOOPB,W
        xorlw 4
        btfss STATUS,Z
        goto WAIT2
        retlw ' '

STARTING:
        clrf LOOPB
START2: movf LOOPB,W
        call MSGST      ;show message
        call LCDOUT
        incf LOOPB,F
        movf LOOPB,W
        xorlw 8
        btfss STATUS,Z
        goto START2
        retlw ' '

ENDWORK:
        clrf LOOPB
END2:   movf LOOPB,W
        call MSGEND     ;show message
        call LCDOUT
        incf LOOPB,F
        movf LOOPB,W
        xorlw 8
        btfss STATUS,Z
        goto END2
        retlw ' '

CLKADD: decfsz CLKCNT,F ;increment system clock counter. Is it = 0?
        return          ;no

        movlw 100        ;yes, reset start value of CLKCNT
        movwf CLKCNT
        decfsz CLKSEC,F
        return

        movlw 60
        movwf CLKSEC

        movf BPM0,W
        movwf BPM0A
        movf BPM1,W
        movwf BPM1A
        clrf BPM0
        clrf BPM1
        return

LCDFRM: movwf STORE2    ;split & format decimal byte for LCD
        swapf STORE2,W  ;swap byte into W to get tens
        andlw 15        ;AND to get nibble
        iorlw 48        ;OR with 48 to make ASCII value
        call LCDOUT     ;send to LCD
        movf STORE2,W   ;get units
        andlw 15        ;AND to get nibble
        iorlw 48        ;OR with 48 to make ASCII value

LCDOUT: movwf STORE1    ;temp store value that will be output to LCD
        movlw 60        ;set minimum time between sending full bytes to ...60
        movwf LOOPA     ;LCD - value of 60 seems OK for this prog with
DELAY:  decfsz LOOPA,F  ;XTAL clk of upto 5MHz, possibly 5.5MHz
        goto DELAY
        call SENDIT     ;send MSB, then (by default) send LSB

SENDIT: swapf STORE1,F  ;swap byte nibbles
        movf STORE1,W   ;get nibble (MSB)
        andlw 15        ;AND to isolate nibble
        iorwf RSLINE,W  ;OR the RS bit
        movwf PORTB     ;output the byte
        BSF PORTB,5     ;set E high
        BCF PORTB,5     ;set E low
        return

LCDLIN: BCF RSLINE,4    ;sets LCD command/line
        call LCDOUT     ;and outputs cmmand code to LCD
        BSF RSLINE,4    ;set RS flag
        return

PAUSIT: movlw 20 ;30  ;60        ;1/5th sec wait set ... 20
        movwf CLKCNT
        clrf INTCON     ;clear interupt flag
PAUSE:                  ;initial 1/5th sec wait before setting up LCD
        btfss INTCON,2  ;has a timer time-out been detected?
        goto PAUSE      ;no
        BCF INTCON,2    ;yes
        decfsz CLKCNT,F ;dec loop, is it zero?
        goto PAUSE      ;no
        return          ;yes

;...............

;WRITE DATA TO EEPROM ROUTINE:

                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in STORE1.
        return
SETPRM: movwf EEADR     ;Now copy W into EEADR to set eeprom address
        BANK1
        bsf EECON1,WREN ;enable write flag
        BANK0
        movf STORE1,W   ;get data value from STORE1 and hold in W
        movwf EEDATA    ;copy W into eeprom data byte register

MANUAL: BANK1           ;these next 12 lines are according to
        movlw $55       ;Microchip manual dictated factors
        movwf EECON2    ;they cause the action required by
        movlw $AA       ;by the eeprom to store the data in EEDATA
        movwf EECON2    ;at the address held by EEADR.
        bsf EECON1,WR   ;set the ``perform write'' flag

CHKWRT: btfss EECON1,4  ;wait until bit 4 of EECON1 is set
        goto CHKWRT
        bcf EECON1,WREN ;disable write
        bcf EECON1,4    ;clear bit 4 of EECON1
        BANK0
        bcf INTCON,6    ;clear bit 6 of INTCON
        return          ;and return

;..........

;READ DATA FROM EEPROM ROUTINE:

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: movwf EEADR     ;Now copy W into EEADR to set eeprom address
        BANK1           ;
        BSF EECON1,RD   ;enable read flag
        BANK0
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        return          ;and return

        .end            ; of program



