;PIC-based Mind Machine		
;by Andy Flind		
;16/6/98		
;for PIC16C84 or PIC16F84		
;Oscillator: XT		
;Watchdog Timer: OFF		
;Startup Timer: ON		
;For use with 3.2768MHz crystal		
		
#DEFINE page0 BCF status,5		
#DEFINE page1 BSF status,5		
		
status:	.EQU $03	;general equates
portA:	.EQU $05	
trisA:	.EQU $05	
portB:	.EQU $06	
trisB:	.EQU $06	
pcl:	.EQU $02	
rtcc:	.EQU $01	
option:	.EQU $01	
intcon:	.EQU $0B	
f:	.EQU $01	
w:	.EQU $00	
z:	.EQU $02	
		
prog:	.EQU $0C	;program specific equates
time:	.EQU $0D	
ratio1:	.EQU $0E	
ratio2:	.EQU $0F	
ratio:	.EQU $10	
firsval:	.EQU $11	
secval:	.EQU $12	
scale:	.EQU $13	
tabval:	.EQU $14	
tim:	.EQU $15	
scl:	.EQU $16	
stats:	.EQU $17	
uu:	.EQU $18	
		
	.org $0004	;interrupt vector
	goto intrpt	
	.org $0005	;start of program
		
	goto start	
		
table:	addwf pcl,f	
	retlw 101	;first value for program 1
	retlw 85	
	retlw 74	
	retlw 68	
	retlw 68	
	retlw 70	
	retlw 79	
	retlw 86	
	retlw 68	
	retlw 63	
	retlw 71	
	retlw 85	
	retlw 89	
	retlw 80	
	retlw 66	
	retlw 66	
	retlw 73	
	retlw 80	
	retlw 80	
	retlw 78	
	retlw 75	
	retlw 74	
	retlw 75	
	retlw 77	
	retlw 79	
	retlw 80	
	retlw 81	
	retlw 83	
	retlw 87	
	retlw 94	
	retlw 101	
		
	retlw 87	;first value for program 2
	retlw 73	
	retlw 60	
	retlw 65	
	retlw 72	
	retlw 68	
	retlw 57	
	retlw 52	
	retlw 55	
	retlw 63	
	retlw 75	
	retlw 81	
	retlw 70	
	retlw 49	
	retlw 44	
	retlw 46	
	retlw 56	
	retlw 73	
	retlw 82	
	retlw 80	
	retlw 61	
	retlw 52	
	retlw 53	
	retlw 56	
	retlw 65	
	retlw 68	
	retlw 59	
	retlw 58	
	retlw 66	
	retlw 77	
	retlw 83	
		
	retlw 92	;first value for program 3
	retlw 85	
	retlw 68	
	retlw 63	
	retlw 52	
	retlw 37	
	retlw 36	
	retlw 40	
	retlw 38	
	retlw 30	
	retlw 36	
	retlw 44	
	retlw 46	
	retlw 37	
	retlw 25	
	retlw 28	
	retlw 36	
	retlw 36	
	retlw 44	
	retlw 41	
	retlw 31	
	retlw 30	
	retlw 35	
	retlw 36	
	retlw 40	
	retlw 56	
	retlw 62	
	retlw 64	
	retlw 67	
	retlw 70	
	retlw 78	
		
	retlw 83	;first value for program 4
	retlw 72	
	retlw 64	
	retlw 63	
	retlw 65	
	retlw 67	
	retlw 66	
	retlw 60	
	retlw 41	
	retlw 25	
	retlw 19	
	retlw 18	
	retlw 23	
	retlw 30	
	retlw 35	
	retlw 30	
	retlw 22	
	retlw 18	
	retlw 20	
	retlw 29	
	retlw 35	
	retlw 36	
	retlw 37	
	retlw 40	
	retlw 47	
	retlw 61	
	retlw 63	
	retlw 63	
	retlw 65	
	retlw 69	
	retlw 78	
		
	retlw 96	;first value for program 5
	retlw 83	
	retlw 78	
	retlw 76	
	retlw 69	
	retlw 63	
	retlw 63	
	retlw 62	
	retlw 58	
	retlw 47	
	retlw 37	
	retlw 35	
	retlw 35	
	retlw 30	
	retlw 20	
	retlw 13	
	retlw 12	
	retlw 16	
	retlw 22	
	retlw 24	
	retlw 19	
	retlw 14	
	retlw 12	
	retlw 15	
	retlw 20	
	retlw 25	
	retlw 30	
	retlw 35	
	retlw 37	
	retlw 39	
	retlw 41	
		
	retlw 101	;first value for program 6
	retlw 87	
	retlw 78	
	retlw 71	
	retlw 67	
	retlw 66	
	retlw 60	
	retlw 39	
	retlw 39	
	retlw 40	
	retlw 45	
	retlw 56	
	retlw 63	
	retlw 57	
	retlw 56	
	retlw 60	
	retlw 55	
	retlw 41	
	retlw 28	
	retlw 30	
	retlw 35	
	retlw 35	
	retlw 19	
	retlw 16	
	retlw 20	
	retlw 37	
	retlw 52	
	retlw 58	
	retlw 60	
	retlw 76	
	retlw 87	
		
	retlw 101	;first value for program 7
	retlw 99	
	retlw 95	
	retlw 78	
	retlw 70	
	retlw 68	
	retlw 69	
	retlw 71	
	retlw 71	
	retlw 63	
	retlw 40	
	retlw 36	
	retlw 37	
	retlw 40	
	retlw 40	
	retlw 35	
	retlw 18	
	retlw 12	
	retlw 15	
	retlw 24	
	retlw 39	
	retlw 57	
	retlw 68	
	retlw 62	
	retlw 63	
	retlw 74	
	retlw 71	
	retlw 51	
	retlw 56	
	retlw 73	
	retlw 96	
		
	;set up to get user input from buttons	
start:	clrf portA	
	clrf portB	
	page1	
	movlw %000011100	
	movwf trisA	;portA bits 2-4 input, rest output
	movlw %00000110	
	movwf option	;set rtcc prescaler for 40mS
	clrf trisB	
	page0	
	movlw %10000000	;portB bit 7 high, used to stop second
	movwf portB	;oscillator until run starts
	call beep	;successful power-up or reset
		
input:	call sw_on	;to get the program selection
	movwf prog	
	rrf prog,f	;shift the input value
	rrf prog,f	;to correct position
	call beep	;user friendly!
	call sw_off	
	call sw_on	;to get the overall run time
	movwf time	
	rrf time,f	;shift the input value
	rrf time,f	;to correct position
	call beep	
	call sw_off	
	call adjust	;add offsets for 1st 5 mins and prog selection
	call sw_on	;to start the program running
	call beep	
		
	;now set up for running the program	
	page1	
	movlw %11111110	;only bit 0 of portA as output
	movwf trisA	
	movlw 1	
	movwf option	;set rtcc prescaler for 800Hz
	page0	
	movlw %10100000	
	movwf intcon	;set general and interrupt timer bits
	goto run	;go run the selected program
		
	;waits for and debounces button presses, returns value in w register	
sw_on:	clrf portA	
	movf portA,w	;any buttons pressed yet?
	andlw %00011100	
	btfsc status,z	;as in "are the three input bits all zero?"
	goto sw_on	;yes, so keep looking
	clrf rtcc	;no, so start timer
on:	comf rtcc,w	;update the zero flag
	btfsc status,z	;timed out yet?
	goto copy	;yes, so input is valid, go get it
	movf portA,w	
	andlw %00011100	;those three bits again...
	btfsc status,z	;if it's zero again, input is not valid
	goto sw_on	;so go back to the start
	goto on	;input still valid so continue timing
copy:	movf portA,w	;copy switch pattern into w
	return	
		
	;waits for and debounces button release	
sw_off:	movf portA,w	
	andlw %00011100	;only interested in these bits
	btfss status,z	;all switches released?
	goto sw_off	;no, so keep checking
	clrf rtcc	;yes, so start timer
off:	comf rtcc,w	
	btfsc status,z	;timed out yet?
	return	;yes, test complete
	movf portA,w	;no, so test switches again
	andlw %00011100	
	btfss status,z	
	goto sw_off	;not cleared, so go back to start
	goto off	;still clear, so continue timing
		
	;provides a short "beep" sound	
beep:	movlw 255	;this value sets the period
	movwf tim	
jmp_0:	movlw 112	;and this one sets the frequency
	movwf scl	
jmp_1:	decfsz scl,f	
	goto jmp_1	
	movlw 2	
	addwf portA,f	;toggle portA bit 1 state
	decfsz tim,f	
	goto jmp_0	
	clrf portA	
	return	
		
	;adjust values in prog and time to suit table calling routine	
adjust:	clrw	
add:	addlw 31	;31 steps per program
	decfsz prog,f	
	goto add	
	movwf prog	
	movlw 31	
	subwf prog,f	;offset for table selection is now correct
	movlw 1	
	addwf time,f	;correction for 1st 5 mins
	return	
		
	;runs the program with the selected values	
run:	clrf tabval	;table value pointer
	movf prog,w	;get the table offset value
	call table	;and get the first value
	movwf secval	;drop it into "secval"
jmp_6:	incf tabval,f	;increment the pointer
	movlw 31	;these four lines
	xorwf tabval,w	;stop the program
	btfsc status,z	;when the pointer
	goto stop	;reaches a value of 31
	movf secval,w	;copy value from secval
	movwf firsval	;into firsval
	movf tabval,w	;get the pointer value
	addwf prog,w	;add the offset
	call table	;get the corresponding table value
	movwf secval	;and drop it into secval
	call scan	;do the scan between the two values
	goto jmp_6	;and do it all again...
		
	;scans rapidly between the two values with varying m/s value	
scan:	movlw 255	;first value for firsval
	movwf ratio1	
	movlw 1	;first value for secval
	movwf ratio2	
	movlw 41	;overall timing trim, 41 for 5-min steps
	movwf scale	
outer:	movf time,w	;start of outer loop
	movwf tim	
middle:	movf scale,w	;start of middle loop
	movwf scl	
inner:	movf firsval,w	;start of inner loop
	movwf portB	
	movf ratio1,w	
	movwf ratio	
loop_1:	decfsz ratio,f	
	goto loop_1	;loop 1 for ratio 1
	movf secval,w	
	movwf portB	
	movf ratio2,w	
	movwf ratio	
loop_2:	decfsz ratio,f	
	goto loop_2	;loop 2 for ratio 2
	decfsz scl,f	
	goto inner	
	decfsz tim,f	
	goto middle	
	incf ratio2,f	
	decfsz ratio1,f	
	goto outer	
	return	
		
	;generate the 400Hz tone	
intrpt:	movwf uu	;save w register state
	movf status,w	
	movwf stats	;save status register state
	incf portA,f	;toggle portA bit 0
	bcf intcon,2	;reset timeout bit
	movf stats,w	
	movwf status	;restore status register state
	movf uu,w	;restore w register state
	retfie	
		
	;beep at 3 second intervals	
stop:	clrf intcon	;stop 400Hz tone interrupts
	movlw %10000000	;stop second output
	movwf portB	;all other outputs to zero
	clrf portA	
	page1	
	movlw %000011100	
	movwf trisA	;portA bit 1 as output again
	page0	
loop_a:	movlw 92	;for 3 second intervals
	movwf firsval	
loop_b:	movwf secval	
loop_c:	movwf scale	
loop_d:	decfsz scale,f	
	goto loop_d	
	decfsz secval,f	
	goto loop_c	
	decfsz firsval,f	
	goto loop_b	
	call beep	
	goto loop_a	
		
	.END	


