 ;MIDI SYNCHRONOME
 ;================
 ;===============================
 ;ASM DIRECTIVES
 ;--------------
 list r=dec ;Default radix decimal
 list p=pic16f627 ;Device
 ;=====================
 ;CONFIGURATION
 ;-------------
 ;
 ;__config %11111101100001;Configuration
 ;
 ;=============
 ;Program code protection off
 ;Data code protection off
 ;Low voltage programming disabled
 ;Brown-out detect enabled
 ;MCLR- selected
 ;Power-up timer enabled
 ;Watchdog timer disabled
 ;XT xtal selected
 ;WORKING REGISTERS
 ;-----------------
w equ 0 ;working register flag
f equ 1 ;file register flag
 ;END OF WORKING REFISTERS
 ;========================
 ;SPECIAL FUNCTION REGISTERS
 ;--------------------------
 ;BANK 0
 ;------
Pcl equ $02 ;
Status equ $03 ;
Rp0 equ 5 ;
Rp1 equ 6;
c equ 0 ;
z equ 2 ;
Porta equ $05 ;
Ra3 equ 3 ;
Ra4 equ 4 ;
Portb equ $06 ;
Intcon equ $0B ;
Gie equ 7 ;
Peie equ 6 ;
Tmr1l equ $0E ;
Tmr1h equ $0F ;
T1con equ $10 ;
Tmr1on equ 0 ;
Rcsta equ $18 ;
Cren equ 4 ;
Spen equ 7 ;
Rcreg equ $1A ;
Cmcon equ $1F ;
 ;BANK 1
 ;------
Option equ $01 ;
Trisa equ $05 ;
Trisb equ $06 ;
Spbrg equ $19 ;
Pie1 equ $0C ;
Rcie equ 5 ;
 ;END OF SPECIAL FUNCTION REGISTERS
 ;=================================
 ;GENERAL PURPOSE REGISTERS
 ;-------------------------
Status_temp equ $20;
Step_pos equ $21;
Varmscount equ $22;
Midi_byte equ $23;
Spp_flags equ $24;
Spp equ 0;
Spp_lsb equ $25;
Bpm_flags equ $26;
Mt120 equ 0 ;
Mt85 equ 1 ;
Lt85 equ 2;
Timer equ 3;
Trplt equ 4;
 ;
 ;END OF GENERAL PURPOSE REGISTERS
 ;================================
 ;ASM DIRECTIVES
 ;============================
 ;END OF SET UP ASSEMBLER
 ;=======================
 ;========================
 ;START OF PROGRAMME CODE
 ;-----------------------
 org $0000 ;
 goto start;
 ;
 org $0004;Interrupt vector
 goto intrpt;
 ;
 org $0005;
Start: ;
 call con_io;Configure in/out registers
 call con_usart;Configure the USART
 call con_intcon;Configure interrupt control
 call con_tmr1;Configure Timer1
 call in_gen_reg;Initialise general registers
 goto main_lp;
 ;TABLES
 ;------
Pb_tbl: addwf pcl,f;Step_pos - clocks - spp - 1/4 notes
 retlw %10000000;0 - 1 - 0 - 0
 retlw %10000000;
 retlw %10000000;
 retlw %01000000;3 - 4
 retlw %01000000;
 retlw %01000000;
 retlw %00100000;6 - 7 - 1
 retlw %00100000;
 retlw %00100000;
 retlw %00010000;9 - 10
 retlw %00010000;
 retlw %00010000;
 retlw %00001000;12 - 13 - 2
 retlw %00001000;
 retlw %00001000;
 retlw %00000001;15 - 16
 retlw %00000001;
 retlw %00000001;
 retlw %00000000;18 - 19 - 3
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;21 - 22
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;24 - 25 - 4 - 1
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;27 - 28
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;30 - 31 - 5
 retlw %00000000;
 retlw %00000000;
 retlw %00000001;33 - 34
 retlw %00000001;
 retlw %00000001;
 retlw %00001000;36 - 37 - 6
 retlw %00001000;
 retlw %00001000;
 retlw %00010000;39 - 40
 retlw %00010000;
 retlw %00010000;
 retlw %00100000;42 - 43 - 7
 retlw %00100000;
 retlw %00100000;
 retlw %01000000;45 - 46
 retlw %01000000;
 retlw %01000000;
 ;48(0) - 49(1) - 8(0) - 0(2)
 ;STRAIGHT + TRIPLET 1/4 NOTE TABLE A
 ;-----------------------------------
Pa_4_tbl: addwf pcl,f;Step_pos - clocks - spp - 1/4 notes
 retlw %00001000;0 - 1 - 0 - 0
 retlw %00000000;Only give click at first of 3 clocks
 retlw %00000000;per LED position
 retlw %00000000;3 - 4
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;6 - 7 - 1
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;9 - 10
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;12 - 13 - 2
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;15 - 16
 retlw %00000000;
 retlw %00000000;
 retlw %00000100;18 - 19 - 3
 retlw %00000100;
 retlw %00000100;
 retlw %00000010;21 - 22
 retlw %00000010;
 retlw %00000010;
 retlw %00001001;24 - 25 - 4 - 1
 retlw %00000001;
 retlw %00000001;
 retlw %00000010;27 - 28
 retlw %00000010;
 retlw %00000010;
 retlw %00000100;30 - 31 - 5
 retlw %00000100;
 retlw %00000100;
 retlw %00000000;33 - 34
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;36 - 35 - 6
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;39 - 40
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;42 - 43 - 7
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;45 - 46
 retlw %00000000;
 retlw %00000000;
 ;48(0) - 49(1) - 8(0) - 0(2)
 ;STRAIGHT TIME 1/8 NOTE TABLE A
 ;------------------------------
Pa_8_tbl: addwf pcl,f;Step_pos - clocks - spp - 1/4 notes
 retlw %00001000;0 - 1 - 0 - 0
 retlw %00000000;Only give click at first of 3 clocks
 retlw %00000000;per LED position
 retlw %00000000;3 - 4
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;6 - 7 - 1
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;9 - 10
 retlw %00000000;
 retlw %00000000;
 retlw %00001000;12 - 13 - 2
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;15 - 16
 retlw %00000000;
 retlw %00000000;
 retlw %00000100;18 - 19 - 3
 retlw %00000100;
 retlw %00000100;
 retlw %00000010;21 - 22
 retlw %00000010;
 retlw %00000010;
 retlw %00001001;24 - 25 - 4 - 1
 retlw %00000001;
 retlw %00000001;
 retlw %00000010;27 - 28
 retlw %00000010;
 retlw %00000010;
 retlw %00000100;30 - 31 - 5
 retlw %00000100;
 retlw %00000100;
 retlw %00000000;33 - 34
 retlw %00000000;
 retlw %00000000;
 retlw %00001000;36 - 35 - 6
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;39 - 40
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;42 - 43 - 7
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;45 - 46
 retlw %00000000;
 retlw %00000000;
 ;48(0) - 49(1) - 8(0) - 0(2)
 ;STRAIGHT TIME 1/16 NOTE TABLE A
 ;------------------------------
Pa_16_tbl: addwf pcl,f;Step_pos - clocks - spp - 1/4 notes
 retlw %00001000;0 - 1 - 0 - 0
 retlw %00000000;Only give click at first of 3 clocks
 retlw %00000000;per LED position
 retlw %00000000;3 - 4
 retlw %00000000;
 retlw %00000000;
 retlw %00001000;6 - 7 - 1
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;9 - 10
 retlw %00000000;
 retlw %00000000;
 retlw %00001000;12 - 13 - 2
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;15 - 16
 retlw %00000000;
 retlw %00000000;
 retlw %00001100;18 - 19 - 3
 retlw %00000100;
 retlw %00000100;
 retlw %00000010;21 - 22
 retlw %00000010;
 retlw %00000010;
 retlw %00001001;24 - 25 - 4 - 1
 retlw %00000001;
 retlw %00000001;
 retlw %00000010;27 - 28
 retlw %00000010;
 retlw %00000010;
 retlw %00001100;30 - 31 - 5
 retlw %00000100;
 retlw %00000100;
 retlw %00000000;33 - 34
 retlw %00000000;
 retlw %00000000;
 retlw %00001000;36 - 35 - 6
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;39 - 40
 retlw %00000000;
 retlw %00000000;
 retlw %00001000;42 - 43 - 7
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;45 - 46
 retlw %00000000;
 retlw %00000000;
 ;48(0) - 49(1) - 8(0) - 0(2)
 ;TRIPLET TIME 1/8 NOTE TABLE A
 ;-----------------------------
Pa_3_tbl: addwf pcl,f;Step_pos - clocks - spp - 1/4 notes
 retlw %00001000;0 - 1 - 0 - 0
 retlw %00000000;Only give click at first of 3 clocks
 retlw %00000000;per LED position
 retlw %00000000;3 - 4
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;6 - 7 - 1
 retlw %00000000;
 retlw %00001000;
 retlw %00000000;9 - 10
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;12 - 13 - 2
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;15 - 16
 retlw %00001000;
 retlw %00000000;
 retlw %00000100;18 - 19 - 3
 retlw %00000100;
 retlw %00000100;
 retlw %00000010;21 - 22
 retlw %00000010;
 retlw %00000010;
 retlw %00001001;24 - 25 - 4 - 1
 retlw %00000001;
 retlw %00000001;
 retlw %00000010;27 - 28
 retlw %00000010;
 retlw %00000010;
 retlw %00000100;30 - 31 - 5
 retlw %00000100;
 retlw %00001100;
 retlw %00000000;33 - 34
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;36 - 35 - 6
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;39 - 40
 retlw %00001000;
 retlw %00000000;
 retlw %00000000;42 - 43 - 7
 retlw %00000000;
 retlw %00000000;
 retlw %00000000;45 - 46
 retlw %00000000;
 retlw %00000000;
 ;48(0) - 49(1) - 8(0) - 0(2)
 ;
 ;END OF TABLES
 ;=============
 ;BEGINNING OF MAIN PROGRAMME LOOP
 ;----------------------
Main_lp: ;
 bsf rcsta,cren;Reset the USART receiver
 ;and loop until interrupt occurs
 goto main_lp;END OF MAIN PROGRAMME CODE
 ;==========================
 ;==========================
 ;INTERRUPT SERVICE ROUTINE
 ;-------------------------
Intrpt: ;
 movf rcreg,w;transfer byte to midi_byte
 movwf midi_byte;
 ;
 btfss spp_flags,spp;Is next byte spp data?(spp=1 if
 goto chk_byte;spp message already received)
 ;If not jump ahead to test byte
 ;If so it is spp lsb (msb not needed)
 ;
 movf midi_byte,w;
 movwf spp_lsb;
 ;
 btfsc spp_lsb,7;Ensure it is a data byte
 goto ret_fie;Return if not
 ;
 ;Only every eight spps needed
 movlw 7;so mask top 5 bits
 andwf spp_lsb,f;
Reset_pos: ;
 ;
 ;Multiply spp by 6 to give step_pos
 movf spp_lsb,w;
 addwf spp_lsb,w;
 addwf spp_lsb,w;
 addwf spp_lsb,w;
 addwf spp_lsb,w;
 addwf spp_lsb,w;
 movwf step_pos;
 ;
Clr_spp: bcf spp_flags,spp;
 goto ret_fie;Reset spp flag then return
 ;and wait for clock
 ;
Chk_byte: ;Not an spp data byte if reach here
 movf midi_byte,w;
 ;
 sublw %11110010;Check if byte is song position pointer
 btfss status,z;message
 goto chk_clk;If not jump ahead to check if clock
 ;If it is, need to collect next
 ;data byte (spp lsb)
 ;Also need to reset bpm flag to >120
 bsf spp_flags,spp;Set spp flag
 bcf bpm_flags,lt85;
 bcf bpm_flags,mt85;
 bsf bpm_flags,mt120;
 ;
 goto ret_fie;Return to wait for data byte
 ;
 ;Check if new byte is clock message
Chk_clk: movf midi_byte,w;
 sublw %11111000;
 btfss status,z;Return from interrupt if it is not
 goto ret_fie;
 ;Must be clock, so start or continue
 ;metronome - check bpm rate after this
 ;Check whether straight or triplet time
 call time_4_3;
 ;
Move_led: movf step_pos,w;
 call pb_tbl;Put the table values in port b
 movwf portb;and port a ie light LED
 ;
 movf step_pos,w;Re-move step_pos for table a
 ;Determine which porta table to use
 btfss bpm_flags,mt120;
 goto not_mt120;
 call pa_4_tbl;
 goto end_pa_tbl;
Not_mt120: ;
 btfss bpm_flags,mt85;
 goto bpm_lt85;
 btfsc bpm_flags,trplt;
 goto mt85_3;
 call pa_8_tbl;
 goto end_pa_tbl;
Bpm_lt85: ;
 btfsc bpm_flags,trplt;
 goto lt85_3;
 ;Must be straight time less than 85 bpm
 call pa_16_tbl;
 goto end_pa_tbl;
 ;
Mt85_3: call pa_4_tbl;
 goto end_pa_tbl;
 ;
Lt85_3: call pa_3_tbl;
 ;
End_pa_tbl: ;
 movwf porta;
 call next_pos;Fetch the next LED position
 ;table values
 ;
 call chk_bpm;Check bpm rate
 ;
 btfss porta,ra3;Check if click on is selected
 goto ret_fie;- return if not
 ;
 movlw 1;Check whether on-beat click
 subwf step_pos,w;or off-beat click is required
 btfsc status,z;and make long or short
 goto ms1;delay accordingly
 movlw 25;
 subwf step_pos,w;
 btfsc status,z;
Ms1: call ms1dly;
 call ms0_5dly; 
 bcf porta,ra3;
Ret_fie: ;
 retfie;
 ;END OF INTERRUPT SERVICE ROUTINE
 ;================================
 ;================================
 ;BEGINNING OF SUB-ROUTINES
 ;=========================
 ;CONFGURE I/O SUB-ROUTINE
 ;--------------------------
 ;SET UP PORT B
 ;-------------
Con_io: bcf status,rp1 ;Set to bank 1
 bsf status,rp0;
 movlw %00000110;Set rb1, rb2 as i/p as required
 movwf trisb;for USART operation
 ;Set others as o/p
 bcf status,rp0 ;Reset to bank 0
 ;END OF SET UP PORT B
 ;====================
 ;SET UP PORT A
 ;-------------
 ;trisa set to all inputs on power-up
 ;trisa = %11-1 1111 at power-up
 ;cmcon set to %00000000 at power-up
 ;vrcon set to %00000000 at power-up
 ;ccp1con set to %00000000 at power-up
 ;ensure ccp module is off
 ;SET COMPARATORS OFF
 ;-------------------
 ;Still bank 0
 movlw %00000111;
 movwf cmcon;
 ;
 bsf status,rp0 ;Set to bank 1
 movlw %00010000;ra4 i/p all others o/p
 movwf trisa;
 bcf status,rp0 ;Reset to bank 0
 ;END OF SET UP PORT A
 ;====================
 return;
 ;END OF CONFIGURE I/O SUB-ROUTINE
 ;=================================
 ;CONFIGURE USART SUB-ROUTINE
 ;---------------------------
Con_usart: ;set up for asynchronous transmission
 ;txsta set to %00000010 at power-up
 ;rcsta set to %0000000x at power-up
 ;spbrg set to %00000000 at power-up
 ;pie1 set to %00000000 at power-up
 ;pir1 set to %00000000 at power-up
 ;rcreg set to %00000000 at power-up
 ;enable serial port
 ;set rcsta,spen
 ;spen = bit 7 (0 at power-up)
 ;data received on rb1
 ;data transmitted on rb2
 ;enable asynchronous mode -
 ;clear txsta,sync (0 at power-up)
 ;sync = bit 4
 ;initialise USART for 31250 baud rate
 ;(4MHz xtal)
 ;use txst-a,brgh = 0 (low speed)
 ;brgh = bit 2 (0 at power-up)
 ;br = fosc/(64(x+1))
 ;x is value in spbrg
 ;x = 1 for 31250 br
 bsf status,rp0 ;set bank 1 
 movlw 1;
 movwf spbrg;
 ;set up 8-bit reception
 ;clear rcsta,rx9
 ;rx9 = bit 6 (0 at power-up)
 ;configure port b for usart
 bcf status,rp0 ;reset to bank 0
 ;ENABLE SERIAL PORT
 ;------------------
 ;set rcsta,spen
 ;spen = bit 7 (0 at power-up)
 ;data received on rb1
 ;data transmitted on rb2
 bsf rcsta,spen;
 ;enable interrupts
 bsf status,rp0 ;set to bank 1
 bsf pie1,rcie;
 bcf status,rp0 ;reset to bank 0
 return;
 ;END OF CONFIGURE USART SUB-ROUTINE
 ;==================================
 ;CONFIGURE INTERRUPT CONTROL S-R
 ;-------------------------------
Con_intcon: bcf status,rp0 ;Set to bank 0
 bsf intcon,peie ;Enable peripheral interrupts
 bsf intcon,gie ;Enable global interrupts
 return;
 ;END OF CONFIG INTERRUPT CONTROL S-R
 ;===================================
 ;CONFIGURE TIMER1 SUB-ROUTINE
 ;----------------------------
Con_tmr1: bcf status,rp0;Bank0
 movlw %00100000;
 movwf t1con;Tmr prescalar 1:4 each increment of
 ;tmr1h = 1ms nominal
 ;Internal clock
 ;Clock off
 clrf tmr1h;
 clrf tmr1l;
 return;
 ;END OF CONFIG TIMER0 SUB-ROUTINE
 ;=================================
 ;START OF NEXT LED POSITION SUBROUTINE
 ;-------------------------------------
 ;
 ;Check if the led position and
 ;makeclick table pointer has reached
 ;the end of the table
 ;
Next_pos: incf step_pos,f;Increment the led step position and
 movf step_pos,w;and move its value into w
 ;
 sublw 48;Check if step_pos is 47,
 ;the last value of the table
 btfss status,z;If not, return from sub-routine
 goto ret_pos;
 ;
 movlw 0;If it is, reset it to 0 and
 movwf step_pos;return from sub-routine
 ;
 ;
Ret_pos: return;END OF NEXT LED POSITION SUBROUTINE
 ;===================================
 ;INITIALISE GENERAL REGISTERS S-R
 ;-------------------------------
In_gen_reg: ;
 clrf status_temp;
 clrf step_pos;
 clrf varmscount;
 clrf midi_byte;
 clrf spp_flags;
 clrf spp_lsb;
 clrf bpm_flags;
 bsf bpm_flags,mt120;Set initial bpm to >120 so that
 ;initial pa table chosen has no
 ;off-beat clicks
 return;
 ;END OF INITIALISE GEN REGISTERS S-R
 ;===================================
 ;START OF 1ms DELAY SUBROUTINE
 ;-----------------------------
Ms1dly: movlw 248;move the required loop number into
 movwf varmscount;varmscount
 ;
Ms1loop: nop;
 decfsz varmscount,f ;
 goto ms1loop;
 ;
 nop;
 nop;
 nop;
 ;
 return;END OF 1ms DELAY SUBROUTINE
 ;===========================
 ;START OF SHORT DELAY SUBROUTINE
 ;-----------------------------
Ms0_5dly: movlw 5;move the required loop number into
 movwf varmscount;varmscount
 ;
Ms05loop: nop;
 decfsz varmscount,f ;
 goto ms05loop;
 ;
 nop;
 nop;
 nop;
 ;
 return;END OF SHORT DELAY SUBROUTINE
 ;=============================
 ;START OF BPM RATE SUBROUTINE
 ;----------------------------
Chk_bpm: bcf t1con,tmr1on;Stop timer
 ;Clear flags
 bcf bpm_flags,lt85;
 bcf bpm_flags,mt85;
 bcf bpm_flags,mt120;
 ;Check timer and set flags
 ;21ms = 120 bpm
 ;29ms = 85 bpm
 ;
 movlw 20;?<20ms since last clock
 subwf tmr1h,w;
 btfss status,c;
 goto bpm_mt_120;
 ;
 movlw 30;?>20ms but <30ms since last clock
 subwf tmr1h,w;
 btfss status,c;
 goto bpm_mt_85;
 ;must be >30ms so bpm<85
 ;set bpm rate flag
 bsf bpm_flags,lt85;
 goto strt_tmr;
Bpm_mt_85: ;
 ;120>bpm>85bpm - set bpm rate flag
 bsf bpm_flags,mt85;
 goto strt_tmr;
 ;
 ;
Bpm_mt_120: ;bpm>120 - set bpm rate flag
 bsf bpm_flags,mt120;
 goto strt_tmr;
 ;
 ;Re-start timer
 ;
Strt_tmr: clrf tmr1l;
 clrf tmr1h;
 bsf t1con,tmr1on;
 ;
 return;END OF BPM RATE SUBROUTINE
 ;==========================
 ;START OF STRAIGHT/TRIPLET TIME S-R
 ;----------------------------------
Time_4_3: ;
 bcf bpm_flags,trplt;
 btfss porta,ra4;
 bsf bpm_flags,trplt;
 ;
 return;END OF STRAIGHT/TRIPLET TIME S-R
 ;================================
 ;END OF SUB-ROUTINES
 ;===================
 end;
 ;======================================
 ;======================================
