; Program 9
; Test bsc intcon, gie with external rb0 interrupt


       list    p=16F84,r=dec
       __config        h'3FF3'

; Equates for registers

       include p16f84.inc
; Macros

#define BANK0   BCF 0x03,5
#define BANK1   BSF 0x03,5

;#define DEBUG
#define INTTMR 201     ; sets interrupt rate   

; Data locations

SAVEW:  equ    0x20    ; preserve W during interrupts
SAVES:  equ    0x21    ; preserve STATUS during interrupts
COUNTL: equ    0x22    ; count of timer interrupts - low byte
COUNTH: equ    0x23    ; count of timer interrupts - high byte
LASTL: equ     0x24    ; last count low byte
LASTH: equ     0x25    ; last count high byte
ISRCL: equ     0x26    ; ISR's count - low byte
ISRCH: equ     0x27    ; ISR's count - high byte
LOOPCT: equ     0x28    ; used to flash the led periodically

; code
       org     0
       goto    init
        org    4
        goto   ISR             ; Interrupt vector
        org    5

; initialise PIC

init:   clrf PORTA             ; initialise all port outputs to zero
        clrf PORTB
       BANK1
       clrf    TRISA           ; RA0 - RA4 all outputs
       movlw   b'10000000'     ; RB7 input, rest outputs
       movwf   TRISB
       movlw   b'00000000'     ; enable PORTB pullups, PSA to TMR, prescale /2
       movwf   OPTION_REG
       BANK0

; data initialisation

       clrf    COUNTL          ; zero interrupt counters
       clrf    COUNTH
       clrf    LASTH           ; zero last counts
       clrf    LASTL
       clrf    ISRCL           ; zero ISR's counts
       clrf    ISRCH
       clrf    LOOPCT          ; main loop counter

; interrupt setup

        bsf     INTCON, INTE    ; enable INTF
        bsf     INTCON, GIE     ; enable global interrupts

; main loop

main:  
       bcf     INTCON, GIE
       movf    ISRCL,W         ; copy ISR low byte counter
       movwf   COUNTL
       movf    ISRCH,W         ; copy ISR high byte counter
       bsf     INTCON, GIE
       movwf   COUNTH
;#ifdef DEBUG
       movlw   4
       xorwf   PORTA,F         ; toggle RA2
;#endif

; subtract last counter value from this counter value
; check that the result is positive or zero (produces no borrow)

       movf    LASTL,W         ; load last counter low byte into W
       subwf   COUNTL,W        ; subtract current low byte
       movf    LASTH,W         ; load last counter high byte into W
       btfss   STATUS,C        ; C set if last subtraction did not borrow
       addlw   1               ; C clear so add 1 to W for the borrow
       movf    COUNTH,F        ; test if high byte is zero
       btfss   STATUS,Z        
       goto    A2              ; Z clear so high byte not zero
       movf    LASTH,F         ; COUNTH is zero, so test if LASTH is zero
       btfss   STATUS,Z        ; if it's not, H byte must have wrapped
       goto    A5              ; Z clear so LASTH not zero - skip the check

A2:    subwf   COUNTH,W        ; subtract LASTH from COUNTH
       btfss   STATUS,C        ; C set if there was no borrow, so OK
       goto    FAIL            ; C clear so an error has occurred
       
A5:    movf    COUNTL,W        ; copy this counter to last counter
       movwf   LASTL
       movf    COUNTH,W
       movwf   LASTH
       incf    LOOPCT,F        ; bump the main loop counter
       btfss   STATUS,Z        ; skip if it has wrapped to zero
       goto    main            ; else repeat main loop

; every 256 times round flash the led briefly

A1:    bsf     PORTA,0         ; turn led on
A3:    incf    LOOPCT,F        ; bump the counter
       btfss   STATUS,Z        ; till it wraps to zero again
       goto    A3
       bcf     PORTA,0         ; then turn off the led
       goto    main            ; and resume

; check has failed - put on the led and loopstop

FAIL:  bsf     PORTA,0
STOP:  goto    STOP

; Interrupt service routine

ISR:    movwf   SAVEW           ; save W 
       swapf   STATUS,W
       movwf   SAVES           ; save STATUS
       BANK0                   ; ensure bank 0 set
;#ifdef DEBUG
       movlw   2               ; toggle RA1
       xorwf   PORTA,F
;#endif
        btfss   INTCON, INTF    ; test INTF
       goto    POP

; there is an INTF interrupt
       
       incf    ISRCL,F         ; bump interrupt count low byte
       btfsc   STATUS,Z        ; test if it wrapped to zero - skip if not
       incf    ISRCH,F         ; bump high byte if low byte wrapped
       bcf     INTCON, INTF    ; clear the interrupt
POP:    swapf   SAVES,W                ; restore STATUS
       movwf   STATUS
       swapf   SAVEW,F         ; restore W
       swapf   SAVEW,W
       retfie                  ; exit ISR

        end                    ; of program
