; Program 5
; Flash a led at about 1Hz
; Interrupts on RB0

	list	p=16F84,r=dec
	__config	h'3FF3'

; Macros

#define BANK0   BCF 0x03,5
#define BANK1   BSF 0x03,5

#define SPEED	5	; controls led flash rate

; Equates for registers

	include	p16f84.inc

; Data locations

SAVEW:	equ	0x20	; preserve W during interrupts
SAVES:	equ	0x21	; preserve STATUS during interrupts
COUNT:	equ	0x22	; count of timer ticks
ICOUNT	equ	0x23	; number of interrupts

; code
	org	0
	goto	init
	org	4
	goto	ISR		; Interrupt vector
	org	5

; initialise PIC

init:	clrf	PORTA		; initialise all port outputs to zero
	clrf	PORTB
	BANK1
	clrf	TRISA		; RA0 - RA4 all outputs
 	movlw	b'00000001'	; RB0 input, rest outputs
	movwf	TRISB
	movlw	b'00000111'	; enable PORTB pullups, PSA to TMR, prescale /256
	movwf	OPTION_REG
	BANK0

; interrupt setup

	bsf	INTCON,INTE	; enable INTF interrupt
	bsf	INTCON,GIE	; enable global interrupts

; data initialisation

	bsf	PORTA,0		; turn on the led

; main loop

main:	clrf	TMR0		; clear internal clock count-up
	clrf	COUNT		; clear ticks count
A2:	bcf	INTCON,T0IF	; clear the TMR0 wrapped flag
A1:	btfss	INTCON,T0IF	; has TMR0 wrapped yet?
	goto	A1		; no, loop till it has
	incf	COUNT,F		; bump count of wraps
	movlw	SPEED		; about 10 bumps/sec at 2MHz clock
	xorwf	COUNT,W		; sets Z if COUNT = W 
	btfss	STATUS,Z	; test Z
	goto	A2		; Z not set so COUNT != SPEED
	movlw	1		; wraps COUNT = SPEED so
	xorwf	PORTA,F		; toggle RA0
	goto	main		; and repeat main loop

; Interrupt service routine

ISR:	movwf	SAVEW		; save W 
	swapf	STATUS,W
	movwf	SAVES		; save STATUS
	BANK0			; ensure bank 0 set
	btfss	INTCON,INTF	; test INTF
	goto	POP		; not an RB0 interrupt

; there is an INTF interrupt
	
	nop			; nothing to do for this demo!
CLR:	bcf	INTCON,INTF	; clear the interrupt
	incf	ICOUNT,F	; bump count of interrupts
POP:    swapf   SAVES,W         ; restore STATUS
	movwf	STATUS
	swapf	SAVEW,F		; restore W
	swapf	SAVEW,W
	retfie			; exit ISR

        end			; of program
