;  RC5 Infra-red decoding program.
;  Written by Roger Thomas.

	list p=16C84
	__config H'3FF9'

RTCC	EQU H'01' ; timer
STATUS	EQU H'03' ; register
C	EQU H'00' ; carry flag
Z	EQU H'02' ; zero flag
PORTB	EQU H'06'
RB0	EQU H'00' ; IR input
RB1	EQU H'01' ; led
RB2	EQU H'02' ; led
INTCON	EQU H'0B' ; register
OPT	EQU H'01' ; register
IRQ_W	EQU H'16' ; interrupt
IRQ_S	EQU H'17' ; interrupt
IRQ_STK	EQU H'18' ; interrupt
TIMERVAL	EQU H'19' ; timer value
BITVALUE	EQU H'1A' ; value of bit
TEMP0	EQU H'1B'
TEMP1	EQU H'1C'
TEMP2	EQU H'1D'
TEMP3	EQU H'1E'
THISBIT	EQU H'1F' ; current value
CBINARY	EQU H'20' ; command
BITS	EQU H'21' ; bits count
XVALUE1	EQU H'22' ; timer value
XVALUE2	EQU H'23' ; timer value
XVALUE3	EQU H'24' ; timer value
FLAG	EQU H'25' ; boolean byte
CONV	EQU H'01' ; convert flag
LASTBIT	EQU H'02' ; last bit flag
EXTRA0	EQU H'03' ; insert 0 flag

	ORG 0
	goto START

	ORG 4   ; interrupt
	MOVWF	IRQ_W
	SWAPF	STATUS,W
	BCF	STATUS,5
	MOVWF	IRQ_S
	MOVF	TEMP2,W
	MOVWF	IRQ_STK
	CALL	INTERRUPT
	MOVF	IRQ_STK,W
	MOVWF	TEMP2
	SWAPF	IRQ_S,W
	MOVWF	STATUS
	SWAPF	IRQ_W,F
	SWAPF	IRQ_W,W
	RETFIE

START	BSF	STATUS,5  ; page 1
	BSF	PORTB,RB0 ; input
	BCF	PORTB,RB1 ; output
	BCF	PORTB,RB2 ; output
	BCF	STATUS,5  ; page 0
	BCF	PORTB,RB1 ; off
	BCF	PORTB,RB2 ; off
	CLRF	FLAG      ; =0
	CLRF	BITS      ; =0
	BSF	STATUS,5  ; page 1
	BCF	OPT,5     ; clock as timer source
	BSF	OPT,0     ; PS0 divide by 16
	BSF	OPT,1     ; PS1
	BCF	OPT,2     ; PS2
	BCF	OPT,3     ; PSA
	BCF	OPT,6     ; interrupt on falling edge 
	BCF	STATUS,5  ; page 0
	BSF	INTCON,4  ; RB0 as interrupt source
	BSF	INTCON,7  ; enable interrupt

LOOP	BTFSS	FLAG,CONV ; data flag
	GOTO	LOOP1
	CALL	CONVRTCC  ; data
	GOTO	LOOP
LOOP1	BTFSS	INTCON,2  ; timer overflow ?
	GOTO	LOOP
	BCF	INTCON,2  ; clear overflow
	CLRF	BITS      ; = 0
	CALL	LEDDISPLAY
	GOTO	LOOP

INTERRUPT
	MOVF	RTCC,W   ; read timer
	MOVWF	TIMERVAL ; timerval = RTCC
	CLRF	RTCC     ; zero 8 bit timer
	BCF	INTCON,1 ; RB0 clear flag
	BSF	FLAG,CONV; set data flag
	RETURN

CONVRTCC
	BCF	FLAG,CONV ; clear flag
	INCF	BITS,F    ; bits + 1
; if bits = 2 
	MOVF	BITS,W
	SUBLW	H'02'
	MOVLW	H'00'
	BTFSC	STATUS,Z
	ADDLW	H'FF'
	ANDLW	H'FF'
	BTFSC	STATUS,Z
	GOTO	BITS3
	MOVF	TIMERVAL,W
	MOVWF	TEMP0
	MOVF	TIMERVAL,W
	MOVWF	TEMP1
	BCF	STATUS,C
	RRF	TEMP0,F ; div 2 
	MOVF	TEMP0,W
	MOVWF	XVALUE1 ; .5X
	BCF	STATUS,C
	RRF	TEMP0,F ; div 2
	MOVF	TEMP1,W
	ADDWF	TEMP0,W
	MOVWF	XVALUE2 ; 1.25X
	BCF	STATUS,C
	RLF	TEMP0,F ; x 2   
	MOVF	XVALUE2,W
	ADDWF	TEMP0,W
	MOVWF	XVALUE3 ; 1.75X
	CLRF	CBINARY
	BSF	FLAG,LASTBIT
	MOVLW	H'20' ; 32
	MOVWF	BITVALUE
	BCF	FLAG,EXTRA0
; if bits >= 3 
BITS3	MOVF	BITS,W
	MOVWF	TEMP2
	MOVLW	H'03'
	SUBWF	TEMP2,W
	CLRW
	BTFSC	STATUS,C
	ADDLW	H'FF'
	BTFSC	STATUS,Z
	GOTO	ENDBIT	
; if timerval > 0.5 and < 1.25  
	MOVF	TIMERVAL,W
	SUBWF	XVALUE1,W
	CLRW
	BTFSS	STATUS,C
	ADDLW	H'FF'
	MOVWF	TEMP3
	MOVF	TIMERVAL,W
	MOVWF	TEMP2
	MOVF	XVALUE2,W
	SUBWF	TEMP2,W
	CLRW
	BTFSS	STATUS,C
	ADDLW	H'FF'
	ANDWF	TEMP3,W
	BTFSC	STATUS,Z
	GOTO	TV125
; if lastbit = 0 
	BTFSC	FLAG,LASTBIT
	GOTO	ADD1
	MOVLW	H'00'
	MOVWF	THISBIT
	CALL	ADDBINARY
	GOTO	TV125	
ADD1	MOVLW	H'01' ; 1
	MOVWF	THISBIT
	CALL	ADDBINARY
; if timer value > .5 and < 1.25
TV125	MOVF	TIMERVAL,W
	MOVWF	TEMP2
	MOVF	XVALUE2,W
	SUBWF	TEMP2,W
	CLRW
	BTFSC	STATUS,C
	ADDLW	H'FF'
	MOVWF	TEMP3
	MOVF	TIMERVAL,W
	MOVWF	TEMP2
	MOVF	XVALUE3,W
	SUBWF	TEMP2,W
	CLRW
	BTFSS	STATUS,C
	ADDLW	H'FF'
	ANDWF	TEMP3,W
	BTFSC	STATUS,Z
	GOTO	TV175
; if extra0 = 1  
	BTFSS	FLAG,EXTRA0
	GOTO	ADD2
	MOVLW	H'00'
	MOVWF	THISBIT
	CALL	ADDBINARY
	BCF	FLAG,LASTBIT
	BCF	FLAG,EXTRA0
	INCF	BITS,F
	GOTO	BIT0
ADD2	BSF	FLAG,EXTRA0
; if lastbit = 0 
BIT0	BTFSC	FLAG,LASTBIT
	GOTO	ADD3
	MOVLW	H'01'
	MOVWF	THISBIT
	CALL	ADDBINARY
	BSF	FLAG,LASTBIT
	GOTO	TV175
ADD3	MOVLW	H'00'
	MOVWF	THISBIT
	CALL	ADDBINARY
	BCF	FLAG,LASTBIT
; if timer value > 1.75 
TV175	MOVF	TIMERVAL,W
	MOVWF	TEMP2
	MOVF	XVALUE3,W
	SUBWF	TEMP2,W
	CLRW
	BTFSC	STATUS,C
	ADDLW	H'FF'
	BTFSC	STATUS,Z
	GOTO	ENDBIT	
	MOVLW	H'00'
	MOVWF	THISBIT ; =0
	CALL	ADDBINARY
	INCF	BITS,F
	MOVLW	H'01'
	MOVWF	THISBIT ; =1
	CALL	ADDBINARY
	BSF	FLAG,LASTBIT
ENDBIT	RETURN

ADDBINARY
; if bits > 8 (command)
	MOVF	BITS,W
	SUBLW	H'08'
	CLRW
	BTFSS	STATUS,C
	ADDLW	H'FF'
	BTFSC	STATUS,Z
	GOTO	ENDADD
; if thisbit = 0
	MOVF	THISBIT,W
	SUBLW	H'00'
	MOVLW	H'00'
	BTFSC	STATUS,Z
	ADDLW	H'FF'
	ANDLW	H'FF'
	BTFSC	STATUS,Z
	GOTO	ADDBIN
	BCF	STATUS,C
	RRF	BITVALUE,F ; div 2
	GOTO	ENDADD
; cbinary = cbinary OR bitvalue
ADDBIN	MOVF	CBINARY,W
	IORWF	BITVALUE,W
	MOVWF	CBINARY
	BCF	STATUS,C
	RRF	BITVALUE,F ; div2
ENDADD	RETURN

LEDDISPLAY
; if cbinary = 1
	MOVF	CBINARY,W
	SUBLW	H'01' ; 1
	MOVLW	H'00'
	BTFSC	STATUS,Z
	ADDLW	H'FF'
	ANDLW	H'FF'
	BTFSC	STATUS,Z
	GOTO	CBIN2
	BSF	PORTB,RB1 ; on 
	BCF	PORTB,RB2 ; off
; if cbinary = 2
CBIN2	MOVF	CBINARY,W
	SUBLW	H'02' ; 2
	MOVLW	H'00'
	BTFSC	STATUS,Z
	ADDLW	H'FF'
	ANDLW	H'FF'
	BTFSC	STATUS,Z
	GOTO	CBIN3
	BCF	PORTB,RB1 ; off
	BSF	PORTB,RB2 ; on
; if cbinary = 3 
CBIN3	MOVF	CBINARY,W
	SUBLW	H'03' ; 3
	MOVLW	H'00'
	BTFSC	STATUS,Z
	ADDLW	H'FF'
	ANDLW	H'FF'
	BTFSC	STATUS,Z
	GOTO	DONE
	BSF	PORTB,RB1 ; on
	BSF	PORTB,RB2 ; on 
DONE	RETURN

	END
