VERSION 5.00
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Begin VB.Form frmTestIC 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Test IC"
   ClientHeight    =   2700
   ClientLeft      =   3930
   ClientTop       =   3480
   ClientWidth     =   4140
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   HelpContextID   =   900
   Icon            =   "frmTestIC.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2700
   ScaleWidth      =   4140
   Begin VB.Timer tmrStart 
      Enabled         =   0   'False
      Interval        =   100
      Left            =   1890
      Top             =   135
   End
   Begin MSCommLib.MSComm MSComm1 
      Left            =   30
      Top             =   120
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   -1  'True
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Sto&p"
      Enabled         =   0   'False
      Height          =   330
      Left            =   2535
      TabIndex        =   1
      Top             =   75
      Width           =   1155
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "&Start"
      Height          =   330
      Left            =   495
      TabIndex        =   0
      Top             =   75
      Width           =   1155
   End
   Begin VB.Frame Frame3 
      Caption         =   "Test Mode:"
      Height          =   1350
      Left            =   2265
      TabIndex        =   14
      Top             =   495
      Width           =   1845
      Begin VB.CheckBox chkStep 
         Caption         =   "Single Step"
         Height          =   195
         HelpContextID   =   900
         Left            =   105
         TabIndex        =   8
         Top             =   1065
         Width           =   1425
      End
      Begin VB.OptionButton optTestMode 
         Caption         =   "Continuous  test"
         Height          =   195
         HelpContextID   =   900
         Index           =   1
         Left            =   90
         TabIndex        =   6
         Top             =   510
         Width           =   1635
      End
      Begin VB.OptionButton optTestMode 
         Caption         =   "Single test"
         Height          =   195
         HelpContextID   =   900
         Index           =   0
         Left            =   90
         TabIndex        =   5
         Top             =   240
         Value           =   -1  'True
         Width           =   1515
      End
      Begin VB.CheckBox chkAbortOnError 
         Caption         =   "Abort on error"
         Height          =   225
         HelpContextID   =   900
         Left            =   105
         TabIndex        =   7
         Top             =   765
         Value           =   1  'Checked
         Width           =   1365
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Test Statistics:"
      Height          =   840
      Left            =   30
      TabIndex        =   10
      Top             =   1860
      Width           =   4080
      Begin VB.Label lblCount 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0"
         Height          =   270
         Index           =   3
         Left            =   3150
         TabIndex        =   19
         Top             =   510
         Width           =   750
      End
      Begin VB.Label lblCount 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0"
         Height          =   270
         Index           =   2
         Left            =   2145
         TabIndex        =   18
         Top             =   510
         Width           =   750
      End
      Begin VB.Label lblCount 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0"
         Height          =   270
         Index           =   1
         Left            =   1140
         TabIndex        =   17
         Top             =   510
         Width           =   750
      End
      Begin VB.Label lblCount 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0"
         Height          =   270
         Index           =   0
         Left            =   180
         TabIndex        =   16
         Top             =   510
         Width           =   750
      End
      Begin VB.Label Label4 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "Fail:"
         Height          =   195
         Left            =   3150
         TabIndex        =   15
         Top             =   300
         Width           =   300
      End
      Begin VB.Label Label3 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "Pass:"
         Height          =   195
         Left            =   2145
         TabIndex        =   13
         Top             =   285
         Width           =   390
      End
      Begin VB.Label Label2 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "Seq:"
         Height          =   195
         Left            =   1140
         TabIndex        =   12
         Top             =   285
         Width           =   330
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "Test Pass:"
         Height          =   195
         Left            =   180
         TabIndex        =   11
         Top             =   270
         Width           =   750
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Performance:"
      Height          =   1350
      Left            =   30
      TabIndex        =   9
      Top             =   495
      Width           =   2130
      Begin VB.CheckBox chkUpdate 
         Caption         =   "Real-time Plot"
         Height          =   195
         HelpContextID   =   900
         Index           =   2
         Left            =   330
         TabIndex        =   4
         ToolTipText     =   "Plot updates to the Logic Trace display real-time"
         Top             =   765
         Width           =   1305
      End
      Begin VB.CheckBox chkUpdate 
         Caption         =   "Update ""Logic Trace"""
         Height          =   270
         HelpContextID   =   900
         Index           =   1
         Left            =   90
         TabIndex        =   3
         ToolTipText     =   "Update the Logic Trace display"
         Top             =   480
         Width           =   1920
      End
      Begin VB.CheckBox chkUpdate 
         Caption         =   "Update ""Pin Display"""
         Height          =   225
         HelpContextID   =   900
         Index           =   0
         Left            =   90
         TabIndex        =   2
         ToolTipText     =   "Update the IC Pin Display"
         Top             =   240
         Width           =   1860
      End
   End
End
Attribute VB_Name = "frmTestIC"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private mbAbort                                 As Boolean
Private ComPort                                 As MSComm

Private Const Module_Name                       As String = "frmTestIC"
Private Sub chkAbortOnError_Click()

    SaveSetting App.Title, "TestIC", "AbortOnError", Format$(chkAbortOnError.Value)
    
End Sub

Private Sub chkUpdate_Click(Index As Integer)
    
    Dim F                           As Integer
    
    
    If chkUpdate(1).Value Then
        chkUpdate(2).Enabled = True
    Else
        chkUpdate(2).Enabled = False
    End If
        
    SaveSetting App.Title, "TestIC", "PerformanceDisplay" & Format$(Index), chkUpdate(Index).Value
    
End Sub

Private Sub cmdStart_Click()
    Dim bDone                           As Boolean
    Dim bFail                           As Boolean
    Dim bICHasFailed                    As Boolean
    Dim nReason                         As Integer
    Dim F                               As Integer
    Dim nSeq                            As Integer
    Dim nIcon                           As Integer
    Dim nReadCount                      As Integer
    Dim sngTimer                        As Single
    Dim sBuffer                         As String
    Dim sLine                           As String
    Dim sBinaryBuffer                   As String
    Dim sCurrentPinConfig               As String

    Const PROC_NAME                     As String = "cmdStart_Click"
    
    On Error GoTo ErrorHandler
    
    '
    ' Before we do anything, we need to check the power pins
    ' for this Test IC before we switch on the power.
    With gtypModel
        If .PinVSS <> gnPowerPins(0) Or .PinVDD <> gnPowerPins(1) Or gbOptions(0) Then
            ' we need to change power configuration
            Load frmPowerConnections
            frmPowerConnections.Description = .Description
            frmPowerConnections.Model = .Model
            frmPowerConnections.Pins = .NumPins
            
            Call frmPowerConnections.SetPowerPins(.NumPins, .PinVDD, .PinVSS)
            
            frmPowerConnections.Show vbModal
            
            If frmPowerConnections.mbCancel = True Then
                ' We need to abandon this
                Unload frmPowerConnections
                Unload Me
                Exit Sub
            Else
                Unload frmPowerConnections
            End If
        End If
                    
        gnPowerPins(0) = .PinVSS
        gnPowerPins(1) = .PinVDD
        
    End With
    
    
    cmdStart.Enabled = False
    cmdStop.Enabled = True
    mbAbort = False
    
    For F = 0 To lblCount.Count - 1
        lblCount(F).Caption = "0"
        lblCount(F).BackColor = &H8000000F
    Next F
    
    
    If chkUpdate(1).Value Then
        Load frmTrace
        frmTrace.Reset
    End If
    
    Load frmTestResults
    frmTestResults.Reset
    
    Set ComPort = MSComm1
    
    Call Device_OpenPort(ComPort) ' This often causes Datacomms Error on the PIC !
    
    '
    ' Make sure there nothing in the RX buffer
    Device_FlushBuffer ComPort
    
    '
    ' Send the device reset command
    LogEvent "Sending Tester 'Reset' Command...", 1, 0
    Device_Reset ComPort
    
    '
    ' Wait for Reply
    sngTimer = Timer
    sBuffer = Device_ReadBuffer(ComPort)
    If Right$(sBuffer, 8) = "Ready." & vbCrLf Then
        ' All ok
        LogEvent "Tester Reset Ok...", 1, 0
        
        ' Reset the PIC to the IC's base I/O configuration
        LogEvent "Base I/O configuration", 1, nSeq
        Device_SendConfigBits ComPort, "" ' Use the base configuration
        '
        ' Start the testing process
        LogEvent "Starting Test...", 11, 0
        nReadCount = 0
        
        Do
            LoadModel gsModelFileName
            lblCount(0).Caption = Format$(Val(lblCount(0).Caption) + 1) ' Update pass count
            Sleep 1
            
            With gtypModel
                ' Start the testing sequence
                For nSeq = 1 To .TestScript.Count
                    bFail = False
                    nReason = 0
                    lblCount(1).Caption = Format$(nSeq) ' Sequence step
                    DoEvents
                    
                    sLine = .TestScript("L" + Format$(nSeq))
                    
                    Select Case Left$(sLine, 1)
                    Case 0 ' Device Reset
                        LogEvent "Tester Reset", 1, nSeq
                        Device_Reset ComPort
                        '
                        ' Wait for Reply
                        sBuffer = Device_ReadBuffer(ComPort)
                        If Right$(sBuffer, 8) <> "Ready." & vbCrLf Then
                            nReason = 1
                        Else
                            ' Device reset ok
                            ' Reset the PIC to the IC's base I/O configuration
                            LogEvent "Base I/O configuration", 1, nSeq
                            Device_SendConfigBits ComPort, "" ' Use the base configuration
                            '
                            ' Wait for Reply
                            sBuffer = Device_ReadBuffer(ComPort)
                            If Right$(sBuffer, 5) <> "OK." & vbCrLf Then
                                nReason = 1
                            End If
                        End If
                        
                    Case 1 ' +5V On
                        LogEvent "Tester '+5V' On", 9, nSeq
                        Device_TestPowerOn ComPort
                        '
                        ' Wait for Reply
                        sBuffer = Device_ReadBuffer(ComPort)
                        If Right$(sBuffer, 5) <> "OK." & vbCrLf Then
                            nReason = 1
                        End If
                    
                    Case 2 ' Config
                        LogEvent "Set Config", 6, nSeq
                        Device_SendConfigBits ComPort, Mid$(sLine, 2)
                        '
                        ' Wait for Reply
                        sBuffer = Device_ReadBuffer(ComPort)
                        If Right$(sBuffer, 5) <> "OK." & vbCrLf Then
                            nReason = 1
                        End If
                        '
                        ' Need to update the model pin usage details
                        For F = 1 To MAX_PINS
                            If .Pin(F).Usage < 2 Then
                                Select Case Val(Mid$(sLine, F + 1, 1))
                                Case "0"
                                    .Pin(F).Usage = 0
                                Case "1"
                                    .Pin(F).Usage = 1
                                    
                                End Select
                            End If
                        Next F
                        
                        
                    Case 3 ' Send Data
                        LogEvent "Send:" & Mid$(sLine, 2), 5, nSeq
                        Device_SendDataBits ComPort, Mid$(sLine, 2)
                        '
                        ' Wait for Reply
                        sBuffer = Device_ReadBuffer(ComPort)
                        If Right$(sBuffer, 5) <> "OK." & vbCrLf Then
                            nReason = 1
                        End If
                    
                    
                    Case 4 ' Read Data
                        sLine = Replace(Mid$(sLine, 2), "2", "X") ' Replace '2' with X AND drop off the first byte with is the line type code
                        sLine = Replace(sLine, "5", "X")
                        LogEvent " Exp:" & sLine, 5, nSeq
                        Device_ReadStatus ComPort
                        '
                        ' Wait for Reply
                        sBuffer = Device_ReadBuffer(ComPort)
                        If Right$(sBuffer, 5) <> "OK." & vbCrLf Then
                            nReason = 1
                        Else
                            ' Valid response received.
                            ' Check to see what came back AND if it's what we expected
                            ' Output details of what was returned
                            bFail = Not CompareResults(sLine, sBuffer, .NumPins, sBinaryBuffer)
                            LogEvent "Read:" & sBinaryBuffer & "  (" & Format$(nReadCount) & ")", 12, 0
                            nReadCount = nReadCount + 1
                            If bFail = True Then
                                LogEvent "IC Failed Test...", 7, 0
                                bICHasFailed = True
                            End If
                            '
                            ' Display the response details on any monitor windows
                            If chkUpdate(0).Value Then
                                ' Update the IC pin package
                                frmICView.UpdateLogicLevels sBinaryBuffer
                            End If
                            If chkUpdate(1).Value Then
                                ' Update the trace display
                                frmTrace.AddEntry sBinaryBuffer, Abs(chkUpdate(2).Value), sLine
                            End If
                                                       
                            If chkStep.Value Then
                                If MsgBox("Single-step mode activated" & vbCrLf & vbCrLf & "Press <CR> to continue", vbOKCancel + vbDefaultButton1 + vbInformation, "Single-step Mode") = vbCancel Then
                                    ' Terminate single-step
                                    bFail = True
                                    nReason = 3
                                    Exit For
                                End If
                            End If
                        End If
                    
                    End Select
                    
                    If bFail = True And chkAbortOnError.Value Then
                        ' No point carrying on with this test
                        Exit For
                    End If
                    
                Next nSeq
            End With
            ' End of sequence test
               
            If Val(lblCount(0).Caption) >= Val(gsSettings(0)) Then
                ' Maximum number of allowed pass's reached
                bDone = True
            End If
            
            If optTestMode(0).Value = True Then
                bDone = True ' Single pass only
            End If
            
            If bFail = True Or bICHasFailed = True Then
                ' The IC failed during testing
                lblCount(3).Caption = Format$(Val(lblCount(3).Caption) + 1) ' Increment fail
                lblCount(3).BackColor = glColors(7)
                
                ' Do we abort or start the test again
                If chkAbortOnError.Value Or bDone Then
                    ' Abort the testing
                    nReason = 2
                End If
            Else
                ' The test didn't fail
                lblCount(2).Caption = Format$(Val(lblCount(2).Caption) + 1) ' Increment pass
                lblCount(2).BackColor = glColors(6)
            End If
                        
        Loop Until bDone = True Or nReason Or mbAbort = True ' Do we test the IC again ?
        
        
        If bDone = True And nReason = 0 And bICHasFailed = False Then
            ' Testing complete, no errors found
            LogEvent "IC Passed All Tests...", 8, 0
            LogEvent "Testing Complete...", 4, 0
        
        Else
            ' We failed for some reason
            Select Case nReason
            Case 0 ' IC Failed at least one test
            
            Case 1 ' Invalid response from hardware
                LogEvent "Invalid Response Received From Tester...", 2, 0
                
            Case 2 ' IC failed a test
                ' Nothing to do here - user already notified
            
            Case 3 ' User terminated Single-step testing
            
            Case Else
                LogEvent "Unknown Failure Reason (" & Format$(nReason) & ")", 10, 0
                
            End Select
            LogEvent "Testing Aborted...", 3, 0
        End If
                                                
    Else
        LogEvent "Tester failed to respond to 'Reset' command...", 2, 0
        LogEvent "Testing Aborted...", 3, 0
    End If
    
    LogEvent "Elapsed time = " & Format$(Timer - sngTimer) & ", Secs", 11, 0
    
    ' Make sure that the trace is upto date if required
    If chkUpdate(1).Value Then
        ' Update the trace display
        If chkUpdate(2).Value = False Then
            frmTrace.RefreshDetails 0 ' Refresh details and display from sample 0
        End If
    End If
    
    If chkStep.Value Then
        MsgBox "Single-step mode activated" & vbCrLf & "Sequence Completed!" & vbCrLf & vbCrLf & "Press <CR> to continue", vbOKOnly + vbInformation, "Single-step Mode"
    End If
    
    Device_Reset ComPort
    
    Device_ClosePort ComPort
    
    cmdStop.Enabled = False
    cmdStart.Enabled = True
    
    'frmTestResults.Show
    
    Exit Sub
        
ErrorHandler:
    ErrorRoutine Module_Name, PROC_NAME, Err
End Sub

Private Sub cmdStop_Click()

    mbAbort = True
    
End Sub


Private Sub Form_Load()

    Dim X                               As Integer
    
    Const PROC_NAME                     As String = "Form_Load"
    
    On Error GoTo ErrorHandler
    
    '
    ' Set always on-top
    
    On Error GoTo ErrorHandler
    
    Unload frmLogicAnalyser
    Unload frmICView
    
    X = GetSetting(App.Title, "TestIC", "TestMode", "0")
    optTestMode(X).Value = True
    
    chkAbortOnError.Value = GetSetting(App.Title, "TestIC", "AbortOnError", "1")
    
    For X = 0 To chkUpdate.Count - 1
        chkUpdate(X).Value = GetSetting(App.Title, "TestIC", "PerformanceDisplay" & Format$(X), "1")
    Next X
    
    If chkUpdate(1).Value Then
        chkUpdate(2).Enabled = True
    Else
        chkUpdate(2).Enabled = False
    End If
    
    RecoverFormLoadPosition Me, True
    
    Call SetWindowPos(Me.hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE Or SWP_NOMOVE)
    
    Exit Sub
    
ErrorHandler:
    ErrorRoutine Module_Name, PROC_NAME, Err
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)

    If Me.WindowState <> vbMinimized Then
        SaveSetting App.Title, "FormPositions", Me.Name, Format$(Me.Width) & "," & Format$(Me.Height) & "," & Format$(Me.Top) & "," & Format$(Me.Left)
    End If
    
End Sub


Private Sub optTestMode_Click(Index As Integer)

    Dim F                       As Integer
    
    For F = 0 To optTestMode.Count
        If optTestMode(F).Value Then
            SaveSetting App.Title, "TestIC", "TestMode", Format$(F)
            Exit For
        End If
    Next F
    
End Sub


Private Sub tmrStart_Timer()

    tmrStart.Enabled = False
    Call cmdStart_Click
    
End Sub


