VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.MDIForm frmMDIMain 
   BackColor       =   &H8000000C&
   Caption         =   "Digital IC Tester"
   ClientHeight    =   5310
   ClientLeft      =   855
   ClientTop       =   2940
   ClientWidth     =   9195
   HelpContextID   =   1
   Icon            =   "mdiMain.frx":0000
   LinkTopic       =   "MDIForm1"
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   630
      Top             =   2265
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin MSComctlLib.ImageList ImageList1 
      Left            =   270
      Top             =   1095
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   12632256
      _Version        =   393216
      BeginProperty Images {2C247F25-8591-11D1-B16A-00C0F0283628} 
         NumListImages   =   15
         BeginProperty ListImage1 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":0442
            Key             =   ""
         EndProperty
         BeginProperty ListImage2 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":0554
            Key             =   ""
         EndProperty
         BeginProperty ListImage3 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":0666
            Key             =   ""
         EndProperty
         BeginProperty ListImage4 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":0778
            Key             =   ""
         EndProperty
         BeginProperty ListImage5 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":088A
            Key             =   ""
         EndProperty
         BeginProperty ListImage6 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":099C
            Key             =   ""
         EndProperty
         BeginProperty ListImage7 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":0AAE
            Key             =   ""
         EndProperty
         BeginProperty ListImage8 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":0BC0
            Key             =   ""
         EndProperty
         BeginProperty ListImage9 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":1012
            Key             =   ""
         EndProperty
         BeginProperty ListImage10 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":116C
            Key             =   ""
         EndProperty
         BeginProperty ListImage11 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":12C6
            Key             =   ""
         EndProperty
         BeginProperty ListImage12 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":1718
            Key             =   ""
         EndProperty
         BeginProperty ListImage13 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":1B6A
            Key             =   ""
         EndProperty
         BeginProperty ListImage14 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":1CC4
            Key             =   ""
         EndProperty
         BeginProperty ListImage15 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":2116
            Key             =   ""
         EndProperty
      EndProperty
   End
   Begin MSComctlLib.StatusBar StatusBar 
      Align           =   2  'Align Bottom
      Height          =   360
      Left            =   0
      TabIndex        =   0
      Top             =   4950
      Width           =   9195
      _ExtentX        =   16219
      _ExtentY        =   635
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   4
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   1
            Object.Width           =   12808
            MinWidth        =   2
         EndProperty
         BeginProperty Panel2 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Alignment       =   1
            AutoSize        =   2
            Object.Width           =   159
            MinWidth        =   2
         EndProperty
         BeginProperty Panel3 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Alignment       =   1
            AutoSize        =   2
            Object.Width           =   159
            MinWidth        =   2
         EndProperty
         BeginProperty Panel4 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
         EndProperty
      EndProperty
   End
   Begin MSComctlLib.Toolbar Toolbar1 
      Align           =   1  'Align Top
      Height          =   420
      Left            =   0
      TabIndex        =   1
      Top             =   0
      Width           =   9195
      _ExtentX        =   16219
      _ExtentY        =   741
      ButtonWidth     =   609
      ButtonHeight    =   582
      Appearance      =   1
      ImageList       =   "ImageList1"
      _Version        =   393216
      BeginProperty Buttons {66833FE8-8583-11D1-B16A-00C0F0283628} 
         NumButtons      =   14
         BeginProperty Button1 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "LOAD"
            Object.ToolTipText     =   "Load IC Model definition file"
            ImageIndex      =   5
         EndProperty
         BeginProperty Button2 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Style           =   3
         EndProperty
         BeginProperty Button3 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "TRACE"
            Object.ToolTipText     =   "View logic trace screen"
            ImageIndex      =   13
         EndProperty
         BeginProperty Button4 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "RUN"
            Object.ToolTipText     =   "Start IC device test"
            ImageIndex      =   9
         EndProperty
         BeginProperty Button5 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Style           =   3
         EndProperty
         BeginProperty Button6 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "LOGIC"
            Object.ToolTipText     =   "Logic Analyser"
            ImageIndex      =   15
         EndProperty
         BeginProperty Button7 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Style           =   3
         EndProperty
         BeginProperty Button8 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "KEY"
            Object.ToolTipText     =   "Display trace 'colour key' chart"
            ImageIndex      =   14
            Style           =   1
         EndProperty
         BeginProperty Button9 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Style           =   3
         EndProperty
         BeginProperty Button10 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "BEEP"
            Object.ToolTipText     =   "Enable additional program 'beeps'"
            ImageIndex      =   8
            Style           =   1
         EndProperty
         BeginProperty Button11 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "CONF"
            Object.ToolTipText     =   "Configure application settings"
            ImageIndex      =   12
         EndProperty
         BeginProperty Button12 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Enabled         =   0   'False
            Key             =   "MODEL"
            Object.ToolTipText     =   "Amend the current model definition parameters"
            ImageIndex      =   10
         EndProperty
         BeginProperty Button13 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Style           =   3
         EndProperty
         BeginProperty Button14 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "HELP"
            ImageIndex      =   2
         EndProperty
      EndProperty
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFile_LoadModel 
         Caption         =   "&Load IC Profile"
      End
      Begin VB.Menu mnuFile_Sep2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFile_LastUsed 
         Caption         =   ""
         Index           =   0
         Visible         =   0   'False
      End
      Begin VB.Menu mnuFile_Sep3 
         Caption         =   "-"
         Visible         =   0   'False
      End
      Begin VB.Menu mnuFile_Exit 
         Caption         =   "&Exit"
      End
   End
   Begin VB.Menu mnuView 
      Caption         =   "&View"
      Begin VB.Menu mnuView_Power 
         Caption         =   "IC &Power Requirements"
         Enabled         =   0   'False
      End
      Begin VB.Menu mnuView_Sep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuView_ICPackage 
         Caption         =   "&IC Package"
         Enabled         =   0   'False
      End
      Begin VB.Menu mnuView_LogicTrace 
         Caption         =   "&Logic Trace"
      End
      Begin VB.Menu mnuView_Sep2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuView_TestResults 
         Caption         =   "&Test Results"
      End
   End
   Begin VB.Menu mnuICTest 
      Caption         =   "&IC Test"
      Begin VB.Menu mnuICTest_Specified 
         Caption         =   "&Test Specified IC"
      End
   End
   Begin VB.Menu mnuTools 
      Caption         =   "&Tools"
      Begin VB.Menu mnuTools_Config 
         Caption         =   "&Configuration"
      End
      Begin VB.Menu mnuTools_Sep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuTools_CreateModel 
         Caption         =   "Create IC &Profile"
      End
      Begin VB.Menu mnuTools_AmendModel 
         Caption         =   "&Modify Current IC Profile"
         Enabled         =   0   'False
      End
      Begin VB.Menu mnuTools_Sep2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuTools_LogicAnalyser 
         Caption         =   "&Logic Analyser"
      End
      Begin VB.Menu mnuTools_Sep3 
         Caption         =   "-"
      End
      Begin VB.Menu mnuTools_ConfirmInterface 
         Caption         =   "Confirm Communications &Interface"
      End
      Begin VB.Menu mnuTools_LowLevelTest 
         Caption         =   "Low Level Interface &Test"
      End
   End
   Begin VB.Menu mnuWindow 
      Caption         =   "&Window"
      WindowList      =   -1  'True
      Begin VB.Menu mnuWindow_TileVert 
         Caption         =   "Tile Vertically"
      End
      Begin VB.Menu mnuWindow_TileHoriz 
         Caption         =   "Tile Horizontally"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelp_About 
         Caption         =   "&About..."
      End
   End
End
Attribute VB_Name = "frmMDIMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private mbAutoStart                             As Boolean

Private Const Module_Name                       As String = "frmMDIMain"
Public Sub ConfigurationChanged()

    Call ReadDefaultSettings
    Call RefreshStatusBar
    
    Toolbar1.Visible = gbOptions(1)
    StatusBar.Visible = gbOptions(2)
        
End Sub

Public Sub NewModelLoaded()

    gbModelLoaded = True
    '
    ' Activate disabled menus
    mnuView_ICPackage.Enabled = True
    mnuICTest_Specified.Enabled = True
    mnuView_Power.Enabled = True
    mnuTools_AmendModel.Enabled = True
    Toolbar1.Buttons("MODEL").Enabled = True
    
    '
    ' Update any loaded forms that require it
    If gbFormLoaded(0) = True Then
        ' Refresh the Logic Trace form
        Call frmTrace.RefreshDetails(0)
    End If
                
    StatusBar.Panels(1).Text = gtypModel.Description & ", Model Loaded..."
    StatusBar.Panels(2).Text = " " & gtypModel.Model & " "
    
End Sub

Public Sub ReadLastUsedList()
    
    Dim F                               As Integer
    Dim sModel                          As String
    Dim sModelPath                      As String
    
    Const PROC_NAME                     As String = "ReadLastUsedList"
    
    On Error GoTo ErrorHandler
    '
    ' Clear last used menu
    mnuFile_LastUsed(0).Visible = False
    For F = 1 To mnuFile_LastUsed.Count - 1
        Unload mnuFile_LastUsed(F)
    Next F
    mnuFile_Sep3.Visible = False
    
    For F = 0 To 3
        sModel = GetSetting(App.Title, "LastUsed", Format$(F), "")
        sModelPath = GetSetting(App.Title, "LastUsedPath", Format$(F), "")
        If Len(Trim$(sModel)) Then
            mnuFile_Sep3.Visible = True
            If F Then
                Load mnuFile_LastUsed(F)
            End If
            mnuFile_LastUsed(F).Caption = sModel
            mnuFile_LastUsed(F).Visible = True
            mnuFile_LastUsed(F).Tag = sModelPath
        End If
    Next F
            
    Exit Sub
    
ErrorHandler:
    ErrorRoutine Module_Name, PROC_NAME, Err
End Sub

Private Sub RefreshStatusBar()

    StatusBar.Panels(3).Text = "COM:" & Format(gnPort) & " @" & Format$(glPortSpeed) & " Baud"
    
End Sub

Private Sub ResetDisplay()

    Unload frmLogicAnalyser
    Unload frmTestIC
        
End Sub

Public Sub UpdateLastUsedList()

    
    Dim F                               As Integer
    Dim sModel                          As String
    Dim sModelPath                      As String
    

    Const PROC_NAME                     As String = "UpdateLastUsedList"
    
    On Error GoTo ErrorHandler

    ' Check to make sure we don't update the list for nothing
    'sModel = GetSetting(App.Title, "LastUsed", Format$(0), "")
    'If sModel <> mnuFile_LastUsed(0).Caption Or sModel = "" Then
    If gtypModel.Model <> mnuFile_LastUsed(0).Caption Then
        For F = mnuFile_LastUsed.Count - 1 To 0 Step -1
            sModel = GetSetting(App.Title, "LastUsed", Format$(F), "")
            SaveSetting App.Title, "LastUsed", Format$(F + 1), sModel
            
            sModelPath = GetSetting(App.Title, "LastUsedPath", Format$(F), "")
            SaveSetting App.Title, "LastUsedPath", Format$(F + 1), sModelPath
        Next F
        SaveSetting App.Title, "LastUsed", Format$(0), gtypModel.Model
        SaveSetting App.Title, "LastUsedPath", Format$(0), gsPaths(0)
    
        '
        ' Clear last used menu
        mnuFile_LastUsed(0).Visible = False
        For F = 1 To mnuFile_LastUsed.Count - 1
            Unload mnuFile_LastUsed(F)
        Next F
        mnuFile_Sep3.Visible = False
        
        For F = 0 To 3
            sModel = GetSetting(App.Title, "LastUsed", Format$(F), "")
            sModelPath = GetSetting(App.Title, "LastUsedPath", Format$(F), "")
            If Len(Trim$(sModel)) Then
                mnuFile_Sep3.Visible = True
                If F Then
                    Load mnuFile_LastUsed(F)
                End If
                mnuFile_LastUsed(F).Caption = sModel
                mnuFile_LastUsed(F).Visible = True
                mnuFile_LastUsed(F).Tag = sModelPath ' Where the file came from
            End If
        Next F
    End If
    
    Exit Sub
    
ErrorHandler:
    ErrorRoutine Module_Name, PROC_NAME, Err
End Sub

Private Sub MDIForm_Load()
    Dim vSplit                      As Variant
    

    Me.Caption = Me.Caption & " - Version " & App.Major & "." & App.Minor & "/" & App.Revision
    
    mnuHelp_About.Caption = "About " & App.Title & "..."
        
    Call ConfigurationChanged
    
    Call ReadLastUsedList
    
    Toolbar1.Buttons("BEEP").Value = Abs(gbBeep)
    
    gnPowerPins(0) = 0
    gnPowerPins(1) = 0
    
    RecoverFormLoadPosition Me, False
    
    
End Sub





Private Sub MDIForm_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    
    Dim frm                 As Form
    
    
    If MsgBox("Are you sure ?", vbYesNo + vbExclamation, "Terminate " & App.Title) <> vbYes Then
        Cancel = True
    Else
        ' Save the forms current position
        If Me.WindowState <> vbMinimized Then
            SaveSetting App.Title, "FormPositions", Me.Name, Format$(Me.Width) & "," & Format$(Me.Height) & "," & Format$(Me.Top) & "," & Format$(Me.Left)
        End If
        
        For Each frm In Forms
            Unload frm
        Next
        End
    End If
        
End Sub



Private Sub mnuFile_Exit_Click()

    Unload Me
    
End Sub


Private Sub mnuFile_LastUsed_Click(Index As Integer)

    gsModelFileName = mnuFile_LastUsed(Index).Tag & "\" & mnuFile_LastUsed(Index).Caption & ".MOD"
    
    If LoadModel(gsModelFileName) = False Then
        MsgBox "Model file could not be loaded", vbOKOnly + vbExclamation, "Model file could not be loaded"
    Else
        Call NewModelLoaded
    End If
    
End Sub

Private Sub mnuFile_LoadModel_Click()
    
    Const PROC_NAME                     As String = "mnuFile_LoadModel_Click"
    
    On Error GoTo ErrorHandler
    
    Load frmModelDir
    frmModelDir.Mode = 0 ' Browse Mode

    frmModelDir.Show vbModal
    
    gbModelLoaded = False
    StatusBar.Panels(2).Text = ""
    
    With frmModelDir
        If .pbCancel = False Then
            ' There is a model selected to be loaded
            gsModelFileName = .psModelFileName
            If LoadModel(gsModelFileName) = False Then
                MsgBox "Model file could not be loaded", vbOKOnly + vbExclamation, "Model file could not be loaded"
            Else
                Call NewModelLoaded
                Call UpdateLastUsedList
            End If
        End If
    End With
    Unload frmModelDir
    
    Exit Sub
    
ErrorHandler:
    ErrorRoutine Module_Name, PROC_NAME, Err
End Sub

Private Sub mnuHelp_About_Click()
    
    frmAbout.Show vbModal
    
End Sub

Private Sub mnuICTest_Specified_Click()

    If gbModelLoaded = True Then
        frmTestIC.Show
        If mbAutoStart = True Then
            frmTestIC.tmrStart.Enabled = True
        End If
    Else
        MsgBox "No IC Model Loaded !", vbOKOnly + vbInformation, "Test Specified Device"
    End If
    mbAutoStart = False
    
End Sub

Private Sub mnuTools_AmendModel_Click()
    
    Load frmModelCreate
    frmModelCreate.Amend = True
    frmModelCreate.Show

End Sub

Private Sub mnuTools_Config_Click()

    Call ResetDisplay
    
    frmConfig.Show vbModal
    
    Call ConfigurationChanged
    
End Sub


Private Sub mnuTools_ConfirmInterface_Click()

    frmTestComms.Show
    
End Sub

Private Sub mnuTools_CreateModel_Click()

    Call ResetDisplay
    
    Unload frmModelCreate
    Load frmModelCreate
    frmModelCreate.Amend = False
    frmModelCreate.Show
    
End Sub

Private Sub mnuTools_LogicAnalyser_Click()

    Unload frmTestIC
    
    StatusBar.Panels(1).Text = ""
    gbModelLoaded = False
    Toolbar1.Buttons("MODEL").Enabled = False
    frmLogicAnalyser.Show
    
End Sub

Private Sub mnuTools_LowLevelTest_Click()

    frmLowLevel.Show vbModal
    
End Sub

Private Sub mnuView_Power_Click()

    With gtypModel
        Load frmPowerConnections
        frmPowerConnections.Description = .Description
        frmPowerConnections.Model = .Model
        frmPowerConnections.Pins = .NumPins
        
        Call frmPowerConnections.SetPowerPins(.NumPins, .PinVDD, .PinVSS)
            
        frmPowerConnections.Show vbModal
    End With
    
    Unload frmPowerConnections
    
End Sub

Private Sub mnuView_ICPackage_Click()
    
    frmICView.Show
    
End Sub



Private Sub mnuView_LogicTrace_Click()

    frmTrace.Show
    frmTrace.ZOrder 0
    
End Sub

Private Sub mnuView_TestResults_Click()

    frmTestResults.Show
    frmTestResults.ZOrder 0
    
End Sub

Private Sub mnuWindow_TileHoriz_Click()

    Me.Arrange vbTileHorizontal

End Sub

Private Sub mnuWindow_TileVert_Click()

    Me.Arrange vbTileVertical
    
End Sub




Private Sub Toolbar1_ButtonClick(ByVal Button As MSComctlLib.Button)

    Select Case UCase$(Button.Key)
    Case "BEEP"
        gbBeep = Button.Value
        SaveSetting App.Title, "Defaults", "Beep", Format$(gbBeep, "Yes/No")
        
    Case "LOAD"
        Call mnuFile_LoadModel_Click
            
    Case "RUN"
        mbAutoStart = True
        Call mnuICTest_Specified_Click
        
    Case "KEY"
        If Button.Value = tbrPressed Then
            frmTraceKey.Show
        Else
            Unload frmTraceKey
        End If
        
    Case "CONF"
        Call mnuTools_Config_Click
        
    Case "MODEL"
        If mnuTools_AmendModel.Enabled = True Then
            Call mnuTools_AmendModel_Click
        End If
       
    Case "TRACE"
        Call mnuView_LogicTrace_Click
        
    Case "LOGIC"
        Call mnuTools_LogicAnalyser_Click
        
    Case "HELP"
        Call mnuHelp_About_Click
        
    End Select
    
End Sub


