;CHROMATONE325.ASM 19MAR05

        LIST    p=18f252,r=dec,f=INHX32

	include p18f252.inc

; Note that MPASM assembly for PIC18F does not recognise
; the Shorthand commands which it does handle for 16F devices.

#DEFINE CLRC    BCF STATUS,C,A
#DEFINE CLRDC   BCF STATUS,DC,A
#DEFINE CLRZ    BCF STATUS,Z,A
#DEFINE SETC    BSF STATUS,C,A
#DEFINE SETDC   BSF STATUS,DC,A
#DEFINE SETZ    BSF STATUS,Z,A
#DEFINE SKPC    BTFSS STATUS,C,A
#DEFINE SKPDC   BTFSS STATUS,DC,A
#DEFINE SKPZ    BTFSS STATUS,Z,A
#DEFINE SKPNC   BTFSC STATUS,C,A
#DEFINE SKPNDC  BTFSC STATUS,DC,A
#DEFINE SKPNZ   BTFSC STATUS,Z,A
 
	__config H'300000', H'00'
      __config H'300001', H'22'   ; 20MHz
	__config H'300002', H'08'
	__config H'300003', H'00'
	__config H'300004', H'00'
	__config H'300005', H'01'
	__config H'300006', H'80'
	__config H'300007', H'00'
	__config H'300008', H'0F'
	__config H'300009', H'C0'
	__config H'30000A', H'0F'
	__config H'30000B', H'E0'
	__config H'30000C', H'0F'
	__config H'30000D', H'40'

        CBLOCK 
LOOP
LOOPA
STORE
SLOWIT
STORE1
RSLINE

REGA0				;lsb
REGA1
REGA2
REGA3				;msb

REGB0				;lsb
REGB1
REGB2
REGB3				;msb

REGC0                           ;lsb
REGC1
REGC2
REGC3                           ;msb

DSIGN				;Digit Sign. 0=positive,FF(or non zero)=negative
DIGIT1				;MSD
DIGIT2
DIGIT3
DIGIT4
DIGIT5				;Decimal digits
DIGIT6
DIGIT7
DIGIT8
DIGIT9
DIGIT10				;LSD
MTEMP
MCOUNT
DCOUNT

SINRMSB		; sine value registers
SINRLSB
SINBMSB
SINBLSB

COSRMSB		; cosine value registers
COSRLSB
COSGMSB
COSGLSB
COSBMSB
COSBLSB

REDMSB
REDLSB
GREENMSB
GREENLSB
BLUEMSB
BLUELSB
WHITEMSB
WHITELSB

MULTSINR0	; multiply colour sines stores
MULTSINR1
MULTSINR2
MULTSINR3

MULTSINB0
MULTSINB1
MULTSINB2
MULTSINB3

MULTSING0
MULTSING1
MULTSING2
MULTSING3

MULTCOSR0	; multiply colour cosines stores
MULTCOSR1
MULTCOSR2
MULTCOSR3

MULTCOSB0
MULTCOSB1
MULTCOSB2
MULTCOSB3

MULTCOSG0
MULTCOSG1
MULTCOSG2
MULTCOSG3

ANGLEMSB
ANGLELSB
ENDLOOP
SIGNSINE
SQUARESIN0
SQUARESIN1
SQUARESIN2
SQUARESIN3

FREQLO           ; frequency counter LSB
FREQHI           ; frequency counter MSB
WAVELO           ; frequency value LSB
WAVEHI           ; frequency value MSB
NOTE             ; note value
PREVINPUT        ; store for prev input val
OUTPUT           ; store for output to PORTC
TRIGGER
OCTAVE
SWITCHVAL
PREVSWITCHVAL
MODE

OUTPUT2
ENVELOPELSB
ENVELOPENSB
ENVELOPEMSB
HYPLSB
REDCORRECT
GREENCORRECT
BLUECORRECT
CORRECTFLAG

        ENDC

	org	0
	goto    START
        org     0008h       ; H'08'
        retfie
        org     0018h       ; H'18'  
        retfie              ; interrupt vector

START:  clrf PORTA,A
        clrf PORTB,A
        clrf PORTC,A
	clrf RSLINE,A
        movlw B'11011111'   ; RA0 to RA4 as input, RA5 as output
        movwf TRISA,A
        movlw B'11000000'
        movwf TRISB,A
        movlw B'01111110'
        movwf TRISC,A       ; RC7, RC0 as output
        movlw B'10000010'   ; set RHS justify (bit 7 = 1), RA0 to RA4 as analog inputs
        movwf ADCON1,A

        movlw B'11000101'   ; set timer0 -  prescale
        movwf T0CON,A
        movlw B'01000001'   ; set AD on (bit 0), Fosc/8 (8 & 7 = 01, & ADCON1 bit 6 = 0)
        movwf ADCON0,A
        bcf INTCON2,7,A     ; PORTB pullups on

        movlw B'01000001'   ; set AD on (bit 0), Fosc/8 (8 & 7 = 01, & ADCON1 bit 6 = 0)
        movwf ADCON0,A
        call PAUSIT         ;  delay
	call LCDSET
        call PAUSIT         ;  delay

        clrf SWITCHVAL,A
        movlw B'01111111'
        movwf PREVSWITCHVAL,A

        call SETSINEFACTS

        clrf NOTE,A
        clrf WAVEHI,A
        clrf WAVELO,A
        clrf PREVINPUT,A
        clrf OUTPUT,A
        clrf MODE,A
        clrf TRIGGER,A
        clrf CORRECTFLAG,A
        movlw 1
        movwf REDCORRECT,A
        movwf GREENCORRECT,A
        movwf BLUECORRECT,A

        btfss PORTB,7,A
        call CORRECTVALS
        call LCD11
        movlw 'M'
        call LCDOUT
        movf MODE,W,A
        iorlw 48
        call LCDOUT


; ********* START OF MAIN LOOP *********

MAIN:   comf PORTB,W,A        ; get switch val, if any
        andlw B'10000000'       ; extract bit 7
        movwf SWITCHVAL,A
        xorwf PREVSWITCHVAL,W,A ; is val same as PREVSWITCH ?
        btfsc STATUS,Z,A
        goto MAIN2            ; yes
        movf SWITCHVAL,W,A
        movwf PREVSWITCHVAL,A
        btfsc STATUS,Z,A      ; is it zero?
        goto MAIN2            ; yes
        incf MODE,F,A
        bcf MODE,3,A          ; limit to 8 modes max
        btfss CORRECTFLAG,0,A ; has CORRECTVALS been called on start up?
        bcf MODE,2,A          ; no, limit to 4 modes max
        call LCD12
        movf MODE,W,A
        iorlw 48
        call LCDOUT

MAIN2:  call GETWHITE
        call GETRED
        call GETGREEN
        call GETBLUE
        btfsc MODE,0,A
        call SWAPREDBLUE

        btfss MODE,2,A
        goto M2A

        call CORRECTRED
        call CORRECTGREEN
        call CORRECTBLUE

M2A:    call PROCESSRED
        call PROCESSGREEN
        call PROCESSBLUE

        call ADDSINES
        call ADDCOSINES
        call DIVIDECOSBYSINE
;        call GETHYPFORCE           ; not used
        call GETANGLE
        call CORRECTFOR360

        call SHOWCOLOURVALS
        call GETMAINNOTES
        bsf TRIGGER,7,A
        clrf ENVELOPELSB,A
        clrf ENVELOPEMSB,A
        call WAITNOTETIME
        goto MAIN

; ******** END OF MAIN LOOP *********

SWAPREDBLUE:
        movf REDLSB,W,A
        movwf ENVELOPELSB,A
        movf REDMSB,W,A
        movwf ENVELOPEMSB,A
        movf BLUELSB,W,A
        movwf REDLSB,A
        movf BLUEMSB,W,A
        movwf REDMSB,A
        movf ENVELOPELSB,W,A
        movwf BLUELSB,A
        movf ENVELOPEMSB,W,A
        movwf BLUEMSB,A
        return

; ********* 

GETMAINNOTES:
        movf ANGLELSB,W,A
        movwf REGA0,A
        movf ANGLEMSB,W,A
        movwf REGA1,A
        clrf REGA2,A
        clrf REGA3,A

        movlw 9                ; bring down 360^ max to 40 max
        movwf REGB0,A
        clrf REGB1,A
        clrf REGB2,A
        clrf REGB3,A
        call DIVIDE

        movlw 8                ; divide by 8 to get octave
        movwf REGB0,A
        clrf REGB1,A
        clrf REGB2,A
        clrf REGB3,A
        call DIVIDE

        call LCD14
        movf REGC0,W,A        ; get remainder, note value (1 of 8 poss)
        andlw B'00000111'
        xorlw 7
        btfsc STATUS,Z,A
        clrf REGC0,A
        movf REGC0,W,A
        addlw 'A'
        call LCDOUT
        movf REGA0,W,A         ; show octave
        iorlw 48
        call LCDOUT
        
        movf REGA0,W,A         ; get PORTC bit on which to output note
        addlw 120
        call GETPRM
        andlw B'01111111'
        movwf OCTAVE,A
        movf OCTAVE,W,A
        movwf TRISC,A          ; set that bit as output
        
        rlcf REGC0,W,A          ; get note values
        andlw B'00001110'
        addlw 100
        movwf STORE,A
        call GETPRM
        movwf FREQLO,A
        incf STORE,W,A
        call GETPRM
        movwf FREQHI,A
        return

; *************

ROUTE2:
        call GETWHITE
        call GETRED
        call GETGREEN
        call GETBLUE

        call SHOWCOLOURVALS

        call BLUENOTE
        call GREENNOTE
        call REDNOTE
        goto MAIN

BLUENOTE:
        bcf STATUS,C,A
        rlcf BLUELSB,F,A
        rlcf BLUEMSB,F,A
        bcf STATUS,C,A
        rlcf BLUELSB,W,A
        rlcf BLUEMSB,W,A
        movwf STORE,A
        andlw B'0000111'
        addlw 100
        call GETPRM
        movwf FREQLO,A

        movlw B'01011111'
        btfsc STORE,3,A
        movlw B'01101111'
        movwf TRISC,A
        bsf TRIGGER,7,A
        clrf ENVELOPELSB,A
        clrf ENVELOPENSB,A
        clrf ENVELOPEMSB,A
        call WAITNOTETIME
        return

GREENNOTE:
        bcf STATUS,C,A
        rlcf GREENLSB,F,A
        rlcf GREENMSB,F,A
        bcf STATUS,C,A
        rlcf GREENLSB,W,A
        rlcf GREENMSB,W,A
        movwf STORE,A
        andlw B'0000111'
        addlw 100
        call GETPRM
        movwf FREQLO,A
        movlw B'01110111'
        btfsc STORE,3,A
        movlw B'01111011'
        movwf TRISC,A
        bsf TRIGGER,7,A
        clrf ENVELOPELSB,A
        clrf ENVELOPENSB,A
        clrf ENVELOPEMSB,A
        call WAITNOTETIME
        return

REDNOTE:
        bcf STATUS,C,A
        rlcf REDLSB,F,A
        rlcf REDMSB,F,A
        bcf STATUS,C,A
        rlcf REDLSB,F,A
        rlcf REDMSB,W,A
        movwf STORE,A
        andlw B'0000111'
        addlw 100
        call GETPRM
        movwf FREQLO,A
        movlw B'01111101'
        btfsc STORE,3,A
        movlw B'01111110'
        movwf TRISC,A
        bsf TRIGGER,7,A
        clrf ENVELOPELSB,A
        clrf ENVELOPENSB,A
        clrf ENVELOPEMSB,A
        call WAITNOTETIME
        call NOTEPAUSIT
        call NOTEPAUSIT
        call NOTEPAUSIT
        call NOTEPAUSIT

        return

; *************

SETSINEFACTS:   ;degree    cos     sin     colour
                ; 0        1000    0       green
                ; 120      -501    866     blue
                ; 240      -499    -867    red

        movlw HIGH 1000     ; cos green ; sin green not needed as = 0
        movwf COSGMSB,A
	movlw LOW 1000
        movwf COSGLSB,A

        movlw HIGH 866      ; sin blue
        movwf SINBMSB,A
	movlw LOW 866
        movwf SINBLSB,A

        movlw HIGH 501      ; cos blue - use as negative
        movwf COSBMSB,A                 
	movlw LOW 501
        movwf COSBLSB,A

        movlw HIGH 867      ; sin red - use as negative
        movwf SINRMSB,A
	movlw LOW 867
        movwf SINRLSB,A

        movlw HIGH 499      ; cos red - use as negative
        movwf COSRMSB,A
	movlw LOW 499
        movwf COSRLSB,A
        return

; ******** get WHITE

GETWHITE:
        movlw B'01000001'   ; set AD on, Fosc/8
        iorlw B'00011000'   ; set for RA3, (WHITE)
	call GETADC
        movf ADRESH,W,A     ; get ADC MSB val
	movwf WHITEMSB,A
	movwf REGA1,A
        movf ADRESL,W,A     ; get ADC LSB val
	movwf WHITELSB,A
        return

CORRECTRED:
        movf REDLSB,W,A
        movwf REGA0,A
        movf REDMSB,W,A
        movwf REGA1,A
        clrf REGA2,A
        clrf REGA3,A
        movf REDCORRECT,W,A
        movwf REGB0,A
        clrf REGB1,A
        clrf REGB2,A
        clrf REGB3,A
        call MULTIPLY
        movf REGA0,W,A
        movwf REDLSB,A
        movf REGA1,W,A
        movwf REDMSB,A
        return

CORRECTGREEN:
        movf GREENLSB,W,A
        movwf REGA0,A
        movf GREENMSB,W,A
        movwf REGA1,A
        clrf REGA2,A
        clrf REGA3,A
        movf GREENCORRECT,W,A
        movwf REGB0,A
        clrf REGB1,A
        clrf REGB2,A
        clrf REGB3,A
        call MULTIPLY
        movf REGA0,W,A
        movwf GREENLSB,A
        movf REGA1,W,A
        movwf GREENMSB,A
        return

CORRECTBLUE:
        movf BLUELSB,W,A
        movwf REGA0,A
        movf BLUEMSB,W,A
        movwf REGA1,A
        clrf REGA2,A
        clrf REGA3,A
        movf BLUECORRECT,W,A
        movwf REGB0,A
        clrf REGB1,A
        clrf REGB2,A
        clrf REGB3,A
        call MULTIPLY
        movf REGA0,W,A
        movwf BLUELSB,A
        movf REGA1,W,A
        movwf BLUEMSB,A
        return


; ******** get RED

GETRED: movlw B'01000001'   ; set AD on, Fosc/8, set for RA0 (RED)
	call GETADC
        movf ADRESH,W,A     ; get ADC MSB val
        movwf REDMSB,A
        movf ADRESL,W,A     ; get ADC LSB val
        movwf REDLSB,A
        return

; ***** mult red x sinR

PROCESSRED:
        movf REDLSB,W,A
        movwf REGA0,A
        movf REDMSB,W,A
        movwf REGA1,A

        movf SINRMSB,W,A
        movwf REGB1,A
        movf SINRLSB,W,A
        movwf REGB0,A

        clrf REGA2,A
        clrf REGA3,A
        clrf REGB2,A
        clrf REGB3,A
        call MULTIPLY       ; multiply red x sine

        movf REGA0,W,A      ; store red sine result
        movwf MULTSINR0,A
        movf REGA1,W,A
        movwf MULTSINR1,A
        movf REGA2,W,A
        movwf MULTSINR2,A
        movf REGA3,W,A
        movwf MULTSINR3,A

; ***** mult red x cosR

        movf ADRESH,W,A     ; get ADC MSB val
        movwf REGA1,A
        movf ADRESL,W,A     ; get ADC LSB val
        movwf REGA0,A
        movf COSRMSB,W,A
        movwf REGB1,A
        movf COSRLSB,W,A
        movwf REGB0,A

        clrf REGA2,A
        clrf REGA3,A
        clrf REGB2,A
        clrf REGB3,A
        call MULTIPLY       ; multiply red x cos

        movf REGA0,W,A      ; store red cos result
        movwf MULTCOSR0,A
        movf REGA1,W,A
        movwf MULTCOSR1,A
        movf REGA2,W,A
        movwf MULTCOSR2,A
        movf REGA3,W,A
        movwf MULTCOSR3,A
        return

; ******* get green

GETGREEN:
        movlw B'01000001'   ; set AD on, Fosc/8
        iorlw B'00001000'   ; set for RA1, (GREEN)
	call GETADC
        movf ADRESH,W,A     ; get ADC MSB val
        movwf GREENMSB,A
        movf ADRESL,W,A     ; get ADC LSB val
        movwf GREENLSB,A
        return

; ***** mult green x cosG   ; no need to process sin green as result always = 0

PROCESSGREEN:
        movf GREENLSB,W,A
        movwf REGA0,A
        movf GREENMSB,W,A
        movwf REGA1,A

        movf COSGMSB,W,A
        movwf REGB1,A
        movf COSGLSB,W,A
        movwf REGB0,A

        clrf REGA2,A
        clrf REGA3,A
        clrf REGB2,A
        clrf REGB3,A
        call MULTIPLY       ; multiply green x cos

        movf REGA0,W,A      ; store green cos result
        movwf MULTCOSG0,A
        movf REGA1,W,A
        movwf MULTCOSG1,A
        movf REGA2,W,A
        movwf MULTCOSG2,A
        movf REGA3,W,A
        movwf MULTCOSG3,A
        return

; ********** get BLUE

GETBLUE:
        movlw B'01000001'   ; set AD on, Fosc/8
        iorlw B'00010000'   ; set for RA2, (BLUE)
	call GETADC
        movf ADRESH,W,A     ; get ADC MSB val
        movwf BLUEMSB,A
        movf ADRESL,W,A     ; get ADC LSB val
        movwf BLUELSB,A
        return

; ******** multiply blue x sin blue

PROCESSBLUE:
        movf BLUELSB,W,A
        movwf REGA0,A
        movf BLUEMSB,W,A
        movwf REGA1,A

        movf SINBMSB,W,A
        movwf REGB1,A
        movf SINBLSB,W,A
        movwf REGB0,A

        clrf REGA2,A
        clrf REGA3,A
        clrf REGB2,A
        clrf REGB3,A
        call MULTIPLY       ; multiply blue x sin

        movf REGA0,W,A      ; store blue sin result
        movwf MULTSINB0,A
        movf REGA1,W,A
        movwf MULTSINB1,A
        movf REGA2,W,A
        movwf MULTSINB2,A
        movf REGA3,W,A
        movwf MULTSINB3,A

; *******  multiply blue x cosB

        movf ADRESH,W,A     ; get ADC MSB val
        movwf REGA1,A
        movf ADRESL,W,A     ; get ADC LSB val
        movwf REGA0,A

        movf COSBMSB,W,A
        movwf REGB1,A
        movf COSBLSB,W,A
        movwf REGB0,A

        clrf REGA2,A
        clrf REGA3,A
        clrf REGB2,A
        clrf REGB3,A
        call MULTIPLY       ; multiply blue x cos

        movf REGA0,W,A      ; store blue cos result
        movwf MULTCOSB0,A
        movf REGA1,W,A
        movwf MULTCOSB1,A
        movf REGA2,W,A
        movwf MULTCOSB2,A
        movf REGA3,W,A
        movwf MULTCOSB3,A
        return

; ******* ADD/SUBTRACT SINES DEPENDING ON SIGN OF VALUE *******

ADDSINES:
        movf MULTSINB0,W,A  ; blue +sin - red -sin (negative)
        movwf REGA0,A
        movf MULTSINB1,W,A
        movwf REGA1,A
        movf MULTSINB2,W,A
        movwf REGA2,A
        movf MULTSINB3,W,A
        movwf REGA3,A

        movf MULTSINR0,W,A
        movwf REGB0,A
        movf MULTSINR1,W,A
        movwf REGB1,A
        movf MULTSINR2,W,A
        movwf REGB2,A
        movf MULTSINR3,W,A
        movwf REGB3,A

        clrf SIGNSINE,A
	call SUBTRACT

        btfss REGA3,7,A       ; store sign of result
        goto J1
        bsf SIGNSINE,0,A      ; = negative if bit 7 set
        call negatea

J1:     movf REGA0,W,A      ; store result before multiplication
        movwf SQUARESIN0,A
        movf REGA1,W,A
        movwf SQUARESIN1,A
        movf REGA2,W,A
        movwf SQUARESIN2,A
        movf REGA3,W,A
        movwf SQUARESIN3,A

        movlw 100           ; multiply sine by 100 
        movwf REGB0,A
        clrf REGB1,A
        clrf REGB2,A
        clrf REGB3,A
        call MULTIPLY

        movf REGA0,W,A      ; store result back into MULTSINR
        movwf MULTSINR0,A   ; (no need to add green sin as it = 0)
        movf REGA1,W,A
        movwf MULTSINR1,A
        movf REGA2,W,A
        movwf MULTSINR2,A
        movf REGA3,W,A
        movwf MULTSINR3,A
        return

; ******* ADD/SUBTRACT COS DEPENDING ON SIGN OF VALUE *******

ADDCOSINES:
        movf MULTCOSG0,W,A  ; green cos - red cos (negative)
        movwf REGA0,A
        movf MULTCOSG1,W,A
        movwf REGA1,A
        movf MULTCOSG2,W,A
        movwf REGA2,A
        movf MULTCOSG3,W,A
        movwf REGA3,A

        movf MULTCOSR0,W,A
        movwf REGB0,A
        movf MULTCOSR1,W,A
        movwf REGB1,A
        movf MULTCOSR2,W,A
        movwf REGB2,A
        movf MULTCOSR3,W,A
        movwf REGB3,A

	call SUBTRACT

        movf MULTCOSB0,W,A  ; subtract blue cos from result
        movwf REGB0,A
        movf MULTCOSB1,W,A
        movwf REGB1,A
        movf MULTCOSB2,W,A
        movwf REGB2,A
        movf MULTCOSB3,W,A
        movwf REGB3,A

	call SUBTRACT

        btfss REGA3,7,A
        goto J2
        bsf SIGNSINE,1,A    ; store sign of result
        call negatea

J2:     movf REGA0,W,A      ; store result back into MULTCOSR
        movwf MULTCOSR0,A
        movf REGA1,W,A
        movwf MULTCOSR1,A
        movf REGA2,W,A
        movwf MULTCOSR2,A
        movf REGA3,W,A
        movwf MULTCOSR3,A
        return

DIVIDECOSBYSINE:

        movf MULTSINR0,W,A  ; now divide COS by SIN
        movwf REGA0,A
        movf MULTSINR1,W,A 
        movwf REGA1,A
        movf MULTSINR2,W,A 
        movwf REGA2,A
        movf MULTSINR3,W,A 
        movwf REGA3,A

        btfsc REGA3,7,A
        call negateA

        movf MULTCOSR0,W,A
        movwf REGB0,A
        movf MULTCOSR1,W,A 
        movwf REGB1,A
        movf MULTCOSR2,W,A 
        movwf REGB2,A
        movf MULTCOSR3,W,A 
        movwf REGB3,A

        btfsc REGB3,7,A
        call negateB

	call DIVIDE

        btfsc REGA3,7,A
        call negatea

        movf REGA0,W,A
        movwf ANGLELSB,A
        movf REGA1,W,A
        movwf ANGLEMSB,A

        clrf REGA2,A
        clrf REGA3,A

        movf SQUARESIN0,W,A
        movwf REGA0,A
        movf SQUARESIN1,W,A
        movwf REGA1,A
        movf SQUARESIN2,W,A
        movwf REGA2,A
        movf SQUARESIN3,W,A
        movwf REGA3,A
        return

GETHYPFORCE:
        movlw H'E8'         ; divide SIN by 1000
        movwf REGB0,A
        movlw 3
        movwf REGB1,A
        clrf REGB2,A
        clrf REGB3,A

        call DIVIDE

        movf REGA0,W,A      ; square it
        movwf REGB0,A
        movf REGA1,W,A
        movwf REGB1,A
        movf REGA2,W,A
        movwf REGB2,A
        movf REGA3,W,A
        movwf REGB3,A

	call MULTIPLY

        movf REGA0,W,A      ; store result back into MULTSING
        movwf MULTSING0,A
        movf REGA1,W,A
        movwf MULTSING1,A
        movf REGA2,W,A
        movwf MULTSING2,A
        movf REGA3,W,A
        movwf MULTSING3,A

        movf MULTCOSR0,W,A
        movwf REGA0,A
        movf MULTCOSR1,W,A
        movwf REGA1,A
        movf MULTCOSR2,W,A
        movwf REGA2,A
        movf MULTCOSR3,W,A
        movwf REGA3,A

        movf MULTCOSR0,W,A  ; divide cos by 1000
        movwf REGA0,A
        movf MULTCOSR1,W,A
        movwf REGA1,A
        movf MULTCOSR2,W,A
        movwf REGA2,A
        movf MULTCOSR3,W,A
        movwf REGA3,A
        movlw H'E8'
        movwf REGB0,A
        movlw 3
        movwf REGB1,A
        clrf REGB2,A
        clrf REGB3,A

        call DIVIDE

        movf REGA0,W,A      ; square it
        movwf REGB0,A
        movf REGA1,W,A
        movwf REGB1,A
        movf REGA2,W,A
        movwf REGB2,A
        movf REGA3,W,A
        movwf REGB3,A

	call MULTIPLY

        movf REGA0,W,A      ; store result back into MULTCOSG
        movwf MULTCOSG0,A
        movf REGA1,W,A
        movwf MULTCOSG1,A
        movf REGA2,W,A
        movwf MULTCOSG2,A
        movf REGA3,W,A
        movwf MULTCOSG3,A

        movf MULTSING0,W,A  ; add sin^2 to cos^2
        movwf REGB0,A
        movf MULTSING1,W,A
        movwf REGB1,A
        movf MULTSING2,W,A
        movwf REGB2,A
        movf MULTSING3,W,A
        movwf REGB3,A

	call ADD

        call SQRT           ; get square root of result
        movf REGA0,W,A
        btfsc STATUS,Z,A
        movlw 1
        movwf HYPLSB,A

	call BIN2DEC
        call LCD6
        call SHOW7          ; show sqrt(sin^2 + cos^2)
        return

; *********** GET ANGLE IN RELATION TO 90^

GETANGLE:
        movf ANGLEMSB,W,A
        btfss STATUS,Z,A
        goto MSB1
        clrf LOOP,A
        movlw 69
        movwf ENDLOOP,A
        goto ATN2

MSB1:   movf ANGLEMSB,W,A
        xorlw 1
        btfss STATUS,Z,A
        goto MSB2
        movlw 69
        movwf LOOP,A
        movlw 79
        movwf ENDLOOP,A
        goto ATN2

MSB2:   movf ANGLEMSB,W,A
        xorlw 2
        btfss STATUS,Z,A
        goto MSB3
        movlw 79
        movwf LOOP,A
        movlw 83
        movwf ENDLOOP,A
        goto ATN2

MSB3:   movf ANGLEMSB,W,A
        xorlw 3
        btfss STATUS,Z,A
        goto MSB4
        movlw 83
        movwf LOOP,A
        movlw 85
        movwf ENDLOOP,A
        goto ATN2

MSB4:   movf ANGLEMSB,W,A
        movwf ANGLELSB,A
        movlw 85
        movwf LOOP,A
        movlw 90
        movwf ENDLOOP,A

ATN2:   movf LOOP,W,A
        call GETPRM
        subwf ANGLELSB,W,A
        btfss STATUS,C,A
        goto ATN4

        incf LOOP,F,A
        movf LOOP,W,A
        xorwf ENDLOOP,W,A
        btfss STATUS,Z,A
        goto ATN2

ATN4:   decf LOOP,W,A
        movwf ANGLELSB,A
        return

; ********* CORRECT FOR 360^

CORRECTFOR360:
        movf ANGLELSB,W,A
        movwf REGA0,A
        clrf REGA1,A
        movf SIGNSINE,W,A
        btfsc STATUS,Z,A    ; sign = 0  angle remains unchanged
        goto ATN10

        xorlw 1             ; sign = 1  angle = 360 - angle
        btfss STATUS,Z,A
        goto ATN5
        movlw H'68'
        movwf REGA0,A
        movlw 1
        movwf REGA1,A
        clrf REGA2,A
        clrf REGA3,A
        movf ANGLELSB,W,A
        movwf REGB0,A
        clrf REGB1,A
        clrf REGB2,A
        clrf REGB3,A
        call SUBTRACT
        goto ATN10

ATN5:   movf SIGNSINE,W,A
        xorlw 2             ; sign = 2  angle = 180 - angle
        btfss STATUS,Z,A
        goto ATN6
        movf REGA0,W,A
        sublw 180
        movwf REGA0,A
        goto ATN10

ATN6:   movf SIGNSINE,W,A
        xorlw 3             ; sign = 3  angle = 180 + angle
        btfss STATUS,Z,A
        goto ATN10
        movlw 180
        addwf REGA0,F,A
        btfsc STATUS,Z,A
        incf REGA1,F,A

ATN10:
        movf REGA0,W,A
        movwf ANGLELSB,A
        movf REGA1,W,A
        movwf ANGLEMSB,A

        clrf REGA2,A
        clrf REGA3,A
        call BIN2DEC
        call LCD1
        call SHOW7          ; show degrees
        movlw H'DF'         ; degree symbol
        call LCDOUT
        return

; ***********

SHOWCOLOURVALS:
        movf REDMSB,W,A     ; show colour values
        movwf REGA1,A
        movf REDLSB,W,A
        movwf REGA0,A
        clrf REGA2,A 
        clrf REGA3,A
        call BIN2DEC
        call LCD21
        call SHOW7
        movlw 'R'
        call LCDOUT

        movf GREENMSB,W,A
        movwf REGA1,A
        movf GREENLSB,W,A
        movwf REGA0,A
        clrf REGA2,A 
        clrf REGA3,A
        call BIN2DEC
        call SHOW7
        movlw 'G'
        call LCDOUT

        movf BLUEMSB,W,A
        movwf REGA1,A
        movf BLUELSB,W,A
        movwf REGA0,A
        clrf REGA2,A 
        clrf REGA3,A
        call BIN2DEC
        call SHOW7
        movlw 'B'
        call LCDOUT

        movf WHITEMSB,W,A
        movwf REGA1,A
        movf WHITELSB,W,A
        movwf REGA0,A
        clrf REGA2,A
        clrf REGA3,A
        call BIN2DEC
        call LCD5
        call SHOW7
        movlw 'W'
        call LCDOUT
        return

;********** GET ADC VALUE

GETADC:	movwf ADCON0,A
	call DELAYB
        bsf ADCON0,GO,A     ; start data conversion

GETADC2: btfsc ADCON0,GO,A
        goto GETADC2
        return

;******** LCD ROUTINES **********

LCD1:   movlw B'10000000'
        goto LCDLIN
LCD5:   movlw B'10000101'
        goto LCDLIN

LCD6:   movlw B'10000110'
        goto LCDLIN
LCD8:   movlw B'10001000'
        goto LCDLIN
LCD11:  movlw B'10001011'
        goto LCDLIN

LCD12:  movlw B'10001100'
        goto LCDLIN
LCD13:  movlw B'10001101'
        goto LCDLIN
LCD14:  movlw B'10001110'
        goto LCDLIN

LCD21:  movlw B'11000000'
        goto LCDLIN
LCD28:  movlw B'11001000'
        goto LCDLIN

LCDLIN: bcf RSLINE,4,A        ; sets LCD command/line
        call LCDOUT         ; and outputs command code to LCD
        bsf RSLINE,4,A        ; set RS flag
        return

SHOW1:  movf DIGIT1,W,A
	call LCDOUT	
SHOW2:  movf DIGIT2,W,A
	call LCDOUT	
SHOW3:  movf DIGIT3,W,A
	call LCDOUT	
SHOW4:  movf DIGIT4,W,A
	call LCDOUT	
SHOW5:  movf DIGIT5,W,A
	call LCDOUT	
SHOW6:  movf DIGIT6,W,A
	call LCDOUT	
SHOW7:  movf DIGIT7,W,A
	call LCDOUT	
SHOW8:  movf DIGIT8,W,A
	call LCDOUT	
SHOW9:  movf DIGIT9,W,A
	call LCDOUT	
SHOW10: movf DIGIT10,W,A
	call LCDOUT	
	return

LCDOUT: movwf STORE1,A        ; temp store value that will be output to LCD
        movlw 255             ; set minimum time between sending full bytes to LCD
        movwf LOOPA,A
DELAY:  decfsz LOOPA,F,A
        goto DELAY
        call SENDIT           ; send MSB, then (by default) send LSB

SENDIT: swapf STORE1,F,A      ; swap byte nibbles
        movf STORE1,W,A       ; get nibble (MSB)
        andlw 15              ; AND to isolate nibble
        iorwf RSLINE,W,A      ; OR the RS bit
        movwf PORTB,A         ; output the byte
        nop
        nop
        bsf PORTB,5,A         ; set E high
        nop
        nop
        bcf PORTB,5,A         ; set E low
        return

PAUSIT: movlw 25
        movwf SLOWIT,A
        bcf INTCON1,2,A
PAUSE:  btfss INTCON1,2,A
        goto PAUSE
        bcf INTCON1,2,A
        decfsz SLOWIT,F,A
        goto PAUSE
        return

NOTEPAUSIT:
        movlw 5                ; basic pause
        btfss MODE,1,A           ; is it mode 2 or 3?
        goto NP2               ; no
        bcf STATUS,C,A           ; yes. divide WHITE by 32
        rrcf WHITEMSB,F,A
        rrcf WHITELSB,F,A
        bcf STATUS,C,A
        rrcf WHITEMSB,F,A
        rrcf WHITELSB,F,A
        bcf STATUS,C,A
        rrcf WHITEMSB,F,A
        rrcf WHITELSB,F,A
        bcf STATUS,C,A
        rrcf WHITEMSB,F,A
        rrcf WHITELSB,F,A
        bcf STATUS,C,A
        rrcf WHITEMSB,F,A
        rrcf WHITELSB,F,A
        comf WHITELSB,W,A        ; yes, relate pause to white level
        andlw B'00011111'        ; limit to 31 max
        btfsc STATUS,Z,A
        addlw 1

NP2:    movwf SLOWIT,A
        bcf INTCON1,2,A
NPAUSE: btfss INTCON1,2,A
        goto NPAUSE
        bcf INTCON1,2,A
        decfsz SLOWIT,F,A
        goto PAUSE
        return

; **** PART OF PETER HEMSLEY'S 32-BIT MATHS ROUTINES amended for 18F by JB *******
;*** SIGNED 32-BIT INTEGER MATHS ROUTINES FOR PIC16 SERIES BY PETER HEMSLEY ***
;
;Functions:
;	add
;       subtract
;	multiply
;	divide
;	round
;	sqrt
;	bin2dec
;	dec2bin

;Variable declarations

;mathram	equ	;(insert required ram address here)

;	cblock mathram

;*** 32 BIT SIGNED SUBTRACT ***
;REGA - REGB -> REGA
;Return carry set if overflow

subtract
        call    negateb     ; Negate REGB
	skpnc
        return              ; Overflow

;*** 32 BIT SIGNED ADD ***
;REGA + REGB -> REGA
;Return carry set if overflow

add     movf    REGA3,w,A         ;Compare signs
        xorwf   REGB3,w,A
        movwf   MTEMP,A

	call	addba		;Add REGB to REGA

	clrc			;Check signs
        movf    REGB3,w,A         ;If signs are same
        xorwf   REGA3,w,A         ;so must result sign
        btfss   MTEMP,7,A         ;else overflow
	addlw	0x80
	return

;*** 32 BIT SIGNED MULTIPLY ***
;REGA * REGB -> REGA
;Return carry set if overflow

multiply:
        clrf    MTEMP,A           ;Reset sign flag
	call	absa		;Make REGA positive
	skpc
	call	absb		;Make REGB positive
	skpnc
	return			;Overflow

	call	movac		;Move REGA to REGC
	call	clra		;Clear product

	movlw	D'31'		;Loop counter
        movwf   MCOUNT,A

muloop	call	slac		;Shift left product and multiplicand
	
        rlcf    REGC3,w,A         ;Test MSB of multiplicand
	skpnc			;If multiplicand bit is a 1 then
	call	addba		;add multiplier to product

	skpc			;Check for overflow
        rlcf    REGA3,w,A
	skpnc
	return

        decfsz  MCOUNT,f,A        ;Next
	goto	muloop

        btfsc   MTEMP,0,A         ;Check result sign
	call	negatea		;Negative
	return


;*** 32 BIT SIGNED DIVIDE ***
;REGA / REGB -> REGA
;Remainder in REGC
;Return carry set if overflow or division by zero

divide  clrf    MTEMP,A           ;Reset sign flag
        movf    REGB0,w,A         ;Trap division by zero
        iorwf   REGB1,w,A
        iorwf   REGB2,w,A
        iorwf   REGB3,w,A
	sublw	0
	skpc
	call	absa		;Make dividend (REGA) positive
	skpc
	call	absb		;Make divisor (REGB) positive
	skpnc
	return			;Overflow

        clrf    REGC0,A           ;Clear remainder
        clrf    REGC1,A
        clrf    REGC2,A
        clrf    REGC3,A
	call	slac		;Purge sign bit

	movlw	D'31'		;Loop counter
        movwf   MCOUNT,A

dvloop	call	slac		;Shift dividend (REGA) msb into remainder (REGC)

        movf    REGB3,w,A         ;Test if remainder (REGC) >= divisor (REGB)
        subwf   REGC3,w,A
	skpz
	goto	dtstgt
        movf    REGB2,w,A
        subwf   REGC2,w,A
	skpz
	goto	dtstgt
        movf    REGB1,w,A
        subwf   REGC1,w,A
	skpz
	goto	dtstgt
        movf    REGB0,w,A
        subwf   REGC0,w,A
dtstgt	skpc			;Carry set if remainder >= divisor
	goto	dremlt

        movf    REGB0,w,A         ;Subtract divisor (REGB) from remainder (REGC)
        subwf   REGC0,f,A
        movf    REGB1,w,A
	skpc
        incfsz  REGB1,w,A
        subwf   REGC1,f,A
        movf    REGB2,w,A
	skpc
        incfsz  REGB2,w,A
        subwf   REGC2,f,A
        movf    REGB3,w,A
	skpc
        incfsz  REGB3,w,A
        subwf   REGC3,f,A
	clrc
        bsf     REGA0,0,A         ;Set quotient bit

dremlt  decfsz  MCOUNT,f,A        ;Next
	goto	dvloop

        btfsc   MTEMP,0,A         ;Check result sign
	call	negatea		;Negative
	return

;*** ROUND RESULT OF DIVISION TO NEAREST INTEGER ***

round   clrf    MTEMP,A           ;Reset sign flag
	call	absa		;Make positive
	clrc
	call	slc		;Multiply remainder by 2
        movf    REGB3,w,A         ;Test if remainder (REGC) >= divisor (REGB)
        subwf   REGC3,w,A
	skpz
	goto	rtstgt
        movf    REGB2,w,A
        subwf   REGC2,w,A
	skpz
	goto	dtstgt
        movf    REGB1,w,A
        subwf   REGC1,w,A
	skpz
	goto	rtstgt
        movf    REGB0,w,A
        subwf   REGC0,w,A
rtstgt	skpc			;Carry set if remainder >= divisor
	goto	rremlt
        incfsz  REGA0,f,A         ;Add 1 to quotient
	goto	rremlt
        incfsz  REGA1,f,A
	goto	rremlt
        incfsz  REGA2,f,A
	goto	rremlt
        incf    REGA3,f,A
	skpnz
	return			;Overflow,return carry set
rremlt  btfsc   MTEMP,0,A         ;Restore sign
	call	negatea
	return


;*** 32 BIT SQUARE ROOT ***
;sqrt(REGA) -> REGA
;Return carry set if negative

sqrt    rlcf    REGA3,w,A         ;Trap negative values
	skpnc
	return

	call	movac		;Move REGA to REGC
	call	clrba		;Clear remainder (REGB) and root (REGA)

	movlw	D'16'		;Loop counter
        movwf   MCOUNT,A

sqloop  rlcf    REGC0,f,A         ;Shift two msb's
        rlcf    REGC1,f,A         ;into remainder
        rlcf    REGC2,f,A
        rlcf    REGC3,f,A
        rlcf    REGB0,f,A
        rlcf    REGB1,f,A
        rlcf    REGB2,f,A
        rlcf    REGC0,f,A
        rlcf    REGC1,f,A
        rlcf    REGC2,f,A
        rlcf    REGC3,f,A
        rlcf    REGB0,f,A
        rlcf    REGB1,f,A
        rlcf    REGB2,f,A

	setc			;Add 1 to root
        rlcf    REGA0,f,A         ;Align root
        rlcf    REGA1,f,A
        rlcf    REGA2,f,A

        movf    REGA2,w,A         ;Test if remdr (REGB) >= root (REGA)
        subwf   REGB2,w,A
	skpz
	goto	ststgt
        movf    REGA1,w,A
        subwf   REGB1,w,A
	skpz
	goto	ststgt
        movf    REGA0,w,A
        subwf   REGB0,w,A
ststgt	skpc			;Carry set if remdr >= root
	goto	sremlt

        movf    REGA0,w,A         ;Subtract root (REGA) from remdr (REGB)
        subwf   REGB0,f,A
        movf    REGA1,w,A
	skpc
        incfsz  REGA1,w,A
        subwf   REGB1,f,A
        movf    REGA2,w,A
	skpc
        incfsz  REGA2,w,A
        subwf   REGB2,f,A
        bsf     REGA0,1,A         ;Set current root bit

sremlt  bcf     REGA0,0,A         ;Clear test bit
        decfsz  MCOUNT,f,A        ;Next
	goto	sqloop

	clrc
        rrcf    REGA2,f,A         ;Adjust root alignment
        rrcf    REGA1,f,A
        rrcf    REGA0,f,A
	return


;*** 32 BIT SIGNED BINARY TO DECIMAL ***
;REGA -> DIGITS 1 (MSD) TO 10 (LSD) & DSIGN
;DSIGN = 0 if REGA is positive, 1 if negative
;Return carry set if overflow
;Uses FSR register

bin2dec clrf    MTEMP,A           ;Reset sign flag
	call	absa		;Make REGA positive
	skpnc
	return			;Overflow

	call	clrdig		;Clear all digits

	movlw	D'32'		;Loop counter
        movwf   MCOUNT,A

b2dloop rlcf    REGA0,f,A         ;Shift msb into carry
        rlcf    REGA1,f,A
        rlcf    REGA2,f,A
        rlcf    REGA3,f,A
        lfsr FSR0, DIGIT10  ;,A       ;Pointer to digits

	movlw	D'10'		;10 digits to do
        movwf   DCOUNT,A

adjlp   rlcf    INDF0,f,A         ;Shift digit and carry 1 bit left
	movlw	D'10'
        subwf   INDF0,w,A         ;Check and adjust for decimal overflow
	skpnc
        movwf   INDF0,A
        movf POSTDEC0,F,A         ; next digit -  decf FSR0L,f does not work 

        decfsz  DCOUNT,f,A
	goto	adjlp

        decfsz  MCOUNT,f,A        ;Next bit
	goto	b2dloop

        btfsc   MTEMP,0,A         ;Check sign
        bsf     DSIGN,0,A         ;Negative
	clrc
	call 	BLANKIT
	return


;*** 32 BIT SIGNED DECIMAL TO BINARY ***
;Decimal DIGIT1 thro DIGIT(X) & DSIGN -> REGA
;Set DSIGN = 0 for positive, DSIGN = 1 for negative values
;Most significant digit in DIGIT1
;Enter this routine with digit count in w register
;Return carry set if overflow
;Uses FSR register

dec2bin movwf   MTEMP,A           ;Save digit count

	movlw	D'32'		;Outer bit loop counter
        movwf   MCOUNT,A

d2blp1	; movlw	DIGIT1-1	;Set up pointer to MSD
	; movwf	FSR

        lfsr FSR0, DIGIT1-1  ;,A      ; load FSR0 with address
        movf    MTEMP,w,A         ;Inner digit loop counter
        movwf   DCOUNT,A

	movlw	D'10'
	clrc			;Bring in '0' bit into MSD

d2blp2	; incf	FSR,f
        movf POSTINC0,F,A         ; next digit -  incf FSR0L,f does not work 
	skpnc
        addwf   INDF0,f,A         ;Add 10 if '1' bit from prev digit
        rrcf    INDF0,f,A         ;Shift out LSB of digit

        decfsz  DCOUNT,f,A        ;Next L.S. Digit
        goto    d2blp2

        rrcf    REGA3,f,A         ;Shift in carry from digits
        rrcf    REGA2,f,A
        rrcf    REGA1,f,A
        rrcf    REGA0,f,A

        decfsz  MCOUNT,f,A        ;Next bit
	goto	d2blp1

        movf    INDF0,w,A         ;Check for overflow
	addlw	0xFF
	skpc
        rlcf    REGA3,w,A
	skpnc
	return

        btfsc   DSIGN,0,A         ;Check result sign
	call	negatea		;Negative
	return


;UTILITY ROUTINES


;Add REGB to REGA (Unsigned)
;Used by add, multiply,

addba   movf    REGB0,w,A         ;Add lo byte
        addwf   REGA0,f,A

        movf    REGB1,w,A         ;Add mid-lo byte
	skpnc			;No carry_in, so just add
        incfsz  REGB1,w,A         ;Add carry_in to REGB
        addwf   REGA1,f,A         ;Add and propagate carry_out

        movf    REGB2,w,A         ;Add mid-hi byte
	skpnc
        incfsz  REGB2,w,A
        addwf   REGA2,f,A

        movf    REGB3,w,A         ;Add hi byte
	skpnc
        incfsz  REGB3,w,A
        addwf   REGA3,f,A
	return


;Move REGA to REGC
;Used by multiply, sqrt

movac   movf    REGA0,w,A
        movwf   REGC0,A
        movf    REGA1,w,A
        movwf   REGC1,A
        movf    REGA2,w,A
        movwf   REGC2,A
        movf    REGA3,w,A
        movwf   REGC3,A
	return


;Clear REGB and REGA
;Used by sqrt

clrba   clrf    REGB0,A
        clrf    REGB1,A
        clrf    REGB2,A
        clrf    REGB3,A

;Clear REGA
;Used by multiply, sqrt

clra    clrf    REGA0,A
        clrf    REGA1,A
        clrf    REGA2,A
        clrf    REGA3,A
	return


;Check sign of REGA and convert negative to positive
;Used by multiply, divide, bin2dec, round

absa    rlcf    REGA3,w,A
	skpc
	return			;Positive

;Negate REGA
;Used by absa, multiply, divide, bin2dec, dec2bin, round

negatea movf    REGA3,w,A         ;Save sign in w
	andlw	0x80

        comf    REGA0,f,A         ;2's complement
        comf    REGA1,f,A
        comf    REGA2,f,A
        comf    REGA3,f,A
        incfsz  REGA0,f,A
	goto	nega1
        incfsz  REGA1,f,A
	goto	nega1
        incfsz  REGA2,f,A
	goto	nega1
        incf    REGA3,f,A
nega1
        incf    MTEMP,f,A         ;flip sign flag
        addwf   REGA3,w,A         ;Return carry set if -2147483648
	return


;Check sign of REGB and convert negative to positive
;Used by multiply, divide

absb    rlcf    REGB3,w,A
	skpc
	return			;Positive

;Negate REGB
;Used by absb, subtract, multiply, divide

negateb movf    REGB3,w,A         ;Save sign in w
	andlw	0x80

        comf    REGB0,f,A         ;2's complement
        comf    REGB1,f,A
        comf    REGB2,f,A
        comf    REGB3,f,A
        incfsz  REGB0,f,A
	goto	negb1
        incfsz  REGB1,f,A
	goto	negb1
        incfsz  REGB2,f,A
	goto	negb1
        incf    REGB3,f,A
negb1
        incf    MTEMP,f,A         ;flip sign flag
        addwf   REGB3,w,A         ;Return carry set if -2147483648
	return


;Shift left REGA and REGC
;Used by multiply, divide, round

slac    rlcf    REGA0,f,A
        rlcf    REGA1,f,A
        rlcf    REGA2,f,A
        rlcf    REGA3,f,A
slc     rlcf    REGC0,f,A
        rlcf    REGC1,f,A
        rlcf    REGC2,f,A
        rlcf    REGC3,f,A
	return


;Set all digits to 0
;Used by bin2dec

clrdig  clrf    DSIGN,A
        clrf    DIGIT1,A
        clrf    DIGIT2,A
        clrf    DIGIT3,A
        clrf    DIGIT4,A
        clrf    DIGIT5,A
        clrf    DIGIT6,A
        clrf    DIGIT7,A
        clrf    DIGIT8,A
        clrf    DIGIT9,A
        clrf    DIGIT10,A
	return

BLANKIT: movlw 48
        iorwf DIGIT1,F,A
        iorwf DIGIT2,F,A
        iorwf DIGIT3,F,A
        iorwf DIGIT4,F,A
        iorwf DIGIT5,F,A
        iorwf DIGIT6,F,A
        iorwf DIGIT7,F,A
        iorwf DIGIT8,F,A
        iorwf DIGIT9,F,A
        iorwf DIGIT10,F,A

        movlw 10          ; blank leading zeros
        movwf LOOP,A
        lfsr FSR0, DIGIT1 ;,A ; **19mar

BLANK:  movf INDF0,W,A
        andlw 15
        btfss STATUS,Z,A
        return
        bcf postinc0,4,A
        decfsz LOOP,F,A
        goto BLANK
        movlw 48
        iorwf DIGIT10,F,A
        return

; ************* LCD INITIALISATION FROM 1ST TABLE *******

LCDSET          clrf RSLINE,A           ; set RSLINE for LCD command mode
		movlw	UPPER TABLCD	; load upper, high and low parts of
		movwf	TBLPTRU,A	; the TABLCD address into TBLPTR
		movlw	HIGH TABLCD
		movwf	TBLPTRH,A
		movlw	LOW TABLCD
		movwf	TBLPTRL,A
		movlw	8
		movwf	LOOP,A		; initialise reads counter

LCDST2:		tblrd*+			; read table, post increment address
		movf	TABLAT,W,A	; get data from latch to W
                movwf STORE,A
		rcall	LCDOUT
		decfsz	LOOP,F,A
		bra	LCDST2		
                call	PAUSIT            ; perform second 1/5th sec delay
                                          ; to allow final LCD command to occur
                                          ; (it takes longer than the rest)
		return
                 

; ************* DATA EEPROM ROUTINES ********************

                                          ; READ DATA FROM EEPROM ROUTINE
                                          ; This routine is entered with W holding
                                          ; the eeprom byte address to be read.

GETPRM		movwf EEADR,A		  ; data memory address to read
		bcf EECON1,EEPGD,A	  ; point to data memory
		bcf EECON1,CFGS,A	  ; access program Flash or data eeprom memory
		bsf EECON1,RD,A		  ; eeprom read
		movf EEDATA,W,A		  ; load data into W
		return

                                          ; WRITE DATA TO EEPROM ROUTINE
                                          ; This routine is entered with W holding
                                          ; the eeprom byte address at which data
                                          ; is to be stored. The data to be stored
                                          ; is held in STORE.

SETPRM		movwf EEADR,A		  ; data memory address to write
                movf STORE,W,A            ; get data value from STORE and hold in W
		movwf EEDATA,A            ; data value to be written
		bcf EECON1,EEPGD,A	  ; point to data memory
		bcf EECON1,CFGS,A	  ; access program Flash or data eeprom memory
		bsf EECON1,WREN,A	  ; enable write
		movlw H'55'		  ;
		movwf EECON2,A		  ; write H'55'
		movlw H'AA'		  ;
		movwf EECON2,A		  ; write H'AA'
		bsf EECON1,WR,A		  ; set WR bit to begin write
CHKWRT	        btfss PIR2,EEIF,A         ; wait until bit EEIF of PIR2 is set
                goto CHKWRT
		bcf EECON1,WREN,A	  ; disable write on write complete (EEIF set)
                bcf PIR2,EEIF,A           ; clear bit EEIF of PIR2
		return

CLRLINE1: call LCD1     ;set address for line 1 cell 1
        bsf RSLINE,4,A    ;set RS for data send
        clrf LOOP,A
CLRL1:  movlw ' '       ;clear cell
        call LCDOUT     ;
        incf LOOP,F,A     ;inc loop
        btfss LOOP,4,A    ;has last LCD letter been sent?
        goto CLRL1      ;no
        return

CLRLINE2: call LCD21
        bsf RSLINE,4,A
        movlw 16
        movwf LOOP,A
CL2:    movlw ' '
        call LCDOUT
        decfsz LOOP,F,A
        goto CL2
        return

DELAYB:   nop
          nop
          nop
          nop
          nop
          nop
          nop

          nop
          nop
          nop
          nop
          nop
          nop
          nop

          return

WAITNOTETIME:
        call PLAYIT
        incf ENVELOPELSB,F,A
        movf STATUS,W,A
        andlw 1
        addwf ENVELOPEMSB,F,A
        btfsc ENVELOPEMSB,5,A
        clrf TRIGGER,A
        btfss ENVELOPEMSB,7,A
        goto WAITNOTETIME
        call NOTEPAUSIT
        return

PLAYIT: movf FREQLO,W,A    ; get freq LSB and add it to WAVE LSB
        addwf WAVELO,F,A
        movf STATUS,W,A    ; add Carry (if any) to WAVE MSB
        andlw 1
        addwf WAVEHI,F,A
        movf STATUS,W,A    ; add Carry (if any)
        andlw 1
        addwf OUTPUT2,F,A
        movf OUTPUT2,W,A
        andlw B'01111111'
        iorwf TRIGGER,W,A
        movwf PORTC,A

        movf FREQHI,W,A    ; get freq MSB and add it to WAVE MSB
        addwf WAVEHI,F,A
        movf STATUS,W,A    ; add Carry (if any)
        andlw 1
        addwf OUTPUT2,F,A
        movf OUTPUT2,W,A
        andlw B'01111111'
        iorwf TRIGGER,W,A
        movwf PORTC,A
        return

; ************

CORRECTVALS:
        call GETWHITE
        call GETRED
        call GETGREEN
        call GETBLUE

        movf WHITELSB,W,A
        movwf REGA0,A
        movf WHITEMSB,W,A
        movwf REGA1,A
        clrf REGA2,A
        clrf REGA3,A

        movf REDLSB,W,A
        movwf REGB0,A
        movf REDMSB,W,A
        movwf REGB1,A
        clrf REGB2,A
        clrf REGB3,A
        call DIVIDE
        movf REGA0,W,A
        btfsc STATUS,Z,A
        movlw 1
        movwf REDCORRECT,A

        movf WHITELSB,W,A
        movwf REGA0,A
        movf WHITEMSB,W,A
        movwf REGA1,A
        clrf REGA2,A
        clrf REGA3,A

        movf GREENLSB,W,A
        movwf REGB0,A
        movf GREENMSB,W,A
        movwf REGB1,A
        clrf REGB2,A
        clrf REGB3,A
        call DIVIDE
        movf REGA0,W,A
        btfsc STATUS,Z,A
        movlw 1
        movwf GREENCORRECT,A

        movf WHITELSB,W,A
        movwf REGA0,A
        movf WHITEMSB,W,A
        movwf REGA1,A
        clrf REGA2,A
        clrf REGA3,A

        movf BLUELSB,W,A
        movwf REGB0,A
        movf BLUEMSB,W,A
        movwf REGB1,A
        clrf REGB2,A
        clrf REGB3,A
        call DIVIDE
        movf REGA0,W,A
        btfsc STATUS,Z,A
        movlw 1
        movwf BLUECORRECT,A
        call LCD1
        movlw 'O'
        call LCDOUT
        movlw 'K'
        call LCDOUT

CV2:    btfss PORTB,7,A
        goto CV2
        call PAUSIT
        movlw 1
        movwf CORRECTFLAG,A
        return

; ***********

                ; LCD initialisation table

TABLCD          db B'00110011', B'00110011'
                db B'00110010', B'00101100'
                db B'00000110', B'00001100'
                db B'00000001', B'00000010'


	org	H'F00000'		  ; data eeprom assembly address

;  ATN values for angles 0 to 68 (msb val = 0)

        DE 0              ; 0
        DE 1              ; 1
        DE 3              ; 2
        DE 5              ; 3
        DE 6              ; 4
        DE 8              ; 5
        DE 10             ; 6
        DE 12             ; 7
        DE 14             ; 8
        DE 15             ; 9
        DE 17             ; 10
        DE 19             ; 11
        DE 21             ; 12
        DE 23             ; 13
        DE 24             ; 14
        DE 26             ; 15
        DE 28             ; 16
        DE 30             ; 17
        DE 32             ; 18
        DE 34             ; 19
        DE 36             ; 20
        DE 38             ; 21
        DE 40             ; 22
        DE 42             ; 23
        DE 44             ; 24
        DE 46             ; 25
        DE 48             ; 26
        DE 50             ; 27
        DE 53             ; 28
        DE 55             ; 29
        DE 57             ; 30
        DE 60             ; 31
        DE 62             ; 32
        DE 64             ; 33
        DE 67             ; 34
        DE 70             ; 35
        DE 72             ; 36
        DE 75             ; 37
        DE 78             ; 38
        DE 81             ; 39
        DE 83             ; 40
        DE 86             ; 41
        DE 90             ; 42
        DE 93             ; 43
        DE 96             ; 44
        DE 100            ; 45
        DE 103            ; 46
        DE 107            ; 47
        DE 111            ; 48
        DE 115            ; 49
        DE 119            ; 50
        DE 123            ; 51
        DE 128            ; 52
        DE 132            ; 53
        DE 137            ; 54
        DE 142            ; 55
        DE 148            ; 56
        DE 154            ; 57
        DE 160            ; 58
        DE 166            ; 59
        DE 173            ; 60
        DE 180            ; 61
        DE 188            ; 62
        DE 196            ; 63
        DE 205            ; 64
        DE 214            ; 65
        DE 224            ; 66
        DE 235            ; 67
        DE 247            ; 68

;  ATN values for angles 69 to 78 (msb val = 1)

        DE 4              ; 69
        DE 19             ; 70
        DE 34             ; 71
        DE 52             ; 72
        DE 71             ; 73
        DE 93             ; 74
        DE 117            ; 75
        DE 145            ; 76
        DE 178            ; 77
        DE 215            ; 78

;  ATN values for angles 79 to 82 (msb val = 2)

        DE 3              ; 79
        DE 56             ; 80
        DE 121            ; 81
        DE 202            ; 82

;  ATN values for angles 83 to 84 (msb val = 3)

        DE 50             ; 83
        DE 188            ; 84

;  ATN values for angles 85 to 89 (msb vals = 4 to 23)

        DE 4              ; 85
        DE 5              ; 86
        DE 7              ; 87
        DE 11             ; 88
        DE 23             ; 89
        DE 0              ; 90
        DE 0              ; 91
        DE 0              ; 92
        DE 0              ; 93
        DE 0              ; 94
        DE 0              ; 95
        DE 0              ; 96
        DE 0              ; 97
        DE 0              ; 98
        DE 0              ; 99


;          FREQVAL      NOTE   TRUE FREQ
;          LSB,MSB
        DE 32           ;A3 0  1760.00Hz   3/155  100
        DE      6
        DE 224          ;B3 1  1975.53Hz   4/11   102
        DE      6
        DE 73           ;C3 2  2093.00Hz   4/73   104
        DE      7
        DE 45           ;D3 3  2349.32Hz   4/207  106
        DE      8
        DE 77           ;E3 4  2637.00Hz   5/102  108
        DE      9
        DE 137          ;F3 5  2739.84Hz   5/156  110
        DE      9
        DE 234          ;G3 6  3135.96Hz   6/108  112
        DE      10
        DE 64           ;A4 7  3520.00Hz   7/53   114
        DE      12
        DE 0            ;                         116
        DE 0
        DE 0            ;                         118
        DE 0

        ; OCTAVE TABLE 
        DE 254 ; B'11111110'                     ;  120
        DE 253 ; B'11111101'                     ;  121
        DE 251 ; B'11111011'                     ;  122
        DE 247 ; B'11110111'                     ;  123
        DE 239 ; B'11101111'                     ;  124
        DE 223 ; B'11011111'                     ;  125
        DE 191 ; B'10111111'                     ;  126
        DE 191 ; B'10111111'                     ;  127

	END
