; CARILLONSTYLOPICMODS.ASM 03-30-2007 00:40:13

; These are the changes needed to the Stylopic ASM program to interface it to the PIC Carillon. But the author no longer has the prototype and has not tested them with it.

1. at the end of the CBLOCK section (before the command ENDC), add the extra variable NOTEVAL

; ***********

2. Add the following TABLE2 after the existing TABLE:

TABLE2: addwf PCL,F ; octave/note allocations for Carillon
; (MSB of the value is the octave, LSB is the note number)

        retlw %01111011  ;11   ; PORTB,0 G'    Oct 3
        retlw %01111010  ;10   ; PORTB,1 F'#   Oct 3
        retlw %01111001  ;9    ; PORTB,2 F'    Oct 3
        retlw %01111000  ;8    ; PORTB,3 E'    Oct 3
        retlw %01110111  ;7    ; PORTB,4 D'#   Oct 3
        retlw %01110110  ;6    ; PORTB,5 D'    Oct 3
        retlw %01110101  ;5    ; PORTB,6 C'#   Oct 3
        retlw %01110100  ;4    ; PORTB,7 C'    Oct 3

        retlw %01001001  ;9    ; PORTC,0 F"    Oct 4
        retlw %01001011  ;11   ; PORTC,1 G"    Oct 4
        retlw %01001100  ;12   ; PORTC,2 G"#   Oct 4
        retlw %01000001  ;1    ; PORTC,3 A"    Oct 4
        retlw %01000111  ;7    ; PORTC,4 D"#   Oct 4
        retlw %01000110  ;6    ; PORTC,5 D"    Oct 4
        retlw %01000101  ;5    ; PORTC,6 C"#   Oct 4
        retlw %01000100  ;4    ; PORTC,7 C"    Oct 4

        retlw %01010001  ;1    ; PORTD,0 A"#   Oct 5
        retlw %01010011  ;3    ; PORTD,1 B"    Oct 5
        retlw %01001001  ;9    ; PORTD,2 F"    Oct 4
        retlw %01001000  ;8    ; PORTD,3 E"    Oct 4
        retlw %01000011  ;3    ; PORTD,4 B'    Oct 4
        retlw %01000010  ;2    ; PORTD,5 A'#   Oct 4   440Hz
        retlw %01001100  ;12   ; PORTD,6 G'#   Oct 4
        retlw %01110100  ;4    ; PORTD,7 C"'   Oct 3

        retlw 0             ; PORTE,0 nil  not used here
        retlw 0             ; PORTE,1 nil  not used here
        retlw %01010101  ;5    ; PORTE,2 C'#   Oct 5

; N.B. THese allocations are believed to be correct but have not been checked

; ***********

3. In the START section, after the command PAGE0, add the command line:

	call JOESETBAUD

; ***********

4. at the very end of the full program, before the final word .END, add this entire section:

JOESETBAUD:
        PAGE1                   ; Configure the baud rate generator
        movlw 129               ; BRG for 9600baud from 20MHz, brgh=1
        movwf   SPBRG           ; In page 1
        movlw   b'00100100'     ; BRGH = 1(High speed, bit 2) & ASYNC transmission (bit 5)
        movwf   TXSTA           ; In page 1
        bcf 	STATUS,RP0  	; back to RAM page 0
        movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In page 0
        call    FlushRXBuffer   ; Flush the RX buffer in page 0
        return

; Send byte in W to the USART

TxByte:
        nop
        btfss   PIR1,TXIF       ; TX Buffer empty yet ?
        goto    TxByte          ; No - Keep waiting
        movwf   TXREG           ; Now empty - send this character
        return

; Flush the contents of the RX Buffer

FlushRXBuffer:
	movf    RCREG,W        	; Flush the RX buffer in bank 0
        movf    RCREG,W
	movf    RCREG,W
        return

; ***********

5. Amend the SCAN4: subroutine as follows:

SCAN4:  movf LOOP,W      ; OR loop val with SCAN
        iorwf SCAN,W
        call TABLE2      ; get Carillon octave/note value
	movwf NOTEVAL
	movf LOOP,W      ; OR loop val with SCAN
        iorwf SCAN,W
        call TABLE       ; get note number

(Note that this may set the tuned frequencies slightly lower and the NOPs in the PADIT section may need reducing in number).

; ***********

6. Amend the OUTIT: routine as follows:

OUTIT:  movwf PORTA
        PAGE1
        movlw %10111111    ; set for serial output via RC6
        movwf TRISC
        PAGE0
	movf NOTEVAL,W
	call TXBYTE
        PAGE1
        movlw %11111111    ; set for serial input via RC6
        movwf TRISC
        PAGE0
        goto MAIN

N.B. if the above changes to TRISC don't work in reality, it will be necessary to permanently use RC6 as an output for serial use and ignore key C''#, changing TRISC in the initialisation section of the ASM code. In which case also remove the newly added resistor as referred to below.

; ***********

7. Also make a hardware change on the StyloPIC PCB - cut the track from key C''# to PIC pin RC6 (serial output). Solder a 10k resistor across the cut. Connect a lead from PIC pin RC6 and connect it to the "serial Input from previous stage" pin on the Carillon board (first board only if using more than one).

; ***********

John Becker

30 Mar 07

