;*****************************************************************************        
;
;   Module:     utils.inc
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    0.1 13/1/04                                                  
;
;               Various support functions called by Main
;               These are placed here to keep the main application
;               source file small and readable
;
;*****************************************************************************        


;*****************************************************************************        
;
;   Function :  calcCosineH
;               This function returns the high byte of a 16bit fixed point
;               cosine value.
;
;   Input:      degrees in W
;
;   Output:     high byte of cosine in W
;
;*****************************************************************************        
calcCosineH
    movlw   high calcCosineH
    movwf   PCLATH
    movfw   LatDeg
    addwf   PCL ,F

	retlw	0xff
	retlw	0xff
	retlw	0xff
	retlw	0xff
	retlw	0xff
	retlw	0xfe
	retlw	0xfe
	retlw	0xfd
	retlw	0xfc
	retlw	0xfc
	retlw	0xfb
	retlw	0xfa
	retlw	0xf9
	retlw	0xf8
	retlw	0xf7
	retlw	0xf6
	retlw	0xf4
	retlw	0xf3
	retlw	0xf2
	retlw	0xf0
	retlw	0xee
	retlw	0xed
	retlw	0xeb
	retlw	0xe9
	retlw	0xe8
	retlw	0xe6
	retlw	0xe4
	retlw	0xe2
	retlw	0xdf
	retlw	0xdd
	retlw	0xdb
	retlw	0xd9
	retlw	0xd6
	retlw	0xd4
	retlw	0xd1
	retlw	0xcf
	retlw	0xcc
	retlw	0xc9
	retlw	0xc6
	retlw	0xc4
	retlw	0xc1
	retlw	0xbe
	retlw	0xbb
	retlw	0xb8
	retlw	0xb5
	retlw	0xb1
	retlw	0xae
	retlw	0xab
	retlw	0xa7
	retlw	0xa4
	retlw	0xa1
	retlw	0x9d
	retlw	0x9a
	retlw	0x96
	retlw	0x92
	retlw	0x8f
	retlw	0x8b
	retlw	0x87
	retlw	0x83
	retlw	0x80
	retlw	0x7C
	retlw	0x78
	retlw	0x74
	retlw	0x70
	retlw	0x6C
	retlw	0x68
	retlw	0x64
	retlw	0x5F
	retlw	0x5B
	retlw	0x57
	retlw	0x53
	retlw	0x4F
	retlw	0x4A
	retlw	0x46
	retlw	0x42
	retlw	0x3D
	retlw	0x39
	retlw	0x35
	retlw	0x30
	retlw	0x2C
	retlw	0x28
	retlw	0x23
	retlw	0x1F
	retlw	0x1A
	retlw	0x16
	retlw	0x11
	retlw	0x0D
	retlw	0x08
calcCosineH_end
	retlw	0x04

    IF ( (calcCosineH & 0x0FF) >= (calcCosineH_end & 0x0FF) )
        MESSG   "Table calcCosineH overflow"
    ENDIF
    

    
;*****************************************************************************        
;
;   Function :  SerialHexTransmit
;               This function sends the byte in W over the RS232 port, formatted
;               in ascii
;
;   Input:      Byte in W
;
;   Output:     
;
;*****************************************************************************        
SerialHexTransmit
    movwf   TEMP
    swapf   TEMP,W
    sublw   0x09
    swapf   TEMP,W
    andlw   0x0F
    btfss   STATUS,DC
    addlw   'A' - .10 - '0'
    addlw   '0'
    btfss   PIR1,TXIF    ;check that buffer is empty
    goto    $-1
    movwf   TXREG        ;transmit byte
    movfw   TEMP
    sublw   0x09
    movfw   TEMP
    andlw   0x0F
    btfss   STATUS,DC
    addlw   'A' - .10 - '0'
    addlw   '0'
    btfss   PIR1,TXIF    ;check that buffer is empty
    goto    $-1
    movwf   TXREG        ;transmit byte 
    return
    

;*****************************************************************************        
;
;   Function :  initHardware
;               reconfigures the peripherals of the chip.
;
;   Input:      None
;
;   Output:     None
;
;*****************************************************************************        
initHardware
    movlw   B'00110100'      
    movwf   T1CON
    
    
    ; Configure timer1 for 100ms 'tick'
    movlw   LOW TMR100MS                ; Timer interval 100ms
    movwf   TMR1L
    movlw   HIGH TMR100MS               ; counts up to FFFF+1 at a rate of 20Mhz/4/8
    movwf   TMR1H
    bsf     STATUS, RP0    
    bsf     PIE1, TMR1IE
    bcf     STATUS, RP0    
    bsf     T1CON, TMR1ON

    ; Initialise output pins to all low
    clrf    PORTB
    clrf    portBCopy
    clrf    PORTC
    
    ; Define I/O pin directions
    bsf     STATUS,RP0                  ; TRIS registers are in Bank1
    clrf    TRISB                       ; Leds are outputs
    movlw   0x06
    movwf   ADCON1                      ; Enable Port A as digital I/O
    movlw   0xFF
    movwf   TRISA
    bcf     STATUS,RP0                  ; Restore Bank0

    ; setup timer2 oscillator for PWM output on rc2/ccp1
    
    bsf     STATUS, RP0    
    clrf    PR2             ; Timer 2 period - no output yet
    bcf     TRISC, 2        ; make rc2 an output
    bcf     STATUS, RP0    
    
    bcf     STATUS, C
    clrf    CCPR1L          ; Duty cycle 0% - no output
    movlw   0x06            ; 16x prescale, enable timer
    movwf   T2CON
    movlw   B'00001100'     ; pwm mode
    movwf   CCP1CON
    
    ; setup serial port for 4800, 8, N, 1, interrupt receive
    bsf     STATUS, RP0    
    bsf     TRISC, 6        
    bsf     TRISC, 7        ; setting these two bits required for serial i/o
    movlw   BAUDRATE
    movwf   SPBRG
    bcf     TXSTA, BRGH     ; 4800 baud requires this cleared
    bcf     TXSTA, SYNC     ; set async mode
    bsf     PIE1, RCIE      ; enable rxint's
    bsf     TXSTA,TXEN    ;enable transmission    
    bcf     STATUS, RP0        
    bsf     RCSTA, SPEN
    bsf     RCSTA, CREN     ; enable reception
    
    ; Setup I2C port pins ( on PORTC )
    call    eepHWInit                   
    return



;*****************************************************************************        
;
;   Function :  calcCosineL
;               This function returns the low byte of a 16bit fixed point
;               cosine value.
;
;   Input:      degrees in W
;
;   Output:     low byte of cosine in W
;
;*****************************************************************************        
calcCosineL
    movlw   high calcCosineL
    movwf   PCLATH
    movfw   LatDeg
    addwf   PCL ,F

	retlw	0xf6
	retlw	0xd8
	retlw	0xa6
	retlw	0x60
	retlw	0x06
	retlw	0x98
	retlw	0x17
	retlw	0x82
	retlw	0xd9
	retlw	0x1c
	retlw	0x4b
	retlw	0x67
	retlw	0x70
	retlw	0x65
	retlw	0x46
	retlw	0x15
	retlw	0xd0
	retlw	0x78
	retlw	0x0d
	retlw	0x8f
	retlw	0xff
	retlw	0x5b
	retlw	0xa6
	retlw	0xde
	retlw	0x03
	retlw	0x17
	retlw	0x19
	retlw	0x08
	retlw	0xe7
	retlw	0xb3
	retlw	0x6f
	retlw	0x19
	retlw	0xb3
	retlw	0x3b
	retlw	0xb3
	retlw	0x1b
	retlw	0x73
	retlw	0xbb
	retlw	0xf3
	retlw	0x1b
	retlw	0x34
	retlw	0x3e
	retlw	0x3a
	retlw	0x26
	retlw	0x04
	retlw	0xd5
	retlw	0x97
	retlw	0x4c
	retlw	0xf3
	retlw	0x8d
	retlw	0x1b
	retlw	0x9b
	retlw	0x10
	retlw	0x79
	retlw	0xd5
	retlw	0x27
	retlw	0x6d
	retlw	0xA8
	retlw	0xD9
	retlw	0x00
	retlw	0x1C
	retlw	0x2F
	retlw	0x38
	retlw	0x39
	retlw	0x30
	retlw	0x1F
	retlw	0x06
	retlw	0xE6
	retlw	0xBE
	retlw	0x8E
	retlw	0x58
	retlw	0x1B
	retlw	0xD8
	retlw	0x90
	retlw	0x41
	retlw	0xEE
	retlw	0x96
	retlw	0x39
	retlw	0xD8
	retlw	0x74
	retlw	0x0C
	retlw	0xA0
	retlw	0x32
	retlw	0xC2
	retlw	0x4F
	retlw	0xDB
	retlw	0x65
	retlw	0xEF
calcCosineL_end	
	retlw	0x77

    IF ( (calcCosineL & 0x0FF) >= (calcCosineL_end & 0x0FF) )
        MESSG   "Table calcCosineL overflow"
    ENDIF




    
;*****************************************************************************        
;
;   Function :  SerialTransmit
;               This function sends the byte in W over the RS232 port. The 
;               function will wait until previous data has been sent
;
;   Input:      Byte in W
;
;   Output:     
;
;*****************************************************************************        
SerialTransmit
    btfss   PIR1,TXIF    ;check that buffer is empty
    goto    $-1
    movwf   TXREG        ;transmit byte
    return

   
    

;*****************************************************************************        
;
;   Function :  SetSound
;               Sets the output frequency on the buzzer.
;               A value of 0 turns the speaker off
;
;   Input:      frequency in W. See equates.inc for frequency settings
;
;   Output:     N/A
;
;*****************************************************************************        
SetSound
    movwf   TEMP
    bsf     STATUS, RP0    
    movwf   PR2             ; Timer 2 period    
    bcf     STATUS, RP0    
    movfw   TEMP
    bcf     STATUS, C
    rrf     TEMP,W
    movwf   CCPR1L          ; Duty cycle about 50%
    return


;*****************************************************************************        
;
;   Function : uiWait100us
;              delays for a multiple of 100us
;
;   Input:     multiple in W
;
;*****************************************************************************        
uiWait100us
    movwf   delay2

d1us002
    movlw    D'165'                    
    movwf    delay1                   
    
d1us001    
    decfsz    delay1, F               
    goto    d1us001                    
    decfsz  delay2, F
    goto    d1us002
    return                         
    

    
;*****************************************************************************        
;
;   Function : uiWait10ms
;              delays for a multiple of 10ms
;
;   Input:     multiple in W
;
;*****************************************************************************        
uiWait10ms
    movwf   delay3
    
d1ms001
    movlw   D'100'
    call    uiWait100us
    decfsz  delay3, F
    goto    d1ms001
    return


