;HEART135.ASM 18APR02 - JOHN BECKER - EPE BIOPIC HEART & PULSE MONITOR

;PIC16F876, 3.2768MHz, WDT OFF, POR ON, XTAL XT

;Config register bits (all PIC TOOLKIT MK2 defaults)
; CP1 CP0 DBG NIL WRT CPD LVP BOR CP1 CP0 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   1   0   0   0   1
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC '87 data sheet.

	List P = PIC16F877, R=DEC; 
        __CONFIG   h'3F31'

#DEFINE PAGE0   BCF $03,5
#DEFINE PAGE1   BSF $03,5

INDF:    .EQU $00  ;page 0, 1, 2, 3
OPTION:  .EQU $01  ;page 1, 3
PCL:     .EQU $02  ;page 0, 1, 2, 3
STATUS:  .EQU $03  ;page 0, 1, 2, 3
FSR:     .EQU $04  ;page 0, 1, 2, 3

PORTA:   .EQU $05  ;page 0
TRISA:   .EQU $05  ;page 1
PORTB:   .EQU $06  ;page 0, 2
TRISB:   .EQU $06  ;page 1, 3
PORTC:   .EQU $07  ;page 0
TRISC:   .EQU $07  ;page 1

INTCON:  .EQU $0B  ;page 0, 1, 2, 3
PIR1:    .EQU $0C  ;page 0
PIE1:    .EQU $0C  ;page 1

RCSTA:   .EQU $18  ;page 0
TXSTA:   .EQU $18  ;page 1

TXREG:   .EQU $19  ;page 0
SPBRG:   .EQU $19  ;page 1

ADRESH:  .EQU $1E  ;page 0

ADCON0:  .EQU $1F  ;page 0
ADCON1:  .EQU $1F  ;page 1

LOOPA:   .EQU $20        ;loop used by LCD send routine
LOOPB:   .EQU $21        ;general loop
STORE:   .EQU $22
RSLINE:  .EQU $23        ;LCD function flag store
CGVAL:   .EQU $24        ;val to be sent to character gen
SLOWIT:  .EQU $25        ;sample limit value
WORK1:   .EQU $26        ;working store 1
WORK2:   .EQU $27        ;working store 2
ANSA1:   .EQU $28        ;decimalisation store 1 & other uses
ANSA2:   .EQU $29        ;answer 2

CLKCNT:  .EQU $2A
PCOUNT:  .EQU $2B
PULSE:   .EQU $2C
PRVPULS: .EQU $2D
PULSCNT: .EQU $2E
SAMPLE:  .EQU $2F       ;current corrected sample store
PSAMPLE: .EQU $30       ;previous corrected sample store

AVRG0:   .EQU $31       ; average
AVRG1:   .EQU $32       ; average
AVRG2:   .EQU $33       ; average
AVRG3:   .EQU $34       ; average
AVRG4:   .EQU $35       ; average
AVRG5:   .EQU $36       ; average
AVRG6:   .EQU $37       ; average
AVRG7:   .EQU $38       ; average
AVRG8:   .EQU $39       ; average
AVRG9:   .EQU $3A       ; average
AVRG10:  .EQU $3B       ; average
AVRG11:  .EQU $3C       ; average
AVRG12:  .EQU $3D       ; average
AVRG13:  .EQU $3E       ; average
AVRG14:  .EQU $3F       ; average
AVRG15:  .EQU $40       ; average
AVRGMSB: .EQU $41       ; average
AVRGLSB: .EQU $42       ; average
AVRGCNT: .EQU $43       ; average
DECAYCNT: .EQU $44      ; delay counter for ppm count decay to zero

MEMA0:   .EQU $48       ;ADC CHAR store 0
MEMA1:   .EQU $49       ;ADC CHAR store 1 - not called by name
MEMA2:   .EQU $4A       ;ADC CHAR store 2 - not called by name
MEMA3:   .EQU $4B       ;ADC CHAR store 3 - not called by name
MEMA4:   .EQU $4C       ;ADC CHAR store 4 - not called by name
MEMA5:   .EQU $4D       ;ADC CHAR store 5 - not called by name
MEMA6:   .EQU $4E       ;ADC CHAR store 6 - not called by name
MEMA7:   .EQU $4F       ;ADC CHAR store 7 - not called by name

ROWA0:   .EQU $58       ;compiled data $58 to $7F
ROWA1:   .EQU $59
ROWA2:   .EQU $5A
ROWA3:   .EQU $5B
ROWA4:   .EQU $5C

ROWB0:   .EQU $5D
ROWB1:   .EQU $5E
ROWB2:   .EQU $5F
ROWB3:   .EQU $60
ROWB4:   .EQU $61

ROWC0:   .EQU $62
ROWC1:   .EQU $63
ROWC2:   .EQU $64
ROWC3:   .EQU $65
ROWC4:   .EQU $66

ROWD0:   .EQU $67
ROWD1:   .EQU $68
ROWD2:   .EQU $69
ROWD3:   .EQU $6A
ROWD4:   .EQU $6B

ROWE0:   .EQU $6C
ROWE1:   .EQU $6D
ROWE2:   .EQU $6E
ROWE3:   .EQU $6F
ROWE4:   .EQU $70

ROWF0:   .EQU $71
ROWF1:   .EQU $72
ROWF2:   .EQU $73
ROWF3:   .EQU $74
ROWF4:   .EQU $75

ROWG0:   .EQU $76
ROWG1:   .EQU $77
ROWG2:   .EQU $78
ROWG3:   .EQU $79
ROWG4:   .EQU $7A

ROWH0:   .EQU $7B
ROWH1:   .EQU $7C
ROWH2:   .EQU $7D
ROWH3:   .EQU $7E
ROWH4:   .EQU $7F

W:      .EQU 0
F:      .EQU 1
C:      .EQU 0
DC:     .EQU 1
Z:      .EQU 2

RP0:    .EQU 5           ;STATUS reg
RP1:    .EQU 6           ;STATUS reg
GIE:    .EQU 7           ;INTCON reg
GO:     .EQU 2           ;ADCON0 reg

        .ORG $0004      ;Interrupt vector address
        GOTO GIEOFF     ;Jump to interrupt routine on interrupt
        .ORG $0005      ;Start of program memory

GIEOFF: BCF INTCON,GIE  ;turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

TABLCD: addwf PCL,F     ;LCD initialisation table
        retlw %00110011 ;initialise lcd - first byte
        retlw %00110011 ;2nd byte (repeat of first)
        retlw %00110010 ;set for 4-bit operation
        retlw %00101100 ;set for 2 lines
        retlw %00000110 ;set entry mode to increment each address
        retlw %00001100 ;set display on, cursor off, blink off
        retlw %00000001 ;clear display
        retlw %00000010 ;return home, cursor & RAM to zero
                        ;end initialisation table

MESSAG0: addwf PCL,F     ;add program counter
         retlw ' '
         retlw ' '
         retlw 'B'
         retlw 'I'
         retlw 'O'
         retlw 'P'
         retlw 'I'
         retlw 'C'

MESSAGE: addwf PCL,F     ;add program counter
         retlw 'P'
         retlw 'U'
         retlw 'L'
         retlw 'S'
         retlw 'E'
         retlw ' '
         retlw 'R'
         retlw 'A'
         retlw 'T'
         retlw 'E'
         retlw ' '
         retlw ' '
         retlw ' '
         retlw ' '
         retlw ' '
         retlw ' '

MESSAG2: addwf PCL,F     ;add program counter
         retlw 'E'
         retlw 'P'
         retlw 'E'
         retlw ' '
         retlw 'B'
         retlw 'I'
         retlw 'O'
         retlw 'P'
         retlw 'I'
         retlw 'C'
         retlw ' '
         retlw 'P'
         retlw 'U'
         retlw 'L'
         retlw 'S'
         retlw 'E'

MESSAG3: addwf PCL,F     ;add program counter
         retlw 'P'
         retlw 'C'
         retlw ' '
         retlw 'S'
         retlw 'E'
         retlw 'R'
         retlw 'I'
         retlw 'A'
         retlw 'L'
         retlw ' '
         retlw 'O'
         retlw 'U'
         retlw 'T'
         retlw 'P'
         retlw 'U'
         retlw 'T'

;..............

START:  bcf STATUS,RP0
        bcf STATUS,RP1
        clrf PORTA
        clrf PORTB
        clrf PORTC
        PAGE1
        movlw %00001111     ;RA0-RA3 as inputs, RA4-RA5 as output
        movwf TRISA
        clrf TRISB          ;PORTB as output
        movlw %00100111     ;set output reg
        movwf TRISC         ;PORTC 7,6,4,3 as output, others as input
        movlw %00000100     ;set LHS justify, RA0, RA1, RA3 as analog inputs
        movwf ADCON1        ;with RA, RE digital, ref to +VE and 0V
        movlw %00000101     ;timer 1:64 (1/50th sec)
        movwf OPTION
        PAGE0

        movlw %01000001
        movwf ADCON0        ;set AD on, Fosc/8

        call PAUSIT
LCDSET: clrf LOOPB
        clrf RSLINE
LCDST2: movf LOOPB,W
        call TABLCD
        call LCDOUT
        incf LOOPB,F
        btfss LOOPB,3
        goto LCDST2
        call PAUSIT

        call NORMAL

        bsf ADCON0,GO     ;start data conversion
        movlw 1
        movwf CLKCNT
        clrf PCOUNT
        clrf PSAMPLE
        clrf PULSCNT
        clrf AVRGCNT
        movlw 8
        movwf DECAYCNT

        movlw AVRG0
        movwf FSR
        movlw 16
        movwf LOOPA
        movlw 255
CLRIT:  movwf INDF
        incf FSR,F
        decfsz LOOPA,F
        goto CLRIT

        call SETBAUD

;............................ END OF SETUP

INTRPT:  btfss INTCON,2  ;has a timer time-out been detected?
         goto INTRPT     ;no
         bcf INTCON,2    ;yes
         btfsc PORTC,5   ;is S2 turned on?
         goto OUTPUT     ;yes, go to output to PC via serial link

WAITAD0: btfsc ADCON0,GO
         goto WAITAD0
         incf PCOUNT,F    ;inc time between pulses count
         bsf ADCON0,GO    ;start data conversion for next sample

         swapf ADRESH,W   ;get ADC val (of which only top nibble needed)
         bsf ADCON0,GO    ;start data conversion for next sample

         movwf STORE      ;store it
         rrf STORE,W      ;reduce ADC val to 3 bits (val between 0 to 7)
         andlw %00000111
         movwf STORE      ;re-store it
         movwf SAMPLE     ;also store it as SAMPLE

         andlw %00000100  ;get val above or below 3
         movwf PULSE      ;store it
         xorwf PRVPULS,W  ;is it equal to previous value?
         btfsc STATUS,Z
         goto W2          ;yes
         call LCD35
         bsf RSLINE,4
         movlw '*'
         btfss PULSE,2
         movlw ' '
         call LCDOUT

         bcf PORTC,4      ;set LED D3 off
         btfsc PULSE,2    :is pulse high?
         bsf PORTC,4      ;yes, set LED D3 on

         btfss PULSE,2    ;is pulse >3?
         goto W2          ;no
         movf PCOUNT,W    ;yes, so transfer count to pulse store
         movwf PULSCNT
         clrf PCOUNT

W2:      movf PULSE,W     ;copy current pulse val to prev pulse store
         movwf PRVPULS

         decfsz CLKCNT,F
         goto INTRPT
         movlw 4
         movwf CLKCNT

         call SHIFTIN
         call GETPPM

         call LCD31
         bsf RSLINE,4
         movf ANSA2,W
         andlw 15
         btfss STATUS,Z
         goto V1
         movlw ' '
         goto V2
V1:      iorlw 48
V2:      call LCDOUT
         swapf ANSA1,W
         andlw 15
         iorlw 48
         call LCDOUT
         movf ANSA1,W
         andlw 15
         iorlw 48
         call LCDOUT

         decfsz DECAYCNT,F
         goto INTRPT
         movlw 8 
         movwf DECAYCNT

         movf ANSA1,W
         btfss STATUS,Z
         decf ANSA1,F
         movlw 6
         addwf ANSA1,W
         btfss STATUS,DC
         goto INTRPT
         movf ANSA1,W
         andlw %11110000
         iorlw 9
         movwf ANSA1
         goto INTRPT

;................

SHIFTIN: clrf MEMA0       ;clear compilation row stores
         clrf MEMA1
         clrf MEMA2
         clrf MEMA3
         clrf MEMA4
         clrf MEMA5
         clrf MEMA6
         clrf MEMA7

         movf SAMPLE,W
         addlw MEMA0      ;add val to address of MEMA0
         movwf FSR
         bsf INDF,0       ;set bit 0 of resultant MEMAx address

         movf SAMPLE,W    ;is current sample = previous sample?
         xorwf PSAMPLE,W
         btfsc STATUS,Z
         goto SHIFT7     ;yes

         movf PSAMPLE,W  ;no, so set address to count up or down to
         addlw MEMA0
         movwf STORE

         movf SAMPLE,W   ;so sub SAMPLE from PSAMPLE
         subwf PSAMPLE,W ;(is current sample less than previous sample?)
         btfss STATUS,C  ;is there a borrow?
         goto SHIFT5     ;yes, so sample is greater than prev sample

SHIFT4:  incf FSR,F       ;sample is less than previous sample
         movf FSR,W       ;is FSR address equal prev sample sample address?
         xorwf STORE,W
         btfsc STATUS,Z
         goto SHIFT7      ;yes so exit loop
         bsf INDF,0       ;no, set bit 0 of resultant MEMAx address
         goto SHIFT4      ;no, so repeat

SHIFT5:  decf FSR,F       ;sample is greater than prvious sample
         movf FSR,W       ;is FSR address equal prev sample sample address?
         xorwf STORE,W
         btfsc STATUS,Z
         goto SHIFT7      ;yes, so exit loop
         bsf INDF,0       ;no, set bit 0 of resultant MEMAx address
         goto SHIFT5

SHIFT7:  movf SAMPLE,W    ;store current sample as previous sample
         movwf PSAMPLE

         rrf MEMA0,F      ;rotate right each set of rows, pulling in new val
         rrf ROWA4,F      :either 1 or 0 from MEMAx
         rrf ROWA3,F
         rrf ROWA2,F
         rrf ROWA1,F
         rrf ROWA0,F

         rrf MEMA1,F
         rrf ROWB4,F
         rrf ROWB3,F
         rrf ROWB2,F
         rrf ROWB1,F
         rrf ROWB0,F

         rrf MEMA2,F
         rrf ROWC4,F
         rrf ROWC3,F
         rrf ROWC2,F
         rrf ROWC1,F
         rrf ROWC0,F

         rrf MEMA3,F
         rrf ROWD4,F
         rrf ROWD3,F
         rrf ROWD2,F
         rrf ROWD1,F
         rrf ROWD0,F

         rrf MEMA4,F
         rrf ROWE4,F
         rrf ROWE3,F
         rrf ROWE2,F
         rrf ROWE1,F
         rrf ROWE0,F

         rrf MEMA5,F
         rrf ROWF4,F
         rrf ROWF3,F
         rrf ROWF2,F
         rrf ROWF1,F
         rrf ROWF0,F

         rrf MEMA6,F
         rrf ROWG4,F
         rrf ROWG3,F
         rrf ROWG2,F
         rrf ROWG1,F
         rrf ROWG0,F

         rrf MEMA7,F
         rrf ROWH4,F
         rrf ROWH3,F
         rrf ROWH2,F
         rrf ROWH1,F
         rrf ROWH0,F

         movlw %01000000  ;set address for CG RAM write to 0
         call LCDLIN
         bsf RSLINE,4

COMPILE: movlw ROWA4
         movwf FSR
         movlw 8
         movwf LOOPB

COMPIL0: rrf INDF,W       ;compile 8 x 5-bit bytes for cell 0
         movwf CGVAL      ;comprising bits 7-3 of byte 4
         rrf CGVAL,F
         rrf CGVAL,W
         andlw %00011111
         call LCDOUT      ;send row
         movlw 5          ;set for next row
         addwf FSR,F
         decfsz LOOPB,F
         goto COMPIL0

         movlw ROWA4
         movwf FSR
         movlw 8
         movwf LOOPB

COMPIL1: movf INDF,W      ;compile 8 x 5-bit bytes for cell 1
         movwf CGVAL      ;comprising bits 2-0 of byte 4 + bits 7-6 of byte 3
         decf FSR,F
         movf INDF,W
         movwf STORE
         rlf STORE,F
         rlf CGVAL,F
         rlf STORE,F
         rlf CGVAL,W
         andlw %00011111
         call LCDOUT      ;send row
         movlw 6          ;set for next row
         addwf FSR,F
         decfsz LOOPB,F
         goto COMPIL1

         movlw ROWA3
         movwf FSR
         movlw 8
         movwf LOOPB

COMPIL2: rrf INDF,W       ;compile 8 x 5-bit bytes for cell 2
         andlw %00011111  ;comprising bits 5-1 of byte 3
         call LCDOUT      ;send row
         movlw 5          ;set for next row
         addwf FSR,F
         decfsz LOOPB,F
         goto COMPIL2

         movlw ROWA3
         movwf FSR
         movlw 8
         movwf LOOPB

COMPIL3: swapf INDF,W     ;compile 8 x 5-bit bytes for cell 3
         andlw %00010000  ;comprising bit 0 of byte 3 + bits 7-4 of byte 2
         movwf CGVAL
         decf FSR,F
         swapf INDF,W
         andlw %00001111
         iorwf CGVAL,W
         call LCDOUT      ;send row
         movlw 6          ;set for next row
         addwf FSR,F
         decfsz LOOPB,F
         goto COMPIL3

         movlw ROWA1
         movwf FSR
         movlw 8
         movwf LOOPB

COMPIL4: rlf INDF,W       ;compile 8 x 5-bit bytes for cell 4
         incf FSR,F       ;comprising bits 3-0 of byte 2. bit 7 of byte 1
         rlf INDF,W
         andlw %00011111  
         call LCDOUT      ;send row
         movlw 4          ;set for next row
         addwf FSR,F
         decfsz LOOPB,F
         goto COMPIL4

         movlw ROWA1
         movwf FSR
         movlw 8
         movwf LOOPB

COMPIL5: rrf INDF,W       ;compile 8 x 5-bit bytes for cell 5
         movwf CGVAL      ;comprising bits 6-2 of byte 1
         rrf CGVAL,W      
         andlw %00011111  
         call LCDOUT      ;send row
         movlw 5          ;set for next row
         addwf FSR,F
         decfsz LOOPB,F
         goto COMPIL5

         movlw ROWA1
         movwf FSR
         movlw 8
         movwf LOOPB

COMPIL6: movf INDF,W      ;compile 8 x 5-bit bytes for cell 6
         movwf CGVAL      ;comprising bits 1-0 of byte 1 + bits 7-5 of byte 0
         decf FSR,F
         movf INDF,W
         movwf STORE
         rlf STORE,F
         rlf CGVAL,F
         rlf STORE,F
         rlf CGVAL,F
         rlf STORE,F
         rlf CGVAL,W
         andlw %00011111
         call LCDOUT      ;send row
         movlw 6          ;set for next row
         addwf FSR,F
         decfsz LOOPB,F
         goto COMPIL6

         movlw ROWA0
         movwf FSR
         movlw 8
         movwf LOOPB

COMPIL7: movf INDF,W      ;compile 8 x 5-bit bytes for cell 7
         andlw %00011111  ;comprising bits 4-0 of byte 0
         call LCDOUT      ;send row A
         movlw 5          ;set for next row
         addwf FSR,F
         decfsz LOOPB,F
         goto COMPIL7
         return

;.........

GETPPM:  clrf CGVAL        ;get pulses per minute, stored in CGVAL
         movf PULSCNT,W
         andlw %11110000
         btfsc STATUS,Z    ;is pulse count <16 ? 
         return            ;yes

         movlw AVRG0
         addwf AVRGCNT,W
         movwf FSR
         movf PULSCNT,W
         movwf INDF

         movlw 16
         movwf LOOPA
         movlw AVRG0
         movwf FSR
         clrf AVRGMSB
         clrf AVRGLSB

GETAV:   movf INDF,W
         addwf AVRGLSB,F
         btfsc STATUS,C
         incf AVRGMSB,F
         incf FSR,F
         decfsz LOOPA,F
         goto GETAV

         rrf AVRGMSB,F          ; divide by 16 to get average
         rrf AVRGLSB,F
         rrf AVRGMSB,F
         rrf AVRGLSB,F
         rrf AVRGMSB,F
         rrf AVRGLSB,F
         rrf AVRGMSB,F
         rrf AVRGLSB,F

         movf AVRGLSB,W
         movwf PULSCNT
         incf AVRGCNT,F
         bcf AVRGCNT,4

         movf PULSCNT,W
         andlw %11110000
         btfsc STATUS,Z    ;is pulse count <16 ?
         return            ;yes
         movlw $0B         ;no, divide answer into 3000 to get ppm
         movwf WORK2
         movlw $B8
         movwf WORK1
         clrf ANSA1
         clrf ANSA2

GP2:     incf CGVAL,F
         incf ANSA1,F
         movlw 6
         addwf ANSA1,W
         btfss STATUS,DC
         goto GP3
         movwf ANSA1
         movlw 96
         addwf ANSA1,W
         btfss STATUS,C
         goto GP3
         movwf ANSA1
         incf ANSA2,F

GP3:     movf PULSCNT,W    ;sub PULSCNT from WORK0
         subwf WORK1,F
         btfsc STATUS,C    ;is there a borrow?
         goto GP2          ;no
         decfsz WORK2,F
         goto GP2
         clrf PULSCNT
         movlw 64
         movwf DECAYCNT
         return

;........

PAUSIT: movlw 50
        movwf SLOWIT
        clrf INTCON
PAUSE:  btfss INTCON,2
        goto PAUSE
        BCF INTCON,2
        decfsz SLOWIT,F
        goto PAUSE
        return

LCD1:   movlw %10000000     ;LCD cell position codes - not all used
        goto LCDLIN
LCD21:  movlw %11000000
        goto LCDLIN
LCD31:  movlw %11001011
        goto LCDLIN
LCD35:  movlw %11001111
        goto LCDLIN

LCDLIN: BCF RSLINE,4

LCDOUT: movwf STORE
        movlw 50
        movwf LOOPA
DELAY:  decfsz LOOPA,F
        goto DELAY
        call SENDIT
SENDIT: swapf STORE,F
        movf STORE,W
        andlw 15
        iorwf RSLINE,W
        movwf PORTB
        BSF PORTB,5
        BCF PORTB,5
        RETURN

;...........

SETBAUD:  PAGE1
          movlw 21            ;BRG for 9600baud from 3.2768MHz, brgh=1
          movwf SPBRG
          movlw %00000100     ;set sync=0, brgh=1
          movwf TXSTA
          bcf PIE1,4          ;clear interrupt bit (bit TXIE)
          PAGE0
          movlw %10000000     ;set SPEN Bit of RCSTA reg
          movwf RCSTA
          PAGE1
          bsf TXSTA,5         ;enable transmission (bit TXEN)
          PAGE0
          nop
          nop
          movlw 0             ;zero to PC
          call SENDPC
          return

;*************** OUTPUT TO PC SERIAL PORT

SERIAL:   rrf ADRESH,W  ;get ADC val/2
          andlw %01111111

SENDPC:   btfss PIR1,4  ;wait for TXIF bit 4 to go high (showing TXREG empty)
          goto SENDPC
          nop
          movwf TXREG   ;put val (held in W) in TXREG ready for transmission
          return

;******* ROUTE FOR READING PULSE MONITOR AND OUTPUT TO PC SERIAL PORT

OUTPUT: call LCD1        ;output to PC via serial link
        bsf RSLINE,4
        clrf LOOPB
SEND4:  movf LOOPB,W
        call MESSAG2
        call LCDOUT
        incf LOOPB,F
        btfss LOOPB,4
        goto SEND4
        call LCD21
        bsf RSLINE,4
        clrf LOOPB
SEND5:  movf LOOPB,W
        call MESSAG3
        call LCDOUT
        incf LOOPB,F
        btfss LOOPB,4
        goto SEND5
        bcf PORTC,4
        call SETBAUD

OUT2:   btfss PORTC,5   ;is S2 turned on?
        goto SETLCD     ;no, return to LCD monitoring via unit

WAITADX: btfsc ADCON0,GO
         goto WAITADX
         call SERIAL
         bsf ADCON0,GO    ;start data conversion for next sample
         goto OUT2

;******************

SETLCD: call NORMAL
        goto INTRPT

NORMAL:
        PAGE1
        bcf TXSTA,5         ;disable transmission (bit TXEN)
        PAGE0
        movlw %00000000     ;set SPEN Bit of RCSTA reg
        movwf RCSTA

        bcf PORTC,6

                  ;setup routine for normal LCD display
        movlw %01000000  ;set address for CG RAM write to 0
        call LCDLIN
        bsf RSLINE,4

SEND0:  movlw 0             ;clear CGVAL
        call LCDOUT
        incf LOOPB,F
        btfss LOOPB,4
        goto SEND0

        call LCD1           ;set 1st 8 cells of screen for CGVAL use
        bsf RSLINE,4        :(character values 0-7)
        clrf LOOPB
SEND1:  movf LOOPB,W
        call LCDOUT
        incf LOOPB,F
        btfss LOOPB,3
        goto SEND1
        clrf LOOPB

SEND2:  movf LOOPB,W
        call MESSAG0
        call LCDOUT
        incf LOOPB,F
        btfss LOOPB,3
        goto SEND2

        call LCD21
        bsf RSLINE,4
        clrf LOOPB
SEND3:  movf LOOPB,W
        call MESSAGE
        call LCDOUT
        incf LOOPB,F
        btfss LOOPB,4
        goto SEND3
        return

         .END

