
$mod51

en          equ p3.7
rw          equ p3.5
rs          equ p3.4


                org 0h
reset:          sjmp start

               
                org 30h                 ; good  start point 
start:          nop
                acall lcd_init         ; initialise lcd for 4bit interface
                mov r1,0ffh
                acall wait
                mov dptr,#text        ; write a string 
                acall outstr

                sjmp $

lcd_init:       nop
                mov a,#03fh
                acall wr_4bit
		mov a,#03fh
                acall wr_4bit
		mov a,#03fh
                acall wr_4bit
                mov a,#02fh          	; set 4 bit operation INIT 1 cycle
                acall wr_4bit

		mov r1,0ffh
                acall wait

		mov a,#028h
                acall wr_ctrl

                mov a,#0Ch               ; increment cursor
                acall wr_ctrl

                mov a,#06h              ; display on, cursor on, blink on
                acall wr_ctrl

                mov a,#01h              ; clear display
                acall wr_ctrl

                mov a,#02h              ; home cursor
                acall wr_ctrl
                ret

wr_4bit:        clr rs             ; select control register
                clr rw             ;select write
                mov p1,a           ;move data to port 1  
                setb en            ;toggle enable 
                nop
                clr en
                nop
                mov p1,#0ffh       ;set port 1 high
                setb rw            ;set read/write high
                mov r1,#0ffh
                acall wait         ;big delay
                ret;

clear:          clr rs
                mov a,#01h
                acall wr_common
                ret
 

wr_ctrl:        clr rs             ; select control register
                acall wr_common         ; write setup info to register
                ret

wr_data:        setb rs            ; select data register
                acall wr_common         ; write data to LCD
                ret

wr_common:      NOP               ;uses r0, r1 
                clr rw            ; strobe write line low
              
                mov r0,a          ; save the value
                ;orl a,#0Fh        ; set LSB of port to 1s -Inputs
                mov p1,a          ; write lsb data out
                setb en
                nop
                clr en            ; and then bring it low 
                mov a,r0          ; put value back in acc
                swap a            ; swap bytes
                orl a,#0Fh        ; set LSB of port to 1s -Inputs  
                mov p1,a          ; write msb data out  
                setb en           ; strobe en high   
                nop
                clr en            ; and then bring it low 
                mov r1,#02h        ; small delay
                acall wait        ; delay
                mov p1,#0ffh
                setb rw           ; pull write line high
                ret 

;use r1 to store the number of loops
; r0 is distroyed
wait:	nop
LP1:	MOV R0,#0FFH
        DJNZ R0,$
        DJNZ R1,LP1
        RET   



outstr:         clr a
                movc a,@a+dptr          ; get character
                jz exit                 ; stop if char == null
                acall wr_data           ; else write it
                inc dptr                ; point to next char
                sjmp outstr
exit:           ret


text:         db 'hello world, I work ',0

                end


