/********************************************************/
/*                  LCD ROUTINES                        */
/*                  ============			*/
/* 2x16 line display					*/ 
/* The LCD is configued for 4 bit transfers		*/
/*							*/
/* Rev A 23/02/96					*/
/********************************************************/

  
#include "lcd.h"               /* special function register declarations */


                              
sfr LCD_DATA=0x90;         	  /*  ONLY upper 4bits of P1 are used       */

bdata unsigned char temp_ch; 	  /*temp holding char	*/
// sbit busy=temp_ch^7;              /*busy flag of BD7	*/


/*Intitialise for : 2x16 lines   */
/*Assume auto init (ok as long as VCC =5V <10mS)*/
/*  4 bit transfers, 2 line, 5x8 font, increment add after write*/



void lcd_init(){
        ENABLE=0;               /*power up init*/
        lcd_4bit_wr(0x3f); 
       
       	lcd_4bit_wr(0x3f); 
       
       	lcd_4bit_wr(0x3f); 
      
 	lcd_4bit_wr(0x2f); 	/* set 4 bit operation INIT 1 cycle*/
 	lcd_wr(CMD,0x28);	/* 4 bit, 2 lines, 5x8	*/
 	lcd_wr(CMD,0x0C);	/* Display ON, Cursor OFF, Bink OFF*/
 	lcd_wr(CMD,0x06);	/* Increment address and shift curser*/
        lcd_wr(CMD,CLEAR);      /* Clear display*/
      /*  set_posn(0x00);          set position to 0*/
     }


void lcd_print( char *ch){
     while(*ch){
         lcd_wr(DATA,*ch);    
         ch++ ;                /* point to next character	*/
        }
     }  



/*SET DD RAM ADDRESS*/
void set_posn(char pos){
     pos=pos|0x80;        /*set D7 */
     lcd_wr(CMD,pos);
     }

/*** LOW LEVEL READ/WRITE ROUTINES  ****/

/*Low level write routine to write a char to lcd */
void lcd_wr(bit c_d, unsigned char ch){


//take the busy check out to save code space
 
/* check busy flag before all writes 		*/
/* During manual initialisation the busy flag
   should not be checked.  			*/

/* read and test DB7			        */
//  busy=1; 	   /* Set busy flag			*/
//   while(busy){
//     ENABLE=0;           /*Ensure everything is "off"    */
//     LCD_DATA=0xff;	/*Ensure port is an input       */
//     R_W=1;		/*Set R_W high for read cycle	*/
//     RS=CMD;             /*Register select =command 	*/
    
     /* Must perform 2 E pulses to get byte, MSB is      */
     /* transfered first, LSB is transfered but not used */
//     ENABLE=1;
//     temp_ch=LCD_DATA;	        /*Get MSB      	*/
//     ENABLE=0;	       		/*Put ENABLE low again 	*/
//     ENABLE=1;	                /*2nd cycle (LSB)	*/
//     ENABLE=0;			
//   }         
   ENABLE=0;
   wait(0x20);
   
/*NOT BUSY NOW ! So do the write			*/
  RS=c_d;			/*Set for command or data*/
  R_W=0;			/*Write line low	*/
  ENABLE=1;
/* WRITE DATA */
  LCD_DATA=ch |0x0f;		/*LSB of P1 must be 0xF	*/
  ENABLE=0;
  ch=ch<<4;                    /*Shift LSB to MSB	*/
  ENABLE=1;
  LCD_DATA=ch |0x0f;           /*Transfer LSB of ch    */
  ENABLE=0;
/*Turn LCD lines inactive                    		*/
  LCD_DATA=0xff;
  R_W=1;
}

void lcd_4bit_wr(unsigned char ch){
  RS=0;                        /*always a command      */
  R_W=0;			/*Write line low	*/
  ENABLE=1;
/* WRITE DATA */
  LCD_DATA=ch |0x0f;		/*LSB of P1 must be 0xF	*/
  ENABLE=0;
/*Turn LCD lines inactive                    		*/
  LCD_DATA=0xff;
  R_W=1;
 wait(0x7f);
}
 

 






